/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.execsqlrow;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.logging.LoggingObjectType;
import org.pentaho.di.core.logging.SimpleLoggingObject;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.StepPluginType;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.trans.RowProducer;
import org.pentaho.di.trans.RowStepCollector;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransHopMeta;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.RowListener;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.execsqlrow.ExecSQLRowMeta;
import org.pentaho.di.trans.steps.injector.InjectorMeta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecSQLRowTest {
    static Database database;
    public static final LoggingObjectInterface loggingObject;
    public static final String[] databasesXML;
    private static String execsqlrow_testtable;
    private static String[] insertStatement;

    public static RowMetaInterface createSourceRowMetaInterface() {
        RowMeta rm = new RowMeta();
        ValueMetaInterface[] valuesMeta = new ValueMetaInterface[]{new ValueMeta("ID", 5)};
        for (int i = 0; i < valuesMeta.length; ++i) {
            rm.addValueMeta(valuesMeta[i]);
        }
        return rm;
    }

    public static void createTables(Database db) throws Exception {
        String source = db.getCreateTableStatement(execsqlrow_testtable, ExecSQLRowTest.createSourceRowMetaInterface(), null, false, null, true);
        try {
            db.execStatement(source);
        }
        catch (KettleException ex) {
            Assert.fail((String)("failure while creating table " + execsqlrow_testtable + ": " + ex.getMessage()));
        }
    }

    private static void createData(Database db) throws Exception {
        for (int idx = 0; idx < insertStatement.length; ++idx) {
            db.execStatement(insertStatement[idx]);
        }
    }

    public RowMetaInterface createRowMetaInterface() {
        RowMeta rm = new RowMeta();
        ValueMetaInterface[] valuesMeta = new ValueMetaInterface[]{new ValueMeta("SQL", 2)};
        for (int i = 0; i < valuesMeta.length; ++i) {
            rm.addValueMeta(valuesMeta[i]);
        }
        return rm;
    }

    public List<RowMetaAndData> createDataRows() {
        ArrayList<RowMetaAndData> list = new ArrayList<RowMetaAndData>();
        RowMetaInterface rm = this.createRowMetaInterface();
        Object[] r1 = new Object[]{"delete from " + execsqlrow_testtable + " where id=1"};
        Object[] r2 = new Object[]{"delete from " + execsqlrow_testtable + " where id=2"};
        Object[] r3 = new Object[]{"delete from " + execsqlrow_testtable + " where id=3"};
        list.add(new RowMetaAndData(rm, r1));
        list.add(new RowMetaAndData(rm, r2));
        list.add(new RowMetaAndData(rm, r3));
        return list;
    }

    public RowMetaInterface createResultRowMetaInterface() {
        RowMeta rm = new RowMeta();
        ValueMetaInterface[] valuesMeta = new ValueMetaInterface[]{new ValueMeta("SQL", 2, 30, 0)};
        for (int i = 0; i < valuesMeta.length; ++i) {
            rm.addValueMeta(valuesMeta[i]);
        }
        return rm;
    }

    public List<RowMetaAndData> createResultDataRows() {
        ArrayList<RowMetaAndData> list = new ArrayList<RowMetaAndData>();
        RowMetaInterface rm = this.createResultRowMetaInterface();
        Object[] r1 = new Object[]{"delete from " + execsqlrow_testtable + " where id=1"};
        Object[] r2 = new Object[]{"delete from " + execsqlrow_testtable + " where id=2"};
        Object[] r3 = new Object[]{"delete from " + execsqlrow_testtable + " where id=3"};
        list.add(new RowMetaAndData(rm, r1));
        list.add(new RowMetaAndData(rm, r2));
        list.add(new RowMetaAndData(rm, r3));
        return list;
    }

    public void checkRows(List<RowMetaAndData> rows1, List<RowMetaAndData> rows2) {
        int idx = 1;
        if (rows1.size() != rows2.size()) {
            Assert.fail((String)("Number of rows is not the same: " + rows1.size() + " and " + rows2.size()));
        }
        Iterator<RowMetaAndData> it1 = rows1.iterator();
        Iterator<RowMetaAndData> it2 = rows2.iterator();
        while (it1.hasNext() && it2.hasNext()) {
            RowMetaAndData rm1 = it1.next();
            RowMetaAndData rm2 = it2.next();
            Object[] r1 = rm1.getData();
            Object[] r2 = rm2.getData();
            if (rm1.size() != rm2.size()) {
                Assert.fail((String)("row nr " + idx + " is not equal"));
            }
            int[] fields = new int[r1.length];
            for (int ydx = 0; ydx < r1.length; ++ydx) {
                fields[ydx] = ydx;
            }
            try {
                if (rm1.getRowMeta().compare(r1, r2, fields) != 0) {
                    Assert.fail((String)("row nr " + idx + " is not equal"));
                }
            }
            catch (KettleValueException e) {
                Assert.fail((String)("row nr " + idx + " is not equal"));
            }
            ++idx;
        }
    }

    @BeforeClass
    public static void createDatabase() throws Exception {
        KettleEnvironment.init();
        TransMeta transMeta = new TransMeta();
        transMeta.setName("transname");
        for (int i = 0; i < databasesXML.length; ++i) {
            DatabaseMeta databaseMeta = new DatabaseMeta(databasesXML[i]);
            transMeta.addDatabase(databaseMeta);
        }
        DatabaseMeta dbInfo = transMeta.findDatabase("db");
        database = new Database(loggingObject, dbInfo);
        database.connect();
        ExecSQLRowTest.createTables(database);
        ExecSQLRowTest.createData(database);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExecSQLRow1() throws Exception {
        KettleEnvironment.init();
        TransMeta transMeta = new TransMeta();
        transMeta.setName("transname");
        for (int i = 0; i < databasesXML.length; ++i) {
            DatabaseMeta databaseMeta = new DatabaseMeta(databasesXML[i]);
            transMeta.addDatabase(databaseMeta);
        }
        DatabaseMeta dbInfo = transMeta.findDatabase("db");
        PluginRegistry registry = PluginRegistry.getInstance();
        String injectorStepname = "injector step";
        InjectorMeta im = new InjectorMeta();
        String injectorPid = registry.getPluginId(StepPluginType.class, (Object)im);
        StepMeta injectorStep = new StepMeta(injectorPid, injectorStepname, (StepMetaInterface)im);
        transMeta.addStep(injectorStep);
        String stepName = "delete from [" + execsqlrow_testtable + "]";
        ExecSQLRowMeta execsqlmeta = new ExecSQLRowMeta();
        execsqlmeta.setDatabaseMeta(transMeta.findDatabase("db"));
        execsqlmeta.setCommitSize(0);
        execsqlmeta.setSqlFieldName("SQL");
        String execSqlRowId = registry.getPluginId(StepPluginType.class, (Object)execsqlmeta);
        StepMeta execSqlRowStep = new StepMeta(execSqlRowId, stepName, (StepMetaInterface)execsqlmeta);
        execSqlRowStep.setDescription("Deletes information from table [" + execsqlrow_testtable + "] on database [" + dbInfo + "]");
        transMeta.addStep(execSqlRowStep);
        TransHopMeta hi = new TransHopMeta(injectorStep, execSqlRowStep);
        transMeta.addTransHop(hi);
        Trans trans = new Trans(transMeta);
        trans.prepareExecution(null);
        StepInterface si = trans.getStepInterface(stepName, 0);
        RowStepCollector rc = new RowStepCollector();
        si.addRowListener((RowListener)rc);
        RowProducer rp = trans.addRowProducer(injectorStepname, 0);
        trans.startThreads();
        List<RowMetaAndData> inputList = this.createDataRows();
        for (RowMetaAndData rm : inputList) {
            rp.putRow(rm.getRowMeta(), rm.getData());
        }
        rp.finished();
        trans.waitUntilFinished();
        List<RowMetaAndData> resultRows = rc.getRowsWritten();
        List<RowMetaAndData> goldRows = this.createResultDataRows();
        this.checkRows(goldRows, resultRows);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExecSQLRow2() throws Exception {
        KettleEnvironment.init();
        TransMeta transMeta = new TransMeta();
        transMeta.setName("transname");
        for (int i = 0; i < databasesXML.length; ++i) {
            DatabaseMeta databaseMeta = new DatabaseMeta(databasesXML[i]);
            transMeta.addDatabase(databaseMeta);
        }
        DatabaseMeta dbInfo = transMeta.findDatabase("db");
        PluginRegistry registry = PluginRegistry.getInstance();
        String injectorStepname = "injector step";
        InjectorMeta im = new InjectorMeta();
        String injectorPid = registry.getPluginId(StepPluginType.class, (Object)im);
        StepMeta injectorStep = new StepMeta(injectorPid, injectorStepname, (StepMetaInterface)im);
        transMeta.addStep(injectorStep);
        String stepName = "delete from [" + execsqlrow_testtable + "]";
        ExecSQLRowMeta execsqlmeta = new ExecSQLRowMeta();
        execsqlmeta.setDatabaseMeta(transMeta.findDatabase("db"));
        execsqlmeta.setCommitSize(1);
        execsqlmeta.setSqlFieldName("SQL");
        String execSqlRowId = registry.getPluginId(StepPluginType.class, (Object)execsqlmeta);
        StepMeta execSqlRowStep = new StepMeta(execSqlRowId, stepName, (StepMetaInterface)execsqlmeta);
        execSqlRowStep.setDescription("Deletes information from table [" + execsqlrow_testtable + "] on database [" + dbInfo + "]");
        transMeta.addStep(execSqlRowStep);
        TransHopMeta hi = new TransHopMeta(injectorStep, execSqlRowStep);
        transMeta.addTransHop(hi);
        Trans trans = new Trans(transMeta);
        trans.prepareExecution(null);
        StepInterface si = trans.getStepInterface(stepName, 0);
        RowStepCollector rc = new RowStepCollector();
        si.addRowListener((RowListener)rc);
        RowProducer rp = trans.addRowProducer(injectorStepname, 0);
        trans.startThreads();
        List<RowMetaAndData> inputList = this.createDataRows();
        for (RowMetaAndData rm : inputList) {
            rp.putRow(rm.getRowMeta(), rm.getData());
        }
        rp.finished();
        trans.waitUntilFinished();
        List<RowMetaAndData> resultRows = rc.getRowsWritten();
        List<RowMetaAndData> goldRows = this.createResultDataRows();
        this.checkRows(goldRows, resultRows);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExecSQLRow3() throws Exception {
        KettleEnvironment.init();
        TransMeta transMeta = new TransMeta();
        transMeta.setName("transname");
        for (int i = 0; i < databasesXML.length; ++i) {
            DatabaseMeta databaseMeta = new DatabaseMeta(databasesXML[i]);
            transMeta.addDatabase(databaseMeta);
        }
        DatabaseMeta dbInfo = transMeta.findDatabase("db");
        PluginRegistry registry = PluginRegistry.getInstance();
        String injectorStepname = "injector step";
        InjectorMeta im = new InjectorMeta();
        String injectorPid = registry.getPluginId(StepPluginType.class, (Object)im);
        StepMeta injectorStep = new StepMeta(injectorPid, injectorStepname, (StepMetaInterface)im);
        transMeta.addStep(injectorStep);
        String stepName = "delete from [" + execsqlrow_testtable + "]";
        ExecSQLRowMeta execsqlmeta = new ExecSQLRowMeta();
        execsqlmeta.setDatabaseMeta(transMeta.findDatabase("db"));
        execsqlmeta.setCommitSize(2);
        execsqlmeta.setSqlFieldName("SQL");
        String execSqlRowId = registry.getPluginId(StepPluginType.class, (Object)execsqlmeta);
        StepMeta execSqlRowStep = new StepMeta(execSqlRowId, stepName, (StepMetaInterface)execsqlmeta);
        execSqlRowStep.setDescription("Deletes information from table [" + execsqlrow_testtable + "] on database [" + dbInfo + "]");
        transMeta.addStep(execSqlRowStep);
        TransHopMeta hi = new TransHopMeta(injectorStep, execSqlRowStep);
        transMeta.addTransHop(hi);
        Trans trans = new Trans(transMeta);
        trans.prepareExecution(null);
        StepInterface si = trans.getStepInterface(stepName, 0);
        RowStepCollector rc = new RowStepCollector();
        si.addRowListener((RowListener)rc);
        RowProducer rp = trans.addRowProducer(injectorStepname, 0);
        trans.startThreads();
        List<RowMetaAndData> inputList = this.createDataRows();
        for (RowMetaAndData rm : inputList) {
            rp.putRow(rm.getRowMeta(), rm.getData());
        }
        rp.finished();
        trans.waitUntilFinished();
        List<RowMetaAndData> resultRows = rc.getRowsWritten();
        List<RowMetaAndData> goldRows = this.createResultDataRows();
        this.checkRows(goldRows, resultRows);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExecSQLRow4() throws Exception {
        KettleEnvironment.init();
        TransMeta transMeta = new TransMeta();
        transMeta.setName("transname");
        for (int i = 0; i < databasesXML.length; ++i) {
            DatabaseMeta databaseMeta = new DatabaseMeta(databasesXML[i]);
            transMeta.addDatabase(databaseMeta);
        }
        DatabaseMeta dbInfo = transMeta.findDatabase("db");
        PluginRegistry registry = PluginRegistry.getInstance();
        String injectorStepname = "injector step";
        InjectorMeta im = new InjectorMeta();
        String injectorPid = registry.getPluginId(StepPluginType.class, (Object)im);
        StepMeta injectorStep = new StepMeta(injectorPid, injectorStepname, (StepMetaInterface)im);
        transMeta.addStep(injectorStep);
        String stepName = "delete from [" + execsqlrow_testtable + "]";
        ExecSQLRowMeta execsqlmeta = new ExecSQLRowMeta();
        execsqlmeta.setDatabaseMeta(transMeta.findDatabase("db"));
        execsqlmeta.setCommitSize(3);
        execsqlmeta.setSqlFieldName("SQL");
        String execSqlRowId = registry.getPluginId(StepPluginType.class, (Object)execsqlmeta);
        StepMeta execSqlRowStep = new StepMeta(execSqlRowId, stepName, (StepMetaInterface)execsqlmeta);
        execSqlRowStep.setDescription("Deletes information from table [" + execsqlrow_testtable + "] on database [" + dbInfo + "]");
        transMeta.addStep(execSqlRowStep);
        TransHopMeta hi = new TransHopMeta(injectorStep, execSqlRowStep);
        transMeta.addTransHop(hi);
        Trans trans = new Trans(transMeta);
        trans.prepareExecution(null);
        StepInterface si = trans.getStepInterface(stepName, 0);
        RowStepCollector rc = new RowStepCollector();
        si.addRowListener((RowListener)rc);
        RowProducer rp = trans.addRowProducer(injectorStepname, 0);
        trans.startThreads();
        List<RowMetaAndData> inputList = this.createDataRows();
        for (RowMetaAndData rm : inputList) {
            rp.putRow(rm.getRowMeta(), rm.getData());
        }
        rp.finished();
        trans.waitUntilFinished();
        List<RowMetaAndData> resultRows = rc.getRowsWritten();
        List<RowMetaAndData> goldRows = this.createResultDataRows();
        this.checkRows(goldRows, resultRows);
    }

    static {
        loggingObject = new SimpleLoggingObject("Exec SQL Row test", LoggingObjectType.GENERAL, null);
        databasesXML = new String[]{"<?xml version=\"1.0\" encoding=\"UTF-8\"?><connection><name>db</name><server>127.0.0.1</server><type>H2</type><access>Native</access><database>mem:db</database><port></port><username>sa</username><password></password></connection>"};
        execsqlrow_testtable = "execsqlrow_testtable";
        insertStatement = new String[]{"INSERT INTO " + execsqlrow_testtable + "(ID) VALUES (1)", "INSERT INTO " + execsqlrow_testtable + "(ID) VALUES (2)", "INSERT INTO " + execsqlrow_testtable + "(ID) VALUES (3)", "INSERT INTO " + execsqlrow_testtable + "(ID) VALUES (4)"};
    }
}

