/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.getxmldata;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.StepPluginType;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.trans.RowProducer;
import org.pentaho.di.trans.RowStepCollector;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransHopMeta;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.RowListener;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.dummytrans.DummyTransMeta;
import org.pentaho.di.trans.steps.getxmldata.GetXMLDataField;
import org.pentaho.di.trans.steps.getxmldata.GetXMLDataMeta;
import org.pentaho.di.trans.steps.injector.InjectorMeta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetXMLDataTest
extends TestCase {
    public RowMetaInterface createRowMetaInterface() {
        RowMeta rm = new RowMeta();
        ValueMetaInterface[] valuesMeta = new ValueMetaInterface[]{new ValueMeta("field1", 2)};
        for (int i = 0; i < valuesMeta.length; ++i) {
            rm.addValueMeta(valuesMeta[i]);
        }
        return rm;
    }

    private static String getXML1() {
        String xml1 = "<Level1>                                      <Level2>                                      <Props>                                       <ObjectID>AAAAA</ObjectID>                   <SAPIDENT>31-8200</SAPIDENT>                 <Quantity>1</Quantity>                       <Merkmalname>TX_B</Merkmalname>              <Merkmalswert> 600</Merkmalswert>           </Props>                                     <Props>                                       <ObjectID>BBBBB</ObjectID>                   <SAPIDENT>31-8201</SAPIDENT>                 <Quantity>3</Quantity>                       <Merkmalname>TX_C</Merkmalname>              <Merkmalswert> 900</Merkmalswert>           </Props>                                    </Level2>                                   </Level1>";
        return xml1;
    }

    private static String getXML2() {
        String xml2 = "<Level1>                                  <Level2>                                      <Props>                                       <ObjectID>CCCCC</ObjectID>                   <SAPIDENT>11-8201</SAPIDENT>                 <Quantity>5</Quantity>                       <Merkmalname>TX_C</Merkmalname>              <Merkmalswert> 700</Merkmalswert>           </Props>                                    </Level2>                                   </Level1>";
        return xml2;
    }

    public List<RowMetaAndData> createData() {
        ArrayList<RowMetaAndData> list = new ArrayList<RowMetaAndData>();
        RowMetaInterface rm = this.createRowMetaInterface();
        Object[] r1 = new Object[]{GetXMLDataTest.getXML1()};
        Object[] r2 = new Object[]{GetXMLDataTest.getXML2()};
        list.add(new RowMetaAndData(rm, r1));
        list.add(new RowMetaAndData(rm, r2));
        return list;
    }

    public RowMetaInterface createResultRowMetaInterface() {
        RowMeta rm = new RowMeta();
        ValueMetaInterface[] valuesMeta = new ValueMetaInterface[]{new ValueMeta("field1", 2), new ValueMeta("objectid", 2), new ValueMeta("sapident", 2), new ValueMeta("quantity", 2), new ValueMeta("merkmalname", 2), new ValueMeta("merkmalswert", 2)};
        for (int i = 0; i < valuesMeta.length; ++i) {
            rm.addValueMeta(valuesMeta[i]);
        }
        return rm;
    }

    public List<RowMetaAndData> createResultData1() {
        ArrayList<RowMetaAndData> list = new ArrayList<RowMetaAndData>();
        RowMetaInterface rm = this.createResultRowMetaInterface();
        Object[] r1 = new Object[]{GetXMLDataTest.getXML1(), "AAAAA", "31-8200", "1", "TX_B", " 600"};
        Object[] r2 = new Object[]{GetXMLDataTest.getXML1(), "BBBBB", "31-8201", "3", "TX_C", " 900"};
        Object[] r3 = new Object[]{GetXMLDataTest.getXML2(), "CCCCC", "11-8201", "5", "TX_C", " 700"};
        list.add(new RowMetaAndData(rm, r1));
        list.add(new RowMetaAndData(rm, r2));
        list.add(new RowMetaAndData(rm, r3));
        return list;
    }

    public void checkRows(List<RowMetaAndData> rows1, List<RowMetaAndData> rows2) {
        int idx = 1;
        if (rows1.size() != rows2.size()) {
            GetXMLDataTest.fail((String)("Number of rows is not the same: " + rows1.size() + " and " + rows2.size()));
        }
        Iterator<RowMetaAndData> it1 = rows1.iterator();
        Iterator<RowMetaAndData> it2 = rows2.iterator();
        while (it1.hasNext() && it2.hasNext()) {
            RowMetaAndData rm1 = it1.next();
            RowMetaAndData rm2 = it2.next();
            Object[] r1 = rm1.getData();
            Object[] r2 = rm2.getData();
            if (rm1.size() != rm2.size()) {
                GetXMLDataTest.fail((String)("row nr " + idx + " is not equal"));
            }
            int[] fields = new int[r1.length];
            for (int ydx = 0; ydx < r1.length; ++ydx) {
                fields[ydx] = ydx;
            }
            try {
                if (rm1.getRowMeta().compare(r1, r2, fields) != 0) {
                    GetXMLDataTest.fail((String)("row nr " + idx + " is not equal"));
                }
            }
            catch (KettleValueException e) {
                GetXMLDataTest.fail((String)("row nr " + idx + " is not equal"));
            }
            ++idx;
        }
    }

    public void testGetXMLDataSimple1() throws Exception {
        KettleEnvironment.init();
        TransMeta transMeta = new TransMeta();
        transMeta.setName("getxmldata1");
        PluginRegistry registry = PluginRegistry.getInstance();
        String injectorStepname = "injector step";
        InjectorMeta im = new InjectorMeta();
        String injectorPid = registry.getPluginId(StepPluginType.class, (Object)im);
        StepMeta injectorStep = new StepMeta(injectorPid, injectorStepname, (StepMetaInterface)im);
        transMeta.addStep(injectorStep);
        String getXMLDataName = "get xml data step";
        GetXMLDataMeta gxdm = new GetXMLDataMeta();
        String getXMLDataPid = registry.getPluginId(StepPluginType.class, (Object)gxdm);
        StepMeta getXMLDataStep = new StepMeta(getXMLDataPid, getXMLDataName, (StepMetaInterface)gxdm);
        transMeta.addStep(getXMLDataStep);
        GetXMLDataField[] fields = new GetXMLDataField[5];
        for (int idx = 0; idx < fields.length; ++idx) {
            fields[idx] = new GetXMLDataField();
        }
        fields[0].setName("objectid");
        fields[0].setXPath("ObjectID");
        fields[0].setElementType(0);
        fields[0].setType(2);
        fields[0].setFormat("");
        fields[0].setLength(-1);
        fields[0].setPrecision(-1);
        fields[0].setCurrencySymbol("");
        fields[0].setDecimalSymbol("");
        fields[0].setGroupSymbol("");
        fields[0].setTrimType(0);
        fields[1].setName("sapident");
        fields[1].setXPath("SAPIDENT");
        fields[1].setElementType(0);
        fields[1].setType(2);
        fields[1].setFormat("");
        fields[1].setLength(-1);
        fields[1].setPrecision(-1);
        fields[1].setCurrencySymbol("");
        fields[1].setDecimalSymbol("");
        fields[1].setGroupSymbol("");
        fields[1].setTrimType(0);
        fields[2].setName("quantity");
        fields[2].setXPath("Quantity");
        fields[2].setElementType(0);
        fields[2].setType(2);
        fields[2].setFormat("");
        fields[2].setLength(-1);
        fields[2].setPrecision(-1);
        fields[2].setCurrencySymbol("");
        fields[2].setDecimalSymbol("");
        fields[2].setGroupSymbol("");
        fields[2].setTrimType(0);
        fields[3].setName("merkmalname");
        fields[3].setXPath("Merkmalname");
        fields[3].setElementType(0);
        fields[3].setType(2);
        fields[3].setFormat("");
        fields[3].setLength(-1);
        fields[3].setPrecision(-1);
        fields[3].setCurrencySymbol("");
        fields[3].setDecimalSymbol("");
        fields[3].setGroupSymbol("");
        fields[3].setTrimType(0);
        fields[4].setName("merkmalswert");
        fields[4].setXPath("Merkmalswert");
        fields[4].setElementType(0);
        fields[4].setType(2);
        fields[4].setFormat("");
        fields[4].setLength(-1);
        fields[4].setPrecision(-1);
        fields[4].setCurrencySymbol("");
        fields[4].setDecimalSymbol("");
        fields[4].setGroupSymbol("");
        fields[4].setTrimType(0);
        gxdm.setEncoding("UTF-8");
        gxdm.setIsAFile(false);
        gxdm.setInFields(true);
        gxdm.setLoopXPath("Level1/Level2/Props");
        gxdm.setXMLField("field1");
        gxdm.setInputFields(fields);
        TransHopMeta hi = new TransHopMeta(injectorStep, getXMLDataStep);
        transMeta.addTransHop(hi);
        String dummyStepname1 = "dummy step 1";
        DummyTransMeta dm1 = new DummyTransMeta();
        String dummyPid1 = registry.getPluginId(StepPluginType.class, (Object)dm1);
        StepMeta dummyStep1 = new StepMeta(dummyPid1, dummyStepname1, (StepMetaInterface)dm1);
        transMeta.addStep(dummyStep1);
        TransHopMeta hi1 = new TransHopMeta(getXMLDataStep, dummyStep1);
        transMeta.addTransHop(hi1);
        Trans trans = new Trans(transMeta);
        trans.prepareExecution(null);
        StepInterface si = trans.getStepInterface(dummyStepname1, 0);
        RowStepCollector dummyRc1 = new RowStepCollector();
        si.addRowListener((RowListener)dummyRc1);
        RowProducer rp = trans.addRowProducer(injectorStepname, 0);
        trans.startThreads();
        List<RowMetaAndData> inputList = this.createData();
        for (RowMetaAndData rm : inputList) {
            rp.putRow(rm.getRowMeta(), rm.getData());
        }
        rp.finished();
        trans.waitUntilFinished();
        List<RowMetaAndData> resultRows = dummyRc1.getRowsWritten();
        List<RowMetaAndData> goldenImageRows = this.createResultData1();
        this.checkRows(goldenImageRows, resultRows);
    }
}

