/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.janino;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.StepPluginType;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.trans.RowProducer;
import org.pentaho.di.trans.RowStepCollector;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransHopMeta;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.RowListener;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.dummytrans.DummyTransMeta;
import org.pentaho.di.trans.steps.injector.InjectorMeta;
import org.pentaho.di.trans.steps.janino.JaninoMeta;
import org.pentaho.di.trans.steps.janino.JaninoMetaFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaninoStepTest
extends TestCase {
    public RowMetaInterface createRowMetaInterface() {
        RowMeta rm = new RowMeta();
        ValueMetaInterface[] valuesMeta = new ValueMetaInterface[]{new ValueMeta("string", 2), new ValueMeta("integer", 5), new ValueMeta("number", 1), new ValueMeta("bigdecimal", 6), new ValueMeta("date", 3), new ValueMeta("binary", 8), new ValueMeta("bool", 4)};
        for (int i = 0; i < valuesMeta.length; ++i) {
            rm.addValueMeta(valuesMeta[i]);
        }
        return rm;
    }

    public List<RowMetaAndData> createInputList() {
        ArrayList<RowMetaAndData> list = new ArrayList<RowMetaAndData>();
        RowMetaInterface rm = this.createRowMetaInterface();
        Object[] r1 = new Object[]{"string-value", new Long(42L), new Double(23.0), new BigDecimal(11.0), new Date(), new byte[]{1, 2, 3, 4, 5}, new Boolean(true)};
        Object[] n = new Object[]{null, null, null, null, null, null, null};
        list.add(new RowMetaAndData(rm, n));
        list.add(new RowMetaAndData(rm, r1));
        list.add(new RowMetaAndData(rm, n));
        list.add(new RowMetaAndData(rm, r1));
        return list;
    }

    public List<RowMetaAndData> createExpectedList() {
        ArrayList<RowMetaAndData> list = new ArrayList<RowMetaAndData>();
        RowMetaInterface rm = this.createRowMetaInterface();
        Object[] r1 = new Object[]{"string-value", new Long(42L), new Double(23.0), new BigDecimal(11.0), new Date(10000000L), new byte[]{1, 2, 3, 4, 5}, new Boolean(true)};
        Object[] n = new Object[]{null, null, null, null, null, null, null};
        list.add(new RowMetaAndData(rm, n));
        list.add(new RowMetaAndData(rm, r1));
        list.add(new RowMetaAndData(rm, n));
        list.add(new RowMetaAndData(rm, r1));
        return list;
    }

    public void checkRows(List<RowMetaAndData> rows1, List<RowMetaAndData> rows2) {
        int idx = 1;
        if (rows1.size() != rows2.size()) {
            JaninoStepTest.fail((String)("Number of rows is not the same: " + rows1.size() + " and " + rows2.size()));
        }
        Iterator<RowMetaAndData> it1 = rows1.iterator();
        Iterator<RowMetaAndData> it2 = rows2.iterator();
        while (it1.hasNext() && it2.hasNext()) {
            RowMetaAndData rm1 = it1.next();
            RowMetaAndData rm2 = it2.next();
            Object[] r1 = rm1.getData();
            Object[] r2 = rm2.getData();
            if (rm1.size() != rm2.size()) {
                JaninoStepTest.fail((String)("row nr " + idx + " is not equal"));
            }
            int[] fields = new int[rm1.size()];
            for (int ydx = 0; ydx < rm1.size(); ++ydx) {
                fields[ydx] = ydx;
            }
            try {
                if (rm1.getRowMeta().compare(r1, r2, fields) != 0) {
                    JaninoStepTest.fail((String)("row nr " + idx + "i s not equal (" + rm1.getRowMeta().getString(r1) + " != " + rm1.getRowMeta().getString(r2) + ")"));
                }
            }
            catch (KettleValueException e) {
                JaninoStepTest.fail((String)("row nr " + idx + " is not equal"));
            }
            ++idx;
        }
    }

    public void testJaninoStep() throws Exception {
        KettleEnvironment.init();
        TransMeta transMeta = new TransMeta();
        transMeta.setName("janino test");
        PluginRegistry registry = PluginRegistry.getInstance();
        String injectorStepName = "injector step";
        InjectorMeta im = new InjectorMeta();
        String injectorPid = registry.getPluginId(StepPluginType.class, (Object)im);
        StepMeta injectorStep = new StepMeta(injectorPid, injectorStepName, (StepMetaInterface)im);
        transMeta.addStep(injectorStep);
        String stepname = "janino";
        JaninoMeta jm = new JaninoMeta();
        String janinoPid = registry.getPluginId(StepPluginType.class, (Object)jm);
        StepMeta janinoStep = new StepMeta(janinoPid, stepname, (StepMetaInterface)jm);
        transMeta.addStep(janinoStep);
        jm.setDefault();
        JaninoMetaFunction[] formulas = new JaninoMetaFunction[]{new JaninoMetaFunction("string", "(string==null)?null:\"string-value\"", 2, -1, -1, "string"), new JaninoMetaFunction("integer", "(integer==null)?null:new Long(42L)", 5, -1, -1, "integer"), new JaninoMetaFunction("number", "(number==null)?null:new Double(23.0)", 1, -1, -1, "number"), new JaninoMetaFunction("bigdecimal", "(bigdecimal==null)?null:new java.math.BigDecimal(11.0)", 6, -1, -1, "bigdecimal"), new JaninoMetaFunction("date", "(date==null)?null:new java.util.Date(10000000)", 3, -1, -1, "date"), new JaninoMetaFunction("binary", "(binary==null)?null:new byte[]{1,2,3,4,5}", 8, -1, -1, "binary"), new JaninoMetaFunction("bool", "(bool==null)?null:Boolean.TRUE", 4, -1, -1, "bool")};
        jm.setFormula(formulas);
        transMeta.addTransHop(new TransHopMeta(injectorStep, janinoStep));
        String dummyStepname = "dummy step";
        DummyTransMeta dm = new DummyTransMeta();
        String dummyPid = registry.getPluginId(StepPluginType.class, (Object)dm);
        StepMeta dummyStep = new StepMeta(dummyPid, dummyStepname, (StepMetaInterface)dm);
        transMeta.addStep(dummyStep);
        TransHopMeta hi = new TransHopMeta(janinoStep, dummyStep);
        transMeta.addTransHop(hi);
        Trans trans = new Trans(transMeta);
        trans.prepareExecution(null);
        StepInterface si = trans.getStepInterface(dummyStepname, 0);
        RowStepCollector rc = new RowStepCollector();
        si.addRowListener((RowListener)rc);
        RowProducer rp = trans.addRowProducer(injectorStepName, 0);
        trans.startThreads();
        for (RowMetaAndData rm : this.createInputList()) {
            rp.putRow(rm.getRowMeta(), rm.getData());
        }
        rp.finished();
        trans.waitUntilFinished();
        List<RowMetaAndData> checkList = this.createExpectedList();
        List<RowMetaAndData> resultRows = rc.getRowsWritten();
        this.checkRows(resultRows, checkList);
    }
}

