/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.jsonoutput;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.pentaho.di.TestUtilities;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.StepPluginType;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.trans.RowStepCollector;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransHopMeta;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.RowListener;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.dummytrans.DummyTransMeta;
import org.pentaho.di.trans.steps.jsonoutput.JsonOutputField;
import org.pentaho.di.trans.steps.jsonoutput.JsonOutputMeta;
import org.pentaho.di.trans.steps.rowgenerator.RowGeneratorMeta;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonOutputTest
extends TestCase {
    private transient Logger logger = LoggerFactory.getLogger(JsonOutputTest.class);
    private static final String EXPECTED_NON_COMPATIBILITY_JSON = "{\"data\":[{\"id\":1,\"state\":\"Florida\",\"city\":\"Orlando\"},{\"id\":1,\"state\":\"Florida\",\"city\":\"Orlando\"},{\"id\":1,\"state\":\"Florida\",\"city\":\"Orlando\"},{\"id\":1,\"state\":\"Florida\",\"city\":\"Orlando\"},{\"id\":1,\"state\":\"Florida\",\"city\":\"Orlando\"},{\"id\":1,\"state\":\"Florida\",\"city\":\"Orlando\"},{\"id\":1,\"state\":\"Florida\",\"city\":\"Orlando\"},{\"id\":1,\"state\":\"Florida\",\"city\":\"Orlando\"},{\"id\":1,\"state\":\"Florida\",\"city\":\"Orlando\"},{\"id\":1,\"state\":\"Florida\",\"city\":\"Orlando\"}]}";
    private static final String EXPECTED_COMPATIBILITY_MODE_JSON = "{\"data\":[{\"id\":1},{\"state\":\"Florida\"},{\"city\":\"Orlando\"},{\"id\":1},{\"state\":\"Florida\"},{\"city\":\"Orlando\"},{\"id\":1},{\"state\":\"Florida\"},{\"city\":\"Orlando\"},{\"id\":1},{\"state\":\"Florida\"},{\"city\":\"Orlando\"},{\"id\":1},{\"state\":\"Florida\"},{\"city\":\"Orlando\"},{\"id\":1},{\"state\":\"Florida\"},{\"city\":\"Orlando\"},{\"id\":1},{\"state\":\"Florida\"},{\"city\":\"Orlando\"},{\"id\":1},{\"state\":\"Florida\"},{\"city\":\"Orlando\"},{\"id\":1},{\"state\":\"Florida\"},{\"city\":\"Orlando\"},{\"id\":1},{\"state\":\"Florida\"},{\"city\":\"Orlando\"}]}";

    private StepMeta createRowGeneratorStep(String name, PluginRegistry registry) {
        String testFileOutputName = Const.isEmpty((String)name) ? "generate rows" : name;
        RowGeneratorMeta rowGeneratorMeta = new RowGeneratorMeta();
        String rowGeneratorPid = registry.getPluginId(StepPluginType.class, (Object)rowGeneratorMeta);
        StepMeta generateRowsStep = new StepMeta(rowGeneratorPid, testFileOutputName, (StepMetaInterface)rowGeneratorMeta);
        rowGeneratorMeta.setFieldName(new String[]{"Id", "State", "City"});
        rowGeneratorMeta.setFieldType(new String[]{"Integer", "String", "String"});
        rowGeneratorMeta.setValue(new String[]{"1", "Florida", "Orlando"});
        rowGeneratorMeta.setFieldLength(new int[]{-1, -1, -1});
        rowGeneratorMeta.setFieldPrecision(new int[]{-1, -1, -1});
        rowGeneratorMeta.setGroup(new String[]{"", "", ""});
        rowGeneratorMeta.setDecimal(new String[]{"", "", ""});
        rowGeneratorMeta.setFieldFormat(new String[]{"", "", ""});
        rowGeneratorMeta.setRowLimit("10");
        return generateRowsStep;
    }

    private StepMeta createDummyStep(String name, PluginRegistry registry) {
        String dummyStepName = "dummy step";
        DummyTransMeta dm1 = new DummyTransMeta();
        String dummyPid1 = registry.getPluginId(StepPluginType.class, (Object)dm1);
        StepMeta dummyStep = new StepMeta(dummyPid1, dummyStepName, (StepMetaInterface)dm1);
        return dummyStep;
    }

    public List<RowMetaAndData> createResultData1() {
        ArrayList<RowMetaAndData> list = new ArrayList<RowMetaAndData>();
        RowMetaInterface rowMetaInterface = this.createResultRowMetaInterface();
        Object[] r1 = new Object[]{new Long(1L), "Orlando", "Florida"};
        Object[] r2 = new Object[]{new Long(1L), "Orlando", "Florida"};
        Object[] r3 = new Object[]{new Long(1L), "Orlando", "Florida"};
        Object[] r4 = new Object[]{new Long(1L), "Orlando", "Florida"};
        Object[] r5 = new Object[]{new Long(1L), "Orlando", "Florida"};
        Object[] r6 = new Object[]{new Long(1L), "Orlando", "Florida"};
        Object[] r7 = new Object[]{new Long(1L), "Orlando", "Florida"};
        Object[] r8 = new Object[]{new Long(1L), "Orlando", "Florida"};
        Object[] r9 = new Object[]{new Long(1L), "Orlando", "Florida"};
        Object[] r10 = new Object[]{new Long(1L), "Orlando", "Florida"};
        list.add(new RowMetaAndData(rowMetaInterface, r1));
        list.add(new RowMetaAndData(rowMetaInterface, r2));
        list.add(new RowMetaAndData(rowMetaInterface, r3));
        list.add(new RowMetaAndData(rowMetaInterface, r4));
        list.add(new RowMetaAndData(rowMetaInterface, r5));
        list.add(new RowMetaAndData(rowMetaInterface, r6));
        list.add(new RowMetaAndData(rowMetaInterface, r7));
        list.add(new RowMetaAndData(rowMetaInterface, r8));
        list.add(new RowMetaAndData(rowMetaInterface, r9));
        list.add(new RowMetaAndData(rowMetaInterface, r10));
        return list;
    }

    public RowMetaInterface createRowMetaInterface() {
        RowMeta rowMetaInterface = new RowMeta();
        ValueMetaInterface[] valuesMeta = new ValueMetaInterface[]{new ValueMeta("filename", 2)};
        for (int i = 0; i < valuesMeta.length; ++i) {
            rowMetaInterface.addValueMeta(valuesMeta[i]);
        }
        return rowMetaInterface;
    }

    public List<RowMetaAndData> createData() {
        ArrayList<RowMetaAndData> list = new ArrayList<RowMetaAndData>();
        RowMetaInterface rowMetaInterface = this.createRowMetaInterface();
        Object[] r1 = new Object[]{};
        list.add(new RowMetaAndData(rowMetaInterface, r1));
        return list;
    }

    public RowMetaInterface createResultRowMetaInterface() {
        RowMeta rowMetaInterface = new RowMeta();
        ValueMetaInterface[] valuesMeta = new ValueMetaInterface[]{new ValueMeta("Id", 5), new ValueMeta("State", 2), new ValueMeta("City", 2)};
        for (int i = 0; i < valuesMeta.length; ++i) {
            rowMetaInterface.addValueMeta(valuesMeta[i]);
        }
        return rowMetaInterface;
    }

    private StepMeta createJsonOutputStep(String name, String jsonFileName, PluginRegistry registry) {
        String testFileOutputName = name;
        JsonOutputMeta jsonOutputMeta = new JsonOutputMeta();
        String textFileInputPid = registry.getPluginId(StepPluginType.class, (Object)jsonOutputMeta);
        StepMeta jsonOutputStep = new StepMeta(textFileInputPid, testFileOutputName, (StepMetaInterface)jsonOutputMeta);
        JsonOutputField[] fields = new JsonOutputField[3];
        for (int idx = 0; idx < fields.length; ++idx) {
            fields[idx] = new JsonOutputField();
        }
        fields[0].setFieldName("id");
        fields[0].setElementName("id");
        fields[1].setFieldName("state");
        fields[1].setElementName("state");
        fields[2].setFieldName("city");
        fields[2].setElementName("city");
        jsonOutputMeta.allocate(fields.length);
        jsonOutputMeta.setOutputFields(fields);
        jsonOutputMeta.setOperationType(1);
        jsonOutputMeta.setOutputValue("data");
        jsonOutputMeta.setFileName(jsonFileName);
        jsonOutputMeta.setExtension("js");
        jsonOutputMeta.setNrRowsInBloc("0");
        jsonOutputMeta.setJsonBloc("data");
        return jsonOutputStep;
    }

    public String test(boolean compatibilityMode) throws Exception {
        KettleEnvironment.init();
        TransMeta transMeta = new TransMeta();
        transMeta.setName("testJsonOutput");
        PluginRegistry registry = PluginRegistry.getInstance();
        String injectorStepName = "injector step";
        StepMeta injectorStep = TestUtilities.createInjectorStep(injectorStepName, registry);
        transMeta.addStep(injectorStep);
        StepMeta rowGeneratorStep = this.createRowGeneratorStep("Create rows for testJsonOutput1", registry);
        transMeta.addStep(rowGeneratorStep);
        TransHopMeta hop_injectory_rowGenerator = new TransHopMeta(injectorStep, rowGeneratorStep);
        transMeta.addTransHop(hop_injectory_rowGenerator);
        String jsonFileName = TestUtilities.createEmptyTempFile("testJsonOutput1_");
        StepMeta jsonOutputStep = this.createJsonOutputStep("json output step", jsonFileName, registry);
        ((JsonOutputMeta)jsonOutputStep.getStepMetaInterface()).setCompatibilityMode(compatibilityMode);
        transMeta.addStep(jsonOutputStep);
        TransHopMeta hop_RowGenerator_outputTextFile = new TransHopMeta(rowGeneratorStep, jsonOutputStep);
        transMeta.addTransHop(hop_RowGenerator_outputTextFile);
        String dummyStepName = "dummy step";
        StepMeta dummyStep = this.createDummyStep(dummyStepName, registry);
        transMeta.addStep(dummyStep);
        TransHopMeta hop_outputJson_dummyStep = new TransHopMeta(jsonOutputStep, dummyStep);
        transMeta.addTransHop(hop_outputJson_dummyStep);
        Trans trans = new Trans(transMeta);
        trans.prepareExecution(null);
        StepInterface dummyStepInterface = trans.getStepInterface(dummyStepName, 0);
        RowStepCollector dummyRowCollector = new RowStepCollector();
        dummyStepInterface.addRowListener((RowListener)dummyRowCollector);
        trans.startThreads();
        trans.waitUntilFinished();
        File outputFile = new File(jsonFileName + ".js");
        this.logger.info("Reading JSON file {}", (Object)outputFile);
        String jsonStructure = FileUtils.readFileToString((File)outputFile);
        this.logger.debug("JSON output => {}", (Object)jsonStructure);
        return jsonStructure;
    }

    public void testNonCompatibilityMode() throws Exception {
        String jsonStructure = this.test(false);
        Assert.assertEquals((Object)EXPECTED_NON_COMPATIBILITY_JSON, (Object)jsonStructure);
    }

    public void testCompatibilityMode() throws Exception {
        String jsonStructure = this.test(true);
        Assert.assertEquals((Object)EXPECTED_COMPATIBILITY_MODE_JSON, (Object)jsonStructure);
    }
}

