/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.mapping;

import java.util.ArrayList;
import java.util.Collections;
import junit.framework.TestCase;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.ObjectLocationSpecificationMethod;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.StepPluginType;
import org.pentaho.di.trans.RowStepCollector;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransHopMeta;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.RowListener;
import org.pentaho.di.trans.step.StepIOMetaInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.mapping.MappingIODefinition;
import org.pentaho.di.trans.steps.mapping.MappingMeta;
import org.pentaho.di.trans.steps.mapping.MappingValueRename;
import org.pentaho.di.trans.steps.rowgenerator.RowGeneratorMeta;

public class MappingTest
extends TestCase {
    private StepMeta buildRowGeneratorStep(PluginRegistry registry, String stepName) {
        RowGeneratorMeta rm = new RowGeneratorMeta();
        String rowGeneratorPid = registry.getPluginId(StepPluginType.class, (Object)rm);
        StepMeta rowGeneratorStep = new StepMeta(rowGeneratorPid, stepName, (StepMetaInterface)rm);
        String[] fieldName = new String[]{"string"};
        String[] type = new String[]{"String"};
        String[] value = new String[]{"string_value"};
        String[] fieldFormat = new String[]{""};
        String[] group = new String[]{""};
        String[] decimal = new String[]{""};
        int[] intDummies = new int[]{-1, -1, -1};
        rm.setDefault();
        rm.setFieldName(fieldName);
        rm.setFieldType(type);
        rm.setValue(value);
        rm.setFieldLength(intDummies);
        rm.setFieldPrecision(intDummies);
        rm.setRowLimit("1");
        rm.setFieldFormat(fieldFormat);
        rm.setGroup(group);
        rm.setDecimal(decimal);
        return rowGeneratorStep;
    }

    private MappingIODefinition createMappingDef(String inputStepName, String mappingStepName, String sourceValueName, String targetValueName) {
        MappingIODefinition def = new MappingIODefinition();
        def.setInputStepname(inputStepName);
        def.setOutputStepname(mappingStepName);
        def.setValueRenames(Collections.singletonList(new MappingValueRename(sourceValueName, targetValueName)));
        return def;
    }

    public void testInfoStreams_single() throws Exception {
        KettleEnvironment.init();
        PluginRegistry registry = PluginRegistry.getInstance();
        TransMeta transMeta = new TransMeta();
        transMeta.setName("Mapping Info Test");
        StepMeta rowGenerator = this.buildRowGeneratorStep(registry, "Generate Rows");
        transMeta.addStep(rowGenerator);
        String mappingName = "mapping";
        MappingMeta mappingMeta = new MappingMeta();
        mappingMeta.setSpecificationMethod(ObjectLocationSpecificationMethod.FILENAME);
        mappingMeta.setFileName("test/org/pentaho/di/trans/steps/mapping/subtrans.ktr");
        String mappingInputStepName = "input";
        mappingMeta.setInputMappings(Collections.singletonList(this.createMappingDef(rowGenerator.getName(), mappingInputStepName, "string", "a")));
        String mappingPid = registry.getPluginId(StepPluginType.class, (Object)mappingMeta);
        StepMeta mapping = new StepMeta(mappingPid, mappingName, (StepMetaInterface)mappingMeta);
        transMeta.addStep(mapping);
        TransHopMeta hopGeneratorToMapping = new TransHopMeta(rowGenerator, mapping);
        transMeta.addTransHop(hopGeneratorToMapping);
        Trans trans = new Trans(transMeta);
        trans.prepareExecution(null);
        for (int i = 0; i < transMeta.nrSteps(); ++i) {
            StepMeta stepMeta = transMeta.getStep(i);
            StepMetaInterface sii = stepMeta.getStepMetaInterface();
            if (sii == null) continue;
            sii.searchInfoAndTargetSteps(transMeta.getSteps());
        }
        MappingTest.assertEquals((String)"Transformation not initialized properly", (int)2, (int)transMeta.nrSteps());
        StepMeta meta = transMeta.getStep(1);
        MappingTest.assertTrue((String)"Transformation not initialized properly", (boolean)(meta.getStepMetaInterface() instanceof MappingMeta));
        MappingMeta loadedMappingMeta = (MappingMeta)meta.getStepMetaInterface();
        MappingTest.assertEquals((String)"Expected a single input mapping definition", (int)1, (int)loadedMappingMeta.getInputMappings().size());
        StepIOMetaInterface ioMeta = loadedMappingMeta.getStepIOMeta();
        MappingTest.assertEquals((String)"Expected a single Info Stream", (int)1, (int)ioMeta.getInfoStreams().size());
        MappingTest.assertEquals((String)"Expected a single Info Step", (int)1, (int)loadedMappingMeta.getInfoSteps().length);
        StepInterface si = trans.getStepInterface(mappingName, 0);
        RowStepCollector rc = new RowStepCollector();
        si.addRowListener((RowListener)rc);
        trans.startThreads();
        trans.waitUntilFinished();
        MappingTest.assertEquals((int)1, (int)rc.getRowsRead().size());
        MappingTest.assertEquals((int)1, (int)rc.getRowsWritten().size());
    }

    public void testInfoStreams_with_main_data_path() throws Exception {
        KettleEnvironment.init();
        PluginRegistry registry = PluginRegistry.getInstance();
        TransMeta transMeta = new TransMeta();
        transMeta.setName("Mapping Info Test");
        StepMeta rowGenerator = this.buildRowGeneratorStep(registry, "Generate Rows");
        transMeta.addStep(rowGenerator);
        StepMeta rowGeneratorMain = this.buildRowGeneratorStep(registry, "Generate Rows Main");
        transMeta.addStep(rowGeneratorMain);
        String mappingName = "mapping";
        MappingMeta mappingMeta = new MappingMeta();
        mappingMeta.setSpecificationMethod(ObjectLocationSpecificationMethod.FILENAME);
        mappingMeta.setFileName("test/org/pentaho/di/trans/steps/mapping/subtrans.ktr");
        ArrayList<MappingIODefinition> inputMappings = new ArrayList<MappingIODefinition>();
        String mappingInputStepName = "input";
        inputMappings.add(this.createMappingDef(rowGenerator.getName(), mappingInputStepName, "string", "a"));
        MappingIODefinition mainMappingDef = this.createMappingDef(rowGeneratorMain.getName(), mappingInputStepName, "string", "a");
        mainMappingDef.setMainDataPath(true);
        inputMappings.add(mainMappingDef);
        mappingMeta.setInputMappings(inputMappings);
        String mappingPid = registry.getPluginId(StepPluginType.class, (Object)mappingMeta);
        StepMeta mapping = new StepMeta(mappingPid, mappingName, (StepMetaInterface)mappingMeta);
        transMeta.addStep(mapping);
        TransHopMeta hopGeneratorToMapping = new TransHopMeta(rowGenerator, mapping);
        transMeta.addTransHop(hopGeneratorToMapping);
        hopGeneratorToMapping = new TransHopMeta(rowGeneratorMain, mapping);
        transMeta.addTransHop(hopGeneratorToMapping);
        Trans trans = new Trans(transMeta);
        trans.prepareExecution(null);
        for (int i = 0; i < transMeta.nrSteps(); ++i) {
            StepMeta stepMeta = transMeta.getStep(i);
            StepMetaInterface sii = stepMeta.getStepMetaInterface();
            if (sii == null) continue;
            sii.searchInfoAndTargetSteps(transMeta.getSteps());
        }
        MappingTest.assertEquals((String)"Transformation not initialized properly", (int)3, (int)transMeta.nrSteps());
        StepMeta meta = transMeta.getStep(2);
        MappingTest.assertTrue((String)"Transformation not initialized properly", (boolean)(meta.getStepMetaInterface() instanceof MappingMeta));
        MappingMeta loadedMappingMeta = (MappingMeta)meta.getStepMetaInterface();
        MappingTest.assertEquals((String)"Expected a two input mapping definition", (int)2, (int)loadedMappingMeta.getInputMappings().size());
        StepIOMetaInterface ioMeta = loadedMappingMeta.getStepIOMeta();
        MappingTest.assertEquals((String)"Expected a single Info Stream", (int)1, (int)ioMeta.getInfoStreams().size());
        MappingTest.assertEquals((String)"Expected a single Info Step", (int)1, (int)loadedMappingMeta.getInfoSteps().length);
    }
}

