/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.metainject;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepInjectionMetaEntry;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInjectionInterface;
import org.pentaho.di.trans.steps.csvinput.CsvInputMeta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaInjectTest
extends TestCase {
    public void testMetaInjectCsvInput() throws Exception {
        KettleEnvironment.init();
        TransMeta transMeta = new TransMeta("test/org/pentaho/di/trans/steps/metainject/read_csv_file.ktr");
        String[][] fields = new String[][]{{"id", "Integer", null, "3", "0", null, ",", ".", "left"}, {"name", "String", null, "10", null, null, null, null, "none"}, {"firstname", "String", null, "13", null, null, null, null, "none"}, {"zip", "String", null, "5", null, null, null, null, "left"}, {"city", "String", null, "8", null, null, null, null, "none"}, {"birthdate", "Date", "yyyy/MM/dd", "10", null, null, null, null, "none"}, {"street", "String", null, "11", null, null, null, null, "none"}, {"housenr", "Integer", null, "3", "0", null, ",", ".", "left"}, {"stateCode", "String", null, "9", null, null, null, null, "none"}, {"state", "String", null, "30", null, null, null, null, "none"}};
        String[] fieldKeys = new String[]{"FIELD_NAME", "FIELD_TYPE", "FIELD_FORMAT", "FIELD_LENGTH", "FIELD_PRECISION", "FIELD_CURRENCY", "FIELD_DECIMAL", "FIELD_GROUP", "FIELD_TRIM_TYPE"};
        String filename = "test/org/pentaho/di/trans/steps/metainject/customers-100.txt";
        String stepname = "CSV file input";
        StepMeta stepMeta = transMeta.findStep(stepname);
        CsvInputMeta csvInputMeta = (CsvInputMeta)stepMeta.getStepMetaInterface();
        StepMetaInjectionInterface injectionInterface = csvInputMeta.getStepMetaInjectionInterface();
        List entries = injectionInterface.getStepInjectionMetadataEntries();
        ArrayList<StepInjectionMetaEntry> injection = new ArrayList<StepInjectionMetaEntry>();
        StepInjectionMetaEntry filenameEntry = this.findMetaEntry(entries, "FILENAME");
        MetaInjectTest.assertNotNull((Object)filenameEntry);
        filenameEntry.setValue((Object)filename);
        injection.add(filenameEntry);
        StepInjectionMetaEntry fieldsEntry = this.findMetaEntry(entries, "FIELDS");
        MetaInjectTest.assertNotNull((Object)fieldsEntry);
        StepInjectionMetaEntry fieldEntry = (StepInjectionMetaEntry)fieldsEntry.getDetails().get(0);
        StepInjectionMetaEntry fieldsCopy = fieldsEntry.clone();
        fieldsCopy.setDetails(new ArrayList());
        injection.add(fieldsCopy);
        for (String[] field : fields) {
            StepInjectionMetaEntry fieldCopy = fieldEntry.clone();
            fieldCopy.setDetails(new ArrayList());
            for (int i = 0; i < fieldKeys.length; ++i) {
                StepInjectionMetaEntry entry = new StepInjectionMetaEntry(fieldKeys[i], (Object)field[i], 2, "description");
                fieldCopy.getDetails().add(entry);
            }
            fieldsCopy.getDetails().add(fieldCopy);
        }
        csvInputMeta.injectStepMetadataEntries(injection);
        MetaInjectTest.assertEquals((String)filename, (String)csvInputMeta.getFilename());
        MetaInjectTest.assertEquals((int)10, (int)csvInputMeta.getInputFields().length);
        Trans trans = new Trans(transMeta);
        trans.execute(null);
        trans.waitUntilFinished();
        Result result = trans.getResult();
        MetaInjectTest.assertEquals((long)101L, (long)result.getNrLinesInput());
        MetaInjectTest.assertEquals((long)100L, (long)result.getNrLinesWritten());
        RowMetaInterface rowMeta = transMeta.getStepFields(stepname);
        for (int i = 0; i < rowMeta.getValueMetaList().size(); ++i) {
            ValueMetaInterface valueMeta = (ValueMetaInterface)rowMeta.getValueMetaList().get(i);
            MetaInjectTest.assertEquals((String)fields[i][0], (String)valueMeta.getName());
            MetaInjectTest.assertEquals((String)fields[i][1], (String)valueMeta.getTypeDesc());
            MetaInjectTest.assertEquals((String)fields[i][2], (String)valueMeta.getConversionMask());
            MetaInjectTest.assertEquals((String)fields[i][3], valueMeta.getLength() == -1 ? null : Integer.toString(valueMeta.getLength()));
            MetaInjectTest.assertEquals((String)fields[i][4], valueMeta.getPrecision() == -1 ? null : Integer.toString(valueMeta.getPrecision()));
            MetaInjectTest.assertEquals((String)fields[i][5], (String)valueMeta.getCurrencySymbol());
            MetaInjectTest.assertEquals((String)fields[i][6], (String)valueMeta.getDecimalSymbol());
            MetaInjectTest.assertEquals((String)fields[i][7], (String)valueMeta.getGroupingSymbol());
            MetaInjectTest.assertEquals((String)fields[i][8], (String)ValueMeta.getTrimTypeCode((int)valueMeta.getTrimType()));
        }
    }

    private StepInjectionMetaEntry findMetaEntry(List<StepInjectionMetaEntry> entries, String key) {
        for (StepInjectionMetaEntry entry : entries) {
            if (!entry.getKey().equals(key)) continue;
            return entry;
        }
        return null;
    }
}

