/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.numberrange;

import junit.framework.TestCase;
import org.pentaho.di.trans.steps.numberrange.NumberRangeRule;

public class NumberRangeRuleTest
extends TestCase {
    private static final String VALUE_10_20 = "10-20";
    private static NumberRangeRule numberRangeRule;

    public void testEvaluate() {
        numberRangeRule = new NumberRangeRule(10.0, 20.0, VALUE_10_20);
        NumberRangeRuleTest.assertEquals((String)"Missed value in middle of range", (String)VALUE_10_20, (String)numberRangeRule.evaluate(15.0));
        NumberRangeRuleTest.assertEquals((String)"Missed value within lower bound", (String)VALUE_10_20, (String)numberRangeRule.evaluate(10.0));
        NumberRangeRuleTest.assertEquals((String)"Missed value outside lower bound", null, (String)numberRangeRule.evaluate(9.999));
        NumberRangeRuleTest.assertEquals((String)"Missed value within upper bound", (String)VALUE_10_20, (String)numberRangeRule.evaluate(19.9999));
        NumberRangeRuleTest.assertEquals((String)"Missed value outside upper bound", null, (String)numberRangeRule.evaluate(20.0));
        NumberRangeRuleTest.assertEquals((String)"Missed value at 0", null, (String)numberRangeRule.evaluate(0.0));
        NumberRangeRuleTest.assertEquals((String)"Missed value at max integer", null, (String)numberRangeRule.evaluate(2.147483647E9));
        NumberRangeRuleTest.assertEquals((String)"Missed negative value", null, (String)numberRangeRule.evaluate(-20.0));
    }
}

