/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.numberrange;

import java.util.Arrays;
import junit.framework.TestCase;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.trans.steps.numberrange.NumberRangeRule;
import org.pentaho.di.trans.steps.numberrange.NumberRangeSet;

public class NumberRangeSetTest
extends TestCase {
    private static final String VALUE_LESS_10 = "Less than 10";
    private static final String VALUE_10_20 = "10-20";
    private static final String VALUE_TO_20 = "Up to 20";
    private static final String VALUE_MORE_20 = "More than 20";
    private static final String FALLBACK_VALUE = "unknown";
    private NumberRangeSet numberRange;

    public void setUp() throws Exception {
        NumberRangeRule rule1 = new NumberRangeRule(0.0, 10.0, VALUE_LESS_10);
        NumberRangeRule rule2 = new NumberRangeRule(10.0, 20.0, VALUE_10_20);
        NumberRangeRule rule3 = new NumberRangeRule(0.0, 20.0, VALUE_TO_20);
        NumberRangeRule rule4 = new NumberRangeRule(20.0, 2.147483647E9, VALUE_MORE_20);
        this.numberRange = new NumberRangeSet(Arrays.asList(rule1, rule2, rule3, rule4), FALLBACK_VALUE);
    }

    public void testEvaluateDouble() throws Exception {
        this.setUp();
        NumberRangeSetTest.assertEquals((String)"Wrong values calculated for 0", (String)(VALUE_LESS_10 + NumberRangeSet.getMultiValueSeparator() + VALUE_TO_20), (String)this.numberRange.evaluateDouble(0.0));
        NumberRangeSetTest.assertEquals((String)"Wrong values calculated for negative value", (String)"", (String)this.numberRange.evaluateDouble(-10.0));
        NumberRangeSetTest.assertEquals((String)"Wrong values calculated for value below first lower bound", (String)(VALUE_LESS_10 + NumberRangeSet.getMultiValueSeparator() + VALUE_TO_20), (String)this.numberRange.evaluateDouble(9.999));
        NumberRangeSetTest.assertEquals((String)"Wrong values calculated for first lower bound", (String)(VALUE_10_20 + NumberRangeSet.getMultiValueSeparator() + VALUE_TO_20), (String)this.numberRange.evaluateDouble(10.0));
        NumberRangeSetTest.assertEquals((String)"Wrong values calculated within range", (String)(VALUE_10_20 + NumberRangeSet.getMultiValueSeparator() + VALUE_TO_20), (String)this.numberRange.evaluateDouble(15.0));
        NumberRangeSetTest.assertEquals((String)"Wrong values calculated at upper bound", (String)VALUE_MORE_20, (String)this.numberRange.evaluateDouble(20.0));
        NumberRangeSetTest.assertEquals((String)"Wrong values calculated above upper bound", (String)VALUE_MORE_20, (String)this.numberRange.evaluateDouble(50.0));
    }

    public void testEvaluate() throws Exception {
        this.setUp();
        NumberRangeSetTest.assertEquals((String)"Wrong values calculated if double is passed", (String)(VALUE_LESS_10 + NumberRangeSet.getMultiValueSeparator() + VALUE_TO_20), (String)this.numberRange.evaluate("0"));
        try {
            this.numberRange.evaluate("10 EUR");
            NumberRangeSetTest.assertTrue((String)"String to number worked for '10 EUR' when it was expected to fail", (boolean)false);
        }
        catch (KettleException e) {
            // empty catch block
        }
        try {
            this.numberRange.evaluate("");
            NumberRangeSetTest.assertTrue((String)"String to number worked for an empty when it was expected to fail", (boolean)false);
        }
        catch (KettleException kettleException) {
            // empty catch block
        }
        NumberRangeSetTest.assertEquals((String)"Didn't handle null value", (String)FALLBACK_VALUE, (String)this.numberRange.evaluate((String)null));
    }
}

