/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.regexeval;

import java.util.List;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.TransTestFactory;
import org.pentaho.di.trans.TransformationTestCase;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.regexeval.RegexEvalMeta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegexEvalTest
extends TransformationTestCase {
    public RowMetaInterface createSourceRowMetaInterface() {
        return this.createRowMetaInterface(new ValueMeta("field1", 2));
    }

    public RowMetaInterface createResultRowMetaInterface1() {
        RowMetaInterface rm = this.createSourceRowMetaInterface();
        rm.addValueMeta((ValueMetaInterface)new ValueMeta("res", 4));
        return rm;
    }

    public RowMetaInterface createResultRowMetaInterface2() {
        RowMetaInterface rm = this.createResultRowMetaInterface1();
        rm.addValueMeta((ValueMetaInterface)new ValueMeta("cap", 5));
        return rm;
    }

    public RowMetaInterface createResultRowMetaInterface3() {
        return this.createRowMetaInterface(new ValueMeta("field1", 2), new ValueMeta("res", 4), new ValueMeta("cap", 2), new ValueMeta("capIfNull", 2), new ValueMeta("capNullIf", 2), new ValueMeta("capIfNullNullIf", 5));
    }

    public List<RowMetaAndData> createSourceData() {
        return this.createData(this.createSourceRowMetaInterface(), new Object[][]{{"abc"}, {"ABC"}, {"123"}, {"abc"}});
    }

    public List<RowMetaAndData> createResultData1() {
        return this.createData(this.createResultRowMetaInterface1(), new Object[][]{{"abc", true}, {"ABC", false}, {"123", false}, {"abc", true}});
    }

    public List<RowMetaAndData> createResultData2() {
        return this.createData(this.createResultRowMetaInterface2(), new Object[][]{{"abc", false}, {"ABC", false}, {"123", true, 2L}, {"abc", false}});
    }

    public List<RowMetaAndData> createResultData3() {
        return this.createData(this.createResultRowMetaInterface3(), new Object[][]{{"abc", true, "a", "a", null, 0L}, {"ABC", true, "A", "x", "A", 0L}, {"123", true, "1", "x", null, 2L}, {"abc", true, "a", "a", null, 0L}});
    }

    public void testRegexEval1() throws Exception {
        String regexStepName = "regexeval";
        RegexEvalMeta regexEvalMeta = new RegexEvalMeta();
        regexEvalMeta.setScript("[abc]*");
        regexEvalMeta.setMatcher("field1");
        regexEvalMeta.setResultFieldName("res");
        TransMeta transMeta = TransTestFactory.generateTestTransformation((VariableSpace)new Variables(), (StepMetaInterface)regexEvalMeta, regexStepName);
        List<RowMetaAndData> result = TransTestFactory.executeTestTransformation(transMeta, "injector", regexStepName, "dummy", this.createSourceData());
        this.checkRows(this.createResultData1(), result);
    }

    public void testRegexEval2() throws Exception {
        String regexStepName = "regexeval";
        RegexEvalMeta regexEvalMeta = new RegexEvalMeta();
        regexEvalMeta.setScript("\\d(\\d)\\d");
        regexEvalMeta.setMatcher("field1");
        regexEvalMeta.setResultFieldName("res");
        regexEvalMeta.setAllowCaptureGroupsFlag(true);
        regexEvalMeta.allocate(1);
        regexEvalMeta.getFieldName()[0] = "cap";
        regexEvalMeta.getFieldType()[0] = 5;
        TransMeta transMeta = TransTestFactory.generateTestTransformation((VariableSpace)new Variables(), (StepMetaInterface)regexEvalMeta, regexStepName);
        List<RowMetaAndData> result = TransTestFactory.executeTestTransformation(transMeta, "injector", regexStepName, "dummy", this.createSourceData());
        this.checkRows(this.createResultData2(), result);
    }

    public void testRegexEval3() throws Exception {
        String regexStepName = "regexeval";
        RegexEvalMeta regexEvalMeta = new RegexEvalMeta();
        regexEvalMeta.setScript("((a)|([A1]))([B2]?).*");
        regexEvalMeta.setMatcher("field1");
        regexEvalMeta.setResultFieldName("res");
        regexEvalMeta.setAllowCaptureGroupsFlag(true);
        regexEvalMeta.allocate(4);
        regexEvalMeta.getFieldName()[0] = "cap";
        regexEvalMeta.getFieldType()[0] = 2;
        regexEvalMeta.getFieldName()[1] = "capIfNull";
        regexEvalMeta.getFieldType()[1] = 2;
        regexEvalMeta.getFieldIfNull()[1] = "x";
        regexEvalMeta.getFieldName()[2] = "capNullIf";
        regexEvalMeta.getFieldType()[2] = 2;
        regexEvalMeta.getFieldNullIf()[2] = "1";
        regexEvalMeta.getFieldName()[3] = "capIfNullNullIf";
        regexEvalMeta.getFieldType()[3] = 5;
        regexEvalMeta.getFieldIfNull()[3] = "0";
        regexEvalMeta.getFieldNullIf()[3] = "B";
        TransMeta transMeta = TransTestFactory.generateTestTransformation((VariableSpace)new Variables(), (StepMetaInterface)regexEvalMeta, regexStepName);
        List<RowMetaAndData> result = TransTestFactory.executeTestTransformation(transMeta, "injector", regexStepName, "dummy", this.createSourceData());
        this.checkRows(this.createResultData3(), result);
    }
}

