/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.rowgenerator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.StepPluginType;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.trans.RowStepCollector;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransHopMeta;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.RowListener;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.dummytrans.DummyTransMeta;
import org.pentaho.di.trans.steps.rowgenerator.RowGeneratorMeta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RowGeneratorTest
extends TestCase {
    public RowMetaInterface createRowMetaInterface() {
        RowMeta rm = new RowMeta();
        ValueMetaInterface[] valuesMeta = new ValueMetaInterface[]{new ValueMeta("string", 2), new ValueMeta("boolean", 4), new ValueMeta("integer", 5)};
        for (int i = 0; i < valuesMeta.length; ++i) {
            rm.addValueMeta(valuesMeta[i]);
        }
        return rm;
    }

    public List<RowMetaAndData> createData() {
        ArrayList<RowMetaAndData> list = new ArrayList<RowMetaAndData>();
        RowMetaInterface rm = this.createRowMetaInterface();
        Object[] r1 = new Object[]{"string_value", Boolean.TRUE, new Long(20L)};
        list.add(new RowMetaAndData(rm, r1));
        list.add(new RowMetaAndData(rm, r1));
        list.add(new RowMetaAndData(rm, r1));
        return list;
    }

    public void checkRows(List<RowMetaAndData> rows1, List<RowMetaAndData> rows2) {
        int idx = 1;
        if (rows1.size() != rows2.size()) {
            RowGeneratorTest.fail((String)("Number of rows is not the same: " + rows1.size() + " and " + rows2.size()));
        }
        Iterator<RowMetaAndData> it1 = rows1.iterator();
        Iterator<RowMetaAndData> it2 = rows2.iterator();
        while (it1.hasNext() && it2.hasNext()) {
            RowMetaAndData rm1 = it1.next();
            RowMetaAndData rm2 = it2.next();
            Object[] r1 = rm1.getData();
            Object[] r2 = rm2.getData();
            if (rm1.size() != rm2.size()) {
                RowGeneratorTest.fail((String)("row nr " + idx + " is not equal"));
            }
            int[] fields = new int[rm1.size()];
            for (int ydx = 0; ydx < rm1.size(); ++ydx) {
                fields[ydx] = ydx;
            }
            try {
                if (rm1.getRowMeta().compare(r1, r2, fields) != 0) {
                    RowGeneratorTest.fail((String)("row nr " + idx + "is not equal"));
                }
            }
            catch (KettleValueException e) {
                RowGeneratorTest.fail((String)("row nr " + idx + "is not equal"));
            }
            ++idx;
        }
    }

    public void testRowGenerator() throws Exception {
        KettleEnvironment.init();
        TransMeta transMeta = new TransMeta();
        transMeta.setName("row generatortest");
        PluginRegistry registry = PluginRegistry.getInstance();
        String rowGeneratorStepname = "row generator step";
        RowGeneratorMeta rm = new RowGeneratorMeta();
        String rowGeneratorPid = registry.getPluginId(StepPluginType.class, (Object)rm);
        StepMeta rowGeneratorStep = new StepMeta(rowGeneratorPid, rowGeneratorStepname, (StepMetaInterface)rm);
        transMeta.addStep(rowGeneratorStep);
        String[] fieldName = new String[]{"string", "boolean", "integer"};
        String[] type = new String[]{"String", "Boolean", "Integer"};
        String[] value = new String[]{"string_value", "true", "20"};
        String[] fieldFormat = new String[]{"", "", ""};
        String[] group = new String[]{"", "", ""};
        String[] decimal = new String[]{"", "", ""};
        int[] intDummies = new int[]{-1, -1, -1};
        rm.setDefault();
        rm.setFieldName(fieldName);
        rm.setFieldType(type);
        rm.setValue(value);
        rm.setFieldLength(intDummies);
        rm.setFieldPrecision(intDummies);
        rm.setRowLimit("3");
        rm.setFieldFormat(fieldFormat);
        rm.setGroup(group);
        rm.setDecimal(decimal);
        String dummyStepname = "dummy step";
        DummyTransMeta dm = new DummyTransMeta();
        String dummyPid = registry.getPluginId(StepPluginType.class, (Object)dm);
        StepMeta dummyStep = new StepMeta(dummyPid, dummyStepname, (StepMetaInterface)dm);
        transMeta.addStep(dummyStep);
        TransHopMeta hi = new TransHopMeta(rowGeneratorStep, dummyStep);
        transMeta.addTransHop(hi);
        Trans trans = new Trans(transMeta);
        trans.prepareExecution(null);
        StepInterface si = trans.getStepInterface(dummyStepname, 0);
        RowStepCollector rc = new RowStepCollector();
        si.addRowListener((RowListener)rc);
        trans.startThreads();
        trans.waitUntilFinished();
        List<RowMetaAndData> checkList = this.createData();
        List<RowMetaAndData> resultRows = rc.getRowsWritten();
        this.checkRows(resultRows, checkList);
    }
}

