/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.scriptvalues_mod;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.StepPluginType;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.trans.RowProducer;
import org.pentaho.di.trans.RowStepCollector;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransHopMeta;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.RowListener;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.dummytrans.DummyTransMeta;
import org.pentaho.di.trans.steps.injector.InjectorMeta;
import org.pentaho.di.trans.steps.scriptvalues_mod.ScriptValuesMetaMod;
import org.pentaho.di.trans.steps.scriptvalues_mod.ScriptValuesScript;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaScriptSpecialTest
extends TestCase {
    public RowMetaInterface createRowMetaInterface1() {
        RowMeta rm = new RowMeta();
        ValueMetaInterface[] valuesMeta = new ValueMetaInterface[]{new ValueMeta("string", 2)};
        for (int i = 0; i < valuesMeta.length; ++i) {
            rm.addValueMeta(valuesMeta[i]);
        }
        return rm;
    }

    public List<RowMetaAndData> createData1() {
        ArrayList<RowMetaAndData> list = new ArrayList<RowMetaAndData>();
        RowMetaInterface rm = this.createRowMetaInterface1();
        Object[] r1 = new Object[]{"446-667-651"};
        Object[] r2 = new Object[]{"446667651"};
        Object[] r3 = new Object[]{"4444333322221111"};
        Object[] r4 = new Object[]{"4444 3333 2222 1111"};
        Object[] r5 = new Object[]{"444433332aa2221111"};
        Object[] r6 = new Object[]{"4444333322221111aa"};
        list.add(new RowMetaAndData(rm, r1));
        list.add(new RowMetaAndData(rm, r2));
        list.add(new RowMetaAndData(rm, r3));
        list.add(new RowMetaAndData(rm, r4));
        list.add(new RowMetaAndData(rm, r5));
        list.add(new RowMetaAndData(rm, r6));
        return list;
    }

    public RowMetaInterface createRowMetaInterfaceResult1() {
        RowMeta rm = new RowMeta();
        ValueMetaInterface[] valuesMeta = new ValueMetaInterface[]{new ValueMeta("string", 2), new ValueMeta("bool", 4)};
        for (int i = 0; i < valuesMeta.length; ++i) {
            rm.addValueMeta(valuesMeta[i]);
        }
        return rm;
    }

    public List<RowMetaAndData> createResultData1() {
        ArrayList<RowMetaAndData> list = new ArrayList<RowMetaAndData>();
        RowMetaInterface rm = this.createRowMetaInterfaceResult1();
        Object[] r1 = new Object[]{"446-667-651", Boolean.FALSE};
        Object[] r2 = new Object[]{"446667651", Boolean.TRUE};
        Object[] r3 = new Object[]{"4444333322221111", Boolean.TRUE};
        Object[] r4 = new Object[]{"4444 3333 2222 1111", Boolean.FALSE};
        Object[] r5 = new Object[]{"444433332aa2221111", Boolean.FALSE};
        Object[] r6 = new Object[]{"4444333322221111aa", Boolean.FALSE};
        list.add(new RowMetaAndData(rm, r1));
        list.add(new RowMetaAndData(rm, r2));
        list.add(new RowMetaAndData(rm, r3));
        list.add(new RowMetaAndData(rm, r4));
        list.add(new RowMetaAndData(rm, r5));
        list.add(new RowMetaAndData(rm, r6));
        return list;
    }

    public List<RowMetaAndData> createResultData2() {
        ArrayList<RowMetaAndData> list = new ArrayList<RowMetaAndData>();
        RowMetaInterface rm = this.createRowMetaInterface1();
        Object[] r1 = new Object[]{"446-667-651"};
        Object[] r2 = new Object[]{"446667651"};
        Object[] r3 = new Object[]{"4444333322221111"};
        list.add(new RowMetaAndData(rm, r1));
        list.add(new RowMetaAndData(rm, r2));
        list.add(new RowMetaAndData(rm, r3));
        return list;
    }

    public RowMetaInterface createRowMetaInterface3() {
        RowMeta rm = new RowMeta();
        ValueMetaInterface[] valuesMeta = new ValueMetaInterface[]{new ValueMeta("int_in", 5), new ValueMeta("number_in", 1), new ValueMeta("string_in", 2)};
        for (int i = 0; i < valuesMeta.length; ++i) {
            rm.addValueMeta(valuesMeta[i]);
        }
        return rm;
    }

    public List<RowMetaAndData> createData3() {
        ArrayList<RowMetaAndData> list = new ArrayList<RowMetaAndData>();
        RowMetaInterface rm = this.createRowMetaInterface3();
        Object[] r1 = new Object[]{new Long(1L), new Double(1.0), "1"};
        Object[] r2 = new Object[]{new Long(2L), new Double(2.0), "2"};
        Object[] r3 = new Object[]{new Long(3L), new Double(3.0), "3"};
        Object[] r4 = new Object[]{new Long(4L), new Double(4.0), "4"};
        list.add(new RowMetaAndData(rm, r1));
        list.add(new RowMetaAndData(rm, r2));
        list.add(new RowMetaAndData(rm, r3));
        list.add(new RowMetaAndData(rm, r4));
        return list;
    }

    public RowMetaInterface createRowMetaInterface4() {
        RowMeta rm = new RowMeta();
        ValueMetaInterface[] valuesMeta = new ValueMetaInterface[]{new ValueMeta("int_in", 5), new ValueMeta("number_in", 1), new ValueMeta("string_in", 2), new ValueMeta("long1", 5), new ValueMeta("number1", 1), new ValueMeta("string1", 2), new ValueMeta("long2", 5), new ValueMeta("number2", 1), new ValueMeta("string2", 2)};
        for (int i = 0; i < valuesMeta.length; ++i) {
            rm.addValueMeta(valuesMeta[i]);
        }
        return rm;
    }

    public List<RowMetaAndData> createResultData3() {
        ArrayList<RowMetaAndData> list = new ArrayList<RowMetaAndData>();
        RowMetaInterface rm = this.createRowMetaInterface4();
        Object[] r1 = new Object[]{new Long(1L), new Double(1.0), "1", new Long(2L), new Double(2.0), "2", new Long(2L), new Double(2.0), "2"};
        Object[] r2 = new Object[]{new Long(2L), new Double(2.0), "2", new Long(3L), new Double(3.0), "3", new Long(3L), new Double(3.0), "3"};
        Object[] r3 = new Object[]{new Long(3L), new Double(3.0), "3", new Long(4L), new Double(4.0), "4", new Long(4L), new Double(4.0), "4"};
        Object[] r4 = new Object[]{new Long(4L), new Double(4.0), "4", new Long(5L), new Double(5.0), "5", new Long(5L), new Double(5.0), "5"};
        list.add(new RowMetaAndData(rm, r1));
        list.add(new RowMetaAndData(rm, r2));
        list.add(new RowMetaAndData(rm, r3));
        list.add(new RowMetaAndData(rm, r4));
        return list;
    }

    public void checkRows(List<RowMetaAndData> rows1, List<RowMetaAndData> rows2) {
        int idx = 1;
        if (rows1.size() != rows2.size()) {
            JavaScriptSpecialTest.fail((String)("Number of rows is not the same: " + rows1.size() + " and " + rows2.size()));
        }
        Iterator<RowMetaAndData> it1 = rows1.iterator();
        Iterator<RowMetaAndData> it2 = rows2.iterator();
        while (it1.hasNext() && it2.hasNext()) {
            RowMetaAndData rm1 = it1.next();
            RowMetaAndData rm2 = it2.next();
            Object[] r1 = rm1.getData();
            Object[] r2 = rm2.getData();
            if (rm1.size() != rm2.size()) {
                JavaScriptSpecialTest.fail((String)("row nr " + idx + " is not equal"));
            }
            int[] fields = new int[rm1.size()];
            for (int ydx = 0; ydx < rm1.size(); ++ydx) {
                fields[ydx] = ydx;
            }
            try {
                if (rm1.getRowMeta().compare(r1, r2, fields) != 0) {
                    JavaScriptSpecialTest.fail((String)("row nr " + idx + " is not equal"));
                }
            }
            catch (KettleValueException e) {
                JavaScriptSpecialTest.fail((String)("row nr " + idx + " is not equal"));
            }
            ++idx;
        }
    }

    public void testLuhnCheck() throws Exception {
        KettleEnvironment.init();
        TransMeta transMeta = new TransMeta();
        transMeta.setName("test javascript LuhnCheck");
        PluginRegistry registry = PluginRegistry.getInstance();
        String injectorStepname = "injector step";
        InjectorMeta im = new InjectorMeta();
        String injectorPid = registry.getPluginId(StepPluginType.class, (Object)im);
        StepMeta injectorStep = new StepMeta(injectorPid, injectorStepname, (StepMetaInterface)im);
        transMeta.addStep(injectorStep);
        String javaScriptStepname = "javascript step";
        ScriptValuesMetaMod svm = new ScriptValuesMetaMod();
        ScriptValuesScript[] js = new ScriptValuesScript[]{new ScriptValuesScript(0, "script", "var str = string;\nvar bool = LuhnCheck(str);")};
        svm.setJSScripts(js);
        svm.setFieldname(new String[]{"bool"});
        svm.setRename(new String[]{""});
        svm.setType(new int[]{4});
        svm.setLength(new int[]{-1});
        svm.setPrecision(new int[]{-1});
        svm.setReplace(new boolean[]{false});
        svm.setCompatible(false);
        String javaScriptStepPid = registry.getPluginId(StepPluginType.class, (Object)svm);
        StepMeta javaScriptStep = new StepMeta(javaScriptStepPid, javaScriptStepname, (StepMetaInterface)svm);
        transMeta.addStep(javaScriptStep);
        TransHopMeta hi1 = new TransHopMeta(injectorStep, javaScriptStep);
        transMeta.addTransHop(hi1);
        String dummyStepname = "dummy step";
        DummyTransMeta dm = new DummyTransMeta();
        String dummyPid = registry.getPluginId(StepPluginType.class, (Object)dm);
        StepMeta dummyStep = new StepMeta(dummyPid, dummyStepname, (StepMetaInterface)dm);
        transMeta.addStep(dummyStep);
        TransHopMeta hi2 = new TransHopMeta(javaScriptStep, dummyStep);
        transMeta.addTransHop(hi2);
        Trans trans = new Trans(transMeta);
        trans.prepareExecution(null);
        StepInterface si = trans.getStepInterface(javaScriptStepname, 0);
        RowStepCollector javaScriptRc = new RowStepCollector();
        si.addRowListener((RowListener)javaScriptRc);
        si = trans.getStepInterface(dummyStepname, 0);
        RowStepCollector dummyRc = new RowStepCollector();
        si.addRowListener((RowListener)dummyRc);
        RowProducer rp = trans.addRowProducer(injectorStepname, 0);
        trans.startThreads();
        List<RowMetaAndData> inputList = this.createData1();
        for (RowMetaAndData rm : inputList) {
            rp.putRow(rm.getRowMeta(), rm.getData());
        }
        rp.finished();
        trans.waitUntilFinished();
        List<RowMetaAndData> goldenImageRows = this.createResultData1();
        List<RowMetaAndData> resultRows1 = javaScriptRc.getRowsWritten();
        this.checkRows(resultRows1, goldenImageRows);
        List<RowMetaAndData> resultRows2 = dummyRc.getRowsRead();
        this.checkRows(resultRows2, goldenImageRows);
    }

    public void testTransStatus() throws Exception {
        KettleEnvironment.init();
        TransMeta transMeta = new TransMeta();
        transMeta.setName("test javascript trans_Status");
        PluginRegistry registry = PluginRegistry.getInstance();
        String injectorStepname = "injector step";
        InjectorMeta im = new InjectorMeta();
        String injectorPid = registry.getPluginId(StepPluginType.class, (Object)im);
        StepMeta injectorStep = new StepMeta(injectorPid, injectorStepname, (StepMetaInterface)im);
        transMeta.addStep(injectorStep);
        String javaScriptStepname = "javascript step";
        ScriptValuesMetaMod svm = new ScriptValuesMetaMod();
        ScriptValuesScript[] js = new ScriptValuesScript[]{new ScriptValuesScript(0, "script", "trans_Status = CONTINUE_TRANSFORMATION;\nif (getProcessCount(\"r\") > 3) {\n \ttrans_Status = SKIP_TRANSFORMATION;\n}")};
        svm.setJSScripts(js);
        svm.setFieldname(new String[0]);
        svm.setRename(new String[0]);
        svm.setType(new int[0]);
        svm.setLength(new int[0]);
        svm.setPrecision(new int[0]);
        svm.setCompatible(false);
        String javaScriptStepPid = registry.getPluginId(StepPluginType.class, (Object)svm);
        StepMeta javaScriptStep = new StepMeta(javaScriptStepPid, javaScriptStepname, (StepMetaInterface)svm);
        transMeta.addStep(javaScriptStep);
        TransHopMeta hi1 = new TransHopMeta(injectorStep, javaScriptStep);
        transMeta.addTransHop(hi1);
        String dummyStepname = "dummy step";
        DummyTransMeta dm = new DummyTransMeta();
        String dummyPid = registry.getPluginId(StepPluginType.class, (Object)dm);
        StepMeta dummyStep = new StepMeta(dummyPid, dummyStepname, (StepMetaInterface)dm);
        transMeta.addStep(dummyStep);
        TransHopMeta hi2 = new TransHopMeta(javaScriptStep, dummyStep);
        transMeta.addTransHop(hi2);
        Trans trans = new Trans(transMeta);
        trans.prepareExecution(null);
        StepInterface si = trans.getStepInterface(javaScriptStepname, 0);
        RowStepCollector javaScriptRc = new RowStepCollector();
        si.addRowListener((RowListener)javaScriptRc);
        si = trans.getStepInterface(dummyStepname, 0);
        RowStepCollector dummyRc = new RowStepCollector();
        si.addRowListener((RowListener)dummyRc);
        RowProducer rp = trans.addRowProducer(injectorStepname, 0);
        trans.startThreads();
        List<RowMetaAndData> inputList = this.createData1();
        for (RowMetaAndData rm : inputList) {
            rp.putRow(rm.getRowMeta(), rm.getData());
        }
        rp.finished();
        trans.waitUntilFinished();
        List<RowMetaAndData> goldenImageRows = this.createResultData2();
        List<RowMetaAndData> resultRows1 = javaScriptRc.getRowsWritten();
        this.checkRows(resultRows1, goldenImageRows);
        List<RowMetaAndData> resultRows2 = dummyRc.getRowsRead();
        this.checkRows(resultRows2, goldenImageRows);
    }

    public void testJavaInterface() throws Exception {
        KettleEnvironment.init();
        TransMeta transMeta = new TransMeta();
        transMeta.setName("test javascript interface");
        PluginRegistry registry = PluginRegistry.getInstance();
        String injectorStepname = "injector step";
        InjectorMeta im = new InjectorMeta();
        String injectorPid = registry.getPluginId(StepPluginType.class, (Object)im);
        StepMeta injectorStep = new StepMeta(injectorPid, injectorStepname, (StepMetaInterface)im);
        transMeta.addStep(injectorStep);
        String javaScriptStepname = "javascript step";
        ScriptValuesMetaMod svm = new ScriptValuesMetaMod();
        ScriptValuesScript[] js = new ScriptValuesScript[]{new ScriptValuesScript(0, "script1", "java;\n\nvar obj     = new Packages.org.pentaho.di.trans.steps.scriptvalues_mod.JavaScriptTest();\nvar long1   = obj.add1ToLong(getInputRowMeta().getInteger(row, 0));\nvar number1 = obj.add1ToNumber(getInputRowMeta().getNumber(row, 1));\nvar string1 = obj.add1ToString(getInputRowMeta().getString(row, 2));\nvar long2   = Packages.org.pentaho.di.trans.steps.scriptvalues_mod.JavaScriptTest.add1ToLongStatic(getInputRowMeta().getInteger(row, 0));\nvar number2 = Packages.org.pentaho.di.trans.steps.scriptvalues_mod.JavaScriptTest.add1ToNumberStatic(getInputRowMeta().getNumber(row, 1));\nvar string2 = Packages.org.pentaho.di.trans.steps.scriptvalues_mod.JavaScriptTest.add1ToStringStatic(getInputRowMeta().getString(row, 2));\n")};
        svm.setJSScripts(js);
        svm.setFieldname(new String[]{"long1", "number1", "string1", "long2", "number2", "string2"});
        svm.setRename(new String[]{"long1", "number1", "string1", "long2", "number2", "string2"});
        svm.setType(new int[]{5, 1, 2, 5, 1, 2});
        svm.setLength(new int[]{-1, -1, -1, -1, -1, -1, -1});
        svm.setPrecision(new int[]{-1, -1, -1, -1, -1, -1, -1});
        svm.setReplace(new boolean[]{false, false, false, false, false, false});
        svm.setCompatible(false);
        String javaScriptStepPid = registry.getPluginId(StepPluginType.class, (Object)svm);
        StepMeta javaScriptStep = new StepMeta(javaScriptStepPid, javaScriptStepname, (StepMetaInterface)svm);
        transMeta.addStep(javaScriptStep);
        TransHopMeta hi1 = new TransHopMeta(injectorStep, javaScriptStep);
        transMeta.addTransHop(hi1);
        String dummyStepname = "dummy step";
        DummyTransMeta dm = new DummyTransMeta();
        String dummyPid = registry.getPluginId(StepPluginType.class, (Object)dm);
        StepMeta dummyStep = new StepMeta(dummyPid, dummyStepname, (StepMetaInterface)dm);
        transMeta.addStep(dummyStep);
        TransHopMeta hi2 = new TransHopMeta(javaScriptStep, dummyStep);
        transMeta.addTransHop(hi2);
        Trans trans = new Trans(transMeta);
        trans.prepareExecution(null);
        StepInterface si = trans.getStepInterface(javaScriptStepname, 0);
        RowStepCollector javaScriptRc = new RowStepCollector();
        si.addRowListener((RowListener)javaScriptRc);
        si = trans.getStepInterface(dummyStepname, 0);
        RowStepCollector dummyRc = new RowStepCollector();
        si.addRowListener((RowListener)dummyRc);
        RowProducer rp = trans.addRowProducer(injectorStepname, 0);
        trans.startThreads();
        List<RowMetaAndData> inputList = this.createData3();
        for (RowMetaAndData rm : inputList) {
            rp.putRow(rm.getRowMeta(), rm.getData());
        }
        rp.finished();
        trans.waitUntilFinished();
        List<RowMetaAndData> goldenImageRows = this.createResultData3();
        List<RowMetaAndData> resultRows1 = javaScriptRc.getRowsWritten();
        this.checkRows(resultRows1, goldenImageRows);
        List<RowMetaAndData> resultRows2 = dummyRc.getRowsRead();
        this.checkRows(resultRows2, goldenImageRows);
    }
}

