/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.scriptvalues_mod;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import junit.framework.TestCase;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.StepPluginType;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.trans.RowProducer;
import org.pentaho.di.trans.RowStepCollector;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransHopMeta;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.TransTestFactory;
import org.pentaho.di.trans.step.RowListener;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.dummytrans.DummyTransMeta;
import org.pentaho.di.trans.steps.injector.InjectorMeta;
import org.pentaho.di.trans.steps.scriptvalues_mod.ScriptValuesMetaMod;
import org.pentaho.di.trans.steps.scriptvalues_mod.ScriptValuesScript;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaScriptStringTest
extends TestCase {
    public RowMetaInterface createRowMetaInterface1() {
        RowMeta rm = new RowMeta();
        ValueMetaInterface[] valuesMeta = new ValueMetaInterface[]{new ValueMeta("string", 2)};
        for (int i = 0; i < valuesMeta.length; ++i) {
            rm.addValueMeta(valuesMeta[i]);
        }
        return rm;
    }

    public List<RowMetaAndData> createData1() {
        ArrayList<RowMetaAndData> list = new ArrayList<RowMetaAndData>();
        RowMetaInterface rm = this.createRowMetaInterface1();
        Object[] r1 = new Object[]{null};
        Object[] r2 = new Object[]{""};
        Object[] r3 = new Object[]{"    "};
        Object[] r4 = new Object[]{"small"};
        Object[] r5 = new Object[]{"longer string"};
        Object[] r6 = new Object[]{"spaces right    "};
        Object[] r7 = new Object[]{"   spaces left"};
        Object[] r8 = new Object[]{"   spaces   "};
        list.add(new RowMetaAndData(rm, r1));
        list.add(new RowMetaAndData(rm, r2));
        list.add(new RowMetaAndData(rm, r3));
        list.add(new RowMetaAndData(rm, r4));
        list.add(new RowMetaAndData(rm, r5));
        list.add(new RowMetaAndData(rm, r6));
        list.add(new RowMetaAndData(rm, r7));
        list.add(new RowMetaAndData(rm, r8));
        return list;
    }

    public List<RowMetaAndData> createData2() {
        ArrayList<RowMetaAndData> list = new ArrayList<RowMetaAndData>();
        RowMetaInterface rm = this.createRowMetaInterface1();
        Object[] r1 = new Object[]{null};
        Object[] r2 = new Object[]{""};
        Object[] r3 = new Object[]{"    "};
        Object[] r4 = new Object[]{"TeSt1"};
        Object[] r5 = new Object[]{"loNgeR st1ing"};
        Object[] r6 = new Object[]{"SPACES RIGHT    "};
        Object[] r7 = new Object[]{"   spacEs lEft"};
        Object[] r8 = new Object[]{"   spaces   "};
        list.add(new RowMetaAndData(rm, r1));
        list.add(new RowMetaAndData(rm, r2));
        list.add(new RowMetaAndData(rm, r3));
        list.add(new RowMetaAndData(rm, r4));
        list.add(new RowMetaAndData(rm, r5));
        list.add(new RowMetaAndData(rm, r6));
        list.add(new RowMetaAndData(rm, r7));
        list.add(new RowMetaAndData(rm, r8));
        return list;
    }

    public List<RowMetaAndData> createData3() {
        ArrayList<RowMetaAndData> list = new ArrayList<RowMetaAndData>();
        RowMetaInterface rm = this.createRowMetaInterface1();
        list.add(new RowMetaAndData(rm, new Object[]{"3.5a"}));
        list.add(new RowMetaAndData(rm, new Object[]{"3.a"}));
        list.add(new RowMetaAndData(rm, new Object[]{"2.0"}));
        list.add(new RowMetaAndData(rm, new Object[]{"1.12"}));
        list.add(new RowMetaAndData(rm, new Object[]{"  5.3"}));
        return list;
    }

    public RowMetaInterface createRowMetaInterfaceResult1() {
        RowMeta rm = new RowMeta();
        ValueMetaInterface[] valuesMeta = new ValueMetaInterface[]{new ValueMeta("string", 2), new ValueMeta("original", 2), new ValueMeta("ltrimStr", 2), new ValueMeta("rtrimStr", 2), new ValueMeta("trimStr", 2)};
        for (int i = 0; i < valuesMeta.length; ++i) {
            rm.addValueMeta(valuesMeta[i]);
        }
        return rm;
    }

    public List<RowMetaAndData> createResultData1() {
        ArrayList<RowMetaAndData> list = new ArrayList<RowMetaAndData>();
        RowMetaInterface rm = this.createRowMetaInterfaceResult1();
        Object[] r1 = new Object[]{null, "bnulle", "bnulle", "bnulle", "bnulle"};
        Object[] r2 = new Object[]{null, "bnulle", "bnulle", "bnulle", "bnulle"};
        Object[] r3 = new Object[]{"    ", "b    e", "be", "be", "be"};
        Object[] r4 = new Object[]{"small", "bsmalle", "bsmalle", "bsmalle", "bsmalle"};
        Object[] r5 = new Object[]{"longer string", "blonger stringe", "blonger stringe", "blonger stringe", "blonger stringe"};
        Object[] r6 = new Object[]{"spaces right    ", "bspaces right    e", "bspaces right    e", "bspaces righte", "bspaces righte"};
        Object[] r7 = new Object[]{"   spaces left", "b   spaces lefte", "bspaces lefte", "b   spaces lefte", "bspaces lefte"};
        Object[] r8 = new Object[]{"   spaces   ", "b   spaces   e", "bspaces   e", "b   spacese", "bspacese"};
        list.add(new RowMetaAndData(rm, r1));
        list.add(new RowMetaAndData(rm, r2));
        list.add(new RowMetaAndData(rm, r3));
        list.add(new RowMetaAndData(rm, r4));
        list.add(new RowMetaAndData(rm, r5));
        list.add(new RowMetaAndData(rm, r6));
        list.add(new RowMetaAndData(rm, r7));
        list.add(new RowMetaAndData(rm, r8));
        return list;
    }

    public RowMetaInterface createRowMetaInterfaceResult2() {
        RowMeta rm = new RowMeta();
        ValueMetaInterface[] valuesMeta = new ValueMetaInterface[]{new ValueMeta("string", 2), new ValueMeta("lpadded1", 2), new ValueMeta("lpadded2", 2), new ValueMeta("rpadded1", 2), new ValueMeta("rpadded2", 2), new ValueMeta("upperStr", 2), new ValueMeta("lowerStr", 2)};
        for (int i = 0; i < valuesMeta.length; ++i) {
            rm.addValueMeta(valuesMeta[i]);
        }
        return rm;
    }

    public RowMetaInterface createRowMetaInterfaceResult3() {
        RowMeta rm = new RowMeta();
        ValueMetaInterface[] valuesMeta = new ValueMetaInterface[]{new ValueMeta("string", 2), new ValueMeta("numb1", 1), new ValueMeta("bool1", 4), new ValueMeta("str1", 2)};
        for (int i = 0; i < valuesMeta.length; ++i) {
            rm.addValueMeta(valuesMeta[i]);
        }
        return rm;
    }

    public List<RowMetaAndData> createResultData2() {
        ArrayList<RowMetaAndData> list = new ArrayList<RowMetaAndData>();
        RowMetaInterface rm = this.createRowMetaInterfaceResult2();
        Object[] r1 = new Object[]{null, "xxxxxxxxxx", "         ", "xxxxxxxxxx", "         ", "", ""};
        Object[] r2 = new Object[]{null, "xxxxxxxxxx", "         ", "xxxxxxxxxx", "         ", "", ""};
        Object[] r3 = new Object[]{"    ", "xxxxxx    ", "         ", "    xxxxxx", "         ", "    ", "    "};
        Object[] r4 = new Object[]{"TeSt1", "xxxxxTeSt1", "    TeSt1", "TeSt1xxxxx", "TeSt1    ", "TEST1", "test1"};
        Object[] r5 = new Object[]{"loNgeR st1ing", "loNgeR st1ing", "loNgeR st1ing", "loNgeR st1ing", "loNgeR st1ing", "LONGER ST1ING", "longer st1ing"};
        Object[] r6 = new Object[]{"SPACES RIGHT    ", "SPACES RIGHT    ", "SPACES RIGHT    ", "SPACES RIGHT    ", "SPACES RIGHT    ", "SPACES RIGHT    ", "spaces right    "};
        Object[] r7 = new Object[]{"   spacEs lEft", "   spacEs lEft", "   spacEs lEft", "   spacEs lEft", "   spacEs lEft", "   SPACES LEFT", "   spaces left"};
        Object[] r8 = new Object[]{"   spaces   ", "   spaces   ", "   spaces   ", "   spaces   ", "   spaces   ", "   SPACES   ", "   spaces   "};
        list.add(new RowMetaAndData(rm, r1));
        list.add(new RowMetaAndData(rm, r2));
        list.add(new RowMetaAndData(rm, r3));
        list.add(new RowMetaAndData(rm, r4));
        list.add(new RowMetaAndData(rm, r5));
        list.add(new RowMetaAndData(rm, r6));
        list.add(new RowMetaAndData(rm, r7));
        list.add(new RowMetaAndData(rm, r8));
        return list;
    }

    public List<RowMetaAndData> createResultData3() {
        ArrayList<RowMetaAndData> list = new ArrayList<RowMetaAndData>();
        RowMetaInterface rm = this.createRowMetaInterfaceResult3();
        Object[] r1 = new Object[]{"3.5a", 3.5, false, "3.5"};
        Object[] r2 = new Object[]{"3.a", 3.0, false, "3"};
        Object[] r3 = new Object[]{"2.0", 2.0, true, "2"};
        Object[] r4 = new Object[]{"1.12", 1.12, true, "1.12"};
        Object[] r5 = new Object[]{"  5.3", 5.3, true, "5.3"};
        list.add(new RowMetaAndData(rm, r1));
        list.add(new RowMetaAndData(rm, r2));
        list.add(new RowMetaAndData(rm, r3));
        list.add(new RowMetaAndData(rm, r4));
        list.add(new RowMetaAndData(rm, r5));
        return list;
    }

    public RowMetaInterface createRowMetaInterface2() {
        RowMeta rm = new RowMeta();
        ValueMetaInterface[] valuesMeta = new ValueMetaInterface[]{new ValueMeta("string", 2), new ValueMeta("search", 2), new ValueMeta("offset1", 5), new ValueMeta("offset2", 5)};
        for (int i = 0; i < valuesMeta.length; ++i) {
            rm.addValueMeta(valuesMeta[i]);
        }
        return rm;
    }

    public List<RowMetaAndData> createData4() {
        ArrayList<RowMetaAndData> list = new ArrayList<RowMetaAndData>();
        RowMetaInterface rm = this.createRowMetaInterface2();
        Object[] r1 = new Object[]{"abcdefgh", "ef", new Long(3L), new Long(10L)};
        Object[] r2 = new Object[]{"abcdefgh", "h", new Long(0L), new Long(7L)};
        Object[] r3 = new Object[]{"abcdefgh", "h", new Long(1L), new Long(6L)};
        Object[] r4 = new Object[]{"abcdefgh", null, new Long(1L), new Long(2L)};
        Object[] r5 = new Object[]{"abcdefgh", "invalid", new Long(1L), new Long(1L)};
        Object[] r6 = new Object[]{"abcdefgh", "invalidlonger", new Long(1L), new Long(1L)};
        list.add(new RowMetaAndData(rm, r1));
        list.add(new RowMetaAndData(rm, r2));
        list.add(new RowMetaAndData(rm, r3));
        list.add(new RowMetaAndData(rm, r4));
        list.add(new RowMetaAndData(rm, r5));
        list.add(new RowMetaAndData(rm, r6));
        return list;
    }

    public RowMetaInterface createRowMetaInterfaceResult4() {
        RowMeta rm = new RowMeta();
        ValueMetaInterface[] valuesMeta = new ValueMetaInterface[]{new ValueMeta("string", 2), new ValueMeta("search", 2), new ValueMeta("offset1", 5), new ValueMeta("offset2", 5), new ValueMeta("index1", 5), new ValueMeta("index2", 5), new ValueMeta("index3", 5)};
        for (int i = 0; i < valuesMeta.length; ++i) {
            rm.addValueMeta(valuesMeta[i]);
        }
        return rm;
    }

    public List<RowMetaAndData> createResultData4() {
        ArrayList<RowMetaAndData> list = new ArrayList<RowMetaAndData>();
        RowMetaInterface rm = this.createRowMetaInterfaceResult4();
        Object[] r1 = new Object[]{"abcdefgh", "ef", new Long(3L), new Long(10L), new Long(4L), new Long(4L), new Long(-1L)};
        Object[] r2 = new Object[]{"abcdefgh", "h", new Long(0L), new Long(7L), new Long(7L), new Long(7L), new Long(7L)};
        Object[] r3 = new Object[]{"abcdefgh", "h", new Long(1L), new Long(6L), new Long(7L), new Long(7L), new Long(7L)};
        Object[] r4 = new Object[]{"abcdefgh", null, new Long(1L), new Long(2L), new Long(-1L), new Long(-1L), new Long(-1L)};
        Object[] r5 = new Object[]{"abcdefgh", "invalid", new Long(1L), new Long(1L), new Long(-1L), new Long(-1L), new Long(-1L)};
        Object[] r6 = new Object[]{"abcdefgh", "invalidlonger", new Long(1L), new Long(1L), new Long(-1L), new Long(-1L), new Long(-1L)};
        list.add(new RowMetaAndData(rm, r1));
        list.add(new RowMetaAndData(rm, r2));
        list.add(new RowMetaAndData(rm, r3));
        list.add(new RowMetaAndData(rm, r4));
        list.add(new RowMetaAndData(rm, r5));
        list.add(new RowMetaAndData(rm, r6));
        return list;
    }

    public void checkRows(List<RowMetaAndData> rows1, List<RowMetaAndData> rows2) {
        int idx = 1;
        if (rows1.size() != rows2.size()) {
            JavaScriptStringTest.fail((String)("Number of rows is not the same: " + rows1.size() + " and " + rows2.size()));
        }
        Iterator<RowMetaAndData> it1 = rows1.iterator();
        Iterator<RowMetaAndData> it2 = rows2.iterator();
        while (it1.hasNext() && it2.hasNext()) {
            RowMetaAndData rm1 = it1.next();
            RowMetaAndData rm2 = it2.next();
            Object[] r1 = rm1.getData();
            Object[] r2 = rm2.getData();
            if (rm1.size() != rm2.size()) {
                JavaScriptStringTest.fail((String)("row nr " + idx + " is not equal"));
            }
            int[] fields = new int[rm1.size()];
            for (int ydx = 0; ydx < rm1.size(); ++ydx) {
                fields[ydx] = ydx;
            }
            try {
                if (rm1.getRowMeta().compare(r1, r2, fields) != 0) {
                    JavaScriptStringTest.fail((String)("row nr " + idx + " is not equal"));
                }
            }
            catch (KettleValueException e) {
                JavaScriptStringTest.fail((String)("row nr " + idx + " is not equal"));
            }
            ++idx;
        }
    }

    public void testStringsTrim() throws Exception {
        KettleEnvironment.init();
        TransMeta transMeta = new TransMeta();
        transMeta.setName("test javascript trim");
        PluginRegistry registry = PluginRegistry.getInstance();
        String injectorStepname = "injector step";
        InjectorMeta im = new InjectorMeta();
        String injectorPid = registry.getPluginId(StepPluginType.class, (Object)im);
        StepMeta injectorStep = new StepMeta(injectorPid, injectorStepname, (StepMetaInterface)im);
        transMeta.addStep(injectorStep);
        String javaScriptStepname = "javascript step";
        ScriptValuesMetaMod svm = new ScriptValuesMetaMod();
        ScriptValuesScript[] js = new ScriptValuesScript[]{new ScriptValuesScript(0, "script", "var original = 'b' + string.getString() + 'e';\nvar ltrimStr = 'b' + ltrim(string.getString()) + 'e';\nvar rtrimStr = 'b' + rtrim(string.getString()) + 'e';\nvar trimStr  = 'b' + trim(string.getString()) + 'e';\n")};
        svm.setJSScripts(js);
        svm.setFieldname(new String[]{"original", "ltrimStr", "rtrimStr", "trimStr"});
        svm.setRename(new String[]{"", "", "", ""});
        svm.setType(new int[]{2, 2, 2, 2});
        svm.setLength(new int[]{-1, -1, -1, -1});
        svm.setPrecision(new int[]{-1, -1, -1, -1});
        svm.setReplace(new boolean[]{false, false, false, false});
        svm.setCompatible(true);
        String javaScriptStepPid = registry.getPluginId(StepPluginType.class, (Object)svm);
        StepMeta javaScriptStep = new StepMeta(javaScriptStepPid, javaScriptStepname, (StepMetaInterface)svm);
        transMeta.addStep(javaScriptStep);
        TransHopMeta hi1 = new TransHopMeta(injectorStep, javaScriptStep);
        transMeta.addTransHop(hi1);
        String dummyStepname = "dummy step";
        DummyTransMeta dm = new DummyTransMeta();
        String dummyPid = registry.getPluginId(StepPluginType.class, (Object)dm);
        StepMeta dummyStep = new StepMeta(dummyPid, dummyStepname, (StepMetaInterface)dm);
        transMeta.addStep(dummyStep);
        TransHopMeta hi2 = new TransHopMeta(javaScriptStep, dummyStep);
        transMeta.addTransHop(hi2);
        Trans trans = new Trans(transMeta);
        trans.prepareExecution(null);
        StepInterface si = trans.getStepInterface(javaScriptStepname, 0);
        RowStepCollector javaScriptRc = new RowStepCollector();
        si.addRowListener((RowListener)javaScriptRc);
        si = trans.getStepInterface(dummyStepname, 0);
        RowStepCollector dummyRc = new RowStepCollector();
        si.addRowListener((RowListener)dummyRc);
        RowProducer rp = trans.addRowProducer(injectorStepname, 0);
        trans.startThreads();
        List<RowMetaAndData> inputList = this.createData1();
        for (RowMetaAndData rm : inputList) {
            rp.putRow(rm.getRowMeta(), rm.getData());
        }
        rp.finished();
        trans.waitUntilFinished();
        List<RowMetaAndData> goldenImageRows = this.createResultData1();
        List<RowMetaAndData> resultRows1 = javaScriptRc.getRowsWritten();
        this.checkRows(resultRows1, goldenImageRows);
        List<RowMetaAndData> resultRows2 = dummyRc.getRowsRead();
        this.checkRows(resultRows2, goldenImageRows);
    }

    public void testStringsPadCase() throws Exception {
        KettleEnvironment.init();
        TransMeta transMeta = new TransMeta();
        transMeta.setName("test javascript pad casing");
        PluginRegistry registry = PluginRegistry.getInstance();
        String injectorStepname = "injector step";
        InjectorMeta im = new InjectorMeta();
        String injectorPid = registry.getPluginId(StepPluginType.class, (Object)im);
        StepMeta injectorStep = new StepMeta(injectorPid, injectorStepname, (StepMetaInterface)im);
        transMeta.addStep(injectorStep);
        String javaScriptStepname = "javascript step";
        ScriptValuesMetaMod svm = new ScriptValuesMetaMod();
        ScriptValuesScript[] js = new ScriptValuesScript[]{new ScriptValuesScript(0, "script", "var lpadded1 = lpad(string, \"x\", 10);\nvar lpadded2 = lpad(string, \" \", 9);\nvar rpadded1 = rpad(string, \"x\", 10);\nvar rpadded2 = rpad(string, \" \", 9);\nvar upperStr = upper(string);\nvar lowerStr = lower(string);\n")};
        svm.setJSScripts(js);
        svm.setFieldname(new String[]{"lpadded1", "lpadded2", "rpadded1", "rpadded2", "upperStr", "lowerStr"});
        svm.setRename(new String[]{"", "", "", "", "", "", ""});
        svm.setType(new int[]{2, 2, 2, 2, 2, 2, 2});
        svm.setLength(new int[]{-1, -1, -1, -1, -1, -1, -1});
        svm.setPrecision(new int[]{-1, -1, -1, -1, -1, -1, -1});
        svm.setReplace(new boolean[]{false, false, false, false, false, false, false});
        svm.setCompatible(true);
        String javaScriptStepPid = registry.getPluginId(StepPluginType.class, (Object)svm);
        StepMeta javaScriptStep = new StepMeta(javaScriptStepPid, javaScriptStepname, (StepMetaInterface)svm);
        transMeta.addStep(javaScriptStep);
        TransHopMeta hi1 = new TransHopMeta(injectorStep, javaScriptStep);
        transMeta.addTransHop(hi1);
        String dummyStepname = "dummy step";
        DummyTransMeta dm = new DummyTransMeta();
        String dummyPid = registry.getPluginId(StepPluginType.class, (Object)dm);
        StepMeta dummyStep = new StepMeta(dummyPid, dummyStepname, (StepMetaInterface)dm);
        transMeta.addStep(dummyStep);
        TransHopMeta hi2 = new TransHopMeta(javaScriptStep, dummyStep);
        transMeta.addTransHop(hi2);
        Trans trans = new Trans(transMeta);
        trans.prepareExecution(null);
        StepInterface si = trans.getStepInterface(javaScriptStepname, 0);
        RowStepCollector javaScriptRc = new RowStepCollector();
        si.addRowListener((RowListener)javaScriptRc);
        si = trans.getStepInterface(dummyStepname, 0);
        RowStepCollector dummyRc = new RowStepCollector();
        si.addRowListener((RowListener)dummyRc);
        RowProducer rp = trans.addRowProducer(injectorStepname, 0);
        trans.startThreads();
        List<RowMetaAndData> inputList = this.createData2();
        for (RowMetaAndData rm : inputList) {
            rp.putRow(rm.getRowMeta(), rm.getData());
        }
        rp.finished();
        trans.waitUntilFinished();
        List<RowMetaAndData> goldenImageRows = this.createResultData2();
        List<RowMetaAndData> resultRows1 = javaScriptRc.getRowsWritten();
        this.checkRows(resultRows1, goldenImageRows);
        List<RowMetaAndData> resultRows2 = dummyRc.getRowsRead();
        this.checkRows(resultRows2, goldenImageRows);
    }

    public void testStringsNum() throws Exception {
        KettleEnvironment.init();
        Locale.setDefault(Locale.ENGLISH);
        ScriptValuesMetaMod svm = new ScriptValuesMetaMod();
        ScriptValuesScript[] js = new ScriptValuesScript[]{new ScriptValuesScript(0, "script", "var numb1 = str2num(trim(string.getString()), \"#.#\", \"en\");\nvar bool1 = isNum(string.getString());\nvar str1  = num2str(numb1);\n")};
        svm.setJSScripts(js);
        svm.setFieldname(new String[]{"numb1", "bool1", "str1"});
        svm.setRename(new String[]{"", "", ""});
        svm.setType(new int[]{1, 4, 2});
        svm.setLength(new int[]{-1, -1, -1});
        svm.setPrecision(new int[]{-1, -1, -1});
        svm.setReplace(new boolean[]{false, false, false});
        svm.setCompatible(true);
        String testStepname = "javascript";
        TransMeta transMeta = TransTestFactory.generateTestTransformation((VariableSpace)new Variables(), (StepMetaInterface)svm, testStepname);
        List<RowMetaAndData> result = TransTestFactory.executeTestTransformation(transMeta, "injector", testStepname, "dummy", this.createData3());
        this.checkRows(result, this.createResultData3());
    }

    public void testIndexOf() throws Exception {
        KettleEnvironment.init();
        String javaScriptStepname = "javascript step";
        ScriptValuesMetaMod svm = new ScriptValuesMetaMod();
        ScriptValuesScript[] js = new ScriptValuesScript[]{new ScriptValuesScript(0, "script", "var index1 = indexOf(string.getString(), search.getString());\nvar index2 = indexOf(string.getString(), search.getString(), offset1.getInteger());\nvar index3 = indexOf(string.getString(), search.getString(), offset2.getInteger());\n")};
        svm.setJSScripts(js);
        svm.setFieldname(new String[]{"index1", "index2", "index3"});
        svm.setRename(new String[]{"", "", ""});
        svm.setType(new int[]{5, 5, 5});
        svm.setLength(new int[]{-1, -1, -1});
        svm.setPrecision(new int[]{-1, -1, -1});
        svm.setReplace(new boolean[]{false, false, false});
        svm.setCompatible(true);
        TransMeta transMeta = TransTestFactory.generateTestTransformation((VariableSpace)new Variables(), (StepMetaInterface)svm, javaScriptStepname);
        List<RowMetaAndData> result = TransTestFactory.executeTestTransformation(transMeta, "injector", javaScriptStepname, "dummy", this.createData4());
        this.checkRows(result, this.createResultData4());
    }
}

