/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.scriptvalues_mod;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.StepPluginType;
import org.pentaho.di.trans.TransHopMeta;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.dummytrans.DummyTransMeta;
import org.pentaho.di.trans.steps.injector.InjectorMeta;
import org.pentaho.di.trans.steps.scriptvalues_mod.JavaScriptSpecialTest;
import org.pentaho.di.trans.steps.scriptvalues_mod.ScriptValuesMetaMod;
import org.pentaho.di.trans.steps.scriptvalues_mod.ScriptValuesScript;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptimizationLevelTest {
    private static final String RANGE_ERROR_MESSAGE_PREFIX = "Optimization level outside [-1..9]";

    private boolean containsErrorMessage(List<CheckResultInterface> checkResultInterfaces) {
        for (CheckResultInterface checkResultInterface : checkResultInterfaces) {
            if (!checkResultInterface.getText().startsWith(RANGE_ERROR_MESSAGE_PREFIX)) continue;
            return true;
        }
        return false;
    }

    @Test
    public void testOptimizationLevelminus1Through9() {
        this.test("-1", false);
        this.test("0", false);
        this.test("1", false);
        this.test("2", false);
        this.test("3", false);
        this.test("4", false);
        this.test("5", false);
        this.test("6", false);
        this.test("7", false);
        this.test("8", false);
        this.test("9", false);
        this.test("-9", true);
        this.test("10", true);
    }

    private void test(String optimizationLevel, boolean containsErrorMessage) {
        try {
            List<CheckResultInterface> remarks = this.testOptimizationLevel(optimizationLevel);
            Assert.assertEquals((Object)this.containsErrorMessage(remarks), (Object)containsErrorMessage);
        }
        catch (KettleException ke) {
            ke.printStackTrace();
            Assert.fail((String)ke.getMessage());
        }
    }

    private List<CheckResultInterface> testOptimizationLevel(String optimizationLevel) throws KettleException {
        KettleEnvironment.init();
        TransMeta transMeta = new TransMeta();
        transMeta.setName("Test optimization level exception handling");
        PluginRegistry registry = PluginRegistry.getInstance();
        String injectorStepname = "injector step";
        InjectorMeta im = new InjectorMeta();
        String injectorPid = registry.getPluginId(StepPluginType.class, (Object)im);
        StepMeta injectorStep = new StepMeta(injectorPid, injectorStepname, (StepMetaInterface)im);
        transMeta.addStep(injectorStep);
        String javaScriptStepname = "javascript step";
        ScriptValuesMetaMod scriptValuesMetaMod = new ScriptValuesMetaMod();
        ScriptValuesScript[] js = new ScriptValuesScript[]{new ScriptValuesScript(0, "script", "var str = string;\nvar bool = LuhnCheck(str);")};
        scriptValuesMetaMod.setJSScripts(js);
        scriptValuesMetaMod.setFieldname(new String[]{"bool"});
        scriptValuesMetaMod.setRename(new String[]{""});
        scriptValuesMetaMod.setType(new int[]{4});
        scriptValuesMetaMod.setLength(new int[]{-1});
        scriptValuesMetaMod.setPrecision(new int[]{-1});
        scriptValuesMetaMod.setReplace(new boolean[]{false});
        scriptValuesMetaMod.setCompatible(false);
        scriptValuesMetaMod.setOptimizationLevel(optimizationLevel);
        String javaScriptStepPid = registry.getPluginId(StepPluginType.class, (Object)scriptValuesMetaMod);
        StepMeta javaScriptStep = new StepMeta(javaScriptStepPid, javaScriptStepname, (StepMetaInterface)scriptValuesMetaMod);
        String dummyStepname = "dummy step";
        DummyTransMeta dm = new DummyTransMeta();
        String dummyPid = registry.getPluginId(StepPluginType.class, (Object)dm);
        StepMeta dummyStep = new StepMeta(dummyPid, dummyStepname, (StepMetaInterface)dm);
        transMeta.addStep(dummyStep);
        TransHopMeta hi2 = new TransHopMeta(javaScriptStep, dummyStep);
        transMeta.addTransHop(hi2);
        JavaScriptSpecialTest javaScriptSpecialTest = new JavaScriptSpecialTest();
        List<RowMetaAndData> inputList = javaScriptSpecialTest.createData1();
        ArrayList<CheckResultInterface> remarks = new ArrayList<CheckResultInterface>();
        String[] input = new String[]{injectorStepname};
        String[] output = new String[]{};
        Iterator<RowMetaAndData> it = inputList.iterator();
        if (it.hasNext()) {
            RowMetaAndData rowMetaAndData = it.next();
            scriptValuesMetaMod.check(remarks, transMeta, javaScriptStep, rowMetaAndData.getRowMeta(), input, output, null);
        } else {
            Assert.fail((String)"No data in the inputList");
        }
        return remarks;
    }
}

