/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.sort;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import junit.framework.TestCase;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.StepPluginType;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.trans.RowProducer;
import org.pentaho.di.trans.RowStepCollector;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransHopMeta;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.RowListener;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.dummytrans.DummyTransMeta;
import org.pentaho.di.trans.steps.injector.InjectorMeta;
import org.pentaho.di.trans.steps.sort.SortRowsMeta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortRowsTest
extends TestCase {
    public static int MAX_COUNT = 1000;

    public RowMetaInterface createRowMetaInterface() {
        RowMeta rm = new RowMeta();
        ValueMetaInterface[] valuesMeta = new ValueMetaInterface[]{new ValueMeta("KEY1", 2), new ValueMeta("KEY2", 2)};
        for (int i = 0; i < valuesMeta.length; ++i) {
            rm.addValueMeta(valuesMeta[i]);
        }
        return rm;
    }

    public List<RowMetaAndData> createIntegerData() {
        ArrayList<RowMetaAndData> list = new ArrayList<RowMetaAndData>();
        String old_key1 = null;
        RowMetaInterface rm = this.createRowMetaInterface();
        Random rand = new Random();
        for (int idx = 0; idx < MAX_COUNT; ++idx) {
            int key1 = Math.abs(rand.nextInt() % 1000000);
            int key2 = Math.abs(rand.nextInt() % 1000000);
            String key1_string = "" + key1 + "." + idx;
            String key2_string = "" + key2 + "." + idx;
            if (idx % 100 == 0 && old_key1 != null) {
                key1_string = old_key1;
            }
            Object[] r1 = new Object[]{key1_string, key2_string};
            list.add(new RowMetaAndData(rm, r1));
            old_key1 = key1_string;
        }
        return list;
    }

    public void checkRows(List<RowMetaAndData> rows, boolean ascending) throws Exception {
        String prev_key1 = null;
        String prev_key2 = null;
        int idx = 0;
        for (RowMetaAndData rm : rows) {
            Object[] r1 = rm.getData();
            RowMetaInterface rmi = rm.getRowMeta();
            String key1 = rmi.getString(r1, "KEY1", "");
            String key2 = rmi.getString(r1, "KEY2", "");
            if (prev_key1 != null && prev_key2 != null) {
                if (ascending) {
                    if (prev_key1.compareTo(key1) == 0) {
                        if (prev_key2.compareTo(key2) > 0) {
                            SortRowsTest.fail((String)"error in sort");
                        }
                    } else if (prev_key1.compareTo(key1) > 0) {
                        SortRowsTest.fail((String)"error in sort");
                    }
                } else if (prev_key1.compareTo(key1) == 0) {
                    if (prev_key2.compareTo(key2) < 0) {
                        SortRowsTest.fail((String)"error in sort");
                    }
                } else if (prev_key1.compareTo(key1) < 0) {
                    SortRowsTest.fail((String)"error in sort");
                }
            }
            prev_key1 = key1;
            prev_key2 = key2;
            ++idx;
        }
        if (idx != MAX_COUNT) {
            SortRowsTest.fail((String)("less rows returned than expected: " + idx));
        }
    }

    public void testSortRows1() throws Exception {
        KettleEnvironment.init();
        TransMeta transMeta = new TransMeta();
        transMeta.setName("sortrowstest");
        PluginRegistry registry = PluginRegistry.getInstance();
        String injectorStepname = "injector step";
        InjectorMeta im = new InjectorMeta();
        String injectorPid = registry.getPluginId(StepPluginType.class, (Object)im);
        StepMeta injectorStep = new StepMeta(injectorPid, injectorStepname, (StepMetaInterface)im);
        transMeta.addStep(injectorStep);
        String sortRowsStepname = "sort rows step";
        SortRowsMeta srm = new SortRowsMeta();
        srm.setSortSize(Integer.toString(MAX_COUNT / 10));
        String[] sortFields = new String[]{"KEY1", "KEY2"};
        boolean[] ascendingFields = new boolean[]{true, true};
        boolean[] caseSensitive = new boolean[]{true, true};
        srm.setFieldName(sortFields);
        srm.setAscending(ascendingFields);
        srm.setCaseSensitive(caseSensitive);
        srm.setPrefix("SortRowsTest");
        srm.setDirectory(".");
        String sortRowsStepPid = registry.getPluginId(StepPluginType.class, (Object)srm);
        StepMeta sortRowsStep = new StepMeta(sortRowsStepPid, sortRowsStepname, (StepMetaInterface)srm);
        transMeta.addStep(sortRowsStep);
        TransHopMeta hi = new TransHopMeta(injectorStep, sortRowsStep);
        transMeta.addTransHop(hi);
        String dummyStepname = "dummy step";
        DummyTransMeta dm = new DummyTransMeta();
        String dummyPid = registry.getPluginId(StepPluginType.class, (Object)dm);
        StepMeta dummyStep = new StepMeta(dummyPid, dummyStepname, (StepMetaInterface)dm);
        transMeta.addStep(dummyStep);
        TransHopMeta hi3 = new TransHopMeta(sortRowsStep, dummyStep);
        transMeta.addTransHop(hi3);
        Trans trans = new Trans(transMeta);
        trans.prepareExecution(null);
        StepInterface si = trans.getStepInterface(dummyStepname, 0);
        RowStepCollector dummyRc = new RowStepCollector();
        si.addRowListener((RowListener)dummyRc);
        RowProducer rp = trans.addRowProducer(injectorStepname, 0);
        trans.startThreads();
        List<RowMetaAndData> inputList = this.createIntegerData();
        for (RowMetaAndData rm : inputList) {
            rp.putRow(rm.getRowMeta(), rm.getData());
        }
        rp.finished();
        trans.waitUntilFinished();
        List<RowMetaAndData> resultRows = dummyRc.getRowsWritten();
        this.checkRows(resultRows, true);
    }

    public void testSortRows2() throws Exception {
        KettleEnvironment.init();
        TransMeta transMeta = new TransMeta();
        transMeta.setName("sortrowstest");
        PluginRegistry registry = PluginRegistry.getInstance();
        String injectorStepname = "injector step";
        InjectorMeta im = new InjectorMeta();
        String injectorPid = registry.getPluginId(StepPluginType.class, (Object)im);
        StepMeta injectorStep = new StepMeta(injectorPid, injectorStepname, (StepMetaInterface)im);
        transMeta.addStep(injectorStep);
        String sortRowsStepname = "sort rows step";
        SortRowsMeta srm = new SortRowsMeta();
        srm.setSortSize(Integer.toString(MAX_COUNT / 10));
        String[] sortFields = new String[]{"KEY1", "KEY2"};
        boolean[] ascendingFields = new boolean[]{false, false};
        boolean[] caseSensitive = new boolean[]{true, true};
        srm.setFieldName(sortFields);
        srm.setAscending(ascendingFields);
        srm.setCaseSensitive(caseSensitive);
        srm.setPrefix("SortRowsTest");
        srm.setDirectory(".");
        String sortRowsStepPid = registry.getPluginId(StepPluginType.class, (Object)srm);
        StepMeta sortRowsStep = new StepMeta(sortRowsStepPid, sortRowsStepname, (StepMetaInterface)srm);
        transMeta.addStep(sortRowsStep);
        TransHopMeta hi = new TransHopMeta(injectorStep, sortRowsStep);
        transMeta.addTransHop(hi);
        String dummyStepname = "dummy step";
        DummyTransMeta dm = new DummyTransMeta();
        String dummyPid = registry.getPluginId(StepPluginType.class, (Object)dm);
        StepMeta dummyStep = new StepMeta(dummyPid, dummyStepname, (StepMetaInterface)dm);
        transMeta.addStep(dummyStep);
        TransHopMeta hi3 = new TransHopMeta(sortRowsStep, dummyStep);
        transMeta.addTransHop(hi3);
        Trans trans = new Trans(transMeta);
        trans.prepareExecution(null);
        StepInterface si = trans.getStepInterface(dummyStepname, 0);
        RowStepCollector dummyRc = new RowStepCollector();
        si.addRowListener((RowListener)dummyRc);
        RowProducer rp = trans.addRowProducer(injectorStepname, 0);
        trans.startThreads();
        List<RowMetaAndData> inputList = this.createIntegerData();
        for (RowMetaAndData rm : inputList) {
            rp.putRow(rm.getRowMeta(), rm.getData());
        }
        rp.finished();
        trans.waitUntilFinished();
        List<RowMetaAndData> resultRows = dummyRc.getRowsWritten();
        this.checkRows(resultRows, false);
    }
}

