/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.splitfieldtorows;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.StepPluginType;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.trans.RowProducer;
import org.pentaho.di.trans.RowStepCollector;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransHopMeta;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.RowListener;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.dummytrans.DummyTransMeta;
import org.pentaho.di.trans.steps.injector.InjectorMeta;
import org.pentaho.di.trans.steps.splitfieldtorows.SplitFieldToRowsMeta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SplitFieldToRowsTest
extends TestCase {
    private static final String FIELD_TO_SPLIT_NAME = "FieldToSplit";
    private static final String NEW_FIELD_NAME = "NewFieldName";
    private static final String TEST_OUTPUT_HEADER_FOOTER = "------------------------------------------------------------------------------";
    private static boolean PRINT_RESULTS = false;

    public RowMetaInterface createRowMetaInterface() {
        RowMeta rowMeta = new RowMeta();
        ValueMetaInterface[] valuesMeta = new ValueMetaInterface[]{new ValueMeta(FIELD_TO_SPLIT_NAME, 2)};
        for (int i = 0; i < valuesMeta.length; ++i) {
            rowMeta.addValueMeta(valuesMeta[i]);
        }
        return rowMeta;
    }

    public List<RowMetaAndData> createData(String value) {
        ArrayList<RowMetaAndData> list = new ArrayList<RowMetaAndData>();
        RowMetaInterface rm = this.createRowMetaInterface();
        Object[] r1 = new Object[]{value};
        list.add(new RowMetaAndData(rm, r1));
        return list;
    }

    public List<RowMetaAndData> test(String testName, String stringToSplit, boolean isDelimiterRegex, String delimiter, String delimiterVariableValue, String[] expectedResult) throws Exception {
        List<RowMetaAndData> result = this.splitFieldToRows(testName, stringToSplit, isDelimiterRegex, delimiter, delimiterVariableValue);
        SplitFieldToRowsTest.assertTrue((boolean)this.isSameData(expectedResult, result));
        return result;
    }

    public List<RowMetaAndData> test(String testName, String stringToSplit, boolean isDelimiterRegex, String delimiter, String[] expectedResult) throws Exception {
        List<RowMetaAndData> result = this.test(testName, stringToSplit, isDelimiterRegex, delimiter, null, expectedResult);
        SplitFieldToRowsTest.assertTrue((boolean)this.isSameData(expectedResult, result));
        return result;
    }

    public void testNonRegex1() throws Exception {
        String[] expectedResult = new String[]{"Sean", "Flatley"};
        this.test("Non Regex Test 1", "Sean;Flatley", false, ";", expectedResult);
    }

    public void testNonRegex2() throws Exception {
        String[] expectedResult = new String[]{"Sean", "Flatley"};
        this.test("Non Regex Test 2", "Sean!;Flatley", false, "!;", expectedResult);
    }

    public void testNonRegex3() throws Exception {
        String[] expectedResult = new String[]{"Sean!", "Flatley"};
        this.test("Non Regex Test 3", "Sean!;Flatley", false, ";", expectedResult);
    }

    public void testNonRegex4() throws Exception {
        String[] expectedResult = new String[]{"Sean", "Flatley"};
        this.test("Non Regex Test 4", "Sean.Flatley", false, ".", expectedResult);
    }

    public void testNonRegex5() throws Exception {
        String[] expectedResult = new String[]{"Sean.Flatley"};
        this.test("Non Regex Test 5", "Sean.Flatley", false, "\\.", expectedResult);
    }

    public void testNonRegex6() throws Exception {
        String[] expectedResult = new String[]{"Sean", "Flatley"};
        this.test("Non Regex Test 6", "Sean;Flatley", false, "${DELIMITER}", ";", expectedResult);
    }

    public void testRegex1() throws Exception {
        String[] expectedResult = new String[]{"Sean", "Flatley"};
        this.test("Regex Test 1", "Sean;Flatley", true, ";", expectedResult);
    }

    public void testRegex2() throws Exception {
        String[] expectedResult = new String[]{"Sean", "Flatley"};
        this.test("Regex Test 2", "Sean!;Flatley", true, "!;", expectedResult);
    }

    public void testRegex3() throws Exception {
        String[] expectedResult = new String[]{"Sean!", "Flatley"};
        this.test("Regex Test 3", "Sean!;Flatley", true, ";", expectedResult);
    }

    public void testRegex4() throws Exception {
        String[] expectedResult = new String[]{};
        this.test("Regex Test 4", "SeanFlatley", true, ".", expectedResult);
    }

    public void testRegex5() throws Exception {
        String[] expectedResult = new String[]{"Sean", "Flatley"};
        this.test("Regex Test 5", "Sean.Flatley", true, "\\.", expectedResult);
    }

    public void testRegex6() throws Exception {
        String[] expectedResult = new String[]{"Sean", "Flatley"};
        this.test("Regex Test 6", "Sean1Flatley", true, "[0-9]", expectedResult);
    }

    public List<RowMetaAndData> splitFieldToRows(String testName, String stringToSplit, boolean isDelimiterRegex, String delimiter) throws Exception {
        return this.splitFieldToRows(testName, stringToSplit, isDelimiterRegex, delimiter, null);
    }

    public List<RowMetaAndData> splitFieldToRows(String testName, String stringToSplit, boolean isDelimiterRegex, String delimiter, String delimiterVariableValue) throws Exception {
        KettleEnvironment.init();
        TransMeta transMeta = new TransMeta();
        transMeta.setName("Split field to rows test");
        PluginRegistry registry = PluginRegistry.getInstance();
        String injectorStepname = "injector step";
        InjectorMeta im = new InjectorMeta();
        String injectorPid = registry.getPluginId(StepPluginType.class, (Object)im);
        StepMeta injectorStep = new StepMeta(injectorPid, injectorStepname, (StepMetaInterface)im);
        transMeta.addStep(injectorStep);
        String splitfieldToRowsName = "Split field to rows";
        SplitFieldToRowsMeta splitFieldtoRowsMeta = new SplitFieldToRowsMeta();
        splitFieldtoRowsMeta.setDelimiter(delimiter);
        splitFieldtoRowsMeta.setDelimiterRegex(isDelimiterRegex);
        splitFieldtoRowsMeta.setSplitField(FIELD_TO_SPLIT_NAME);
        splitFieldtoRowsMeta.setNewFieldname(NEW_FIELD_NAME);
        String splitFieldTotRowsPid = registry.getPluginId(StepPluginType.class, (Object)splitFieldtoRowsMeta);
        StepMeta splitFieldToRows = new StepMeta(splitFieldTotRowsPid, splitfieldToRowsName, (StepMetaInterface)splitFieldtoRowsMeta);
        transMeta.addStep(splitFieldToRows);
        TransHopMeta hop_injector_splitfieldToRows = new TransHopMeta(injectorStep, splitFieldToRows);
        transMeta.addTransHop(hop_injector_splitfieldToRows);
        String dummyStepname = "dummy step";
        DummyTransMeta dm = new DummyTransMeta();
        String dummyPid = registry.getPluginId(StepPluginType.class, (Object)dm);
        StepMeta dummyStep = new StepMeta(dummyPid, dummyStepname, (StepMetaInterface)dm);
        transMeta.addStep(dummyStep);
        TransHopMeta hop_SplitFieldToRows_Dummy = new TransHopMeta(splitFieldToRows, dummyStep);
        transMeta.addTransHop(hop_SplitFieldToRows_Dummy);
        if (!Const.isEmpty((String)delimiterVariableValue)) {
            String delimiterVariableName = delimiter.replace("${", "");
            delimiterVariableName = delimiterVariableName.replace("}", "");
            transMeta.setVariable(delimiterVariableName, delimiterVariableValue);
        }
        System.out.println(transMeta.environmentSubstitute(delimiter));
        Trans trans = new Trans(transMeta);
        trans.prepareExecution(null);
        StepInterface si = trans.getStepInterface(dummyStepname, 0);
        RowStepCollector rc = new RowStepCollector();
        si.addRowListener((RowListener)rc);
        RowProducer rowProducer = trans.addRowProducer(injectorStepname, 0);
        trans.startThreads();
        List<RowMetaAndData> inputList = this.createData(stringToSplit);
        for (RowMetaAndData rm : inputList) {
            rowProducer.putRow(rm.getRowMeta(), rm.getData());
        }
        rowProducer.finished();
        trans.waitUntilFinished();
        this.printTestInfo(testName, stringToSplit, splitFieldtoRowsMeta, transMeta);
        List<RowMetaAndData> resultRows = rc.getRowsWritten();
        if (resultRows != null && resultRows.size() > 0) {
            this.print("Rows produced:");
            for (RowMetaAndData row : resultRows) {
                String string = row.getString(1, "");
                this.print(string == null ? "     [null]" : "     " + string);
            }
        } else {
            this.print("No rows were produced.");
        }
        this.print(TEST_OUTPUT_HEADER_FOOTER);
        return resultRows;
    }

    private boolean isSameData(String[] expectedData, List<RowMetaAndData> result) {
        for (int i = 0; i < expectedData.length; ++i) {
            try {
                String resultElement = result.get(i).getString(NEW_FIELD_NAME, "String");
                if (expectedData[i].equals(resultElement)) continue;
                return false;
            }
            catch (ArrayIndexOutOfBoundsException aiobe) {
                System.out.println(aiobe.getMessage());
                return false;
            }
            catch (KettleValueException kve) {
                System.out.println(kve.getMessage());
                return false;
            }
        }
        return true;
    }

    private void printTestInfo(String testName, String stringToSplit, SplitFieldToRowsMeta splitFieldToRowsMeta, TransMeta transMeta) {
        this.print(TEST_OUTPUT_HEADER_FOOTER);
        this.print(testName);
        this.print("Field to split: " + stringToSplit);
        if (transMeta == null) {
            this.print("Delimiter: " + splitFieldToRowsMeta.getDelimiter());
        } else {
            this.print("Delimiter: " + transMeta.environmentSubstitute(splitFieldToRowsMeta.getDelimiter()));
        }
        this.print(splitFieldToRowsMeta.isDelimiterRegex() ? "The delimiter is a regex" : "The delimiter is not a regex");
    }

    private void print(String string) {
        if (PRINT_RESULTS) {
            System.out.println(string);
        }
    }
}

