/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.stringcut;

import java.util.ArrayList;
import java.util.List;
import org.junit.Test;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.StepPluginType;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.trans.RowProducer;
import org.pentaho.di.trans.RowStepCollector;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransHopMeta;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.TransformationTestCase;
import org.pentaho.di.trans.step.RowListener;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.dummytrans.DummyTransMeta;
import org.pentaho.di.trans.steps.injector.InjectorMeta;
import org.pentaho.di.trans.steps.stringcut.StringCutMeta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringCutTest
extends TransformationTestCase {
    public RowMetaInterface createRowMetaInterface() {
        RowMeta rm = new RowMeta();
        ValueMetaInterface[] valuesMeta = new ValueMetaInterface[]{new ValueMeta("field1", 2), new ValueMeta("field2", 2)};
        for (int i = 0; i < valuesMeta.length; ++i) {
            rm.addValueMeta(valuesMeta[i]);
        }
        return rm;
    }

    public RowMetaInterface createResultRowMetaInterface1() {
        RowMeta rm = new RowMeta();
        ValueMetaInterface[] valuesMeta = new ValueMetaInterface[]{new ValueMeta("field1", 2), new ValueMeta("field2", 2), new ValueMeta("outf3", 2)};
        for (int i = 0; i < valuesMeta.length; ++i) {
            rm.addValueMeta(valuesMeta[i]);
        }
        return rm;
    }

    public RowMetaInterface createResultRowMetaInterface2() {
        RowMeta rm = new RowMeta();
        ValueMetaInterface[] valuesMeta = new ValueMetaInterface[]{new ValueMeta("field1", 2), new ValueMeta("field2", 2), new ValueMeta("outf3", 2), new ValueMeta("outf4", 2)};
        for (int i = 0; i < valuesMeta.length; ++i) {
            rm.addValueMeta(valuesMeta[i]);
        }
        return rm;
    }

    public List<RowMetaAndData> createData1() {
        ArrayList<RowMetaAndData> list = new ArrayList<RowMetaAndData>();
        RowMetaInterface rm = this.createRowMetaInterface();
        Object[] r1 = new Object[]{"abcdef", "ghijkl"};
        list.add(new RowMetaAndData(rm, r1));
        return list.subList(0, 1);
    }

    public List<RowMetaAndData> createResultData1() {
        ArrayList<RowMetaAndData> list = new ArrayList<RowMetaAndData>();
        RowMetaInterface rm = this.createResultRowMetaInterface1();
        Object[] r1 = new Object[]{"abcdef", "ghijkl", "hi"};
        list.add(new RowMetaAndData(rm, r1));
        return list.subList(0, 1);
    }

    public List<RowMetaAndData> createResultData2() {
        ArrayList<RowMetaAndData> list = new ArrayList<RowMetaAndData>();
        RowMetaInterface rm = this.createResultRowMetaInterface2();
        Object[] r1 = new Object[]{"abcdef", "ghijkl", "a", "hi"};
        list.add(new RowMetaAndData(rm, r1));
        return list.subList(0, 1);
    }

    @Test
    public void testStringCut1() throws KettleException {
        KettleEnvironment.init();
        TransMeta transMeta = new TransMeta();
        transMeta.setName("stringcuttest1");
        PluginRegistry registry = PluginRegistry.getInstance();
        String injectorStepname = "injector step";
        InjectorMeta im = new InjectorMeta();
        String injectorPid = registry.getPluginId(StepPluginType.class, (Object)im);
        StepMeta injectorStep = new StepMeta(injectorPid, injectorStepname, (StepMetaInterface)im);
        transMeta.addStep(injectorStep);
        String dummyStepname1 = "dummy step 1";
        DummyTransMeta dm1 = new DummyTransMeta();
        String dummyPid1 = registry.getPluginId(StepPluginType.class, (Object)dm1);
        StepMeta dummyStep1 = new StepMeta(dummyPid1, dummyStepname1, (StepMetaInterface)dm1);
        transMeta.addStep(dummyStep1);
        TransHopMeta hi = new TransHopMeta(injectorStep, dummyStep1);
        transMeta.addTransHop(hi);
        String stringcutStepname = "string cut step";
        StringCutMeta scm = new StringCutMeta();
        scm.setFieldInStream(new String[]{"field1", "field2"});
        scm.setFieldOutStream(new String[]{null, "outf3"});
        scm.setCutFrom(new String[]{null, "1"});
        scm.setCutTo(new String[]{null, "3"});
        String stringCutStepPid = registry.getPluginId(StepPluginType.class, (Object)scm);
        StepMeta stringCutStep = new StepMeta(stringCutStepPid, stringcutStepname, (StepMetaInterface)scm);
        transMeta.addStep(stringCutStep);
        TransHopMeta hi2 = new TransHopMeta(dummyStep1, stringCutStep);
        transMeta.addTransHop(hi2);
        String dummyStepname2 = "dummy step 2";
        DummyTransMeta dm2 = new DummyTransMeta();
        String dummyPid2 = registry.getPluginId(StepPluginType.class, (Object)dm2);
        StepMeta dummyStep2 = new StepMeta(dummyPid2, dummyStepname2, (StepMetaInterface)dm2);
        transMeta.addStep(dummyStep2);
        TransHopMeta hi3 = new TransHopMeta(stringCutStep, dummyStep2);
        transMeta.addTransHop(hi3);
        Trans trans = new Trans(transMeta);
        trans.prepareExecution(null);
        StepInterface si = trans.getStepInterface(dummyStepname1, 0);
        RowStepCollector dummyRc1 = new RowStepCollector();
        si.addRowListener((RowListener)dummyRc1);
        si = trans.getStepInterface(stringcutStepname, 0);
        RowStepCollector stringCutRc = new RowStepCollector();
        si.addRowListener((RowListener)stringCutRc);
        RowProducer rp = trans.addRowProducer(injectorStepname, 0);
        trans.startThreads();
        List<RowMetaAndData> inputList = this.createData1();
        for (RowMetaAndData rm : inputList) {
            rp.putRow(rm.getRowMeta(), rm.getData());
        }
        rp.finished();
        trans.waitUntilFinished();
        List<RowMetaAndData> resultRows1 = dummyRc1.getRowsRead();
        this.checkRows(resultRows1, inputList);
        List<RowMetaAndData> goldRows = this.createResultData1();
        List<RowMetaAndData> resultRows2 = stringCutRc.getRowsWritten();
        this.checkRows(resultRows2, goldRows);
    }

    @Test
    public void testStringCut2() throws KettleException {
        KettleEnvironment.init();
        TransMeta transMeta = new TransMeta();
        transMeta.setName("stringcuttest1");
        PluginRegistry registry = PluginRegistry.getInstance();
        String injectorStepname = "injector step";
        InjectorMeta im = new InjectorMeta();
        String injectorPid = registry.getPluginId(StepPluginType.class, (Object)im);
        StepMeta injectorStep = new StepMeta(injectorPid, injectorStepname, (StepMetaInterface)im);
        transMeta.addStep(injectorStep);
        String dummyStepname1 = "dummy step 1";
        DummyTransMeta dm1 = new DummyTransMeta();
        String dummyPid1 = registry.getPluginId(StepPluginType.class, (Object)dm1);
        StepMeta dummyStep1 = new StepMeta(dummyPid1, dummyStepname1, (StepMetaInterface)dm1);
        transMeta.addStep(dummyStep1);
        TransHopMeta hi = new TransHopMeta(injectorStep, dummyStep1);
        transMeta.addTransHop(hi);
        String stringcutStepname = "string cut step";
        StringCutMeta scm = new StringCutMeta();
        scm.setFieldInStream(new String[]{"field1", "field2"});
        scm.setFieldOutStream(new String[]{"outf3", "outf4"});
        scm.setCutFrom(new String[]{"0", "1"});
        scm.setCutTo(new String[]{"1", "3"});
        String stringCutStepPid = registry.getPluginId(StepPluginType.class, (Object)scm);
        StepMeta stringCutStep = new StepMeta(stringCutStepPid, stringcutStepname, (StepMetaInterface)scm);
        transMeta.addStep(stringCutStep);
        TransHopMeta hi2 = new TransHopMeta(dummyStep1, stringCutStep);
        transMeta.addTransHop(hi2);
        String dummyStepname2 = "dummy step 2";
        DummyTransMeta dm2 = new DummyTransMeta();
        String dummyPid2 = registry.getPluginId(StepPluginType.class, (Object)dm2);
        StepMeta dummyStep2 = new StepMeta(dummyPid2, dummyStepname2, (StepMetaInterface)dm2);
        transMeta.addStep(dummyStep2);
        TransHopMeta hi3 = new TransHopMeta(stringCutStep, dummyStep2);
        transMeta.addTransHop(hi3);
        Trans trans = new Trans(transMeta);
        trans.prepareExecution(null);
        StepInterface si = trans.getStepInterface(dummyStepname1, 0);
        RowStepCollector dummyRc1 = new RowStepCollector();
        si.addRowListener((RowListener)dummyRc1);
        si = trans.getStepInterface(stringcutStepname, 0);
        RowStepCollector stringCutRc = new RowStepCollector();
        si.addRowListener((RowListener)stringCutRc);
        RowProducer rp = trans.addRowProducer(injectorStepname, 0);
        trans.startThreads();
        List<RowMetaAndData> inputList = this.createData1();
        for (RowMetaAndData rm : inputList) {
            rp.putRow(rm.getRowMeta(), rm.getData());
        }
        rp.finished();
        trans.waitUntilFinished();
        List<RowMetaAndData> resultRows1 = dummyRc1.getRowsRead();
        this.checkRows(resultRows1, inputList);
        List<RowMetaAndData> goldRows = this.createResultData2();
        List<RowMetaAndData> resultRows2 = stringCutRc.getRowsWritten();
        this.checkRows(resultRows2, goldRows);
    }
}

