/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.tableoutput;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.StepPluginType;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.trans.RowProducer;
import org.pentaho.di.trans.RowStepCollector;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransHopMeta;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.RowListener;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.injector.InjectorMeta;
import org.pentaho.di.trans.steps.tableoutput.TableOutputData;
import org.pentaho.di.trans.steps.tableoutput.TableOutputMeta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableOutputTest
extends TestCase {
    public static final String[] databasesXML = new String[]{"<?xml version=\"1.0\" encoding=\"UTF-8\"?><connection><name>db</name><server>127.0.0.1</server><type>H2</type><access>Native</access><database>mem:db</database><port></port><username>sa</username><password></password></connection>"};
    private static String target_table = "table";
    private static String target_table1 = "table1";
    private static String target_table2 = "table2";
    private static String target_table3 = "table3";

    public void createTable(Database db, String tableName, RowMetaInterface rm) throws Exception {
        String source = db.getCreateTableStatement(tableName, rm, null, false, null, true);
        try {
            db.execStatement(source);
        }
        catch (KettleException ex) {
            TableOutputTest.fail((String)("failure while creating table " + tableName + ": " + ex.getMessage()));
        }
    }

    public void dropTable(Database db, String tableName) throws Exception {
        String source = "DROP TABLE " + tableName + ";";
        try {
            db.execStatement(source);
        }
        catch (KettleException ex) {
            TableOutputTest.fail((String)("failure while dropping table " + tableName + ": " + ex.getMessage()));
        }
    }

    public RowMetaInterface createSourceRowMetaInterface1() {
        RowMeta rm = new RowMeta();
        ValueMetaInterface[] valuesMeta = new ValueMetaInterface[]{new ValueMeta("ID", 5, 8, 0), new ValueMeta("CODE", 5, 8, 0)};
        for (int i = 0; i < valuesMeta.length; ++i) {
            rm.addValueMeta(valuesMeta[i]);
        }
        return rm;
    }

    public List<RowMetaAndData> createNormalDataRows() {
        ArrayList<RowMetaAndData> list = new ArrayList<RowMetaAndData>();
        RowMetaInterface rm = this.createSourceRowMetaInterface1();
        Object[] r1 = new Object[]{new Long(100L), new Long(1000L)};
        Object[] r2 = new Object[]{new Long(101L), new Long(1001L)};
        Object[] r3 = new Object[]{new Long(102L), new Long(1002L)};
        Object[] r4 = new Object[]{new Long(103L), new Long(1003L)};
        Object[] r5 = new Object[]{new Long(104L), new Long(1004L)};
        Object[] r6 = new Object[]{new Long(105L), new Long(1005L)};
        Object[] r7 = new Object[]{new Long(106L), new Long(1006L)};
        list.add(new RowMetaAndData(rm, r1));
        list.add(new RowMetaAndData(rm, r2));
        list.add(new RowMetaAndData(rm, r3));
        list.add(new RowMetaAndData(rm, r4));
        list.add(new RowMetaAndData(rm, r5));
        list.add(new RowMetaAndData(rm, r6));
        list.add(new RowMetaAndData(rm, r7));
        return list;
    }

    public RowMetaInterface createJIRA897RowMetaInterface() {
        RowMeta rm = new RowMeta();
        ValueMetaInterface[] valuesMeta = new ValueMetaInterface[]{new ValueMeta("ID", 5, 8, 0), new ValueMeta("TABLE", 2, 30, 0), new ValueMeta("CODE", 5, 8, 0)};
        for (int i = 0; i < valuesMeta.length; ++i) {
            rm.addValueMeta(valuesMeta[i]);
        }
        return rm;
    }

    public List<RowMetaAndData> createJIRA897DataRows() {
        ArrayList<RowMetaAndData> list = new ArrayList<RowMetaAndData>();
        RowMetaInterface rm = this.createJIRA897RowMetaInterface();
        Object[] r1 = new Object[]{new Long(100L), target_table1, new Long(1000L)};
        Object[] r2 = new Object[]{new Long(101L), target_table2, new Long(1001L)};
        Object[] r3 = new Object[]{new Long(102L), target_table1, new Long(1002L)};
        Object[] r4 = new Object[]{new Long(103L), target_table2, new Long(1003L)};
        Object[] r5 = new Object[]{new Long(104L), target_table2, new Long(1004L)};
        Object[] r6 = new Object[]{new Long(105L), target_table1, new Long(1005L)};
        Object[] r7 = new Object[]{new Long(106L), target_table1, new Long(1006L)};
        list.add(new RowMetaAndData(rm, r1));
        list.add(new RowMetaAndData(rm, r2));
        list.add(new RowMetaAndData(rm, r3));
        list.add(new RowMetaAndData(rm, r4));
        list.add(new RowMetaAndData(rm, r5));
        list.add(new RowMetaAndData(rm, r6));
        list.add(new RowMetaAndData(rm, r7));
        return list;
    }

    public List<RowMetaAndData> createJIRA897ResultDataRows() {
        ArrayList<RowMetaAndData> list = new ArrayList<RowMetaAndData>();
        RowMetaInterface rm = this.createSourceRowMetaInterface1();
        Object[] r1 = new Object[]{new Long(100L), new Long(1000L)};
        Object[] r2 = new Object[]{new Long(101L), new Long(1001L)};
        Object[] r3 = new Object[]{new Long(102L), new Long(1002L)};
        Object[] r4 = new Object[]{new Long(103L), new Long(1003L)};
        Object[] r5 = new Object[]{new Long(104L), new Long(1004L)};
        Object[] r6 = new Object[]{new Long(105L), new Long(1005L)};
        Object[] r7 = new Object[]{new Long(106L), new Long(1006L)};
        list.add(new RowMetaAndData(rm, r1));
        list.add(new RowMetaAndData(rm, r2));
        list.add(new RowMetaAndData(rm, r3));
        list.add(new RowMetaAndData(rm, r4));
        list.add(new RowMetaAndData(rm, r5));
        list.add(new RowMetaAndData(rm, r6));
        list.add(new RowMetaAndData(rm, r7));
        return list;
    }

    public void checkRows(List<RowMetaAndData> rows1, List<RowMetaAndData> rows2) {
        int idx = 1;
        if (rows1.size() != rows2.size()) {
            TableOutputTest.fail((String)("Number of rows is not the same: " + rows1.size() + " and " + rows2.size()));
        }
        Iterator<RowMetaAndData> it1 = rows1.iterator();
        Iterator<RowMetaAndData> it2 = rows2.iterator();
        while (it1.hasNext() && it2.hasNext()) {
            RowMetaAndData rm1 = it1.next();
            RowMetaAndData rm2 = it2.next();
            Object[] r1 = rm1.getData();
            Object[] r2 = rm2.getData();
            if (rm1.size() != rm2.size()) {
                TableOutputTest.fail((String)("row nr " + idx + " is not equal"));
            }
            int[] fields = new int[r1.length];
            for (int ydx = 0; ydx < r1.length; ++ydx) {
                fields[ydx] = ydx;
            }
            try {
                if (rm1.getRowMeta().compare(r1, r2, fields) != 0) {
                    TableOutputTest.fail((String)("row nr " + idx + " is not equal"));
                }
            }
            catch (KettleValueException e) {
                TableOutputTest.fail((String)("row nr " + idx + " is not equal"));
            }
            ++idx;
        }
    }

    public void checkResultsNormal(Database db) throws Exception {
        String query = "SELECT ID, CODE FROM " + target_table + " ORDER BY ID";
        String[] correctResults = new String[]{"100|1000", "101|1001", "102|1002", "103|1003", "104|1004", "105|1005", "106|1006"};
        ResultSet rs = db.openQuery(query);
        int idx = 0;
        while (rs.next()) {
            int id = rs.getInt("ID");
            int code = rs.getInt("CODE");
            String result = id + "|" + code;
            if (idx > correctResults.length) {
                TableOutputTest.fail((String)"more rows returned than expected");
            }
            if (!result.equals(correctResults[idx])) {
                TableOutputTest.fail((String)("row " + (idx + 1) + " is different than expected"));
            }
            ++idx;
        }
        if (idx < correctResults.length) {
            TableOutputTest.fail((String)"less rows returned than expected");
        }
    }

    public void checkResultsJIRA897(Database db) throws Exception {
        String query = "SELECT ID, CODE FROM " + target_table1 + " ORDER BY ID";
        String[] correctResults = new String[]{"100|1000", "102|1002", "105|1005", "106|1006"};
        ResultSet rs = db.openQuery(query);
        int idx = 0;
        while (rs.next()) {
            int id = rs.getInt("ID");
            int code = rs.getInt("CODE");
            String result = id + "|" + code;
            if (idx > correctResults.length) {
                TableOutputTest.fail((String)"more rows returned than expected");
            }
            if (!result.equals(correctResults[idx])) {
                TableOutputTest.fail((String)("row " + (idx + 1) + " is different than expected"));
            }
            ++idx;
        }
        if (idx < correctResults.length) {
            TableOutputTest.fail((String)"less rows returned than expected");
        }
        query = "SELECT ID, CODE FROM " + target_table2 + " ORDER BY ID";
        String[] correctResults1 = new String[]{"101|1001", "103|1003", "104|1004"};
        rs = db.openQuery(query);
        idx = 0;
        while (rs.next()) {
            int id = rs.getInt("ID");
            int code = rs.getInt("CODE");
            String result = id + "|" + code;
            if (idx > correctResults1.length) {
                TableOutputTest.fail((String)"more rows returned than expected");
            }
            if (!result.equals(correctResults1[idx])) {
                TableOutputTest.fail((String)("row " + (idx + 1) + " is different than expected"));
            }
            ++idx;
        }
        if (idx < correctResults1.length) {
            TableOutputTest.fail((String)"less rows returned than expected");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTableOutputNormal() throws Exception {
        KettleEnvironment.init();
        TransMeta transMeta = new TransMeta();
        transMeta.setName("table output normal test");
        for (int i = 0; i < databasesXML.length; ++i) {
            DatabaseMeta databaseMeta = new DatabaseMeta(databasesXML[i]);
            transMeta.addDatabase(databaseMeta);
        }
        DatabaseMeta dbInfo = transMeta.findDatabase("db");
        Database database = new Database((LoggingObjectInterface)transMeta, dbInfo);
        database.connect();
        this.createTable(database, target_table, this.createSourceRowMetaInterface1());
        PluginRegistry registry = PluginRegistry.getInstance();
        String injectorStepname = "injector step";
        InjectorMeta im = new InjectorMeta();
        String injectorPid = registry.getPluginId(StepPluginType.class, (Object)im);
        StepMeta injectorStep = new StepMeta(injectorPid, injectorStepname, (StepMetaInterface)im);
        transMeta.addStep(injectorStep);
        String outputname = "output to [" + target_table + "]";
        TableOutputMeta tom = new TableOutputMeta();
        tom.setDatabaseMeta(transMeta.findDatabase("db"));
        tom.setTableName(target_table);
        String fromid = registry.getPluginId(StepPluginType.class, (Object)tom);
        StepMeta fromstep = new StepMeta(fromid, outputname, (StepMetaInterface)tom);
        fromstep.setDescription("write data to table [" + target_table + "] on database [" + dbInfo + "]");
        transMeta.addStep(fromstep);
        TransHopMeta hi = new TransHopMeta(injectorStep, fromstep);
        transMeta.addTransHop(hi);
        Trans trans = new Trans(transMeta);
        trans.prepareExecution(null);
        StepInterface si = trans.getStepInterface(outputname, 0);
        RowStepCollector rc = new RowStepCollector();
        si.addRowListener((RowListener)rc);
        RowProducer rp = trans.addRowProducer(injectorStepname, 0);
        trans.startThreads();
        List<RowMetaAndData> inputList = this.createNormalDataRows();
        for (RowMetaAndData rm : inputList) {
            rp.putRow(rm.getRowMeta(), rm.getData());
        }
        rp.finished();
        trans.waitUntilFinished();
        List<RowMetaAndData> resultRows = rc.getRowsWritten();
        List<RowMetaAndData> goldRows = this.createNormalDataRows();
        this.checkRows(goldRows, resultRows);
        this.checkResultsNormal(database);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTableOutputJIRA897() throws Exception {
        KettleEnvironment.init();
        TransMeta transMeta = new TransMeta();
        transMeta.setName("table output JIRA897 test");
        for (int i = 0; i < databasesXML.length; ++i) {
            DatabaseMeta databaseMeta = new DatabaseMeta(databasesXML[i]);
            transMeta.addDatabase(databaseMeta);
        }
        DatabaseMeta dbInfo = transMeta.findDatabase("db");
        Database database = new Database((LoggingObjectInterface)transMeta, dbInfo);
        database.connect();
        this.createTable(database, target_table1, this.createSourceRowMetaInterface1());
        this.createTable(database, target_table2, this.createSourceRowMetaInterface1());
        PluginRegistry registry = PluginRegistry.getInstance();
        String injectorStepname = "injector step";
        InjectorMeta im = new InjectorMeta();
        String injectorPid = registry.getPluginId(StepPluginType.class, (Object)im);
        StepMeta injectorStep = new StepMeta(injectorPid, injectorStepname, (StepMetaInterface)im);
        transMeta.addStep(injectorStep);
        String outputname = "output to [" + target_table1 + "] and [" + target_table2 + "]";
        TableOutputMeta tom = new TableOutputMeta();
        tom.setDatabaseMeta(transMeta.findDatabase("db"));
        tom.setTableNameInField(true);
        tom.setTableNameField("TABLE");
        tom.setTableNameInTable(false);
        String fromid = registry.getPluginId(StepPluginType.class, (Object)tom);
        StepMeta fromstep = new StepMeta(fromid, outputname, (StepMetaInterface)tom);
        fromstep.setDescription("write data to tables on database [" + dbInfo + "]");
        transMeta.addStep(fromstep);
        TransHopMeta hi = new TransHopMeta(injectorStep, fromstep);
        transMeta.addTransHop(hi);
        Trans trans = new Trans(transMeta);
        trans.prepareExecution(null);
        StepInterface si = trans.getStepInterface(outputname, 0);
        RowStepCollector rc = new RowStepCollector();
        si.addRowListener((RowListener)rc);
        RowProducer rp = trans.addRowProducer(injectorStepname, 0);
        trans.startThreads();
        List<RowMetaAndData> inputList = this.createJIRA897DataRows();
        for (RowMetaAndData rm : inputList) {
            rp.putRow(rm.getRowMeta(), rm.getData());
        }
        rp.finished();
        trans.waitUntilFinished();
        List<RowMetaAndData> resultRows = rc.getRowsWritten();
        List<RowMetaAndData> goldRows = this.createJIRA897DataRows();
        this.checkRows(goldRows, resultRows);
        this.checkResultsJIRA897(database);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTableOutputJIRA2733() throws Exception {
        int dataDelay = 10;
        KettleEnvironment.init();
        TransMeta transMeta = new TransMeta();
        transMeta.setName("table output JIRA2733 test");
        for (int i = 0; i < databasesXML.length; ++i) {
            DatabaseMeta databaseMeta = new DatabaseMeta(databasesXML[i]);
            transMeta.addDatabase(databaseMeta);
        }
        DatabaseMeta dbInfo = transMeta.findDatabase("db");
        Database database = new Database((LoggingObjectInterface)transMeta, dbInfo);
        database.connect();
        this.createTable(database, target_table3, this.createSourceRowMetaInterface1());
        database.execStatement("ALTER TABLE " + target_table3 + " ADD COLUMN ts TIMESTAMP DEFAULT NOW() ");
        PluginRegistry registry = PluginRegistry.getInstance();
        String injectorStepname = "injector step";
        InjectorMeta im = new InjectorMeta();
        String injectorPid = registry.getPluginId(StepPluginType.class, (Object)im);
        StepMeta injectorStep = new StepMeta(injectorPid, injectorStepname, (StepMetaInterface)im);
        transMeta.addStep(injectorStep);
        String outputname = "output to [" + target_table3 + "]";
        TableOutputMeta tom = new TableOutputMeta();
        tom.setDatabaseMeta(transMeta.findDatabase("db"));
        tom.setTableName(target_table3);
        tom.setTruncateTable(true);
        tom.setUseBatchUpdate(true);
        String fromid = registry.getPluginId(StepPluginType.class, (Object)tom);
        StepMeta fromstep = new StepMeta(fromid, outputname, (StepMetaInterface)tom);
        fromstep.setDescription("write data to table [" + target_table3 + "] on database [" + dbInfo + "]");
        transMeta.addStep(fromstep);
        TransHopMeta hi = new TransHopMeta(injectorStep, fromstep);
        transMeta.addTransHop(hi);
        int[] goldRowCounts = new int[]{1, 8, 4, 3, 2, 2, 2, 2, 1};
        for (int commitSize = 0; commitSize <= 8; ++commitSize) {
            tom.setCommitSize(commitSize);
            Trans trans = new Trans(transMeta);
            trans.prepareExecution(null);
            StepInterface si = trans.getStepInterface(outputname, 0);
            RowStepCollector rc = new RowStepCollector();
            si.addRowListener((RowListener)rc);
            RowProducer rp = trans.addRowProducer(injectorStepname, 0);
            trans.startThreads();
            List<RowMetaAndData> inputList = this.createNormalDataRows();
            for (RowMetaAndData rm : inputList) {
                Thread.sleep(dataDelay);
                rp.putRow(rm.getRowMeta(), rm.getData());
            }
            rp.finished();
            trans.waitUntilFinished();
            TableOutputData data = (TableOutputData)trans.findDataInterface(outputname);
            int exp = goldRowCounts[commitSize];
            int act = data.db.getNrExecutedCommits() - 1;
            TableOutputTest.assertEquals((String)("Incorrect number of commits with commitSize=" + commitSize + Const.CR), (int)exp, (int)act);
        }
        this.dropTable(database, target_table3);
    }

    public static void main(String[] args) throws Exception {
        TableOutputTest test = new TableOutputTest();
        for (int i = 0; i < 100; ++i) {
            test.testTableOutputJIRA2733();
        }
    }
}

