/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.textfileinput;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import junit.framework.TestCase;
import org.pentaho.di.TestFailedException;
import org.pentaho.di.TestUtilities;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.StepPluginType;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.trans.RowProducer;
import org.pentaho.di.trans.RowStepCollector;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransHopMeta;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.RowListener;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.textfileinput.TextFileInput;
import org.pentaho.di.trans.steps.textfileinput.TextFileInputField;
import org.pentaho.di.trans.steps.textfileinput.TextFileInputMeta;
import org.pentaho.reporting.libraries.base.util.CSVTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextFileInputTests
extends TestCase {
    public String writeInputFile() throws IOException {
        String rcode = null;
        File tempFile = File.createTempFile("PDI_tmp", ".tmp");
        tempFile.deleteOnExit();
        rcode = tempFile.getAbsolutePath();
        String endOfLineCharacters = TestUtilities.getEndOfLineCharacters();
        FileWriter fout = new FileWriter(tempFile);
        fout.write("A;B;C;D;E" + endOfLineCharacters);
        fout.write("1;b1;c1;d1;e1" + endOfLineCharacters);
        fout.write("2;b2;c2;d2;e2" + endOfLineCharacters);
        fout.write("3;b3;c3;d3;e3" + endOfLineCharacters);
        fout.close();
        return rcode;
    }

    public List<RowMetaAndData> createResultData1() {
        ArrayList<RowMetaAndData> list = new ArrayList<RowMetaAndData>();
        RowMetaInterface rm = this.createResultRowMetaInterface();
        Object[] r1 = new Object[]{new Long(1L), "b1", "c1", "d1", "e1", "fileName"};
        Object[] r2 = new Object[]{new Long(2L), "b2", "c2", "d2", "e2", "fileName"};
        Object[] r3 = new Object[]{new Long(3L), "b3", "c3", "d3", "e3", "fileName"};
        list.add(new RowMetaAndData(rm, r1));
        list.add(new RowMetaAndData(rm, r2));
        list.add(new RowMetaAndData(rm, r3));
        return list;
    }

    public RowMetaInterface createRowMetaInterface() {
        RowMeta rowMeta = new RowMeta();
        ValueMetaInterface[] valuesMeta = new ValueMetaInterface[]{new ValueMeta("filename", 2)};
        for (int i = 0; i < valuesMeta.length; ++i) {
            rowMeta.addValueMeta(valuesMeta[i]);
        }
        return rowMeta;
    }

    public List<RowMetaAndData> createData(String fileName) {
        ArrayList<RowMetaAndData> list = new ArrayList<RowMetaAndData>();
        RowMetaInterface rm = this.createRowMetaInterface();
        Object[] r1 = new Object[]{fileName};
        list.add(new RowMetaAndData(rm, r1));
        return list;
    }

    public RowMetaInterface createResultRowMetaInterface() {
        RowMeta rm = new RowMeta();
        ValueMetaInterface[] valuesMeta = new ValueMetaInterface[]{new ValueMeta("a", 5), new ValueMeta("b", 2), new ValueMeta("c", 2), new ValueMeta("d", 2), new ValueMeta("e", 2), new ValueMeta("filename", 2)};
        for (int i = 0; i < valuesMeta.length; ++i) {
            rm.addValueMeta(valuesMeta[i]);
        }
        return rm;
    }

    private StepMeta createTextFileInputStep(String name, String fileName, PluginRegistry registry) {
        String testFileInputName = "text file input step";
        TextFileInputMeta textFileInputMeta = new TextFileInputMeta();
        String textFileInputPid = registry.getPluginId(StepPluginType.class, (Object)textFileInputMeta);
        StepMeta textFileInputStep = new StepMeta(textFileInputPid, testFileInputName, (StepMetaInterface)textFileInputMeta);
        TextFileInputField[] fields = new TextFileInputField[5];
        for (int idx = 0; idx < fields.length; ++idx) {
            fields[idx] = new TextFileInputField();
        }
        fields[0].setName("a");
        fields[0].setType(5);
        fields[0].setFormat("");
        fields[0].setLength(-1);
        fields[0].setPrecision(-1);
        fields[0].setCurrencySymbol("");
        fields[0].setDecimalSymbol("");
        fields[0].setGroupSymbol("");
        fields[0].setTrimType(0);
        fields[0].setPosition(1);
        fields[1].setName("b");
        fields[1].setType(2);
        fields[1].setFormat("");
        fields[1].setLength(-1);
        fields[1].setPrecision(-1);
        fields[1].setCurrencySymbol("");
        fields[1].setDecimalSymbol("");
        fields[1].setGroupSymbol("");
        fields[1].setTrimType(0);
        fields[1].setPosition(2);
        fields[2].setName("c");
        fields[2].setType(2);
        fields[2].setFormat("");
        fields[2].setLength(-1);
        fields[2].setPrecision(-1);
        fields[2].setCurrencySymbol("");
        fields[2].setDecimalSymbol("");
        fields[2].setGroupSymbol("");
        fields[2].setTrimType(0);
        fields[2].setPosition(3);
        fields[3].setName("d");
        fields[3].setType(2);
        fields[3].setFormat("");
        fields[3].setLength(-1);
        fields[3].setPrecision(-1);
        fields[3].setCurrencySymbol("");
        fields[3].setDecimalSymbol("");
        fields[3].setGroupSymbol("");
        fields[3].setTrimType(0);
        fields[3].setPosition(4);
        fields[4].setName("e");
        fields[4].setType(2);
        fields[4].setFormat("");
        fields[4].setLength(-1);
        fields[4].setPrecision(-1);
        fields[4].setCurrencySymbol("");
        fields[4].setDecimalSymbol("");
        fields[4].setGroupSymbol("");
        fields[4].setTrimType(0);
        fields[4].setPosition(5);
        textFileInputMeta.allocate(1, 1, 0);
        String[] filesRequired = new String[]{"N"};
        String[] includeSubfolders = new String[]{"N"};
        textFileInputMeta.setFilenameField("filename");
        textFileInputMeta.setEnclosure("\"");
        textFileInputMeta.setAddResultFile(false);
        textFileInputMeta.setFileName(new String[]{fileName});
        textFileInputMeta.setFileFormat(TestUtilities.getFileFormat());
        textFileInputMeta.setFileType("CSV");
        textFileInputMeta.setSeparator(";");
        textFileInputMeta.setFileRequired(filesRequired);
        textFileInputMeta.setIncludeSubFolders(includeSubfolders);
        textFileInputMeta.setInputFields(fields);
        textFileInputMeta.setHeader(true);
        textFileInputMeta.setNrHeaderLines(1);
        textFileInputMeta.setFileCompression("None");
        textFileInputMeta.setNoEmptyLines(true);
        textFileInputMeta.setRowLimit(0L);
        textFileInputMeta.setAddResultFile(true);
        textFileInputMeta.setDateFormatLocale(new Locale("en_US"));
        textFileInputMeta.setIncludeFilename(true);
        return textFileInputStep;
    }

    public void testTextFileInput1() throws Exception {
        KettleEnvironment.init();
        TransMeta transMeta = new TransMeta();
        transMeta.setName("testTextFileInput1");
        PluginRegistry registry = PluginRegistry.getInstance();
        String fileName = this.writeInputFile();
        String injectorStepName = "injector step";
        StepMeta injectorStep = TestUtilities.createInjectorStep(injectorStepName, registry);
        transMeta.addStep(injectorStep);
        String testFileInputName = "text file input step";
        StepMeta textFileInputStep = this.createTextFileInputStep(testFileInputName, fileName, registry);
        transMeta.addStep(textFileInputStep);
        TransHopMeta hopInputTextFile = new TransHopMeta(injectorStep, textFileInputStep);
        transMeta.addTransHop(hopInputTextFile);
        String dummyStepName = "dummy step";
        StepMeta dummyStep = TestUtilities.createDummyStep(dummyStepName, registry);
        transMeta.addStep(dummyStep);
        TransHopMeta hop_textFileInputStep_dummyStep = new TransHopMeta(textFileInputStep, dummyStep);
        transMeta.addTransHop(hop_textFileInputStep_dummyStep);
        Trans trans = new Trans(transMeta);
        trans.prepareExecution(null);
        StepInterface si = trans.getStepInterface(dummyStepName, 0);
        RowStepCollector dummyRowCollector = new RowStepCollector();
        si.addRowListener((RowListener)dummyRowCollector);
        RowProducer rowProducer = trans.addRowProducer(injectorStepName, 0);
        trans.startThreads();
        List<RowMetaAndData> inputList = this.createData(fileName);
        for (RowMetaAndData rowMetaAndData : inputList) {
            rowProducer.putRow(rowMetaAndData.getRowMeta(), rowMetaAndData.getData());
        }
        rowProducer.finished();
        trans.waitUntilFinished();
        List<RowMetaAndData> resultRows = dummyRowCollector.getRowsWritten();
        List<RowMetaAndData> goldenImageRows = this.createResultData1();
        try {
            TestUtilities.checkRows(goldenImageRows, resultRows, 5);
        }
        catch (TestFailedException tfe) {
            TextFileInputTests.fail((String)tfe.getMessage());
        }
    }

    public void testGetLine_FILE_FORMAT_MIXED() throws Exception {
        String fileLocation = "testfiles/example.csv";
        InputStream inputStream = KettleVFS.getInputStream((String)fileLocation);
        InputStreamReader reader = new InputStreamReader(inputStream);
        StringBuilder stringBuilder = new StringBuilder(1000);
        String line = TextFileInput.getLine(null, (InputStreamReader)reader, (int)2, (StringBuilder)stringBuilder);
        CSVTokenizer csvt = new CSVTokenizer(line, ",", "\"");
        TextFileInputTests.assertEquals((int)4, (int)csvt.countTokens());
    }
}

