/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.textfileoutput;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import junit.framework.TestCase;
import org.junit.Test;
import org.pentaho.di.TestFailedException;
import org.pentaho.di.TestUtilities;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.StepPluginType;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.trans.RowStepCollector;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransHopMeta;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.RowListener;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.dummytrans.DummyTransMeta;
import org.pentaho.di.trans.steps.rowgenerator.RowGeneratorMeta;
import org.pentaho.di.trans.steps.textfileoutput.TextFileField;
import org.pentaho.di.trans.steps.textfileoutput.TextFileOutputMeta;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextFileOutputTests
extends TestCase {
    private static final String SEPARATOR = ";";
    private static final String EXTENSION = "txt";

    private StepMeta createRowGeneratorStep(String name, PluginRegistry registry) {
        String testFileOutputName = Const.isEmpty((String)name) ? "generate rows" : name;
        RowGeneratorMeta rowGeneratorMeta = new RowGeneratorMeta();
        String rowGeneratorPid = registry.getPluginId(StepPluginType.class, (Object)rowGeneratorMeta);
        StepMeta generateRowsStep = new StepMeta(rowGeneratorPid, testFileOutputName, (StepMetaInterface)rowGeneratorMeta);
        rowGeneratorMeta.setFieldName(new String[]{"Id", "State", "City"});
        rowGeneratorMeta.setFieldType(new String[]{"Integer", "String", "String"});
        rowGeneratorMeta.setValue(new String[]{"1", "Orlando", "Florida"});
        rowGeneratorMeta.setFieldLength(new int[]{-1, -1, -1});
        rowGeneratorMeta.setFieldPrecision(new int[]{-1, -1, -1});
        rowGeneratorMeta.setGroup(new String[]{"", "", ""});
        rowGeneratorMeta.setDecimal(new String[]{"", "", ""});
        rowGeneratorMeta.setCurrency(new String[]{"", "", ""});
        rowGeneratorMeta.setFieldFormat(new String[]{"", "", ""});
        rowGeneratorMeta.setRowLimit("10");
        return generateRowsStep;
    }

    private StepMeta createDummyStep(String name, PluginRegistry registry) {
        String dummyStepName = "dummy step";
        DummyTransMeta dm1 = new DummyTransMeta();
        String dummyPid1 = registry.getPluginId(StepPluginType.class, (Object)dm1);
        StepMeta dummyStep = new StepMeta(dummyPid1, dummyStepName, (StepMetaInterface)dm1);
        return dummyStep;
    }

    public List<RowMetaAndData> createResultData1() {
        ArrayList<RowMetaAndData> list = new ArrayList<RowMetaAndData>();
        RowMetaInterface rowMetaInterface = this.createResultRowMetaInterface();
        Object[] r1 = new Object[]{new Long(1L), "Orlando", "Florida"};
        Object[] r2 = new Object[]{new Long(1L), "Orlando", "Florida"};
        Object[] r3 = new Object[]{new Long(1L), "Orlando", "Florida"};
        Object[] r4 = new Object[]{new Long(1L), "Orlando", "Florida"};
        Object[] r5 = new Object[]{new Long(1L), "Orlando", "Florida"};
        Object[] r6 = new Object[]{new Long(1L), "Orlando", "Florida"};
        Object[] r7 = new Object[]{new Long(1L), "Orlando", "Florida"};
        Object[] r8 = new Object[]{new Long(1L), "Orlando", "Florida"};
        Object[] r9 = new Object[]{new Long(1L), "Orlando", "Florida"};
        Object[] r10 = new Object[]{new Long(1L), "Orlando", "Florida"};
        list.add(new RowMetaAndData(rowMetaInterface, r1));
        list.add(new RowMetaAndData(rowMetaInterface, r2));
        list.add(new RowMetaAndData(rowMetaInterface, r3));
        list.add(new RowMetaAndData(rowMetaInterface, r4));
        list.add(new RowMetaAndData(rowMetaInterface, r5));
        list.add(new RowMetaAndData(rowMetaInterface, r6));
        list.add(new RowMetaAndData(rowMetaInterface, r7));
        list.add(new RowMetaAndData(rowMetaInterface, r8));
        list.add(new RowMetaAndData(rowMetaInterface, r9));
        list.add(new RowMetaAndData(rowMetaInterface, r10));
        return list;
    }

    public List<RowMetaAndData> createResultDataFromObjects(Object[][] objs) {
        ArrayList<RowMetaAndData> list = new ArrayList<RowMetaAndData>();
        RowMetaInterface rowMetaInterface = this.createResultRowMetaInterface();
        for (Object[] o : objs) {
            list.add(new RowMetaAndData(rowMetaInterface, o));
        }
        return list;
    }

    public RowMetaInterface createRowMetaInterface() {
        RowMeta rowMetaInterface = new RowMeta();
        ValueMetaInterface[] valuesMeta = new ValueMetaInterface[]{new ValueMeta("filename", 2)};
        for (int i = 0; i < valuesMeta.length; ++i) {
            rowMetaInterface.addValueMeta(valuesMeta[i]);
        }
        return rowMetaInterface;
    }

    public List<RowMetaAndData> createData() {
        ArrayList<RowMetaAndData> list = new ArrayList<RowMetaAndData>();
        RowMetaInterface rowMetaInterface = this.createRowMetaInterface();
        Object[] r1 = new Object[]{};
        list.add(new RowMetaAndData(rowMetaInterface, r1));
        return list;
    }

    public RowMetaInterface createResultRowMetaInterface() {
        RowMeta rowMetaInterface = new RowMeta();
        ValueMetaInterface[] valuesMeta = new ValueMetaInterface[]{new ValueMeta("Id", 5), new ValueMeta("City", 2), new ValueMeta("State", 2)};
        for (int i = 0; i < valuesMeta.length; ++i) {
            rowMetaInterface.addValueMeta(valuesMeta[i]);
        }
        return rowMetaInterface;
    }

    private static String getXML1() {
        String xml1 = "  <step>    <name>Text file output</name>    <type>TextFileOutput</type>    <description/>    <distribute>Y</distribute>    <copies>1</copies>         <partitioning>           <method>none</method>           <schema_name/>           </partitioning>    <separator>;</separator>    <enclosure>&quot;</enclosure>    <enclosure_forced>N</enclosure_forced>    <enclosure_fix_disabled>N</enclosure_fix_disabled>    <header>Y</header>    <footer>N</footer>    <format>DOS</format>    <compression>None</compression>    <encoding/>    <endedLine/>    <fileNameInField>N</fileNameInField>    <fileNameField/>    <file>      <name>file</name>      <is_command>N</is_command>      <servlet_output>N</servlet_output>      <do_not_open_new_file_init>N</do_not_open_new_file_init>      <extention>txt</extention>      <append>N</append>      <split>N</split>      <haspartno>N</haspartno>      <add_date>N</add_date>      <add_time>N</add_time>      <SpecifyFormat>N</SpecifyFormat>      <date_time_format/>      <add_to_result_filenames>Y</add_to_result_filenames>      <pad>N</pad>      <fast_dump>N</fast_dump>      <splitevery>0</splitevery>    </file>    <fields>    </fields>     <cluster_schema/> <remotesteps>   <input>   </input>   <output>   </output> </remotesteps>    <GUI>      <xloc>183</xloc>      <yloc>66</yloc>      <draw>Y</draw>      </GUI>    </step>";
        return xml1;
    }

    private StepMeta createTextFileOutputStep(String name, String textFileName, String compression, PluginRegistry registry) {
        String testFileOutputName = name;
        TextFileOutputMeta textFileOutputMeta = new TextFileOutputMeta();
        String textFileInputPid = registry.getPluginId(StepPluginType.class, (Object)textFileOutputMeta);
        StepMeta textFileOutputStep = new StepMeta(textFileInputPid, testFileOutputName, (StepMetaInterface)textFileOutputMeta);
        TextFileField[] fields = new TextFileField[3];
        for (int idx = 0; idx < fields.length; ++idx) {
            fields[idx] = new TextFileField();
        }
        fields[0].setName("id");
        fields[0].setType(5);
        fields[0].setFormat("");
        fields[0].setLength(-1);
        fields[0].setPrecision(-1);
        fields[0].setCurrencySymbol("");
        fields[0].setDecimalSymbol("");
        fields[0].setTrimType(0);
        fields[1].setName("city");
        fields[1].setType(2);
        fields[1].setFormat("");
        fields[1].setLength(-1);
        fields[1].setPrecision(-1);
        fields[1].setCurrencySymbol("");
        fields[1].setDecimalSymbol("");
        fields[1].setTrimType(0);
        fields[2].setName("state");
        fields[2].setType(2);
        fields[2].setFormat("");
        fields[2].setLength(-1);
        fields[2].setPrecision(-1);
        fields[2].setCurrencySymbol("");
        fields[2].setDecimalSymbol("");
        fields[2].setTrimType(0);
        textFileOutputMeta.allocate(3);
        textFileOutputMeta.setOutputFields(fields);
        textFileOutputMeta.setFileName(textFileName);
        textFileOutputMeta.setFileNameInField(false);
        textFileOutputMeta.setExtension(EXTENSION);
        textFileOutputMeta.setEnclosure("\"");
        textFileOutputMeta.setFileCompression(compression);
        textFileOutputMeta.setSeparator(SEPARATOR);
        textFileOutputMeta.setFileFormat(TestUtilities.getFileFormat());
        textFileOutputMeta.setAddToResultFiles(false);
        textFileOutputMeta.setNewline(TestUtilities.getEndOfLineCharacters());
        textFileOutputMeta.setSeparator(SEPARATOR);
        textFileOutputMeta.setEnclosure("\"");
        return textFileOutputStep;
    }

    @Test
    public void testTextFileOutput1() throws Exception {
        KettleEnvironment.init();
        TransMeta transMeta = new TransMeta();
        transMeta.setName("testTextFileOutput1");
        PluginRegistry registry = PluginRegistry.getInstance();
        String injectorStepName = "injector step";
        StepMeta injectorStep = TestUtilities.createInjectorStep(injectorStepName, registry);
        transMeta.addStep(injectorStep);
        StepMeta rowGeneratorStep = this.createRowGeneratorStep("Create rows for testTextFileOutput1", registry);
        transMeta.addStep(rowGeneratorStep);
        TransHopMeta hop_injectory_rowGenerator = new TransHopMeta(injectorStep, rowGeneratorStep);
        transMeta.addTransHop(hop_injectory_rowGenerator);
        String textFileName = TestUtilities.createEmptyTempFile("testTextFileOutput1");
        StepMeta textFileOutputStep = this.createTextFileOutputStep("text file output step", textFileName, "None", registry);
        transMeta.addStep(textFileOutputStep);
        TransHopMeta hop_RowGenerator_outputTextFile = new TransHopMeta(rowGeneratorStep, textFileOutputStep);
        transMeta.addTransHop(hop_RowGenerator_outputTextFile);
        String dummyStepName = "dummy step";
        StepMeta dummyStep = this.createDummyStep(dummyStepName, registry);
        transMeta.addStep(dummyStep);
        TransHopMeta hop_outputTextFile_dummyStep = new TransHopMeta(textFileOutputStep, dummyStep);
        transMeta.addTransHop(hop_outputTextFile_dummyStep);
        Trans trans = new Trans(transMeta);
        trans.prepareExecution(null);
        StepInterface dummyStepInterface = trans.getStepInterface(dummyStepName, 0);
        RowStepCollector dummyRowCollector = new RowStepCollector();
        dummyStepInterface.addRowListener((RowListener)dummyRowCollector);
        trans.startThreads();
        trans.waitUntilFinished();
        List<RowMetaAndData> resultRows = dummyRowCollector.getRowsWritten();
        List<RowMetaAndData> goldenImageRows = this.createResultData1();
        try {
            TestUtilities.checkRows(goldenImageRows, resultRows);
        }
        catch (TestFailedException tfe) {
            TextFileOutputTests.fail((String)tfe.getMessage());
        }
    }

    @Test
    public void testTextFileOutput2() throws Exception {
        KettleEnvironment.init();
        TextFileOutputMeta textFileOutputMeta = new TextFileOutputMeta();
        TextFileOutputTests.assertTrue((boolean)textFileOutputMeta.isCreateParentFolder());
        textFileOutputMeta.setDefault();
        TextFileOutputTests.assertTrue((boolean)textFileOutputMeta.isCreateParentFolder());
    }

    @Test
    public void testTextFileOutput3() throws Exception {
        KettleEnvironment.init();
        ByteArrayInputStream xmlStream = new ByteArrayInputStream(TextFileOutputTests.getXML1().getBytes("UTF-8"));
        Document doc = XMLHandler.loadXMLFile((InputStream)xmlStream, null, (boolean)false, (boolean)false);
        Node stepnode = XMLHandler.getSubNode((Node)doc, (String)"step");
        TextFileOutputMeta textFileOutputMeta = new TextFileOutputMeta();
        textFileOutputMeta.loadXML(stepnode, null, null);
        TextFileOutputTests.assertTrue((boolean)textFileOutputMeta.isCreateParentFolder());
    }

    @Test
    public void testTextFileOutput4() throws Exception {
        KettleEnvironment.init();
        TransMeta transMeta = new TransMeta();
        transMeta.setName("testTextFileOutput4");
        PluginRegistry registry = PluginRegistry.getInstance();
        String injectorStepName = "injector step";
        StepMeta injectorStep = TestUtilities.createInjectorStep(injectorStepName, registry);
        transMeta.addStep(injectorStep);
        StepMeta rowGeneratorStep = this.createRowGeneratorStep("Create rows for testTextFileOutput4", registry);
        transMeta.addStep(rowGeneratorStep);
        TransHopMeta hop_injectory_rowGenerator = new TransHopMeta(injectorStep, rowGeneratorStep);
        transMeta.addTransHop(hop_injectory_rowGenerator);
        String textFileName = "testTextFileOutput4";
        String textFileOutputStepName = "text file output step";
        StepMeta textFileOutputStep = this.createTextFileOutputStep(textFileOutputStepName, textFileName, "Zip", registry);
        transMeta.addStep(textFileOutputStep);
        TransHopMeta hop_RowGenerator_outputTextFile = new TransHopMeta(rowGeneratorStep, textFileOutputStep);
        transMeta.addTransHop(hop_RowGenerator_outputTextFile);
        Trans trans = new Trans(transMeta);
        trans.prepareExecution(null);
        StepInterface dummyStepInterface = trans.getStepInterface(textFileOutputStepName, 0);
        RowStepCollector dummyRowCollector = new RowStepCollector();
        dummyStepInterface.addRowListener((RowListener)dummyRowCollector);
        trans.startThreads();
        trans.waitUntilFinished();
        List<RowMetaAndData> resultRows = dummyRowCollector.getRowsWritten();
        Object[][] rows = new Object[10][3];
        File f = new File(textFileName + ".zip");
        f.deleteOnExit();
        try {
            ZipFile zf = new ZipFile(f);
            int zipEntryCount = 0;
            Enumeration<? extends ZipEntry> entries = zf.entries();
            while (entries.hasMoreElements()) {
                ZipEntry ze = entries.nextElement();
                ++zipEntryCount;
                BufferedReader input = new BufferedReader(new InputStreamReader(zf.getInputStream(ze)));
                int rowCount = 0;
                try {
                    String inputLine = input.readLine();
                    while (inputLine != null) {
                        String[] columns = inputLine.split(SEPARATOR);
                        if (columns.length != 3) {
                            TextFileOutputTests.fail((String)("Expected 3 columns, got " + columns.length));
                        }
                        rows[rowCount][0] = Long.parseLong(columns[0].trim());
                        rows[rowCount][1] = columns[1];
                        rows[rowCount][2] = columns[2];
                        inputLine = input.readLine();
                    }
                }
                catch (IOException ioe) {
                }
            }
            zf.close();
            TextFileOutputTests.assertEquals((int)zipEntryCount, (int)1);
        }
        catch (IOException e) {
            TextFileOutputTests.fail((String)e.getLocalizedMessage());
        }
        List<RowMetaAndData> goldenImageRows = this.createResultDataFromObjects(rows);
        try {
            TestUtilities.checkRows(goldenImageRows, resultRows);
        }
        catch (TestFailedException tfe) {
            TextFileOutputTests.fail((String)tfe.getMessage());
        }
    }

    @Test
    public void testTextFileOutput5() throws Exception {
        KettleEnvironment.init();
        TransMeta transMeta = new TransMeta();
        transMeta.setName("testTextFileOutput5");
        PluginRegistry registry = PluginRegistry.getInstance();
        String injectorStepName = "injector step";
        StepMeta injectorStep = TestUtilities.createInjectorStep(injectorStepName, registry);
        transMeta.addStep(injectorStep);
        StepMeta rowGeneratorStep = this.createRowGeneratorStep("Create rows for testTextFileOutput5", registry);
        transMeta.addStep(rowGeneratorStep);
        TransHopMeta hop_injectory_rowGenerator = new TransHopMeta(injectorStep, rowGeneratorStep);
        transMeta.addTransHop(hop_injectory_rowGenerator);
        String textFileName = "testTextFileOutput5";
        String textFileOutputStepName = "text file output step";
        StepMeta textFileOutputStep = this.createTextFileOutputStep(textFileOutputStepName, textFileName, "GZip", registry);
        transMeta.addStep(textFileOutputStep);
        TransHopMeta hop_RowGenerator_outputTextFile = new TransHopMeta(rowGeneratorStep, textFileOutputStep);
        transMeta.addTransHop(hop_RowGenerator_outputTextFile);
        Trans trans = new Trans(transMeta);
        trans.prepareExecution(null);
        StepInterface dummyStepInterface = trans.getStepInterface(textFileOutputStepName, 0);
        RowStepCollector dummyRowCollector = new RowStepCollector();
        dummyStepInterface.addRowListener((RowListener)dummyRowCollector);
        trans.startThreads();
        trans.waitUntilFinished();
        List<RowMetaAndData> resultRows = dummyRowCollector.getRowsWritten();
        Object[][] rows = new Object[10][3];
        File f = new File(textFileName + "." + EXTENSION + ".gz");
        f.deleteOnExit();
        try {
            FileInputStream fin = new FileInputStream(f);
            GZIPInputStream gzis = new GZIPInputStream(fin);
            InputStreamReader xover = new InputStreamReader(gzis);
            BufferedReader input = new BufferedReader(xover);
            int rowCount = 0;
            try {
                String inputLine = input.readLine();
                while (inputLine != null) {
                    String[] columns = inputLine.split(SEPARATOR);
                    if (columns.length != 3) {
                        TextFileOutputTests.fail((String)("Expected 3 columns, got " + columns.length));
                    }
                    rows[rowCount][0] = Long.parseLong(columns[0].trim());
                    rows[rowCount][1] = columns[1];
                    rows[rowCount][2] = columns[2];
                    inputLine = input.readLine();
                }
            }
            catch (IOException ioe) {
                // empty catch block
            }
            fin.close();
        }
        catch (IOException e) {
            TextFileOutputTests.fail((String)e.getLocalizedMessage());
        }
        List<RowMetaAndData> goldenImageRows = this.createResultDataFromObjects(rows);
        try {
            TestUtilities.checkRows(goldenImageRows, resultRows);
        }
        catch (TestFailedException tfe) {
            TextFileOutputTests.fail((String)tfe.getMessage());
        }
    }

    @Test
    public void testTextFileOutput6() throws Exception {
        KettleEnvironment.init();
        TransMeta transMeta = new TransMeta();
        transMeta.setName("testTextFileOutput6");
        PluginRegistry registry = PluginRegistry.getInstance();
        String injectorStepName = "injector step";
        StepMeta injectorStep = TestUtilities.createInjectorStep(injectorStepName, registry);
        transMeta.addStep(injectorStep);
        StepMeta rowGeneratorStep = this.createRowGeneratorStep("Create rows for testTextFileOutput5", registry);
        transMeta.addStep(rowGeneratorStep);
        TransHopMeta hop_injectory_rowGenerator = new TransHopMeta(injectorStep, rowGeneratorStep);
        transMeta.addTransHop(hop_injectory_rowGenerator);
        String textFileName = "testTextFileOutput6";
        String textFileOutputStepName = "text file output step";
        StepMeta textFileOutputStep = this.createTextFileOutputStep(textFileOutputStepName, textFileName, "None", registry);
        transMeta.addStep(textFileOutputStep);
        TransHopMeta hop_RowGenerator_outputTextFile = new TransHopMeta(rowGeneratorStep, textFileOutputStep);
        transMeta.addTransHop(hop_RowGenerator_outputTextFile);
        Trans trans = new Trans(transMeta);
        trans.prepareExecution(null);
        StepInterface dummyStepInterface = trans.getStepInterface(textFileOutputStepName, 0);
        RowStepCollector dummyRowCollector = new RowStepCollector();
        dummyStepInterface.addRowListener((RowListener)dummyRowCollector);
        trans.startThreads();
        trans.waitUntilFinished();
        List<RowMetaAndData> resultRows = dummyRowCollector.getRowsWritten();
        Object[][] rows = new Object[10][3];
        File f = new File(textFileName + "." + EXTENSION);
        f.deleteOnExit();
        try {
            FileInputStream fin = new FileInputStream(f);
            InputStreamReader xover = new InputStreamReader(fin);
            BufferedReader input = new BufferedReader(xover);
            int rowCount = 0;
            try {
                String inputLine = input.readLine();
                while (inputLine != null) {
                    String[] columns = inputLine.split(SEPARATOR);
                    if (columns.length != 3) {
                        TextFileOutputTests.fail((String)("Expected 3 columns, got " + columns.length));
                    }
                    rows[rowCount][0] = Long.parseLong(columns[0].trim());
                    rows[rowCount][1] = columns[1];
                    rows[rowCount][2] = columns[2];
                    inputLine = input.readLine();
                }
            }
            catch (IOException ioe) {
                // empty catch block
            }
            fin.close();
        }
        catch (IOException e) {
            TextFileOutputTests.fail((String)e.getLocalizedMessage());
        }
        List<RowMetaAndData> goldenImageRows = this.createResultDataFromObjects(rows);
        try {
            TestUtilities.checkRows(goldenImageRows, resultRows);
        }
        catch (TestFailedException tfe) {
            TextFileOutputTests.fail((String)tfe.getMessage());
        }
    }
}

