/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.unique;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import org.junit.Test;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.StepPluginType;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.trans.RowProducer;
import org.pentaho.di.trans.RowStepCollector;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransHopMeta;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.RowListener;
import org.pentaho.di.trans.step.StepErrorMeta;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.dummytrans.DummyTransMeta;
import org.pentaho.di.trans.steps.injector.InjectorMeta;
import org.pentaho.di.trans.steps.sort.SortRowsMeta;
import org.pentaho.di.trans.steps.uniquerows.UniqueRowsMeta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UniqueRowsTest
extends TestCase {
    public static int MAX_COUNT = 1000;

    public RowMetaInterface createRowMetaInterface() {
        RowMeta rm = new RowMeta();
        ValueMetaInterface[] valuesMeta = new ValueMetaInterface[]{new ValueMeta("KEY", 2)};
        for (int i = 0; i < valuesMeta.length; ++i) {
            rm.addValueMeta(valuesMeta[i]);
        }
        return rm;
    }

    public List<RowMetaAndData> createData() {
        ArrayList<RowMetaAndData> list = new ArrayList<RowMetaAndData>();
        RowMetaInterface rm = this.createRowMetaInterface();
        Object[] r1 = new Object[]{"abc"};
        Object[] r2 = new Object[]{"ABC"};
        Object[] r3 = new Object[]{"abc"};
        Object[] r4 = new Object[]{"ABC"};
        list.add(new RowMetaAndData(rm, r1));
        list.add(new RowMetaAndData(rm, r2));
        list.add(new RowMetaAndData(rm, r3));
        list.add(new RowMetaAndData(rm, r4));
        return list;
    }

    public List<RowMetaAndData> createDataAllUnique() {
        ArrayList<RowMetaAndData> list = new ArrayList<RowMetaAndData>();
        RowMetaInterface rm = this.createRowMetaInterface();
        Object[] r1 = new Object[]{"A"};
        Object[] r2 = new Object[]{"B"};
        Object[] r3 = new Object[]{"C"};
        Object[] r4 = new Object[]{"D"};
        list.add(new RowMetaAndData(rm, r1));
        list.add(new RowMetaAndData(rm, r2));
        list.add(new RowMetaAndData(rm, r3));
        list.add(new RowMetaAndData(rm, r4));
        return list;
    }

    public List<RowMetaAndData> createResultDataAllUnique() {
        ArrayList<RowMetaAndData> list = new ArrayList<RowMetaAndData>();
        RowMetaInterface rm = this.createRowMetaInterface();
        Object[] r1 = new Object[]{"A"};
        Object[] r2 = new Object[]{"B"};
        Object[] r3 = new Object[]{"C"};
        Object[] r4 = new Object[]{"D"};
        list.add(new RowMetaAndData(rm, r1));
        list.add(new RowMetaAndData(rm, r2));
        list.add(new RowMetaAndData(rm, r3));
        list.add(new RowMetaAndData(rm, r4));
        return list;
    }

    public List<RowMetaAndData> createResultDataCaseSensitiveNoPreviousSort() {
        ArrayList<RowMetaAndData> list = new ArrayList<RowMetaAndData>();
        RowMetaInterface rm = this.createRowMetaInterface();
        Object[] r1 = new Object[]{"abc"};
        Object[] r2 = new Object[]{"ABC"};
        Object[] r3 = new Object[]{"abc"};
        Object[] r4 = new Object[]{"ABC"};
        list.add(new RowMetaAndData(rm, r1));
        list.add(new RowMetaAndData(rm, r2));
        list.add(new RowMetaAndData(rm, r3));
        list.add(new RowMetaAndData(rm, r4));
        return list;
    }

    public List<RowMetaAndData> createResultDataCaseInsensitiveNoPreviousSort() {
        ArrayList<RowMetaAndData> list = new ArrayList<RowMetaAndData>();
        RowMetaInterface rm = this.createRowMetaInterface();
        Object[] r1 = new Object[]{"abc"};
        list.add(new RowMetaAndData(rm, r1));
        return list;
    }

    public List<RowMetaAndData> createResultDataSortCaseSensitiveUniqueCaseSensitive() {
        ArrayList<RowMetaAndData> list = new ArrayList<RowMetaAndData>();
        RowMetaInterface rm = this.createRowMetaInterface();
        Object[] r1 = new Object[]{"ABC"};
        Object[] r2 = new Object[]{"abc"};
        list.add(new RowMetaAndData(rm, r1));
        list.add(new RowMetaAndData(rm, r2));
        return list;
    }

    public List<RowMetaAndData> createResultDataSortCaseSensitiveUniqueCaseInsensitive() {
        ArrayList<RowMetaAndData> list = new ArrayList<RowMetaAndData>();
        RowMetaInterface rm = this.createRowMetaInterface();
        Object[] r1 = new Object[]{"ABC"};
        list.add(new RowMetaAndData(rm, r1));
        return list;
    }

    public List<RowMetaAndData> createResultDataSortCaseInsensitiveUniqueCaseSensitive() {
        ArrayList<RowMetaAndData> list = new ArrayList<RowMetaAndData>();
        RowMetaInterface rm = this.createRowMetaInterface();
        Object[] r1 = new Object[]{"abc"};
        Object[] r2 = new Object[]{"ABC"};
        Object[] r3 = new Object[]{"abc"};
        Object[] r4 = new Object[]{"ABC"};
        list.add(new RowMetaAndData(rm, r1));
        list.add(new RowMetaAndData(rm, r2));
        list.add(new RowMetaAndData(rm, r3));
        list.add(new RowMetaAndData(rm, r4));
        return list;
    }

    public List<RowMetaAndData> createResultDataSortCaseInsensitiveUniqueCaseInsensitive() {
        ArrayList<RowMetaAndData> list = new ArrayList<RowMetaAndData>();
        RowMetaInterface rm = this.createRowMetaInterface();
        Object[] r1 = new Object[]{"abc"};
        list.add(new RowMetaAndData(rm, r1));
        return list;
    }

    public void checkRows(List<RowMetaAndData> rows1, List<RowMetaAndData> rows2) {
        int idx = 1;
        if (rows1.size() != rows2.size()) {
            UniqueRowsTest.fail((String)("Number of rows is not the same: " + rows1.size() + " and " + rows2.size()));
        }
        Iterator<RowMetaAndData> it1 = rows1.iterator();
        Iterator<RowMetaAndData> it2 = rows2.iterator();
        while (it1.hasNext() && it2.hasNext()) {
            RowMetaAndData rm1 = it1.next();
            RowMetaAndData rm2 = it2.next();
            Object[] r1 = rm1.getData();
            Object[] r2 = rm2.getData();
            if (rm1.size() != rm2.size()) {
                UniqueRowsTest.fail((String)("row nr " + idx + " is not equal"));
            }
            int[] fields = new int[r1.length];
            for (int ydx = 0; ydx < r1.length; ++ydx) {
                fields[ydx] = ydx;
            }
            try {
                if (rm1.getRowMeta().compare(r1, r2, fields) != 0) {
                    UniqueRowsTest.fail((String)("row nr " + idx + " is not equal"));
                }
            }
            catch (KettleValueException e) {
                UniqueRowsTest.fail((String)("row nr " + idx + " is not equal"));
            }
            ++idx;
        }
    }

    public void testCaseSensitiveNoPreviousSort() throws Exception {
        KettleEnvironment.init();
        TransMeta transMeta = new TransMeta();
        transMeta.setName("uniquerowstest");
        PluginRegistry registry = PluginRegistry.getInstance();
        String injectorStepname = "injector step";
        InjectorMeta im = new InjectorMeta();
        String injectorPid = registry.getPluginId(StepPluginType.class, (Object)im);
        StepMeta injectorStep = new StepMeta(injectorPid, injectorStepname, (StepMetaInterface)im);
        transMeta.addStep(injectorStep);
        String uniqueRowsStepname = "unique rows step";
        UniqueRowsMeta urm = new UniqueRowsMeta();
        urm.setCompareFields(new String[]{"KEY"});
        urm.setCaseInsensitive(new boolean[]{false});
        String uniqueRowsStepPid = registry.getPluginId(StepPluginType.class, (Object)urm);
        StepMeta uniqueRowsStep = new StepMeta(uniqueRowsStepPid, uniqueRowsStepname, (StepMetaInterface)urm);
        transMeta.addStep(uniqueRowsStep);
        transMeta.addTransHop(new TransHopMeta(injectorStep, uniqueRowsStep));
        String dummyStepname = "dummy step";
        DummyTransMeta dm = new DummyTransMeta();
        String dummyPid = registry.getPluginId(StepPluginType.class, (Object)dm);
        StepMeta dummyStep = new StepMeta(dummyPid, dummyStepname, (StepMetaInterface)dm);
        transMeta.addStep(dummyStep);
        transMeta.addTransHop(new TransHopMeta(uniqueRowsStep, dummyStep));
        Trans trans = new Trans(transMeta);
        trans.prepareExecution(null);
        StepInterface si = trans.getStepInterface(dummyStepname, 0);
        RowStepCollector dummyRc = new RowStepCollector();
        si.addRowListener((RowListener)dummyRc);
        RowProducer rp = trans.addRowProducer(injectorStepname, 0);
        trans.startThreads();
        List<RowMetaAndData> inputList = this.createData();
        for (RowMetaAndData rm : inputList) {
            rp.putRow(rm.getRowMeta(), rm.getData());
        }
        rp.finished();
        trans.waitUntilFinished();
        List<RowMetaAndData> resultRows = dummyRc.getRowsWritten();
        this.checkRows(this.createResultDataCaseSensitiveNoPreviousSort(), resultRows);
    }

    public void testCaseInsensitiveNoPreviousSort() throws Exception {
        KettleEnvironment.init();
        TransMeta transMeta = new TransMeta();
        transMeta.setName("uniquerowstest");
        PluginRegistry registry = PluginRegistry.getInstance();
        String injectorStepname = "injector step";
        InjectorMeta im = new InjectorMeta();
        String injectorPid = registry.getPluginId(StepPluginType.class, (Object)im);
        StepMeta injectorStep = new StepMeta(injectorPid, injectorStepname, (StepMetaInterface)im);
        transMeta.addStep(injectorStep);
        String uniqueRowsStepname = "unique rows step";
        UniqueRowsMeta urm = new UniqueRowsMeta();
        urm.setCompareFields(new String[]{"KEY"});
        urm.setCaseInsensitive(new boolean[]{true});
        String uniqueRowsStepPid = registry.getPluginId(StepPluginType.class, (Object)urm);
        StepMeta uniqueRowsStep = new StepMeta(uniqueRowsStepPid, uniqueRowsStepname, (StepMetaInterface)urm);
        transMeta.addStep(uniqueRowsStep);
        transMeta.addTransHop(new TransHopMeta(injectorStep, uniqueRowsStep));
        String dummyStepname = "dummy step";
        DummyTransMeta dm = new DummyTransMeta();
        String dummyPid = registry.getPluginId(StepPluginType.class, (Object)dm);
        StepMeta dummyStep = new StepMeta(dummyPid, dummyStepname, (StepMetaInterface)dm);
        transMeta.addStep(dummyStep);
        transMeta.addTransHop(new TransHopMeta(uniqueRowsStep, dummyStep));
        Trans trans = new Trans(transMeta);
        trans.prepareExecution(null);
        StepInterface si = trans.getStepInterface(dummyStepname, 0);
        RowStepCollector dummyRc = new RowStepCollector();
        si.addRowListener((RowListener)dummyRc);
        RowProducer rp = trans.addRowProducer(injectorStepname, 0);
        trans.startThreads();
        List<RowMetaAndData> inputList = this.createData();
        for (RowMetaAndData rm : inputList) {
            rp.putRow(rm.getRowMeta(), rm.getData());
        }
        rp.finished();
        trans.waitUntilFinished();
        List<RowMetaAndData> resultRows = dummyRc.getRowsWritten();
        this.checkRows(this.createResultDataCaseInsensitiveNoPreviousSort(), resultRows);
    }

    public void testSortCaseSensitiveUniqueCaseSensitive() throws Exception {
        KettleEnvironment.init();
        TransMeta transMeta = new TransMeta();
        transMeta.setName("uniquerowstest");
        PluginRegistry registry = PluginRegistry.getInstance();
        String injectorStepname = "injector step";
        InjectorMeta im = new InjectorMeta();
        String injectorPid = registry.getPluginId(StepPluginType.class, (Object)im);
        StepMeta injectorStep = new StepMeta(injectorPid, injectorStepname, (StepMetaInterface)im);
        transMeta.addStep(injectorStep);
        String sortRowsStepname = "sort rows step";
        SortRowsMeta srm = new SortRowsMeta();
        srm.setFieldName(new String[]{"KEY"});
        srm.setAscending(new boolean[]{true});
        srm.setCaseSensitive(new boolean[]{true});
        srm.setPrefix("SortRowsTest");
        srm.setDirectory(".");
        String sortRowsStepPid = registry.getPluginId(StepPluginType.class, (Object)srm);
        StepMeta sortRowsStep = new StepMeta(sortRowsStepPid, sortRowsStepname, (StepMetaInterface)srm);
        transMeta.addStep(sortRowsStep);
        transMeta.addTransHop(new TransHopMeta(injectorStep, sortRowsStep));
        String uniqueRowsStepname = "unique rows step";
        UniqueRowsMeta urm = new UniqueRowsMeta();
        urm.setCompareFields(new String[]{"KEY"});
        urm.setCaseInsensitive(new boolean[]{false});
        String uniqueRowsStepPid = registry.getPluginId(StepPluginType.class, (Object)urm);
        StepMeta uniqueRowsStep = new StepMeta(uniqueRowsStepPid, uniqueRowsStepname, (StepMetaInterface)urm);
        transMeta.addStep(uniqueRowsStep);
        transMeta.addTransHop(new TransHopMeta(sortRowsStep, uniqueRowsStep));
        String dummyStepname = "dummy step";
        DummyTransMeta dm = new DummyTransMeta();
        String dummyPid = registry.getPluginId(StepPluginType.class, (Object)dm);
        StepMeta dummyStep = new StepMeta(dummyPid, dummyStepname, (StepMetaInterface)dm);
        transMeta.addStep(dummyStep);
        transMeta.addTransHop(new TransHopMeta(uniqueRowsStep, dummyStep));
        Trans trans = new Trans(transMeta);
        trans.prepareExecution(null);
        StepInterface si = trans.getStepInterface(dummyStepname, 0);
        RowStepCollector dummyRc = new RowStepCollector();
        si.addRowListener((RowListener)dummyRc);
        RowProducer rp = trans.addRowProducer(injectorStepname, 0);
        trans.startThreads();
        List<RowMetaAndData> inputList = this.createData();
        for (RowMetaAndData rm : inputList) {
            rp.putRow(rm.getRowMeta(), rm.getData());
        }
        rp.finished();
        trans.waitUntilFinished();
        List<RowMetaAndData> resultRows = dummyRc.getRowsWritten();
        this.checkRows(this.createResultDataSortCaseSensitiveUniqueCaseSensitive(), resultRows);
    }

    public void testSortCaseSensitiveUniqueCaseInsensitive() throws Exception {
        KettleEnvironment.init();
        TransMeta transMeta = new TransMeta();
        transMeta.setName("uniquerowstest");
        PluginRegistry registry = PluginRegistry.getInstance();
        String injectorStepname = "injector step";
        InjectorMeta im = new InjectorMeta();
        String injectorPid = registry.getPluginId(StepPluginType.class, (Object)im);
        StepMeta injectorStep = new StepMeta(injectorPid, injectorStepname, (StepMetaInterface)im);
        transMeta.addStep(injectorStep);
        String sortRowsStepname = "sort rows step";
        SortRowsMeta srm = new SortRowsMeta();
        srm.setFieldName(new String[]{"KEY"});
        srm.setAscending(new boolean[]{true});
        srm.setCaseSensitive(new boolean[]{true});
        srm.setPrefix("SortRowsTest");
        srm.setDirectory(".");
        String sortRowsStepPid = registry.getPluginId(StepPluginType.class, (Object)srm);
        StepMeta sortRowsStep = new StepMeta(sortRowsStepPid, sortRowsStepname, (StepMetaInterface)srm);
        transMeta.addStep(sortRowsStep);
        transMeta.addTransHop(new TransHopMeta(injectorStep, sortRowsStep));
        String uniqueRowsStepname = "unique rows step";
        UniqueRowsMeta urm = new UniqueRowsMeta();
        urm.setCompareFields(new String[]{"KEY"});
        urm.setCaseInsensitive(new boolean[]{true});
        String uniqueRowsStepPid = registry.getPluginId(StepPluginType.class, (Object)urm);
        StepMeta uniqueRowsStep = new StepMeta(uniqueRowsStepPid, uniqueRowsStepname, (StepMetaInterface)urm);
        transMeta.addStep(uniqueRowsStep);
        transMeta.addTransHop(new TransHopMeta(sortRowsStep, uniqueRowsStep));
        String dummyStepname = "dummy step";
        DummyTransMeta dm = new DummyTransMeta();
        String dummyPid = registry.getPluginId(StepPluginType.class, (Object)dm);
        StepMeta dummyStep = new StepMeta(dummyPid, dummyStepname, (StepMetaInterface)dm);
        transMeta.addStep(dummyStep);
        transMeta.addTransHop(new TransHopMeta(uniqueRowsStep, dummyStep));
        Trans trans = new Trans(transMeta);
        trans.prepareExecution(null);
        StepInterface si = trans.getStepInterface(dummyStepname, 0);
        RowStepCollector dummyRc = new RowStepCollector();
        si.addRowListener((RowListener)dummyRc);
        RowProducer rp = trans.addRowProducer(injectorStepname, 0);
        trans.startThreads();
        List<RowMetaAndData> inputList = this.createData();
        for (RowMetaAndData rm : inputList) {
            rp.putRow(rm.getRowMeta(), rm.getData());
        }
        rp.finished();
        trans.waitUntilFinished();
        List<RowMetaAndData> resultRows = dummyRc.getRowsWritten();
        this.checkRows(this.createResultDataSortCaseSensitiveUniqueCaseInsensitive(), resultRows);
    }

    public void testSortCaseInsensitiveUniqueCaseSensitive() throws Exception {
        KettleEnvironment.init();
        TransMeta transMeta = new TransMeta();
        transMeta.setName("uniquerowstest");
        PluginRegistry registry = PluginRegistry.getInstance();
        String injectorStepname = "injector step";
        InjectorMeta im = new InjectorMeta();
        String injectorPid = registry.getPluginId(StepPluginType.class, (Object)im);
        StepMeta injectorStep = new StepMeta(injectorPid, injectorStepname, (StepMetaInterface)im);
        transMeta.addStep(injectorStep);
        String sortRowsStepname = "sort rows step";
        SortRowsMeta srm = new SortRowsMeta();
        srm.setFieldName(new String[]{"KEY"});
        srm.setAscending(new boolean[]{true});
        srm.setCaseSensitive(new boolean[]{false});
        srm.setPrefix("SortRowsTest");
        srm.setDirectory(".");
        String sortRowsStepPid = registry.getPluginId(StepPluginType.class, (Object)srm);
        StepMeta sortRowsStep = new StepMeta(sortRowsStepPid, sortRowsStepname, (StepMetaInterface)srm);
        transMeta.addStep(sortRowsStep);
        transMeta.addTransHop(new TransHopMeta(injectorStep, sortRowsStep));
        String uniqueRowsStepname = "unique rows step";
        UniqueRowsMeta urm = new UniqueRowsMeta();
        urm.setCompareFields(new String[]{"KEY"});
        urm.setCaseInsensitive(new boolean[]{false});
        String uniqueRowsStepPid = registry.getPluginId(StepPluginType.class, (Object)urm);
        StepMeta uniqueRowsStep = new StepMeta(uniqueRowsStepPid, uniqueRowsStepname, (StepMetaInterface)urm);
        transMeta.addStep(uniqueRowsStep);
        transMeta.addTransHop(new TransHopMeta(sortRowsStep, uniqueRowsStep));
        String dummyStepname = "dummy step";
        DummyTransMeta dm = new DummyTransMeta();
        String dummyPid = registry.getPluginId(StepPluginType.class, (Object)dm);
        StepMeta dummyStep = new StepMeta(dummyPid, dummyStepname, (StepMetaInterface)dm);
        transMeta.addStep(dummyStep);
        transMeta.addTransHop(new TransHopMeta(uniqueRowsStep, dummyStep));
        Trans trans = new Trans(transMeta);
        trans.prepareExecution(null);
        StepInterface si = trans.getStepInterface(dummyStepname, 0);
        RowStepCollector dummyRc = new RowStepCollector();
        si.addRowListener((RowListener)dummyRc);
        RowProducer rp = trans.addRowProducer(injectorStepname, 0);
        trans.startThreads();
        List<RowMetaAndData> inputList = this.createData();
        for (RowMetaAndData rm : inputList) {
            rp.putRow(rm.getRowMeta(), rm.getData());
        }
        rp.finished();
        trans.waitUntilFinished();
        List<RowMetaAndData> resultRows = dummyRc.getRowsWritten();
        this.checkRows(this.createResultDataSortCaseInsensitiveUniqueCaseSensitive(), resultRows);
    }

    public void testSortCaseInsensitiveUniqueCaseInsensitive() throws Exception {
        KettleEnvironment.init();
        TransMeta transMeta = new TransMeta();
        transMeta.setName("uniquerowstest");
        PluginRegistry registry = PluginRegistry.getInstance();
        String injectorStepname = "injector step";
        InjectorMeta im = new InjectorMeta();
        String injectorPid = registry.getPluginId(StepPluginType.class, (Object)im);
        StepMeta injectorStep = new StepMeta(injectorPid, injectorStepname, (StepMetaInterface)im);
        transMeta.addStep(injectorStep);
        String sortRowsStepname = "sort rows step";
        SortRowsMeta srm = new SortRowsMeta();
        srm.setFieldName(new String[]{"KEY"});
        srm.setAscending(new boolean[]{true});
        srm.setCaseSensitive(new boolean[]{false});
        srm.setPrefix("SortRowsTest");
        srm.setDirectory(".");
        String sortRowsStepPid = registry.getPluginId(StepPluginType.class, (Object)srm);
        StepMeta sortRowsStep = new StepMeta(sortRowsStepPid, sortRowsStepname, (StepMetaInterface)srm);
        transMeta.addStep(sortRowsStep);
        transMeta.addTransHop(new TransHopMeta(injectorStep, sortRowsStep));
        String uniqueRowsStepname = "unique rows step";
        UniqueRowsMeta urm = new UniqueRowsMeta();
        urm.setCompareFields(new String[]{"KEY"});
        urm.setCaseInsensitive(new boolean[]{true});
        String uniqueRowsStepPid = registry.getPluginId(StepPluginType.class, (Object)urm);
        StepMeta uniqueRowsStep = new StepMeta(uniqueRowsStepPid, uniqueRowsStepname, (StepMetaInterface)urm);
        transMeta.addStep(uniqueRowsStep);
        transMeta.addTransHop(new TransHopMeta(sortRowsStep, uniqueRowsStep));
        String dummyStepname = "dummy step";
        DummyTransMeta dm = new DummyTransMeta();
        String dummyPid = registry.getPluginId(StepPluginType.class, (Object)dm);
        StepMeta dummyStep = new StepMeta(dummyPid, dummyStepname, (StepMetaInterface)dm);
        transMeta.addStep(dummyStep);
        transMeta.addTransHop(new TransHopMeta(uniqueRowsStep, dummyStep));
        Trans trans = new Trans(transMeta);
        trans.prepareExecution(null);
        StepInterface si = trans.getStepInterface(dummyStepname, 0);
        RowStepCollector dummyRc = new RowStepCollector();
        si.addRowListener((RowListener)dummyRc);
        RowProducer rp = trans.addRowProducer(injectorStepname, 0);
        trans.startThreads();
        List<RowMetaAndData> inputList = this.createData();
        for (RowMetaAndData rm : inputList) {
            rp.putRow(rm.getRowMeta(), rm.getData());
        }
        rp.finished();
        trans.waitUntilFinished();
        List<RowMetaAndData> resultRows = dummyRc.getRowsWritten();
        this.checkRows(this.createResultDataSortCaseInsensitiveUniqueCaseInsensitive(), resultRows);
    }

    @Test
    public void testAllUnique() throws Exception {
        KettleEnvironment.init();
        TransMeta transMeta = new TransMeta();
        transMeta.setName("uniquerowstest");
        PluginRegistry registry = PluginRegistry.getInstance();
        String injectorStepname = "injector step";
        InjectorMeta im = new InjectorMeta();
        String injectorPid = registry.getPluginId(StepPluginType.class, (Object)im);
        StepMeta injectorStep = new StepMeta(injectorPid, injectorStepname, (StepMetaInterface)im);
        transMeta.addStep(injectorStep);
        String uniqueRowsStepname = "unique rows step";
        UniqueRowsMeta urm = new UniqueRowsMeta();
        urm.setCompareFields(new String[]{"KEY"});
        urm.setCaseInsensitive(new boolean[]{true});
        urm.setRejectDuplicateRow(true);
        String uniqueRowsStepPid = registry.getPluginId(StepPluginType.class, (Object)urm);
        StepMeta uniqueRowsStep = new StepMeta(uniqueRowsStepPid, uniqueRowsStepname, (StepMetaInterface)urm);
        uniqueRowsStep.setDistributes(false);
        transMeta.addStep(uniqueRowsStep);
        transMeta.addTransHop(new TransHopMeta(injectorStep, uniqueRowsStep));
        String dummyStepname1 = "dummy step";
        DummyTransMeta dm1 = new DummyTransMeta();
        String dummyPid1 = registry.getPluginId(StepPluginType.class, (Object)dm1);
        StepMeta dummyStep1 = new StepMeta(dummyPid1, dummyStepname1, (StepMetaInterface)dm1);
        transMeta.addStep(dummyStep1);
        transMeta.addTransHop(new TransHopMeta(uniqueRowsStep, dummyStep1));
        String dummyStepname2 = "dummy step2";
        DummyTransMeta dm2 = new DummyTransMeta();
        String dummyPid2 = registry.getPluginId(StepPluginType.class, (Object)dm2);
        StepMeta dummyStep2 = new StepMeta(dummyPid2, dummyStepname2, (StepMetaInterface)dm2);
        transMeta.addStep(dummyStep2);
        StepErrorMeta stepErrorMeta = new StepErrorMeta((VariableSpace)new Variables(), uniqueRowsStep);
        stepErrorMeta.setTargetStep(dummyStep2);
        stepErrorMeta.setEnabled(true);
        stepErrorMeta.setNrErrorsValuename("numErrors");
        stepErrorMeta.setErrorDescriptionsValuename("duplicates");
        stepErrorMeta.setErrorFieldsValuename("KEY");
        stepErrorMeta.setErrorCodesValuename("errorCodes");
        stepErrorMeta.setMaxErrors("9999");
        stepErrorMeta.setMaxPercentErrors("");
        stepErrorMeta.setMinPercentRows("");
        uniqueRowsStep.setStepErrorMeta(stepErrorMeta);
        transMeta.addTransHop(new TransHopMeta(uniqueRowsStep, dummyStep2));
        Trans trans = new Trans(transMeta);
        trans.prepareExecution(null);
        StepInterface si = trans.getStepInterface(dummyStepname1, 0);
        RowStepCollector dummyRc1 = new RowStepCollector();
        si.addRowListener((RowListener)dummyRc1);
        StepInterface si2 = trans.getStepInterface(dummyStepname2, 0);
        RowStepCollector dummyRc2 = new RowStepCollector();
        si2.addRowListener((RowListener)dummyRc2);
        RowProducer rp = trans.addRowProducer(injectorStepname, 0);
        trans.startThreads();
        List<RowMetaAndData> inputList = this.createDataAllUnique();
        for (RowMetaAndData rm : inputList) {
            rp.putRow(rm.getRowMeta(), rm.getData());
        }
        rp.finished();
        trans.waitUntilFinished();
        List<RowMetaAndData> resultRows = dummyRc1.getRowsWritten();
        this.checkRows(this.createResultDataAllUnique(), resultRows);
        List<RowMetaAndData> errorRows = dummyRc2.getRowsWritten();
        UniqueRowsTest.assertEquals((int)errorRows.size(), (int)0);
    }
}

