/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.update;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.StepPluginType;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.trans.RowProducer;
import org.pentaho.di.trans.RowStepCollector;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransHopMeta;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.RowListener;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.injector.InjectorMeta;
import org.pentaho.di.trans.steps.update.UpdateMeta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateTest
extends TestCase {
    public static final String[] databasesXML = new String[]{"<?xml version=\"1.0\" encoding=\"UTF-8\"?><connection><name>db</name><server>127.0.0.1</server><type>H2</type><access>Native</access><database>mem:db</database><port></port><username>sa</username><password></password></connection>"};
    public static final String TARGET_TABLE = "update_step_test_case_table";
    private static String[] insertStatement = new String[]{"INSERT INTO update_step_test_case_table(ID, CODE, VALUE, ROW_ORDER) VALUES (NULL, NULL, 'null_id_code', 1)", "INSERT INTO update_step_test_case_table(ID, CODE, VALUE, ROW_ORDER) VALUES (NULL, 1, 'null_id', 2)", "INSERT INTO update_step_test_case_table(ID, CODE, VALUE, ROW_ORDER) VALUES (1, NULL, 'null_code', 3)", "INSERT INTO update_step_test_case_table(ID, CODE, VALUE, ROW_ORDER) VALUES (2, 2, 'non_null_keys', 4)"};
    Trans trans;
    public UpdateMeta upd;
    public RowStepCollector rc;
    public RowProducer rp;
    public Database db;

    public RowMetaInterface getTargetTableRowMeta() {
        RowMeta rm = new RowMeta();
        ValueMetaInterface[] valuesMeta = new ValueMetaInterface[]{new ValueMeta("ID", 5, 8, 0), new ValueMeta("CODE", 5, 8, 0), new ValueMeta("VALUE", 2, 255, 0), new ValueMeta("ROW_ORDER", 5, 8, 0)};
        for (int i = 0; i < valuesMeta.length; ++i) {
            rm.addValueMeta(valuesMeta[i]);
        }
        return rm;
    }

    public void addLookup(String[] def) {
        if (this.upd.getKeyLookup() == null) {
            this.upd.setKeyLookup(new String[0]);
            this.upd.setKeyCondition(new String[0]);
            this.upd.setKeyStream(new String[0]);
            this.upd.setKeyStream2(new String[0]);
        }
        int newLength = this.upd.getKeyLookup().length + 1;
        ArrayList<String> newKeyLookup = new ArrayList<String>(newLength);
        newKeyLookup.addAll(Arrays.asList(this.upd.getKeyLookup()));
        newKeyLookup.add(def[0]);
        this.upd.setKeyLookup(newKeyLookup.toArray(new String[0]));
        ArrayList<String> newKeyCondition = new ArrayList<String>(newLength);
        newKeyCondition.addAll(Arrays.asList(this.upd.getKeyCondition()));
        newKeyCondition.add(def[1]);
        this.upd.setKeyCondition(newKeyCondition.toArray(new String[0]));
        ArrayList<String> newKeyStream = new ArrayList<String>(newLength);
        newKeyStream.addAll(Arrays.asList(this.upd.getKeyStream()));
        newKeyStream.add(def[2]);
        this.upd.setKeyStream(newKeyStream.toArray(new String[0]));
        ArrayList<String> newKeyStream2 = new ArrayList<String>(newLength);
        newKeyStream2.addAll(Arrays.asList(this.upd.getKeyStream2()));
        newKeyStream2.add(def[3]);
        this.upd.setKeyStream2(newKeyStream2.toArray(new String[0]));
    }

    @Before
    public void setUp() throws Exception {
        KettleEnvironment.init();
        TransMeta transMeta = new TransMeta();
        transMeta.setName("update test");
        for (int i = 0; i < databasesXML.length; ++i) {
            DatabaseMeta databaseMeta = new DatabaseMeta(databasesXML[i]);
            transMeta.addDatabase(databaseMeta);
        }
        DatabaseMeta dbInfo = transMeta.findDatabase("db");
        this.db = new Database((LoggingObjectInterface)transMeta, dbInfo);
        this.db.connect();
        String source = this.db.getCreateTableStatement(TARGET_TABLE, this.getTargetTableRowMeta(), null, false, null, true);
        this.db.execStatement(source);
        for (String sql : insertStatement) {
            this.db.execStatement(sql);
        }
        PluginRegistry registry = PluginRegistry.getInstance();
        String injectorStepName = "injector step";
        InjectorMeta im = new InjectorMeta();
        String injectorPid = registry.getPluginId(StepPluginType.class, (Object)im);
        StepMeta injectorStep = new StepMeta(injectorPid, injectorStepName, (StepMetaInterface)im);
        transMeta.addStep(injectorStep);
        String updateStepName = "update [update_step_test_case_table]";
        this.upd = new UpdateMeta();
        this.upd.setDatabaseMeta(transMeta.findDatabase("db"));
        this.upd.setTableName(TARGET_TABLE);
        this.upd.setUpdateLookup(new String[]{"VALUE"});
        this.upd.setUpdateStream(new String[]{"VALUE"});
        this.upd.setErrorIgnored(true);
        String fromid = registry.getPluginId(StepPluginType.class, (Object)this.upd);
        StepMeta updateStep = new StepMeta(fromid, updateStepName, (StepMetaInterface)this.upd);
        updateStep.setDescription("update data in table [update_step_test_case_table] on database [" + dbInfo + "]");
        transMeta.addStep(updateStep);
        TransHopMeta hi = new TransHopMeta(injectorStep, updateStep);
        transMeta.addTransHop(hi);
        this.trans = new Trans(transMeta);
        this.trans.prepareExecution(null);
        StepInterface si = this.trans.getStepInterface(updateStepName, 0);
        this.rc = new RowStepCollector();
        si.addRowListener((RowListener)this.rc);
        this.rp = this.trans.addRowProducer(injectorStepName, 0);
    }

    @After
    public void tearDown() throws Exception {
        if (this.db != null) {
            this.db.execStatement("DROP TABLE update_step_test_case_table;");
            this.db.disconnect();
        }
        this.db = null;
        this.upd = null;
        this.trans = null;
        this.rc = null;
        this.rp = null;
    }

    public List<RowMetaAndData> createMatchingDataRows() {
        RowMetaInterface rm = this.getTargetTableRowMeta();
        ArrayList<RowMetaAndData> list = new ArrayList<RowMetaAndData>();
        list.add(new RowMetaAndData(rm, new Object[]{null, null, "updated"}));
        list.add(new RowMetaAndData(rm, new Object[]{null, 1L, "updated"}));
        list.add(new RowMetaAndData(rm, new Object[]{1L, null, "updated"}));
        list.add(new RowMetaAndData(rm, new Object[]{2L, 2L, "updated"}));
        return list;
    }

    public void pumpMatchingRows() throws Exception {
        this.pumpRows(this.createMatchingDataRows());
    }

    public void pumpRows(List<RowMetaAndData> inputList) throws Exception {
        this.trans.startThreads();
        for (RowMetaAndData rm : inputList) {
            this.rp.putRow(rm.getRowMeta(), rm.getData());
        }
        this.rp.finished();
        this.trans.waitUntilFinished();
        if (this.trans.getErrors() > 0) {
            UpdateTest.fail((String)"test transformation failed, check logs!");
        }
    }

    public String[] getDbRows() throws Exception {
        ResultSet rs = this.db.openQuery("SELECT VALUE FROM update_step_test_case_table ORDER BY ROW_ORDER ASC;");
        ArrayList<String> rows = new ArrayList<String>();
        while (rs.next()) {
            rows.add(rs.getString("VALUE"));
        }
        return rows.toArray(new String[0]);
    }

    public void testUpdateEquals() throws Exception {
        this.addLookup(new String[]{"ID", "=", "ID", ""});
        this.pumpMatchingRows();
        Object[] rows = this.getDbRows();
        Object[] expected = new String[]{"null_id_code", "null_id", "updated", "updated"};
        Assert.assertArrayEquals((String)"Unexpected changes by update step", (Object[])expected, (Object[])rows);
    }

    public void testUpdateEqualsSkip() throws Exception {
        this.upd.setSkipLookup(true);
        this.testUpdateEquals();
    }

    public void testUpdateEqualsTwoKeys() throws Exception {
        this.addLookup(new String[]{"ID", "=", "ID", ""});
        this.addLookup(new String[]{"CODE", "=", "CODE", ""});
        this.pumpMatchingRows();
        Object[] rows = this.getDbRows();
        Object[] expected = new String[]{"null_id_code", "null_id", "null_code", "updated"};
        Assert.assertArrayEquals((String)"Unexpected changes by update step", (Object[])expected, (Object[])rows);
    }

    public void testUpdateEqualsTwoKeysSkip() throws Exception {
        this.upd.setSkipLookup(true);
        this.testUpdateEqualsTwoKeys();
    }

    public void testUpdateEqualsSupportsNull() throws Exception {
        this.addLookup(new String[]{"ID", "= ~NULL", "ID", ""});
        this.pumpMatchingRows();
        Object[] rows = this.getDbRows();
        Object[] expected = new String[]{"updated", "updated", "updated", "updated"};
        Assert.assertArrayEquals((String)"Unexpected changes by update step", (Object[])expected, (Object[])rows);
    }

    public void testUpdateEqualsSupportsNullSkip() throws Exception {
        this.upd.setSkipLookup(true);
        this.testUpdateEqualsSupportsNull();
    }

    public void testUpdateEqualsSupportsNullTwoKeys() throws Exception {
        this.addLookup(new String[]{"ID", "= ~NULL", "ID", ""});
        this.addLookup(new String[]{"CODE", "= ~NULL", "CODE", ""});
        this.pumpMatchingRows();
        Object[] rows = this.getDbRows();
        Object[] expected = new String[]{"updated", "updated", "updated", "updated"};
        Assert.assertArrayEquals((String)"Unexpected changes by update step", (Object[])expected, (Object[])rows);
    }

    public void testUpdateEqualsSupportsNullTwoKeysSkip() throws Exception {
        this.upd.setSkipLookup(true);
        this.testUpdateEqualsSupportsNullTwoKeys();
    }

    public void testUpdateEqualsSupportsNullTwoKeysMixed() throws Exception {
        this.addLookup(new String[]{"ID", "= ~NULL", "ID", ""});
        this.addLookup(new String[]{"CODE", "=", "CODE", ""});
        this.pumpMatchingRows();
        Object[] rows = this.getDbRows();
        Object[] expected = new String[]{"null_id_code", "updated", "null_code", "updated"};
        Assert.assertArrayEquals((String)"Unexpected changes by update step", (Object[])expected, (Object[])rows);
    }

    public void testUpdateEqualsSupportsNullTwoKeysMixedSkip() throws Exception {
        this.upd.setSkipLookup(true);
        this.testUpdateEqualsSupportsNullTwoKeysMixed();
    }

    public void testUpdateIsNull() throws Exception {
        this.addLookup(new String[]{"CODE", "IS NULL", "", ""});
        this.pumpMatchingRows();
        Object[] rows = this.getDbRows();
        Object[] expected = new String[]{"updated", "null_id", "updated", "non_null_keys"};
        Assert.assertArrayEquals((String)"Unexpected changes by update step", (Object[])expected, (Object[])rows);
    }

    public void testUpdateIsNullSkip() throws Exception {
        this.upd.setSkipLookup(true);
        this.testUpdateIsNull();
    }

    public void testUpdateIsNotNull() throws Exception {
        this.addLookup(new String[]{"CODE", "IS NOT NULL", "", ""});
        this.pumpMatchingRows();
        Object[] rows = this.getDbRows();
        Object[] expected = new String[]{"null_id_code", "updated", "null_code", "updated"};
        Assert.assertArrayEquals((String)"Unexpected changes by update step", (Object[])expected, (Object[])rows);
    }

    public void testUpdateIsNotNullSkip() throws Exception {
        this.upd.setSkipLookup(true);
        this.testUpdateIsNotNull();
    }

    public void testUpdateBetween() throws Exception {
        this.addLookup(new String[]{"ID", "BETWEEN", "ID", "CODE"});
        this.pumpMatchingRows();
        Object[] rows = this.getDbRows();
        Object[] expected = new String[]{"null_id_code", "null_id", "null_code", "updated"};
        Assert.assertArrayEquals((String)"Unexpected changes by update step", (Object[])expected, (Object[])rows);
    }

    public void testUpdateBetweenSkip() throws Exception {
        this.upd.setSkipLookup(true);
        this.testUpdateBetween();
    }

    public void testUpdateEqualsSupportsNullTwoKeysMixed2() throws Exception {
        this.addLookup(new String[]{"ID", "=", "ID", ""});
        this.addLookup(new String[]{"CODE", "= ~NULL", "CODE", ""});
        this.pumpMatchingRows();
        Object[] rows = this.getDbRows();
        Object[] expected = new String[]{"null_id_code", "null_id", "updated", "updated"};
        Assert.assertArrayEquals((String)"Unexpected changes by update step", (Object[])expected, (Object[])rows);
    }

    public void testUpdateEqualsSupportsNullTwoKeysMixed2Skip() throws Exception {
        this.upd.setSkipLookup(true);
        this.testUpdateEqualsSupportsNullTwoKeysMixed2();
    }
}

