/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.valuemapper;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.StepPluginType;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.trans.RowProducer;
import org.pentaho.di.trans.RowStepCollector;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransHopMeta;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.RowListener;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.dummytrans.DummyTransMeta;
import org.pentaho.di.trans.steps.injector.InjectorMeta;
import org.pentaho.di.trans.steps.valuemapper.ValueMapperMeta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueMapperTest
extends TestCase {
    public RowMetaInterface createRowMetaInterface() {
        RowMeta rm = new RowMeta();
        ValueMetaInterface[] valuesMeta = new ValueMetaInterface[]{new ValueMeta("field1", 2)};
        for (int i = 0; i < valuesMeta.length; ++i) {
            rm.addValueMeta(valuesMeta[i]);
        }
        return rm;
    }

    public List<RowMetaAndData> createData() {
        ArrayList<RowMetaAndData> list = new ArrayList<RowMetaAndData>();
        RowMetaInterface rm = this.createRowMetaInterface();
        Object[] r1 = new Object[]{"abc"};
        Object[] r2 = new Object[]{"ABC"};
        Object[] r3 = new Object[]{"def"};
        Object[] r4 = new Object[]{"def"};
        Object[] r5 = new Object[]{"ghij"};
        Object[] r6 = new Object[]{"zzz"};
        Object[] r7 = new Object[]{""};
        Object[] r8 = new Object[]{null};
        Object[] r9 = new Object[]{"abc"};
        list.add(new RowMetaAndData(rm, r1));
        list.add(new RowMetaAndData(rm, r2));
        list.add(new RowMetaAndData(rm, r3));
        list.add(new RowMetaAndData(rm, r4));
        list.add(new RowMetaAndData(rm, r5));
        list.add(new RowMetaAndData(rm, r6));
        list.add(new RowMetaAndData(rm, r7));
        list.add(new RowMetaAndData(rm, r8));
        list.add(new RowMetaAndData(rm, r9));
        return list;
    }

    public RowMetaInterface createRowMetaInterface1() {
        RowMeta rm = new RowMeta();
        ValueMetaInterface[] valuesMeta = new ValueMetaInterface[]{new ValueMeta("field1", 2), new ValueMeta("new_field", 2)};
        for (int i = 0; i < valuesMeta.length; ++i) {
            rm.addValueMeta(valuesMeta[i]);
        }
        return rm;
    }

    public List<RowMetaAndData> createResultData1() {
        ArrayList<RowMetaAndData> list = new ArrayList<RowMetaAndData>();
        RowMetaInterface rm = this.createRowMetaInterface1();
        Object[] r1 = new Object[]{"abc", "begin"};
        Object[] r2 = new Object[]{"ABC", "BEG_LONGER"};
        Object[] r3 = new Object[]{"def", "test"};
        Object[] r4 = new Object[]{"def", "test"};
        Object[] r5 = new Object[]{"ghij", null};
        Object[] r6 = new Object[]{"zzz", null};
        Object[] r7 = new Object[]{"", null};
        Object[] r8 = new Object[]{null, null};
        Object[] r9 = new Object[]{"abc", "begin"};
        list.add(new RowMetaAndData(rm, r1));
        list.add(new RowMetaAndData(rm, r2));
        list.add(new RowMetaAndData(rm, r3));
        list.add(new RowMetaAndData(rm, r4));
        list.add(new RowMetaAndData(rm, r5));
        list.add(new RowMetaAndData(rm, r6));
        list.add(new RowMetaAndData(rm, r7));
        list.add(new RowMetaAndData(rm, r8));
        list.add(new RowMetaAndData(rm, r9));
        return list;
    }

    public List<RowMetaAndData> createResultData2() {
        ArrayList<RowMetaAndData> list = new ArrayList<RowMetaAndData>();
        RowMetaInterface rm = this.createRowMetaInterface();
        Object[] r1 = new Object[]{"begin"};
        Object[] r2 = new Object[]{"BEG_LONGER"};
        Object[] r3 = new Object[]{"test"};
        Object[] r4 = new Object[]{"test"};
        Object[] r5 = new Object[]{null};
        Object[] r6 = new Object[]{"zzz"};
        Object[] r7 = new Object[]{null};
        Object[] r8 = new Object[]{null};
        Object[] r9 = new Object[]{"begin"};
        list.add(new RowMetaAndData(rm, r1));
        list.add(new RowMetaAndData(rm, r2));
        list.add(new RowMetaAndData(rm, r3));
        list.add(new RowMetaAndData(rm, r4));
        list.add(new RowMetaAndData(rm, r5));
        list.add(new RowMetaAndData(rm, r6));
        list.add(new RowMetaAndData(rm, r7));
        list.add(new RowMetaAndData(rm, r8));
        list.add(new RowMetaAndData(rm, r9));
        return list;
    }

    public List<RowMetaAndData> createResultData3() {
        ArrayList<RowMetaAndData> list = new ArrayList<RowMetaAndData>();
        RowMetaInterface rm = this.createRowMetaInterface();
        Object[] r1 = new Object[]{"begin"};
        Object[] r2 = new Object[]{"BEG_LONGER"};
        Object[] r3 = new Object[]{"test"};
        Object[] r4 = new Object[]{"test"};
        Object[] r5 = new Object[]{null};
        Object[] r6 = new Object[]{"zzz"};
        Object[] r7 = new Object[]{"emptyField"};
        Object[] r8 = new Object[]{"emptyField"};
        Object[] r9 = new Object[]{"begin"};
        list.add(new RowMetaAndData(rm, r1));
        list.add(new RowMetaAndData(rm, r2));
        list.add(new RowMetaAndData(rm, r3));
        list.add(new RowMetaAndData(rm, r4));
        list.add(new RowMetaAndData(rm, r5));
        list.add(new RowMetaAndData(rm, r6));
        list.add(new RowMetaAndData(rm, r7));
        list.add(new RowMetaAndData(rm, r8));
        list.add(new RowMetaAndData(rm, r9));
        return list;
    }

    public List<RowMetaAndData> createResultData4() {
        ArrayList<RowMetaAndData> list = new ArrayList<RowMetaAndData>();
        RowMetaInterface rm = this.createRowMetaInterface1();
        Object[] r1 = new Object[]{"abc", "begin"};
        Object[] r2 = new Object[]{"ABC", "BEG_LONGER"};
        Object[] r3 = new Object[]{"def", "test"};
        Object[] r4 = new Object[]{"def", "test"};
        Object[] r5 = new Object[]{"ghij", null};
        Object[] r6 = new Object[]{"zzz", "default"};
        Object[] r7 = new Object[]{"", null};
        Object[] r8 = new Object[]{null, null};
        Object[] r9 = new Object[]{"abc", "begin"};
        list.add(new RowMetaAndData(rm, r1));
        list.add(new RowMetaAndData(rm, r2));
        list.add(new RowMetaAndData(rm, r3));
        list.add(new RowMetaAndData(rm, r4));
        list.add(new RowMetaAndData(rm, r5));
        list.add(new RowMetaAndData(rm, r6));
        list.add(new RowMetaAndData(rm, r7));
        list.add(new RowMetaAndData(rm, r8));
        list.add(new RowMetaAndData(rm, r9));
        return list;
    }

    public List<RowMetaAndData> createResultData5() {
        ArrayList<RowMetaAndData> list = new ArrayList<RowMetaAndData>();
        RowMetaInterface rm = this.createRowMetaInterface();
        Object[] r1 = new Object[]{"begin"};
        Object[] r2 = new Object[]{"BEG_LONGER"};
        Object[] r3 = new Object[]{"test"};
        Object[] r4 = new Object[]{"test"};
        Object[] r5 = new Object[]{null};
        Object[] r6 = new Object[]{"default"};
        Object[] r7 = new Object[]{null};
        Object[] r8 = new Object[]{null};
        Object[] r9 = new Object[]{"begin"};
        list.add(new RowMetaAndData(rm, r1));
        list.add(new RowMetaAndData(rm, r2));
        list.add(new RowMetaAndData(rm, r3));
        list.add(new RowMetaAndData(rm, r4));
        list.add(new RowMetaAndData(rm, r5));
        list.add(new RowMetaAndData(rm, r6));
        list.add(new RowMetaAndData(rm, r7));
        list.add(new RowMetaAndData(rm, r8));
        list.add(new RowMetaAndData(rm, r9));
        return list;
    }

    public List<RowMetaAndData> createResultData6() {
        ArrayList<RowMetaAndData> list = new ArrayList<RowMetaAndData>();
        RowMetaInterface rm = this.createRowMetaInterface();
        Object[] r1 = new Object[]{"begin"};
        Object[] r2 = new Object[]{"BEG_LONGER"};
        Object[] r3 = new Object[]{"test"};
        Object[] r4 = new Object[]{"test"};
        Object[] r5 = new Object[]{"default"};
        Object[] r6 = new Object[]{"default"};
        Object[] r7 = new Object[]{"emptyField"};
        Object[] r8 = new Object[]{"emptyField"};
        Object[] r9 = new Object[]{"begin"};
        list.add(new RowMetaAndData(rm, r1));
        list.add(new RowMetaAndData(rm, r2));
        list.add(new RowMetaAndData(rm, r3));
        list.add(new RowMetaAndData(rm, r4));
        list.add(new RowMetaAndData(rm, r5));
        list.add(new RowMetaAndData(rm, r6));
        list.add(new RowMetaAndData(rm, r7));
        list.add(new RowMetaAndData(rm, r8));
        list.add(new RowMetaAndData(rm, r9));
        return list;
    }

    public void checkRows(List<RowMetaAndData> rows1, List<RowMetaAndData> rows2) {
        int idx = 1;
        if (rows1.size() != rows2.size()) {
            ValueMapperTest.fail((String)("Number of rows is not the same: " + rows1.size() + " and " + rows2.size()));
        }
        Iterator<RowMetaAndData> it1 = rows1.iterator();
        Iterator<RowMetaAndData> it2 = rows2.iterator();
        while (it1.hasNext() && it2.hasNext()) {
            RowMetaAndData rm1 = it1.next();
            RowMetaAndData rm2 = it2.next();
            Object[] r1 = rm1.getData();
            Object[] r2 = rm2.getData();
            if (rm1.size() != rm2.size()) {
                ValueMapperTest.fail((String)("row nr " + idx + " is not equal"));
            }
            int[] fields = new int[r1.length];
            for (int ydx = 0; ydx < r1.length; ++ydx) {
                fields[ydx] = ydx;
            }
            try {
                if (rm1.getRowMeta().compare(r1, r2, fields) != 0) {
                    ValueMapperTest.fail((String)("row nr " + idx + " is not equal"));
                }
            }
            catch (KettleValueException e) {
                ValueMapperTest.fail((String)("row nr " + idx + " is not equal"));
            }
            ++idx;
        }
    }

    public void testValueMapper1() throws Exception {
        KettleEnvironment.init();
        TransMeta transMeta = new TransMeta();
        transMeta.setName("valuemappertest1");
        PluginRegistry registry = PluginRegistry.getInstance();
        String injectorStepname = "injector step";
        InjectorMeta im = new InjectorMeta();
        String injectorPid = registry.getPluginId(StepPluginType.class, (Object)im);
        StepMeta injectorStep = new StepMeta(injectorPid, injectorStepname, (StepMetaInterface)im);
        transMeta.addStep(injectorStep);
        String dummyStepname1 = "dummy step 1";
        DummyTransMeta dm1 = new DummyTransMeta();
        String dummyPid1 = registry.getPluginId(StepPluginType.class, (Object)dm1);
        StepMeta dummyStep1 = new StepMeta(dummyPid1, dummyStepname1, (StepMetaInterface)dm1);
        transMeta.addStep(dummyStep1);
        TransHopMeta hi = new TransHopMeta(injectorStep, dummyStep1);
        transMeta.addTransHop(hi);
        String valueMapperName = "valuemapper step";
        ValueMapperMeta vm = new ValueMapperMeta();
        vm.setFieldToUse("field1");
        vm.setTargetField("new_field");
        vm.setSourceValue(new String[]{"abc", "ABC", "def", "ghij"});
        vm.setTargetValue(new String[]{"begin", "BEG_LONGER", "test", ""});
        String valueMapperPid = registry.getPluginId(StepPluginType.class, (Object)vm);
        StepMeta valueMapperStep = new StepMeta(valueMapperPid, valueMapperName, (StepMetaInterface)vm);
        transMeta.addStep(valueMapperStep);
        TransHopMeta hi2 = new TransHopMeta(dummyStep1, valueMapperStep);
        transMeta.addTransHop(hi2);
        String dummyStepname2 = "dummy step 2";
        DummyTransMeta dm2 = new DummyTransMeta();
        String dummyPid2 = registry.getPluginId(StepPluginType.class, (Object)dm2);
        StepMeta dummyStep2 = new StepMeta(dummyPid2, dummyStepname2, (StepMetaInterface)dm2);
        transMeta.addStep(dummyStep2);
        TransHopMeta hi3 = new TransHopMeta(valueMapperStep, dummyStep2);
        transMeta.addTransHop(hi3);
        Trans trans = new Trans(transMeta);
        trans.prepareExecution(null);
        StepInterface si = trans.getStepInterface(dummyStepname1, 0);
        RowStepCollector dummyRc1 = new RowStepCollector();
        si.addRowListener((RowListener)dummyRc1);
        si = trans.getStepInterface(valueMapperName, 0);
        RowStepCollector valueMapperRc = new RowStepCollector();
        si.addRowListener((RowListener)valueMapperRc);
        si = trans.getStepInterface(dummyStepname2, 0);
        RowStepCollector dummyRc = new RowStepCollector();
        si.addRowListener((RowListener)dummyRc);
        RowProducer rp = trans.addRowProducer(injectorStepname, 0);
        trans.startThreads();
        List<RowMetaAndData> inputList = this.createData();
        for (RowMetaAndData rm : inputList) {
            rp.putRow(rm.getRowMeta(), rm.getData());
        }
        rp.finished();
        trans.waitUntilFinished();
        List<RowMetaAndData> resultRows = dummyRc.getRowsWritten();
        List<RowMetaAndData> goldenImageRows = this.createResultData1();
        this.checkRows(goldenImageRows, resultRows);
    }

    public void testValueMapper2() throws Exception {
        KettleEnvironment.init();
        TransMeta transMeta = new TransMeta();
        transMeta.setName("valuemappertest2");
        PluginRegistry registry = PluginRegistry.getInstance();
        String injectorStepname = "injector step";
        InjectorMeta im = new InjectorMeta();
        String injectorPid = registry.getPluginId(StepPluginType.class, (Object)im);
        StepMeta injectorStep = new StepMeta(injectorPid, injectorStepname, (StepMetaInterface)im);
        transMeta.addStep(injectorStep);
        String dummyStepname1 = "dummy step 1";
        DummyTransMeta dm1 = new DummyTransMeta();
        String dummyPid1 = registry.getPluginId(StepPluginType.class, (Object)dm1);
        StepMeta dummyStep1 = new StepMeta(dummyPid1, dummyStepname1, (StepMetaInterface)dm1);
        transMeta.addStep(dummyStep1);
        TransHopMeta hi = new TransHopMeta(injectorStep, dummyStep1);
        transMeta.addTransHop(hi);
        String valueMapperName = "valuemapper step";
        ValueMapperMeta vm = new ValueMapperMeta();
        vm.setFieldToUse("field1");
        vm.setTargetField("");
        vm.setSourceValue(new String[]{"abc", "ABC", "def", "ghij"});
        vm.setTargetValue(new String[]{"begin", "BEG_LONGER", "test", ""});
        String valueMapperPid = registry.getPluginId(StepPluginType.class, (Object)vm);
        StepMeta valueMapperStep = new StepMeta(valueMapperPid, valueMapperName, (StepMetaInterface)vm);
        transMeta.addStep(valueMapperStep);
        TransHopMeta hi2 = new TransHopMeta(dummyStep1, valueMapperStep);
        transMeta.addTransHop(hi2);
        String dummyStepname2 = "dummy step 2";
        DummyTransMeta dm2 = new DummyTransMeta();
        String dummyPid2 = registry.getPluginId(StepPluginType.class, (Object)dm2);
        StepMeta dummyStep2 = new StepMeta(dummyPid2, dummyStepname2, (StepMetaInterface)dm2);
        transMeta.addStep(dummyStep2);
        TransHopMeta hi3 = new TransHopMeta(valueMapperStep, dummyStep2);
        transMeta.addTransHop(hi3);
        Trans trans = new Trans(transMeta);
        trans.prepareExecution(null);
        StepInterface si = trans.getStepInterface(dummyStepname1, 0);
        RowStepCollector dummyRc1 = new RowStepCollector();
        si.addRowListener((RowListener)dummyRc1);
        si = trans.getStepInterface(valueMapperName, 0);
        RowStepCollector valueMapperRc = new RowStepCollector();
        si.addRowListener((RowListener)valueMapperRc);
        si = trans.getStepInterface(dummyStepname2, 0);
        RowStepCollector dummyRc = new RowStepCollector();
        si.addRowListener((RowListener)dummyRc);
        RowProducer rp = trans.addRowProducer(injectorStepname, 0);
        trans.startThreads();
        List<RowMetaAndData> inputList = this.createData();
        for (RowMetaAndData rm : inputList) {
            rp.putRow(rm.getRowMeta(), rm.getData());
        }
        rp.finished();
        trans.waitUntilFinished();
        List<RowMetaAndData> resultRows = dummyRc.getRowsWritten();
        List<RowMetaAndData> goldenImageRows = this.createResultData2();
        this.checkRows(goldenImageRows, resultRows);
    }

    public void testValueMapper3() throws Exception {
        KettleEnvironment.init();
        TransMeta transMeta = new TransMeta();
        transMeta.setName("valuemappertest3");
        PluginRegistry registry = PluginRegistry.getInstance();
        String injectorStepname = "injector step";
        InjectorMeta im = new InjectorMeta();
        String injectorPid = registry.getPluginId(StepPluginType.class, (Object)im);
        StepMeta injectorStep = new StepMeta(injectorPid, injectorStepname, (StepMetaInterface)im);
        transMeta.addStep(injectorStep);
        String dummyStepname1 = "dummy step 1";
        DummyTransMeta dm1 = new DummyTransMeta();
        String dummyPid1 = registry.getPluginId(StepPluginType.class, (Object)dm1);
        StepMeta dummyStep1 = new StepMeta(dummyPid1, dummyStepname1, (StepMetaInterface)dm1);
        transMeta.addStep(dummyStep1);
        TransHopMeta hi = new TransHopMeta(injectorStep, dummyStep1);
        transMeta.addTransHop(hi);
        String valueMapperName = "valuemapper step";
        ValueMapperMeta vm = new ValueMapperMeta();
        vm.setFieldToUse("field1");
        vm.setTargetField("");
        vm.setSourceValue(new String[]{"abc", "ABC", "def", "ghij", null});
        vm.setTargetValue(new String[]{"begin", "BEG_LONGER", "test", "", "emptyField"});
        String valueMapperPid = registry.getPluginId(StepPluginType.class, (Object)vm);
        StepMeta valueMapperStep = new StepMeta(valueMapperPid, valueMapperName, (StepMetaInterface)vm);
        transMeta.addStep(valueMapperStep);
        TransHopMeta hi2 = new TransHopMeta(dummyStep1, valueMapperStep);
        transMeta.addTransHop(hi2);
        String dummyStepname2 = "dummy step 2";
        DummyTransMeta dm2 = new DummyTransMeta();
        String dummyPid2 = registry.getPluginId(StepPluginType.class, (Object)dm2);
        StepMeta dummyStep2 = new StepMeta(dummyPid2, dummyStepname2, (StepMetaInterface)dm2);
        transMeta.addStep(dummyStep2);
        TransHopMeta hi3 = new TransHopMeta(valueMapperStep, dummyStep2);
        transMeta.addTransHop(hi3);
        Trans trans = new Trans(transMeta);
        trans.prepareExecution(null);
        StepInterface si = trans.getStepInterface(dummyStepname1, 0);
        RowStepCollector dummyRc1 = new RowStepCollector();
        si.addRowListener((RowListener)dummyRc1);
        si = trans.getStepInterface(valueMapperName, 0);
        RowStepCollector valueMapperRc = new RowStepCollector();
        si.addRowListener((RowListener)valueMapperRc);
        si = trans.getStepInterface(dummyStepname2, 0);
        RowStepCollector dummyRc = new RowStepCollector();
        si.addRowListener((RowListener)dummyRc);
        RowProducer rp = trans.addRowProducer(injectorStepname, 0);
        trans.startThreads();
        List<RowMetaAndData> inputList = this.createData();
        for (RowMetaAndData rm : inputList) {
            rp.putRow(rm.getRowMeta(), rm.getData());
        }
        rp.finished();
        trans.waitUntilFinished();
        List<RowMetaAndData> resultRows = dummyRc.getRowsWritten();
        List<RowMetaAndData> goldenImageRows = this.createResultData3();
        this.checkRows(goldenImageRows, resultRows);
    }

    public void testValueMapper4() throws Exception {
        KettleEnvironment.init();
        TransMeta transMeta = new TransMeta();
        transMeta.setName("valuemappertest4");
        PluginRegistry registry = PluginRegistry.getInstance();
        String injectorStepname = "injector step";
        InjectorMeta im = new InjectorMeta();
        String injectorPid = registry.getPluginId(StepPluginType.class, (Object)im);
        StepMeta injectorStep = new StepMeta(injectorPid, injectorStepname, (StepMetaInterface)im);
        transMeta.addStep(injectorStep);
        String dummyStepname1 = "dummy step 1";
        DummyTransMeta dm1 = new DummyTransMeta();
        String dummyPid1 = registry.getPluginId(StepPluginType.class, (Object)dm1);
        StepMeta dummyStep1 = new StepMeta(dummyPid1, dummyStepname1, (StepMetaInterface)dm1);
        transMeta.addStep(dummyStep1);
        TransHopMeta hi = new TransHopMeta(injectorStep, dummyStep1);
        transMeta.addTransHop(hi);
        String valueMapperName = "valuemapper step";
        ValueMapperMeta vm = new ValueMapperMeta();
        vm.setFieldToUse("field1");
        vm.setTargetField("new_field");
        vm.setNonMatchDefault("default");
        vm.setSourceValue(new String[]{"abc", "ABC", "def", "ghij"});
        vm.setTargetValue(new String[]{"begin", "BEG_LONGER", "test", ""});
        String valueMapperPid = registry.getPluginId(StepPluginType.class, (Object)vm);
        StepMeta valueMapperStep = new StepMeta(valueMapperPid, valueMapperName, (StepMetaInterface)vm);
        transMeta.addStep(valueMapperStep);
        TransHopMeta hi2 = new TransHopMeta(dummyStep1, valueMapperStep);
        transMeta.addTransHop(hi2);
        String dummyStepname2 = "dummy step 2";
        DummyTransMeta dm2 = new DummyTransMeta();
        String dummyPid2 = registry.getPluginId(StepPluginType.class, (Object)dm2);
        StepMeta dummyStep2 = new StepMeta(dummyPid2, dummyStepname2, (StepMetaInterface)dm2);
        transMeta.addStep(dummyStep2);
        TransHopMeta hi3 = new TransHopMeta(valueMapperStep, dummyStep2);
        transMeta.addTransHop(hi3);
        Trans trans = new Trans(transMeta);
        trans.prepareExecution(null);
        StepInterface si = trans.getStepInterface(dummyStepname1, 0);
        RowStepCollector dummyRc1 = new RowStepCollector();
        si.addRowListener((RowListener)dummyRc1);
        si = trans.getStepInterface(valueMapperName, 0);
        RowStepCollector valueMapperRc = new RowStepCollector();
        si.addRowListener((RowListener)valueMapperRc);
        si = trans.getStepInterface(dummyStepname2, 0);
        RowStepCollector dummyRc = new RowStepCollector();
        si.addRowListener((RowListener)dummyRc);
        RowProducer rp = trans.addRowProducer(injectorStepname, 0);
        trans.startThreads();
        List<RowMetaAndData> inputList = this.createData();
        for (RowMetaAndData rm : inputList) {
            rp.putRow(rm.getRowMeta(), rm.getData());
        }
        rp.finished();
        trans.waitUntilFinished();
        List<RowMetaAndData> resultRows = dummyRc.getRowsWritten();
        List<RowMetaAndData> goldenImageRows = this.createResultData4();
        this.checkRows(goldenImageRows, resultRows);
    }

    public void testValueMapper5() throws Exception {
        KettleEnvironment.init();
        TransMeta transMeta = new TransMeta();
        transMeta.setName("valuemappertest5");
        PluginRegistry registry = PluginRegistry.getInstance();
        String injectorStepname = "injector step";
        InjectorMeta im = new InjectorMeta();
        String injectorPid = registry.getPluginId(StepPluginType.class, (Object)im);
        StepMeta injectorStep = new StepMeta(injectorPid, injectorStepname, (StepMetaInterface)im);
        transMeta.addStep(injectorStep);
        String dummyStepname1 = "dummy step 1";
        DummyTransMeta dm1 = new DummyTransMeta();
        String dummyPid1 = registry.getPluginId(StepPluginType.class, (Object)dm1);
        StepMeta dummyStep1 = new StepMeta(dummyPid1, dummyStepname1, (StepMetaInterface)dm1);
        transMeta.addStep(dummyStep1);
        TransHopMeta hi = new TransHopMeta(injectorStep, dummyStep1);
        transMeta.addTransHop(hi);
        String valueMapperName = "valuemapper step";
        ValueMapperMeta vm = new ValueMapperMeta();
        vm.setFieldToUse("field1");
        vm.setTargetField("");
        vm.setNonMatchDefault("default");
        vm.setSourceValue(new String[]{"abc", "ABC", "def", "ghij"});
        vm.setTargetValue(new String[]{"begin", "BEG_LONGER", "test", ""});
        String valueMapperPid = registry.getPluginId(StepPluginType.class, (Object)vm);
        StepMeta valueMapperStep = new StepMeta(valueMapperPid, valueMapperName, (StepMetaInterface)vm);
        transMeta.addStep(valueMapperStep);
        TransHopMeta hi2 = new TransHopMeta(dummyStep1, valueMapperStep);
        transMeta.addTransHop(hi2);
        String dummyStepname2 = "dummy step 2";
        DummyTransMeta dm2 = new DummyTransMeta();
        String dummyPid2 = registry.getPluginId(StepPluginType.class, (Object)dm2);
        StepMeta dummyStep2 = new StepMeta(dummyPid2, dummyStepname2, (StepMetaInterface)dm2);
        transMeta.addStep(dummyStep2);
        TransHopMeta hi3 = new TransHopMeta(valueMapperStep, dummyStep2);
        transMeta.addTransHop(hi3);
        Trans trans = new Trans(transMeta);
        trans.prepareExecution(null);
        StepInterface si = trans.getStepInterface(dummyStepname1, 0);
        RowStepCollector dummyRc1 = new RowStepCollector();
        si.addRowListener((RowListener)dummyRc1);
        si = trans.getStepInterface(valueMapperName, 0);
        RowStepCollector valueMapperRc = new RowStepCollector();
        si.addRowListener((RowListener)valueMapperRc);
        si = trans.getStepInterface(dummyStepname2, 0);
        RowStepCollector dummyRc = new RowStepCollector();
        si.addRowListener((RowListener)dummyRc);
        RowProducer rp = trans.addRowProducer(injectorStepname, 0);
        trans.startThreads();
        List<RowMetaAndData> inputList = this.createData();
        for (RowMetaAndData rm : inputList) {
            rp.putRow(rm.getRowMeta(), rm.getData());
        }
        rp.finished();
        trans.waitUntilFinished();
        List<RowMetaAndData> resultRows = dummyRc.getRowsWritten();
        List<RowMetaAndData> goldenImageRows = this.createResultData5();
        this.checkRows(goldenImageRows, resultRows);
    }

    public void testValueMapper6() throws Exception {
        boolean prepare;
        KettleEnvironment.init();
        TransMeta transMeta = new TransMeta();
        transMeta.setName("valuemappertest6");
        PluginRegistry registry = PluginRegistry.getInstance();
        String injectorStepname = "injector step";
        InjectorMeta im = new InjectorMeta();
        String injectorPid = registry.getPluginId(StepPluginType.class, (Object)im);
        StepMeta injectorStep = new StepMeta(injectorPid, injectorStepname, (StepMetaInterface)im);
        transMeta.addStep(injectorStep);
        String dummyStepname1 = "dummy step 1";
        DummyTransMeta dm1 = new DummyTransMeta();
        String dummyPid1 = registry.getPluginId(StepPluginType.class, (Object)dm1);
        StepMeta dummyStep1 = new StepMeta(dummyPid1, dummyStepname1, (StepMetaInterface)dm1);
        transMeta.addStep(dummyStep1);
        TransHopMeta hi = new TransHopMeta(injectorStep, dummyStep1);
        transMeta.addTransHop(hi);
        String valueMapperName = "valuemapper step";
        ValueMapperMeta vm = new ValueMapperMeta();
        vm.setFieldToUse("field1");
        vm.setTargetField("");
        vm.setNonMatchDefault("default");
        vm.setSourceValue(new String[]{"abc", "ABC", "def", "ghijk", null});
        vm.setTargetValue(new String[]{"begin", "BEG_LONGER", "test", "blah", "emptyField"});
        String valueMapperPid = registry.getPluginId(StepPluginType.class, (Object)vm);
        StepMeta valueMapperStep = new StepMeta(valueMapperPid, valueMapperName, (StepMetaInterface)vm);
        transMeta.addStep(valueMapperStep);
        TransHopMeta hi2 = new TransHopMeta(dummyStep1, valueMapperStep);
        transMeta.addTransHop(hi2);
        String dummyStepname2 = "dummy step 2";
        DummyTransMeta dm2 = new DummyTransMeta();
        String dummyPid2 = registry.getPluginId(StepPluginType.class, (Object)dm2);
        StepMeta dummyStep2 = new StepMeta(dummyPid2, dummyStepname2, (StepMetaInterface)dm2);
        transMeta.addStep(dummyStep2);
        TransHopMeta hi3 = new TransHopMeta(valueMapperStep, dummyStep2);
        transMeta.addTransHop(hi3);
        Trans trans = new Trans(transMeta);
        try {
            trans.prepareExecution(null);
            prepare = true;
        }
        catch (KettleException e) {
            prepare = false;
        }
        ValueMapperTest.assertTrue((boolean)prepare);
        StepInterface si = trans.getStepInterface(dummyStepname1, 0);
        RowStepCollector dummyRc1 = new RowStepCollector();
        si.addRowListener((RowListener)dummyRc1);
        si = trans.getStepInterface(valueMapperName, 0);
        RowStepCollector valueMapperRc = new RowStepCollector();
        si.addRowListener((RowListener)valueMapperRc);
        si = trans.getStepInterface(dummyStepname2, 0);
        RowStepCollector dummyRc = new RowStepCollector();
        si.addRowListener((RowListener)dummyRc);
        RowProducer rp = trans.addRowProducer(injectorStepname, 0);
        trans.startThreads();
        List<RowMetaAndData> inputList = this.createData();
        for (RowMetaAndData rm : inputList) {
            rp.putRow(rm.getRowMeta(), rm.getData());
        }
        rp.finished();
        trans.waitUntilFinished();
        List<RowMetaAndData> resultRows = dummyRc.getRowsWritten();
        List<RowMetaAndData> goldenImageRows = this.createResultData6();
        this.checkRows(goldenImageRows, resultRows);
    }
}

