/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.xslt;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.StepPluginType;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.trans.RowProducer;
import org.pentaho.di.trans.RowStepCollector;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransHopMeta;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.RowListener;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.dummytrans.DummyTransMeta;
import org.pentaho.di.trans.steps.injector.InjectorMeta;
import org.pentaho.di.trans.steps.textfileinput.TextFileInputField;
import org.pentaho.di.trans.steps.xslt.XsltMeta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XsltTest
extends TestCase {
    private static final String TEST1_XML = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><message>Yep, it worked!</message>";
    private static final String TEST1_XSL = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><xsl:stylesheet version = \"1.0\" xmlns:xsl = \"http://www.w3.org/1999/XSL/Transform\"><xsl:output method = \"text\" encoding = \"UTF-8\"/><!--simply copy the message to the result tree --><xsl:template match = \"/\"><xsl:value-of select = \"message\"/></xsl:template></xsl:stylesheet>";
    private static final String TEST1_FNAME = "template.xsl";

    public String writeInputFile() throws IOException {
        String rcode = null;
        File tempFile = File.createTempFile("template", ".xsl");
        tempFile.deleteOnExit();
        rcode = tempFile.getAbsolutePath();
        FileWriter fout = new FileWriter(tempFile);
        fout.write(TEST1_XSL);
        fout.close();
        return rcode;
    }

    public RowMetaInterface createRowMetaInterface() {
        RowMeta rm = new RowMeta();
        ValueMetaInterface[] valuesMeta = new ValueMetaInterface[]{new ValueMeta("XML", 2), new ValueMeta("XSL", 2), new ValueMeta("filename", 2)};
        for (int i = 0; i < valuesMeta.length; ++i) {
            rm.addValueMeta(valuesMeta[i]);
        }
        return rm;
    }

    public List<RowMetaAndData> createData(String fileName) {
        ArrayList<RowMetaAndData> list = new ArrayList<RowMetaAndData>();
        RowMetaInterface rm = this.createRowMetaInterface();
        Object[] r1 = new Object[]{TEST1_XML, TEST1_XSL, fileName};
        list.add(new RowMetaAndData(rm, r1));
        return list;
    }

    public RowMetaInterface createResultRowMetaInterface() {
        RowMeta rm = new RowMeta();
        ValueMetaInterface[] valuesMeta = new ValueMetaInterface[]{new ValueMeta("XML", 2), new ValueMeta("XSL", 2), new ValueMeta("filename", 2), new ValueMeta("result", 2)};
        for (int i = 0; i < valuesMeta.length; ++i) {
            rm.addValueMeta(valuesMeta[i]);
        }
        return rm;
    }

    public List<RowMetaAndData> createResultData1() {
        ArrayList<RowMetaAndData> list = new ArrayList<RowMetaAndData>();
        RowMetaInterface rm = this.createResultRowMetaInterface();
        Object[] r1 = new Object[]{TEST1_XML, TEST1_XSL, TEST1_FNAME, "Yep, it worked!"};
        list.add(new RowMetaAndData(rm, r1));
        return list;
    }

    public void checkRows(List<RowMetaAndData> rows1, List<RowMetaAndData> rows2, int fileNameColumn) {
        int idx = 1;
        if (rows1.size() != rows2.size()) {
            XsltTest.fail((String)("Number of rows is not the same: " + rows1.size() + " and " + rows2.size()));
        }
        Iterator<RowMetaAndData> it1 = rows1.iterator();
        Iterator<RowMetaAndData> it2 = rows2.iterator();
        while (it1.hasNext() && it2.hasNext()) {
            RowMetaAndData rm1 = it1.next();
            RowMetaAndData rm2 = it2.next();
            Object[] r1 = rm1.getData();
            Object[] r2 = rm2.getData();
            if (rm1.size() != rm2.size()) {
                XsltTest.fail((String)("row nr " + idx + " is not equal"));
            }
            int[] fields = new int[r1.length];
            for (int ydx = 0; ydx < r1.length; ++ydx) {
                fields[ydx] = ydx;
            }
            try {
                r1[fileNameColumn] = r2[fileNameColumn];
                if (rm1.getRowMeta().compare(r1, r2, fields) != 0) {
                    XsltTest.fail((String)("row nr " + idx + " is not equal"));
                }
            }
            catch (KettleValueException e) {
                XsltTest.fail((String)("row nr " + idx + " is not equal"));
            }
            ++idx;
        }
    }

    public void testXslt1() throws Exception {
        String fileName = this.writeInputFile();
        this.runTestWithParams("XML", "result", true, true, "filename", fileName, "JAXP");
    }

    public void testXslt2() throws Exception {
        String fileName = this.writeInputFile();
        this.runTestWithParams("XML", "result", true, true, "filename", fileName, "SAXON");
    }

    public void testXslt3() throws Exception {
        this.runTestWithParams("XML", "result", true, false, "XSL", "", "JAXP");
    }

    public void testXslt4() throws Exception {
        this.runTestWithParams("XML", "result", true, false, "XSL", "", "SAXON");
    }

    public void testXslt5() throws Exception {
        String fileName = this.writeInputFile();
        this.runTestWithParams("XML", "result", false, false, "filename", fileName, "JAXP");
    }

    public void testXslt6() throws Exception {
        String fileName = this.writeInputFile();
        this.runTestWithParams("XML", "result", false, false, "filename", fileName, "SAXON");
    }

    public void runTestWithParams(String xmlFieldname, String resultFieldname, boolean xslInField, boolean xslFileInField, String xslFileField, String xslFilename, String xslFactory) throws Exception {
        KettleEnvironment.init();
        TransMeta transMeta = new TransMeta();
        transMeta.setName("xslt");
        PluginRegistry registry = PluginRegistry.getInstance();
        String injectorStepname = "injector step";
        InjectorMeta im = new InjectorMeta();
        String injectorPid = registry.getPluginId(StepPluginType.class, (Object)im);
        StepMeta injectorStep = new StepMeta(injectorPid, injectorStepname, (StepMetaInterface)im);
        transMeta.addStep(injectorStep);
        String xsltName = "xslt step";
        XsltMeta xm = new XsltMeta();
        String xsltPid = registry.getPluginId(StepPluginType.class, (Object)xm);
        StepMeta xsltStep = new StepMeta(xsltPid, xsltName, (StepMetaInterface)xm);
        transMeta.addStep(xsltStep);
        TextFileInputField[] fields = new TextFileInputField[3];
        for (int idx = 0; idx < fields.length; ++idx) {
            fields[idx] = new TextFileInputField();
        }
        fields[0].setName("XML");
        fields[0].setType(2);
        fields[0].setFormat("");
        fields[0].setLength(-1);
        fields[0].setPrecision(-1);
        fields[0].setCurrencySymbol("");
        fields[0].setDecimalSymbol("");
        fields[0].setGroupSymbol("");
        fields[0].setTrimType(0);
        fields[1].setName("XSL");
        fields[1].setType(2);
        fields[1].setFormat("");
        fields[1].setLength(-1);
        fields[1].setPrecision(-1);
        fields[1].setCurrencySymbol("");
        fields[1].setDecimalSymbol("");
        fields[1].setGroupSymbol("");
        fields[1].setTrimType(0);
        fields[2].setName("filename");
        fields[2].setType(2);
        fields[2].setFormat("");
        fields[2].setLength(-1);
        fields[2].setPrecision(-1);
        fields[2].setCurrencySymbol("");
        fields[2].setDecimalSymbol("");
        fields[2].setGroupSymbol("");
        fields[2].setTrimType(0);
        xm.setFieldname(xmlFieldname);
        xm.setResultfieldname(resultFieldname);
        xm.setXSLField(xslInField);
        xm.setXSLFileField(xslFileField);
        xm.setXSLFieldIsAFile(xslFileInField);
        xm.setXslFilename(xslFilename);
        xm.setXSLFactory(xslFactory);
        TransHopMeta hi = new TransHopMeta(injectorStep, xsltStep);
        transMeta.addTransHop(hi);
        String dummyStepname1 = "dummy step 1";
        DummyTransMeta dm1 = new DummyTransMeta();
        String dummyPid1 = registry.getPluginId(StepPluginType.class, (Object)dm1);
        StepMeta dummyStep1 = new StepMeta(dummyPid1, dummyStepname1, (StepMetaInterface)dm1);
        transMeta.addStep(dummyStep1);
        TransHopMeta hi1 = new TransHopMeta(xsltStep, dummyStep1);
        transMeta.addTransHop(hi1);
        Trans trans = new Trans(transMeta);
        trans.prepareExecution(null);
        StepInterface si = trans.getStepInterface(dummyStepname1, 0);
        RowStepCollector dummyRc1 = new RowStepCollector();
        si.addRowListener((RowListener)dummyRc1);
        RowProducer rp = trans.addRowProducer(injectorStepname, 0);
        trans.startThreads();
        List<RowMetaAndData> inputList = this.createData(xslFilename);
        for (RowMetaAndData rm : inputList) {
            rp.putRow(rm.getRowMeta(), rm.getData());
        }
        rp.finished();
        trans.waitUntilFinished();
        List<RowMetaAndData> resultRows = dummyRc1.getRowsWritten();
        List<RowMetaAndData> goldenImageRows = this.createResultData1();
        this.checkRows(goldenImageRows, resultRows, 2);
    }
}

