/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.www;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.html.dom.HTMLDocumentImpl;
import org.cyberneko.html.parsers.DOMFragmentParser;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mortbay.jetty.testing.HttpTester;
import org.mortbay.jetty.testing.ServletTester;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransConfiguration;
import org.pentaho.di.trans.TransExecutionConfiguration;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.TransPreviewFactory;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.rowgenerator.RowGeneratorMeta;
import org.pentaho.di.www.AddTransServlet;
import org.pentaho.di.www.CarteSingleton;
import org.pentaho.di.www.GetRootServlet;
import org.pentaho.di.www.GetStatusServlet;
import org.pentaho.di.www.JobMap;
import org.pentaho.di.www.PauseTransServlet;
import org.pentaho.di.www.SlaveServerStatus;
import org.pentaho.di.www.SlaveServerTransStatus;
import org.pentaho.di.www.SocketRepository;
import org.pentaho.di.www.StartTransServlet;
import org.pentaho.di.www.TransformationMap;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CarteTest {
    private ServletTester tester = null;

    @Before
    public void before() {
        this.tester = new ServletTester();
        this.tester.addServlet(GetRootServlet.class, "/*");
        this.tester.addServlet(GetStatusServlet.class, "/kettle/status");
        this.tester.addServlet(AddTransServlet.class, "/kettle/addTrans");
        this.tester.addServlet(StartTransServlet.class, "/kettle/startTrans");
        this.tester.addServlet(PauseTransServlet.class, "/kettle/pauseTrans");
        try {
            this.tester.start();
            System.out.println("Started");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)ex.getMessage());
        }
    }

    @After
    public void after() {
        try {
            this.tester.stop();
            CarteSingleton.getInstance().getDetections().clear();
            CarteSingleton.getInstance().setJobMap(new JobMap());
            CarteSingleton.getInstance().setTransformationMap(new TransformationMap());
            CarteSingleton.getInstance().getSocketRepository().closeAll();
            CarteSingleton.getInstance().setSocketRepository(new SocketRepository((LogChannelInterface)new LogChannel((Object)"Carte")));
            System.out.println("Stopped");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)ex.getMessage());
        }
    }

    @Test
    public void testGetRootServlet() {
        HttpTester request = new HttpTester();
        HttpTester response = new HttpTester();
        request.setMethod("GET");
        request.setHeader("Host", "tester");
        request.setURI("/");
        request.setVersion("HTTP/1.0");
        try {
            response.parse(this.tester.getResponses(request.generate()));
            Node document = CarteTest.parse(response.getContent());
            String title = BaseMessages.getString(GetRootServlet.class, (String)"GetRootServlet.KettleSlaveServer.Title", (String[])new String[0]);
            Assert.assertEquals((Object)title, (Object)CarteTest.findTextNode(document, "TITLE").getTextContent());
            String menu = BaseMessages.getString(GetRootServlet.class, (String)"GetRootServlet.SlaveServerMenu", (String[])new String[0]);
            Assert.assertEquals((Object)menu, (Object)CarteTest.findTextNode(document, "H2").getTextContent());
            String status = BaseMessages.getString(GetRootServlet.class, (String)"GetRootServlet.ShowStatus", (String[])new String[0]);
            Assert.assertEquals((Object)status, (Object)CarteTest.findTextNode(document, "A").getTextContent());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)ex.getMessage());
        }
    }

    @Test
    public void testGetStatusServlet() {
        HttpTester request = new HttpTester();
        HttpTester response = new HttpTester();
        request.setMethod("GET");
        request.setHeader("Host", "tester");
        request.setURI("/kettle/status?xml=Y");
        request.setVersion("HTTP/1.0");
        try {
            response.parse(this.tester.getResponses(request.generate()));
            String xml = XMLHandler.getXMLHeader((String)"UTF-8") + SlaveServerStatus.fromXML((String)response.getContent()).getXML();
            Assert.assertEquals((Object)response.getContent().trim(), (Object)xml.trim());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)ex.getMessage());
        }
    }

    public SlaveServerStatus getStatus() {
        HttpTester request = new HttpTester();
        HttpTester response = new HttpTester();
        request.setMethod("GET");
        request.setHeader("Host", "tester");
        request.setURI("/kettle/status?xml=Y");
        request.setVersion("HTTP/1.0");
        try {
            response.parse(this.tester.getResponses(request.generate()));
            return SlaveServerStatus.fromXML((String)response.getContent());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Test
    public void testAddTransServlet() {
        HttpTester request = new HttpTester();
        HttpTester response = new HttpTester();
        request.setMethod("GET");
        request.setHeader("Host", "tester");
        request.setURI("/kettle/addTrans?xml=Y");
        request.setVersion("HTTP/1.0");
        try {
            TransExecutionConfiguration transExecConfig = new TransExecutionConfiguration();
            Trans trans = CarteTest.generateTestTransformation();
            TransConfiguration transConfig = new TransConfiguration(trans.getTransMeta(), transExecConfig);
            request.setContent(transConfig.getXML());
            response.parse(this.tester.getResponses(request.generate()));
            Document document = XMLHandler.loadXMLString((String)response.getContent());
            NodeList nodes = document.getElementsByTagName("result");
            Assert.assertEquals((long)1L, (long)nodes.getLength());
            Assert.assertEquals((Object)"OK", (Object)nodes.item(0).getTextContent());
            SlaveServerStatus status = this.getStatus();
            SlaveServerTransStatus transStatus = status.findTransStatus(trans.getName(), null);
            Assert.assertNotNull((Object)transStatus);
            Assert.assertFalse((boolean)transStatus.isPaused());
            Assert.assertFalse((boolean)transStatus.isRunning());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)ex.getMessage());
        }
    }

    @Test
    public void testStartTransServlet() {
        this.testAddTransServlet();
        HttpTester request = new HttpTester();
        HttpTester response = new HttpTester();
        request.setMethod("GET");
        request.setHeader("Host", "tester");
        request.setURI("/kettle/startTrans?xml=Y&name=CarteUnitTest");
        request.setVersion("HTTP/1.0");
        try {
            response.parse(this.tester.getResponses(request.generate()));
            Document document = XMLHandler.loadXMLString((String)response.getContent());
            NodeList nodes = document.getElementsByTagName("result");
            Assert.assertEquals((long)1L, (long)nodes.getLength());
            Assert.assertEquals((Object)"OK", (Object)nodes.item(0).getTextContent());
            SlaveServerStatus status = this.getStatus();
            SlaveServerTransStatus transStatus = status.findTransStatus("CarteUnitTest", null);
            Assert.assertNotNull((Object)transStatus);
            Assert.assertFalse((boolean)transStatus.isPaused());
            Assert.assertTrue((boolean)transStatus.isRunning());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)ex.getMessage());
        }
    }

    @Test
    public void testPauseTransServlet() {
        this.testAddTransServlet();
        this.testStartTransServlet();
        HttpTester request = new HttpTester();
        HttpTester response = new HttpTester();
        request.setMethod("GET");
        request.setHeader("Host", "tester");
        request.setURI("/kettle/pauseTrans?xml=Y&name=CarteUnitTest");
        request.setVersion("HTTP/1.0");
        try {
            SlaveServerStatus status = this.getStatus();
            SlaveServerTransStatus transStatus = status.findTransStatus("CarteUnitTest", null);
            Assert.assertNotNull((Object)transStatus);
            Assert.assertFalse((boolean)transStatus.isPaused());
            response.parse(this.tester.getResponses(request.generate()));
            Document document = XMLHandler.loadXMLString((String)response.getContent());
            NodeList nodes = document.getElementsByTagName("result");
            Assert.assertEquals((long)1L, (long)nodes.getLength());
            Assert.assertEquals((Object)"OK", (Object)nodes.item(0).getTextContent());
            status = this.getStatus();
            transStatus = status.findTransStatus("CarteUnitTest", null);
            Assert.assertNotNull((Object)transStatus);
            Assert.assertTrue((boolean)transStatus.isPaused());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)ex.getMessage());
        }
    }

    public static Node parse(String content) throws SAXException, IOException {
        DOMFragmentParser parser = new DOMFragmentParser();
        HTMLDocumentImpl document = new HTMLDocumentImpl();
        DocumentFragment fragment = document.createDocumentFragment();
        InputSource is = new InputSource(new StringReader(content));
        parser.parse(is, fragment);
        return fragment;
    }

    public static Node findTextNode(Node parent, String parentNodeName) {
        List<Node> nodes = CarteTest.flatten(parent, null);
        for (Node node : nodes) {
            if (node.getNodeType() != 3 || !node.getParentNode().getNodeName().equalsIgnoreCase(parentNodeName)) continue;
            return node;
        }
        return null;
    }

    public static List<Node> flatten(Node parent, List<Node> nodes) {
        Node child = parent.getFirstChild();
        if (nodes == null) {
            nodes = new ArrayList<Node>();
        }
        nodes.add(parent);
        while (child != null) {
            CarteTest.flatten(child, nodes);
            child = child.getNextSibling();
        }
        return nodes;
    }

    public static void print(Node node, String indent) {
        if (node.getNodeType() == 3 && !StringUtils.isEmpty((String)node.getTextContent().trim())) {
            System.out.println(node.getParentNode().getNodeName());
            System.out.println(node.getNodeName() + node.getTextContent());
        }
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            CarteTest.print(child, indent + " ");
        }
    }

    public static Trans generateTestTransformation() {
        RowGeneratorMeta A = new RowGeneratorMeta();
        A.allocate(3);
        A.setRowLimit("10000000");
        A.getFieldName()[0] = "ID";
        A.getFieldType()[0] = ValueMeta.getTypeDesc((int)5);
        A.getFieldLength()[0] = 7;
        A.getValue()[0] = "1234";
        A.getFieldName()[1] = "Name";
        A.getFieldType()[1] = ValueMeta.getTypeDesc((int)2);
        A.getFieldLength()[1] = 35;
        A.getValue()[1] = "Some name";
        A.getFieldName()[2] = "Last updated";
        A.getFieldType()[2] = ValueMeta.getTypeDesc((int)3);
        A.getFieldFormat()[2] = "yyyy/MM/dd";
        A.getValue()[2] = "2010/02/09";
        TransMeta transMeta = TransPreviewFactory.generatePreviewTransformation(null, (StepMetaInterface)A, (String)"A");
        transMeta.setName("CarteUnitTest");
        transMeta.setSizeRowset(2500);
        transMeta.setFeedbackSize(50000);
        transMeta.setUsingThreadPriorityManagment(false);
        return new Trans(transMeta);
    }
}

