/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.test.ui.database;

import java.util.Iterator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.database.PartitionDatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.ui.database.DatabaseConnectionDialog;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.containers.XulDialog;
import org.pentaho.ui.xul.containers.XulRoot;
import org.pentaho.ui.xul.containers.XulWindow;

public class DatabaseDialogHarness {
    DatabaseMeta database = null;

    public static void main(String[] args) {
        try {
            KettleEnvironment.init();
        }
        catch (KettleException e) {
            e.printStackTrace();
            System.exit(1);
        }
        DatabaseDialogHarness harness = new DatabaseDialogHarness();
        harness.showDialog();
    }

    private void showDialog() {
        XulDomContainer container = null;
        try {
            DatabaseConnectionDialog dcDialog = new DatabaseConnectionDialog();
            container = dcDialog.getSwtInstance(new Shell(0));
            if (this.database != null) {
                container.getEventHandler("dataHandler").setData((Object)this.database);
            }
        }
        catch (XulException e) {
            e.printStackTrace();
        }
        XulRoot root = (XulRoot)container.getDocumentRoot().getRootElement();
        if (root instanceof XulDialog) {
            ((XulDialog)root).show();
        }
        if (root instanceof XulWindow) {
            ((XulWindow)root).open();
        }
        try {
            this.database = (DatabaseMeta)container.getEventHandler("dataHandler").getData();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String message = DatabaseDialogHarness.setMessage(this.database);
        Shell shell = new Shell(2144);
        shell.setLayout((Layout)new RowLayout());
        Label label = new Label((Composite)shell, 0);
        label.setText(message);
        Button button = new Button((Composite)shell, 0);
        button.setText("Edit Database ...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    DatabaseDialogHarness.this.showDialog();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        shell.pack();
        shell.open();
        while (!shell.isDisposed()) {
            if (shell.getDisplay().readAndDispatch()) continue;
            shell.getDisplay().sleep();
        }
    }

    private static String setMessage(DatabaseMeta database) {
        String message = "";
        if (database != null) {
            String carriageReturn = System.getProperty("line.separator");
            try {
                PartitionDatabaseMeta[] partitions;
                message = "Name: ".concat(database.getName()).concat(carriageReturn).concat("Database Name: ").concat(database.getDatabaseName()).concat(carriageReturn).concat("Host Name: ").concat(database.getHostname()).concat(carriageReturn).concat("Port Number: ").concat(database.getDatabasePortNumberString()).concat(carriageReturn).concat("User Name: ").concat(database.getUsername()).concat(carriageReturn).concat("Password: ").concat(database.getPassword()).concat(carriageReturn).concat("Driver Class: ").concat(database.getDriverClass()).concat(carriageReturn).concat("URL: ").concat(database.getURL()).concat(carriageReturn);
                Iterator keys = database.getExtraOptions().keySet().iterator();
                message = message.concat(carriageReturn).concat("Option Parameters:").concat(carriageReturn);
                while (keys.hasNext()) {
                    String parameter = (String)keys.next();
                    String value = (String)database.getExtraOptions().get(parameter);
                    message = message.concat(carriageReturn).concat(parameter).concat(": ").concat(value).concat(carriageReturn);
                }
                message = message.concat(carriageReturn).concat("SQL: ").concat(database.getConnectSQL() != null ? database.getConnectSQL() : "").concat(carriageReturn).concat("Quote Identifiers: ").concat(Boolean.toString(database.isQuoteAllFields())).concat(carriageReturn).concat("Upper Case Identifiers: ").concat(Boolean.toString(database.isForcingIdentifiersToUpperCase())).concat(carriageReturn).concat("Lower Case Identifiers: ").concat(Boolean.toString(database.isForcingIdentifiersToLowerCase())).concat(carriageReturn);
                message = message.concat(carriageReturn).concat("Is Partitioned: ").concat(Boolean.toString(database.isPartitioned())).concat(carriageReturn);
                if (database.isPartitioned() && (partitions = database.getPartitioningInformation()) != null) {
                    for (int i = 0; i < partitions.length; ++i) {
                        PartitionDatabaseMeta pdm = partitions[i];
                        message = message.concat(carriageReturn).concat(Integer.toString(i)).concat(". ID: ").concat(pdm.getPartitionId()).concat(", Host: ").concat(pdm.getHostname()).concat(", Db: ").concat(pdm.getDatabaseName()).concat(", Port: ").concat(pdm.getPort()).concat(", User: ").concat(pdm.getUsername()).concat(", Pass: ").concat(pdm.getPassword()).concat(carriageReturn);
                    }
                }
                Iterator<Object> poolKeys = database.getConnectionPoolingProperties().keySet().iterator();
                message = message.concat(carriageReturn).concat("Pooling Parameters:").concat(carriageReturn);
                while (poolKeys.hasNext()) {
                    String parameter = (String)poolKeys.next();
                    String value = database.getConnectionPoolingProperties().getProperty(parameter);
                    message = message.concat(carriageReturn).concat(parameter).concat(": ").concat(value).concat(carriageReturn);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return message;
    }
}

