/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.io.HbaseObjectWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Writable;

public class Action
implements Writable,
Comparable {
    private byte[] regionName;
    private Row action;
    private int originalIndex;
    private Result result;

    public Action() {
    }

    public Action(byte[] regionName, Row action, int originalIndex) {
        this.regionName = regionName;
        this.action = action;
        this.originalIndex = originalIndex;
    }

    public byte[] getRegionName() {
        return this.regionName;
    }

    public void setRegionName(byte[] regionName) {
        this.regionName = regionName;
    }

    public Result getResult() {
        return this.result;
    }

    public void setResult(Result result) {
        this.result = result;
    }

    public Row getAction() {
        return this.action;
    }

    public int getOriginalIndex() {
        return this.originalIndex;
    }

    public int compareTo(Object o) {
        return this.action.compareTo(((Action)o).getAction());
    }

    public void write(DataOutput out) throws IOException {
        Bytes.writeByteArray(out, this.regionName);
        HbaseObjectWritable.writeObject(out, this.action, Row.class, null);
        out.writeInt(this.originalIndex);
        HbaseObjectWritable.writeObject(out, this.result, Result.class, null);
    }

    public void readFields(DataInput in) throws IOException {
        this.regionName = Bytes.readByteArray(in);
        this.action = (Row)HbaseObjectWritable.readObject(in, null);
        this.originalIndex = in.readInt();
        this.result = (Result)HbaseObjectWritable.readObject(in, null);
    }
}

