/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.LinkedList;

public class ReadWriteConsistencyControl {
    private volatile long memstoreRead = 0L;
    private volatile long memstoreWrite = 0L;
    private final Object readWaiters = new Object();
    private final LinkedList<WriteEntry> writeQueue = new LinkedList();
    private static final ThreadLocal<Long> perThreadReadPoint = new ThreadLocal();

    public static long getThreadReadPoint() {
        return perThreadReadPoint.get();
    }

    public static void setThreadReadPoint(long readPoint) {
        perThreadReadPoint.set(readPoint);
    }

    public static long resetThreadReadPoint(ReadWriteConsistencyControl rwcc) {
        perThreadReadPoint.set(rwcc.memstoreReadPoint());
        return ReadWriteConsistencyControl.getThreadReadPoint();
    }

    public static void resetThreadReadPoint() {
        perThreadReadPoint.set(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WriteEntry beginMemstoreInsert() {
        LinkedList<WriteEntry> linkedList = this.writeQueue;
        synchronized (linkedList) {
            long nextWriteNumber = ++this.memstoreWrite;
            WriteEntry e = new WriteEntry(nextWriteNumber);
            this.writeQueue.add(e);
            return e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void completeMemstoreInsert(WriteEntry e) {
        LinkedList<WriteEntry> linkedList = this.writeQueue;
        synchronized (linkedList) {
            e.markCompleted();
            long nextReadValue = -1L;
            boolean ranOnce = false;
            while (!this.writeQueue.isEmpty()) {
                ranOnce = true;
                WriteEntry queueFirst = this.writeQueue.getFirst();
                if (nextReadValue > 0L && nextReadValue + 1L != queueFirst.getWriteNumber()) {
                    throw new RuntimeException("invariant in completeMemstoreInsert violated, prev: " + nextReadValue + " next: " + queueFirst.getWriteNumber());
                }
                if (!queueFirst.isCompleted()) break;
                nextReadValue = queueFirst.getWriteNumber();
                this.writeQueue.removeFirst();
            }
            if (!ranOnce) {
                throw new RuntimeException("never was a first");
            }
            if (nextReadValue > 0L) {
                Object object = this.readWaiters;
                synchronized (object) {
                    this.memstoreRead = nextReadValue;
                    this.readWaiters.notifyAll();
                }
            }
        }
        boolean interrupted = false;
        Object object = this.readWaiters;
        synchronized (object) {
            while (this.memstoreRead < e.getWriteNumber()) {
                try {
                    this.readWaiters.wait(0L);
                }
                catch (InterruptedException ie) {
                    interrupted = true;
                }
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    public long memstoreReadPoint() {
        return this.memstoreRead;
    }

    public static class WriteEntry {
        private long writeNumber;
        private boolean completed = false;

        WriteEntry(long writeNumber) {
            this.writeNumber = writeNumber;
        }

        void markCompleted() {
            this.completed = true;
        }

        boolean isCompleted() {
            return this.completed;
        }

        long getWriteNumber() {
            return this.writeNumber;
        }
    }
}

