/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.lang.reflect.Field;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.util.Threads;

class ShutdownHook {
    private static final Log LOG = LogFactory.getLog(ShutdownHook.class);
    private static final String CLIENT_FINALIZER_DATA_METHOD = "clientFinalizer";
    public static final String RUN_SHUTDOWN_HOOK = "hbase.shutdown.hook";
    public static final String FS_SHUTDOWN_HOOK_WAIT = "hbase.fs.shutdown.hook.wait";

    ShutdownHook() {
    }

    static void install(Configuration conf, FileSystem fs, Stoppable stop, Thread threadToJoin) {
        Thread fsShutdownHook = ShutdownHook.suppressHdfsShutdownHook(fs);
        ShutdownHookThread t = new ShutdownHookThread(conf, stop, threadToJoin, fsShutdownHook);
        Runtime.getRuntime().addShutdownHook(t);
        LOG.info((Object)("Installed shutdown hook thread: " + t.getName()));
    }

    private static Thread suppressHdfsShutdownHook(FileSystem fs) {
        try {
            Thread hdfsClientFinalizer = null;
            Class<?>[] classes = FileSystem.class.getDeclaredClasses();
            Class<?> cache = null;
            for (Class<?> c : classes) {
                if (!c.getSimpleName().equals("Cache")) continue;
                cache = c;
                break;
            }
            Field field = null;
            try {
                field = cache.getDeclaredField(CLIENT_FINALIZER_DATA_METHOD);
            }
            catch (NoSuchFieldException e) {
                // empty catch block
            }
            if (field != null) {
                field.setAccessible(true);
                Field cacheField = FileSystem.class.getDeclaredField("CACHE");
                cacheField.setAccessible(true);
                Object cacheInstance = cacheField.get(fs);
                hdfsClientFinalizer = (Thread)field.get(cacheInstance);
            } else {
                field = FileSystem.class.getDeclaredField(CLIENT_FINALIZER_DATA_METHOD);
                field.setAccessible(true);
                hdfsClientFinalizer = (Thread)field.get(null);
            }
            if (hdfsClientFinalizer == null) {
                throw new RuntimeException("Client finalizer is null, can't suppress!");
            }
            if (!Runtime.getRuntime().removeShutdownHook(hdfsClientFinalizer)) {
                throw new RuntimeException("Failed suppression of fs shutdown hook: " + hdfsClientFinalizer);
            }
            return hdfsClientFinalizer;
        }
        catch (NoSuchFieldException nsfe) {
            LOG.fatal((Object)"Couldn't find field 'clientFinalizer' in FileSystem!", (Throwable)nsfe);
            throw new RuntimeException("Failed to suppress HDFS shutdown hook");
        }
        catch (IllegalAccessException iae) {
            LOG.fatal((Object)"Couldn't access field 'clientFinalizer' in FileSystem!", (Throwable)iae);
            throw new RuntimeException("Failed to suppress HDFS shutdown hook");
        }
    }

    public static void main(String[] args) throws IOException {
        Configuration conf = HBaseConfiguration.create();
        String prop = System.getProperty(RUN_SHUTDOWN_HOOK);
        if (prop != null) {
            conf.setBoolean(RUN_SHUTDOWN_HOOK, Boolean.parseBoolean(prop));
        }
        FileSystem fs = FileSystem.get((Configuration)conf);
        DoNothingThread donothing = new DoNothingThread();
        donothing.start();
        ShutdownHook.install(conf, fs, new DoNothingStoppable(), donothing);
    }

    static class DoNothingStoppable
    implements Stoppable {
        DoNothingStoppable() {
        }

        @Override
        public boolean isStopped() {
            return false;
        }

        @Override
        public void stop(String why) {
        }
    }

    static class DoNothingThread
    extends Thread {
        DoNothingThread() {
            super("donothing");
        }

        @Override
        public void run() {
            super.run();
        }
    }

    private static class ShutdownHookThread
    extends Thread {
        private final Stoppable stop;
        private final Thread threadToJoin;
        private final Thread fsShutdownHook;
        private final Configuration conf;

        ShutdownHookThread(Configuration conf, Stoppable stop, Thread threadToJoin, Thread fsShutdownHook) {
            super("Shutdownhook:" + threadToJoin.getName());
            this.stop = stop;
            this.threadToJoin = threadToJoin;
            this.conf = conf;
            this.fsShutdownHook = fsShutdownHook;
        }

        @Override
        public void run() {
            boolean b = this.conf.getBoolean(ShutdownHook.RUN_SHUTDOWN_HOOK, true);
            LOG.info((Object)("Shutdown hook starting; hbase.shutdown.hook=" + b + "; fsShutdownHook=" + this.fsShutdownHook));
            if (b) {
                this.stop.stop("Shutdown hook");
                Threads.shutdown(this.threadToJoin);
                if (this.fsShutdownHook != null) {
                    LOG.info((Object)"Starting fs shutdown hook thread.");
                    this.fsShutdownHook.start();
                    Threads.shutdown(this.fsShutdownHook, this.conf.getLong(ShutdownHook.FS_SHUTDOWN_HOOK_WAIT, 30000L));
                }
            }
            LOG.info((Object)"Shutdown hook finished.");
        }
    }
}

