/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.core.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.MessageDigest;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.dom4j.Document;
import org.dom4j.Node;
import org.pentaho.core.admin.datasources.DataSourceInfo;
import org.pentaho.core.system.PentahoSystem;
import org.pentaho.messages.Messages;

public class PublisherUtil {
    public static final int FILE_EXISTS = 1;
    public static final int FILE_ADD_FAILED = 2;
    public static final int FILE_ADD_SUCCESSFUL = 3;
    public static final int FILE_ADD_INVALID_PUBLISH_PASSWORD = 4;
    public static final int FILE_ADD_INVALID_USER_CREDENTIALS = 5;
    private static final String PublishConfigFile = "publisher_config.xml";

    public static int publish(String publishURL, String publishPath, File[] publishFiles, String publishPassword, boolean overwrite) {
        return PublisherUtil.publish(publishURL, publishPath, publishFiles, null, publishPassword, null, null, overwrite);
    }

    public static int publish(String publishURL, String publishPath, File[] publishFiles, String publishPassword, String serverUserid, String serverPassword, boolean overwrite) {
        return PublisherUtil.publish(publishURL, publishPath, publishFiles, null, publishPassword, serverUserid, serverPassword, overwrite);
    }

    public static int publish(String publishURL, String publishPath, File[] publishFiles, DataSourceInfo dataSource, String publishPassword, boolean overwrite) {
        return PublisherUtil.publish(publishURL, publishPath, publishFiles, dataSource, publishPassword, null, null, overwrite);
    }

    public static int publish(String publishURL, String publishPath, File[] publishFiles, DataSourceInfo dataSource, String publishPassword, String serverUserid, String serverPassword, boolean overwrite) {
        int status = -1;
        System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.SimpleLog");
        System.setProperty("org.apache.commons.logging.simplelog.showdatetime", "true");
        System.setProperty("org.apache.commons.logging.simplelog.log.httpclient.wire.header", "warn");
        System.setProperty("org.apache.commons.logging.simplelog.log.org.apache.commons.httpclient", "warn");
        String fullURL = publishURL + "?publishPath=" + publishPath;
        if (publishPassword == null) {
            throw new IllegalArgumentException(Messages.getErrorString((String)"PUBLISHERUTIL.ERROR_0001_PUBLISHPASSWORDREQUIRED"));
        }
        fullURL = fullURL + "&publishKey=" + PublisherUtil.getPasswordKey(publishPassword);
        fullURL = fullURL + "&overwrite=" + overwrite;
        if (dataSource != null) {
            fullURL = fullURL + "&jndiName=" + dataSource.getName();
            fullURL = fullURL + "&jdbcDriver=" + dataSource.getDriver();
            fullURL = fullURL + "&jdbcUrl=" + dataSource.getUrl();
            fullURL = fullURL + "&jdbcUserId=" + dataSource.getUserId();
            fullURL = fullURL + "&jdbcPassword=" + dataSource.getPassword();
        }
        PostMethod filePost = new PostMethod(fullURL);
        Part[] parts = new Part[publishFiles.length];
        for (int i = 0; i < publishFiles.length; ++i) {
            try {
                parts[i] = new FilePart(publishFiles[i].getName(), publishFiles[i]);
                continue;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        filePost.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts, filePost.getParams()));
        HttpClient client = new HttpClient();
        try {
            if (serverUserid != null && serverUserid.length() > 0 && serverPassword != null && serverPassword.length() > 0) {
                UsernamePasswordCredentials creds = new UsernamePasswordCredentials(serverUserid, serverPassword);
                client.getState().setCredentials(AuthScope.ANY, (Credentials)creds);
                client.getParams().setAuthenticationPreemptive(true);
            }
            if ((status = client.executeMethod((HttpMethod)filePost)) == 200) {
                String postResult = filePost.getResponseBodyAsString();
                if (postResult != null) {
                    try {
                        return Integer.parseInt(postResult.trim());
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                        return 5;
                    }
                }
            } else if (status == 401) {
                return 5;
            }
        }
        catch (HttpException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 2;
    }

    public static final String getPasswordKey(String passWord) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.reset();
            md.update(passWord.getBytes());
            byte[] digest = md.digest("P3ntah0Publ1shPa55w0rd".getBytes());
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < digest.length; ++i) {
                String s = Integer.toHexString(0xFF & digest[i]);
                buf.append(s.length() == 1 ? "0" : "").append(s);
            }
            return buf.toString();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static final boolean checkPublisherKey(String key) {
        String setting;
        Node node;
        Document doc;
        if (key != null && (doc = PentahoSystem.getSystemSettings().getSystemSettingsDocument(PublishConfigFile)) != null && (node = doc.selectSingleNode("//publisher-config/publisher-password")) != null && (setting = node.getText()) != null && setting.length() > 0) {
            String pubKey = PublisherUtil.getPasswordKey(setting);
            return pubKey.equals(key);
        }
        return false;
    }
}

