/*
 * Decompiled with CFR 0.152.
 */
package com.infobright.etl.agent;

import com.infobright.etl.agent.CLArgs;
import com.infobright.etl.agent.UsageException;
import com.infobright.io.AgentThread;
import com.infobright.logging.ConsoleEtlLogger;
import com.infobright.logging.EtlLogger;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class Agent {
    private final int port;
    private final EtlLogger logger;
    private final Set<AgentThread> workers;
    private static long nextWorkerID = 0L;

    public static void main(String[] args) throws IOException, UsageException {
        CLArgs clargs = new CLArgs(args);
        int port2 = clargs.getPort();
        ConsoleEtlLogger.Level logLevel = clargs.getLogLevel();
        ConsoleEtlLogger logger2 = new ConsoleEtlLogger(logLevel);
        new Agent(port2, logger2).execute();
    }

    private Agent(int port, EtlLogger logger) {
        this.port = port;
        this.logger = logger;
        this.workers = new HashSet<AgentThread>();
        new Reaper().start();
        logger.info("Infobright remote load agent started on port " + port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute() {
        try {
            ServerSocket ss = new ServerSocket(this.port);
            while (true) {
                AgentThread worker = new AgentThread(ss.accept(), ++nextWorkerID, this.logger);
                Set<AgentThread> set = this.workers;
                synchronized (set) {
                    this.workers.add(worker);
                }
                worker.start();
            }
        }
        catch (IOException e) {
            this.logger.error("Infobright remote load agent failed", e);
            System.exit(1);
            return;
        }
    }

    private class Reaper
    extends Thread {
        private final int REAP_INTERVAL = 1000;

        private Reaper() {
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block10: while (true) {
                HashSet workersCopy;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    return;
                }
                Set set = Agent.this.workers;
                synchronized (set) {
                    workersCopy = new HashSet(Agent.this.workers);
                }
                Iterator i$ = workersCopy.iterator();
                while (true) {
                    if (!i$.hasNext()) continue block10;
                    AgentThread worker = (AgentThread)i$.next();
                    if (Thread.State.TERMINATED != worker.getState()) continue;
                    try {
                        worker.join();
                        Set set2 = Agent.this.workers;
                        synchronized (set2) {
                            Agent.this.workers.remove(worker);
                        }
                        Agent.this.logger.debug("Reaped worker [" + worker.getWorkerId() + "]");
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
                break;
            }
        }
    }
}

