/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.hibernate;

import java.util.HashMap;
import javax.swing.table.TableModel;
import org.hibernate.Session;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.extensions.datasources.hibernate.SessionProvider;
import org.pentaho.reporting.engine.classic.extensions.datasources.hibernate.SimpleHQLDataFactory;

public class HQLDataFactory
extends SimpleHQLDataFactory {
    private HashMap<String, String> querymappings = new HashMap();

    public HQLDataFactory(Session connection) {
        super(connection);
    }

    public HQLDataFactory(SessionProvider connectionProvider) {
        super(connectionProvider);
    }

    public boolean isQueryExecutable(String query, DataRow parameters) {
        return this.querymappings.containsKey(query);
    }

    public void setQuery(String name, String queryString) {
        if (queryString == null) {
            this.querymappings.remove(name);
        } else {
            this.querymappings.put(name, queryString);
        }
    }

    public TableModel queryData(String query, DataRow parameters) throws ReportDataFactoryException {
        if (query == null) {
            throw new NullPointerException("Query is null.");
        }
        String realQuery = this.getQuery(query);
        if (realQuery == null) {
            throw new ReportDataFactoryException("Query '" + query + "' is not recognized.");
        }
        return super.queryData(realQuery, parameters);
    }

    public String getQuery(String name) {
        return this.querymappings.get(name);
    }

    public String[] getQueryNames() {
        return this.querymappings.keySet().toArray(new String[this.querymappings.size()]);
    }

    public DataFactory derive() {
        HQLDataFactory df = (HQLDataFactory)super.derive();
        df.querymappings = (HashMap)this.querymappings.clone();
        return df;
    }
}

