/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.hibernate;

import java.sql.SQLException;
import java.util.ArrayList;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.ResourceBundleFactory;
import org.pentaho.reporting.engine.classic.extensions.datasources.hibernate.SessionProvider;
import org.pentaho.reporting.engine.classic.extensions.datasources.hibernate.StaticSessionProvider;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class SimpleHQLDataFactory
implements DataFactory {
    private transient Session session;
    private SessionProvider sessionProvider;

    public SimpleHQLDataFactory(Session connection) {
        this(new StaticSessionProvider(connection));
    }

    public SimpleHQLDataFactory(SessionProvider connectionProvider) {
        if (connectionProvider == null) {
            throw new NullPointerException();
        }
        this.sessionProvider = connectionProvider;
    }

    public SessionProvider getSessionProvider() {
        return this.sessionProvider;
    }

    private synchronized Session getSession() throws HibernateException {
        if (this.session == null) {
            this.session = this.sessionProvider.getSession();
        }
        return this.session;
    }

    public void initialize(Configuration configuration, ResourceManager resourceManager, ResourceKey contextKey, ResourceBundleFactory resourceBundleFactory) {
    }

    public synchronized TableModel queryData(String query, DataRow parameters) throws ReportDataFactoryException {
        try {
            Number i;
            Object queryTimeout;
            Number i2;
            Query pstmt = this.getSession().createQuery(query);
            String[] params = pstmt.getNamedParameters();
            for (int i3 = 0; i3 < params.length; ++i3) {
                String param = params[i3];
                Object pvalue = parameters.get(param);
                if (pvalue == null) {
                    pstmt.setParameter(param, null);
                    continue;
                }
                pstmt.setParameter(param, pvalue);
            }
            Object queryLimit = parameters.get("::org.pentaho.reporting::query-limit");
            if (queryLimit instanceof Number && (i2 = (Number)queryLimit).intValue() >= 0) {
                pstmt.setMaxResults(i2.intValue());
            }
            if ((queryTimeout = parameters.get("::org.pentaho.reporting::query-timeout")) instanceof Number && (i = (Number)queryLimit).intValue() >= 0) {
                pstmt.setTimeout(i.intValue());
            }
            ScrollableResults res = pstmt.scroll(ScrollMode.FORWARD_ONLY);
            return this.generateDefaultTableModel(res, pstmt.getReturnAliases());
        }
        catch (Exception e) {
            throw new ReportDataFactoryException("Failed at query: " + query, (Throwable)e);
        }
    }

    public TableModel generateDefaultTableModel(ScrollableResults rs, String[] labelMapping) throws SQLException {
        int colcount = labelMapping.length;
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        while (rs.next()) {
            Object[] column = new Object[colcount];
            for (int i = 0; i < colcount; ++i) {
                column[i] = rs.get(i);
            }
            rows.add(column);
        }
        Object[] tempRows = rows.toArray();
        Object[][] rowMap = new Object[tempRows.length][];
        for (int i = 0; i < tempRows.length; ++i) {
            rowMap[i] = (Object[])tempRows[i];
        }
        return new DefaultTableModel(rowMap, labelMapping);
    }

    public void open() {
    }

    public synchronized void close() {
        if (this.session == null) {
            return;
        }
        try {
            this.session.close();
        }
        catch (HibernateException hibernateException) {
            // empty catch block
        }
        this.session = null;
    }

    public DataFactory derive() {
        return (DataFactory)this.clone();
    }

    public Object clone() {
        try {
            SimpleHQLDataFactory dataFactory = (SimpleHQLDataFactory)super.clone();
            dataFactory.session = null;
            return dataFactory;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Clone failed?", e);
        }
    }

    public boolean isQueryExecutable(String query, DataRow parameters) {
        return true;
    }

    public String[] getQueryNames() {
        return new String[0];
    }

    public void cancelRunningQuery() {
    }
}

