/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.hibernate.parser;

import java.util.ArrayList;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.DataFactoryReadHandler;
import org.pentaho.reporting.engine.classic.extensions.datasources.hibernate.HQLDataFactory;
import org.pentaho.reporting.engine.classic.extensions.datasources.hibernate.SessionProvider;
import org.pentaho.reporting.engine.classic.extensions.datasources.hibernate.parser.SessionProviderReadHandler;
import org.pentaho.reporting.engine.classic.extensions.datasources.hibernate.parser.SessionProviderReadHandlerFactory;
import org.pentaho.reporting.libraries.xmlns.parser.AbstractXmlReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.PropertyReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class HibernateDataSourceReadHandler
extends AbstractXmlReadHandler
implements DataFactoryReadHandler {
    private SessionProviderReadHandler connectionProviderReadHandler;
    private ArrayList queries = new ArrayList();
    private DataFactory dataFactory;

    protected XmlReadHandler getHandlerForChild(String uri, String tagName, Attributes atts) throws SAXException {
        SessionProviderReadHandlerFactory factory = SessionProviderReadHandlerFactory.getInstance();
        SessionProviderReadHandler handler = (SessionProviderReadHandler)factory.getHandler(uri, tagName);
        if (handler != null) {
            this.connectionProviderReadHandler = handler;
            return this.connectionProviderReadHandler;
        }
        if (!this.isSameNamespace(uri)) {
            return null;
        }
        if (tagName.equals("query")) {
            PropertyReadHandler queryReadHandler = new PropertyReadHandler();
            this.queries.add(queryReadHandler);
            return queryReadHandler;
        }
        return null;
    }

    protected void doneParsing() throws SAXException {
        SessionProvider provider = null;
        if (this.connectionProviderReadHandler != null) {
            provider = (SessionProvider)this.connectionProviderReadHandler.getObject();
        }
        if (provider == null) {
            provider = (SessionProvider)this.getRootHandler().getHelperObject("session-provider");
        }
        if (provider == null) {
            throw new SAXException("Unable to create SQL Factory: No connection provider.");
        }
        HQLDataFactory srdf = new HQLDataFactory(provider);
        for (int i = 0; i < this.queries.size(); ++i) {
            PropertyReadHandler handler = (PropertyReadHandler)this.queries.get(i);
            srdf.setQuery(handler.getName(), handler.getResult());
        }
        this.dataFactory = srdf;
    }

    public Object getObject() throws SAXException {
        return this.dataFactory;
    }

    public DataFactory getDataFactory() {
        return this.dataFactory;
    }
}

