/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.hibernate.writer;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleDataFactoryWriterHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleWriterException;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleWriterState;
import org.pentaho.reporting.engine.classic.core.modules.parser.extwriter.ReportWriterException;
import org.pentaho.reporting.engine.classic.extensions.datasources.hibernate.HQLDataFactory;
import org.pentaho.reporting.engine.classic.extensions.datasources.hibernate.SessionProvider;
import org.pentaho.reporting.engine.classic.extensions.datasources.hibernate.writer.SessionProviderWriteHandler;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.docbundle.BundleUtilities;
import org.pentaho.reporting.libraries.docbundle.DocumentBundle;
import org.pentaho.reporting.libraries.docbundle.WriteableDocumentBundle;
import org.pentaho.reporting.libraries.xmlns.common.AttributeList;
import org.pentaho.reporting.libraries.xmlns.writer.DefaultTagDescription;
import org.pentaho.reporting.libraries.xmlns.writer.TagDescription;
import org.pentaho.reporting.libraries.xmlns.writer.XmlWriter;

public class HibernateDataFactoryBundleWriteHandler
implements BundleDataFactoryWriterHandler {
    public static final String PREFIX = "org.pentaho.reporting.engine.classic.extensions.datasources.hibernate.writer.session-provider.";

    public String writeDataFactory(WriteableDocumentBundle bundle, DataFactory dataFactory, BundleWriterState state) throws IOException, BundleWriterException {
        HQLDataFactory hqlDataFactory = (HQLDataFactory)dataFactory;
        String fileName = BundleUtilities.getUniqueName((DocumentBundle)bundle, (String)state.getFileName(), (String)"datasources/hibernate-ds{0}.xml");
        if (fileName == null) {
            throw new IOException("Unable to generate unique name for Inline-Data-Source");
        }
        OutputStream outputStream = bundle.createEntry(fileName, "text/xml");
        DefaultTagDescription tagDescription = new DefaultTagDescription(ClassicEngineBoot.getInstance().getGlobalConfig(), "org.pentaho.reporting.engine.classic.extensions.datasources.hibernate.tag-def.");
        XmlWriter xmlWriter = new XmlWriter((Writer)new OutputStreamWriter(outputStream, "UTF-8"), (TagDescription)tagDescription, "  ", "\n");
        AttributeList rootAttrs = new AttributeList();
        if (!xmlWriter.isNamespaceDefined("http://jfreereport.sourceforge.net/namespaces/datasources/hibernate")) {
            rootAttrs.addNamespaceDeclaration("data", "http://jfreereport.sourceforge.net/namespaces/datasources/hibernate");
        }
        xmlWriter.writeTag("http://jfreereport.sourceforge.net/namespaces/datasources/hibernate", "hibernate-datasource", rootAttrs, false);
        try {
            this.writeConnectionInfo(xmlWriter, hqlDataFactory.getSessionProvider());
        }
        catch (ReportWriterException e) {
            throw new BundleWriterException("Failed to write connection info", (Exception)((Object)e));
        }
        String[] queryNames = hqlDataFactory.getQueryNames();
        for (int i = 0; i < queryNames.length; ++i) {
            String queryName = queryNames[i];
            String query = hqlDataFactory.getQuery(queryName);
            xmlWriter.writeTag("http://jfreereport.sourceforge.net/namespaces/datasources/hibernate", "query", "name", queryName, false);
            xmlWriter.writeTextNormalized(query, false);
            xmlWriter.writeCloseTag();
        }
        xmlWriter.writeCloseTag();
        xmlWriter.close();
        return fileName;
    }

    private void writeConnectionInfo(XmlWriter xmlWriter, SessionProvider connectionProvider) throws IOException, ReportWriterException {
        SessionProviderWriteHandler handler;
        String configKey = PREFIX + connectionProvider.getClass().getName();
        Configuration globalConfig = ClassicEngineBoot.getInstance().getGlobalConfig();
        String value = globalConfig.getConfigProperty(configKey);
        if (value != null && (handler = (SessionProviderWriteHandler)ObjectUtilities.loadAndInstantiate((String)value, HQLDataFactory.class, SessionProviderWriteHandler.class)) != null) {
            handler.write(xmlWriter, connectionProvider);
        }
    }
}

