/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.hibernate.writer;

import java.io.IOException;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.modules.parser.extwriter.DataFactoryWriteHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.extwriter.ReportWriterContext;
import org.pentaho.reporting.engine.classic.core.modules.parser.extwriter.ReportWriterException;
import org.pentaho.reporting.engine.classic.extensions.datasources.hibernate.HQLDataFactory;
import org.pentaho.reporting.engine.classic.extensions.datasources.hibernate.SessionProvider;
import org.pentaho.reporting.engine.classic.extensions.datasources.hibernate.writer.SessionProviderWriteHandler;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.xmlns.common.AttributeList;
import org.pentaho.reporting.libraries.xmlns.writer.XmlWriter;

public class HibernateDataFactoryWriteHandler
implements DataFactoryWriteHandler {
    public static final String PREFIX = "org.pentaho.reporting.engine.classic.extensions.datasources.hibernate.writer.session-provider.";

    public void write(ReportWriterContext reportWriter, XmlWriter xmlWriter, DataFactory dataFactory) throws IOException, ReportWriterException {
        HQLDataFactory hqlDataFactory = (HQLDataFactory)dataFactory;
        AttributeList rootAttrs = new AttributeList();
        rootAttrs.addNamespaceDeclaration("data", "http://jfreereport.sourceforge.net/namespaces/datasources/hibernate");
        xmlWriter.writeTag("http://jfreereport.sourceforge.net/namespaces/datasources/hibernate", "hibernate-datasource", rootAttrs, false);
        this.writeConnectionInfo(reportWriter, xmlWriter, hqlDataFactory.getSessionProvider());
        String[] queryNames = hqlDataFactory.getQueryNames();
        for (int i = 0; i < queryNames.length; ++i) {
            String queryName = queryNames[i];
            String query = hqlDataFactory.getQuery(queryName);
            xmlWriter.writeTag("http://jfreereport.sourceforge.net/namespaces/datasources/hibernate", "query", "name", queryName, false);
            xmlWriter.writeTextNormalized(query, false);
            xmlWriter.writeCloseTag();
        }
        xmlWriter.writeCloseTag();
    }

    private void writeConnectionInfo(ReportWriterContext reportWriter, XmlWriter xmlWriter, SessionProvider connectionProvider) throws IOException, ReportWriterException {
        SessionProviderWriteHandler handler;
        String configKey = PREFIX + connectionProvider.getClass().getName();
        Configuration globalConfig = ClassicEngineBoot.getInstance().getGlobalConfig();
        String value = globalConfig.getConfigProperty(configKey);
        if (value != null && (handler = (SessionProviderWriteHandler)ObjectUtilities.loadAndInstantiate((String)value, HQLDataFactory.class, SessionProviderWriteHandler.class)) != null) {
            handler.write(xmlWriter, connectionProvider);
        }
    }
}

