/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.mapReduceLayer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.pig.CollectableLoadFunc;
import org.apache.pig.ExecType;
import org.apache.pig.FuncSpec;
import org.apache.pig.IndexableLoadFunc;
import org.apache.pig.LoadFunc;
import org.apache.pig.OrderedLoadFunc;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.datastorage.ConfigurationUtil;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.MergeJoinIndexer;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigRecordReader;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigSplit;
import org.apache.pig.backend.hadoop.executionengine.util.MapRedUtil;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.io.FileSpec;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.util.ObjectSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PigInputFormat
extends InputFormat<Text, Tuple> {
    public static final Log log = LogFactory.getLog(PigInputFormat.class);
    private static final PathFilter hiddenFileFilter = new PathFilter(){

        public boolean accept(Path p) {
            String name = p.getName();
            return !name.startsWith("_") && !name.startsWith(".");
        }
    };
    public static final String PIG_INPUTS = "pig.inputs";
    @Deprecated
    public static Configuration sJob;
    private static PigSplit activeSplit;

    public RecordReader<Text, Tuple> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        PigSplit pigSplit;
        activeSplit = pigSplit = (PigSplit)split;
        int n = pigSplit.getTotalSplits();
        context.getConfiguration().setInt("pig.mapsplits.count", n);
        Configuration conf = context.getConfiguration();
        LoadFunc loadFunc = PigInputFormat.getLoadFunc(pigSplit.getInputIndex(), conf);
        PigInputFormat.passLoadSignature(loadFunc, pigSplit.getInputIndex(), conf);
        PigInputFormat.mergeSplitSpecificConf(loadFunc, pigSplit, conf);
        sJob = conf;
        InputFormat inputFormat = loadFunc.getInputFormat();
        return new PigRecordReader(inputFormat, pigSplit, loadFunc, context);
    }

    static void mergeSplitSpecificConf(LoadFunc loadFunc, PigSplit pigSplit, Configuration originalConf) throws IOException {
        Job job = new Job(originalConf);
        loadFunc.setLocation(PigInputFormat.getLoadLocation(pigSplit.getInputIndex(), originalConf), job);
        ConfigurationUtil.mergeConf(originalConf, job.getConfiguration());
    }

    private static LoadFunc getLoadFunc(int inputIndex, Configuration conf) throws IOException {
        ArrayList inputs = (ArrayList)ObjectSerializer.deserialize(conf.get(PIG_INPUTS));
        FuncSpec loadFuncSpec = ((FileSpec)inputs.get(inputIndex)).getFuncSpec();
        return (LoadFunc)PigContext.instantiateFuncFromSpec(loadFuncSpec);
    }

    private static String getLoadLocation(int inputIndex, Configuration conf) throws IOException {
        ArrayList inputs = (ArrayList)ObjectSerializer.deserialize(conf.get(PIG_INPUTS));
        return ((FileSpec)inputs.get(inputIndex)).getFileName();
    }

    static void passLoadSignature(LoadFunc loadFunc, int inputIndex, Configuration conf) throws IOException {
        ArrayList inpSignatureLists = (ArrayList)ObjectSerializer.deserialize(conf.get("pig.inpSignatures"));
        if (inpSignatureLists.get(inputIndex) != null) {
            loadFunc.setUDFContextSignature((String)inpSignatureLists.get(inputIndex));
            conf.set("pig.loader.signature", (String)inpSignatureLists.get(inputIndex));
        }
        MapRedUtil.setupUDFContext(conf);
    }

    public List<InputSplit> getSplits(JobContext jobcontext) throws IOException, InterruptedException {
        PigContext pigContext;
        ArrayList inpTargets;
        ArrayList inputs;
        Configuration conf = jobcontext.getConfiguration();
        try {
            inputs = (ArrayList)ObjectSerializer.deserialize(conf.get(PIG_INPUTS));
            inpTargets = (ArrayList)ObjectSerializer.deserialize(conf.get("pig.inpTargets"));
            pigContext = (PigContext)ObjectSerializer.deserialize(conf.get("pig.pigContext"));
            PigContext.setPackageImportList((ArrayList)ObjectSerializer.deserialize(conf.get("udf.import.list")));
        }
        catch (Exception e) {
            int errCode = 2094;
            String msg = "Unable to deserialize object.";
            throw new ExecException(msg, errCode, 4, e);
        }
        ArrayList<InputSplit> splits = new ArrayList<InputSplit>();
        for (int i = 0; i < inputs.size(); ++i) {
            try {
                FuncSpec loadFuncSpec;
                LoadFunc loadFunc;
                boolean combinable;
                FileSystem fs;
                Path path = new Path(((FileSpec)inputs.get(i)).getFileName());
                try {
                    fs = path.getFileSystem(conf);
                }
                catch (Exception e) {
                    fs = new Path("/").getFileSystem(conf);
                }
                if (pigContext.getExecType() == ExecType.MAPREDUCE) {
                    fs.setWorkingDirectory(jobcontext.getWorkingDirectory());
                }
                boolean bl = combinable = !((loadFunc = (LoadFunc)PigContext.instantiateFuncFromSpec(loadFuncSpec = ((FileSpec)inputs.get(i)).getFuncSpec())) instanceof MergeJoinIndexer) && !IndexableLoadFunc.class.isAssignableFrom(loadFunc.getClass()) && (!CollectableLoadFunc.class.isAssignableFrom(loadFunc.getClass()) || !OrderedLoadFunc.class.isAssignableFrom(loadFunc.getClass()));
                if (combinable) {
                    combinable = !conf.getBoolean("pig.noSplitCombination", false);
                }
                Configuration confClone = new Configuration(conf);
                Job inputSpecificJob = new Job(confClone);
                PigInputFormat.passLoadSignature(loadFunc, i, inputSpecificJob.getConfiguration());
                loadFunc.setLocation(((FileSpec)inputs.get(i)).getFileName(), inputSpecificJob);
                InputFormat inpFormat = loadFunc.getInputFormat();
                List oneInputSplits = inpFormat.getSplits(new JobContext(inputSpecificJob.getConfiguration(), jobcontext.getJobID()));
                List<InputSplit> oneInputPigSplits = this.getPigSplits(oneInputSplits, i, (ArrayList)inpTargets.get(i), fs.getDefaultBlockSize(), combinable, confClone);
                splits.addAll(oneInputPigSplits);
                continue;
            }
            catch (ExecException ee) {
                throw ee;
            }
            catch (Exception e) {
                int errCode = 2118;
                String msg = "Unable to create input splits for: " + ((FileSpec)inputs.get(i)).getFileName();
                if (e.getMessage() != null && !e.getMessage().isEmpty()) {
                    throw new ExecException(e.getMessage(), errCode, 4, e);
                }
                throw new ExecException(msg, errCode, 4, e);
            }
        }
        int n = splits.size();
        int m = inputs.size();
        for (InputSplit split : splits) {
            ((PigSplit)split).setTotalSplits(n);
            if (m <= 1) continue;
            ((PigSplit)split).setMultiInputs(true);
        }
        return splits;
    }

    protected List<InputSplit> getPigSplits(List<InputSplit> oneInputSplits, int inputIndex, ArrayList<OperatorKey> targetOps, long blockSize, boolean combinable, Configuration conf) throws IOException, InterruptedException {
        ArrayList<InputSplit> pigSplits = new ArrayList<InputSplit>();
        if (!combinable) {
            int splitIndex = 0;
            for (InputSplit inputSplit : oneInputSplits) {
                PigSplit pigSplit = new PigSplit(new InputSplit[]{inputSplit}, inputIndex, targetOps, splitIndex++);
                pigSplit.setConf(conf);
                pigSplits.add(pigSplit);
            }
            return pigSplits;
        }
        long maxCombinedSplitSize = conf.getLong("pig.maxCombinedSplitSize", 0L);
        if (maxCombinedSplitSize == 0L) {
            maxCombinedSplitSize = blockSize;
        }
        List<List<InputSplit>> combinedSplits = MapRedUtil.getCombinePigSplits(oneInputSplits, maxCombinedSplitSize, conf);
        for (int i = 0; i < combinedSplits.size(); ++i) {
            pigSplits.add(this.createPigSplit(combinedSplits.get(i), inputIndex, targetOps, i, conf));
        }
        return pigSplits;
    }

    private InputSplit createPigSplit(List<InputSplit> combinedSplits, int inputIndex, ArrayList<OperatorKey> targetOps, int splitIndex, Configuration conf) {
        PigSplit pigSplit = new PigSplit(combinedSplits.toArray(new InputSplit[0]), inputIndex, targetOps, splitIndex);
        pigSplit.setConf(conf);
        return pigSplit;
    }

    public static PigSplit getActiveSplit() {
        return activeSplit;
    }
}

