/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.mapReduceLayer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.serializer.Deserializer;
import org.apache.hadoop.io.serializer.SerializationFactory;
import org.apache.hadoop.io.serializer.Serializer;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.pig.impl.plan.OperatorKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PigSplit
extends InputSplit
implements Writable,
Configurable {
    private ArrayList<OperatorKey> targetOps;
    private int inputIndex;
    private InputSplit[] wrappedSplits;
    private int splitIndex;
    private boolean isMultiInputs = false;
    private Configuration conf;
    private int totalSplits;
    private long length = -1L;
    String[] locations = null;

    public PigSplit() {
    }

    public PigSplit(InputSplit[] wrappedSplits, int inputIndex, List<OperatorKey> targetOps, int splitIndex) {
        this.wrappedSplits = wrappedSplits;
        this.inputIndex = inputIndex;
        this.targetOps = new ArrayList<OperatorKey>(targetOps);
        this.splitIndex = splitIndex;
    }

    public List<OperatorKey> getTargetOps() {
        return new ArrayList<OperatorKey>(this.targetOps);
    }

    public InputSplit getWrappedSplit() {
        return this.wrappedSplits[0];
    }

    public InputSplit getWrappedSplit(int idx) {
        return this.wrappedSplits[idx];
    }

    public String[] getLocations() throws IOException, InterruptedException {
        if (this.locations == null) {
            HashMap<String, Long> locMap = new HashMap<String, Long>();
            for (InputSplit split : this.wrappedSplits) {
                String[] locs;
                for (String loc : locs = split.getLocations()) {
                    Long lenInMap = (Long)locMap.get(loc);
                    if (lenInMap == null) {
                        locMap.put(loc, split.getLength());
                        continue;
                    }
                    locMap.put(loc, lenInMap + split.getLength());
                }
            }
            Set entrySet = locMap.entrySet();
            Map.Entry[] hostSize = entrySet.toArray(new Map.Entry[entrySet.size()]);
            Arrays.sort(hostSize, new Comparator<Map.Entry<String, Long>>(){

                @Override
                public int compare(Map.Entry<String, Long> o1, Map.Entry<String, Long> o2) {
                    long diff = o1.getValue() - o2.getValue();
                    if (diff < 0L) {
                        return 1;
                    }
                    if (diff > 0L) {
                        return -1;
                    }
                    return 0;
                }
            });
            int nHost = Math.min(hostSize.length, 5);
            this.locations = new String[nHost];
            for (int i = 0; i < nHost; ++i) {
                this.locations[i] = (String)hostSize[i].getKey();
            }
        }
        return this.locations;
    }

    public long getLength() throws IOException, InterruptedException {
        if (this.length == -1L) {
            this.length = 0L;
            for (int i = 0; i < this.wrappedSplits.length; ++i) {
                this.length += this.wrappedSplits[i].getLength();
            }
        }
        return this.length;
    }

    public long getLength(int idx) throws IOException, InterruptedException {
        return this.wrappedSplits[idx].getLength();
    }

    public void readFields(DataInput is) throws IOException {
        this.isMultiInputs = is.readBoolean();
        this.totalSplits = is.readInt();
        this.splitIndex = is.readInt();
        this.inputIndex = is.readInt();
        this.targetOps = (ArrayList)this.readObject(is);
        int splitLen = is.readInt();
        String splitClassName = is.readUTF();
        try {
            Class splitClass = this.conf.getClassByName(splitClassName);
            SerializationFactory sf = new SerializationFactory(this.conf);
            Deserializer d = sf.getDeserializer(splitClass);
            d.open((InputStream)((Object)is));
            this.wrappedSplits = new InputSplit[splitLen];
            for (int i = 0; i < splitLen; ++i) {
                this.wrappedSplits[i] = (InputSplit)ReflectionUtils.newInstance((Class)splitClass, (Configuration)this.conf);
                d.deserialize((Object)this.wrappedSplits[i]);
            }
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
    }

    public void write(DataOutput os) throws IOException {
        os.writeBoolean(this.isMultiInputs);
        os.writeInt(this.totalSplits);
        os.writeInt(this.splitIndex);
        os.writeInt(this.inputIndex);
        this.writeObject(this.targetOps, os);
        os.writeInt(this.wrappedSplits.length);
        os.writeUTF(this.wrappedSplits[0].getClass().getName());
        SerializationFactory sf = new SerializationFactory(this.conf);
        Serializer s = sf.getSerializer(this.wrappedSplits[0].getClass());
        s.open((OutputStream)((Object)os));
        for (int i = 0; i < this.wrappedSplits.length; ++i) {
            s.serialize((Object)this.wrappedSplits[i]);
        }
    }

    private void writeObject(Serializable obj, DataOutput os) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(obj);
        byte[] bytes = baos.toByteArray();
        os.writeInt(bytes.length);
        os.write(bytes);
    }

    private Object readObject(DataInput is) throws IOException {
        byte[] bytes = new byte[is.readInt()];
        is.readFully(bytes);
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bytes));
        try {
            return ois.readObject();
        }
        catch (ClassNotFoundException cnfe) {
            IOException newE = new IOException(cnfe.getMessage());
            newE.initCause(cnfe);
            throw newE;
        }
    }

    public int getSplitIndex() {
        return this.splitIndex;
    }

    public void setMultiInputs(boolean b) {
        this.isMultiInputs = b;
    }

    public boolean isMultiInputs() {
        return this.isMultiInputs;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    int getInputIndex() {
        return this.inputIndex;
    }

    public int getNumPaths() {
        return this.wrappedSplits.length;
    }

    int getTotalSplits() {
        return this.totalSplits;
    }

    void setTotalSplits(int totalSplits) {
        this.totalSplits = totalSplits;
    }

    public String toString() {
        StringBuilder st = new StringBuilder();
        st.append("Number of splits :" + this.wrappedSplits.length + "\n");
        try {
            st.append("Total Length = " + this.getLength() + "\n");
            for (int i = 0; i < this.wrappedSplits.length; ++i) {
                st.append("Input split[" + i + "]:\n   Length = " + this.wrappedSplits[i].getLength() + "\n  Locations:\n");
                for (String location : this.wrappedSplits[i].getLocations()) {
                    st.append("    " + location + "\n");
                }
                st.append("\n-----------------------\n");
            }
        }
        catch (IOException e) {
            return null;
        }
        catch (InterruptedException e) {
            return null;
        }
        return st.toString();
    }
}

