/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.hbase;

import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.pig.LoadStoreCaster;
import org.apache.pig.ResourceSchema;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HBaseBinaryConverter
implements LoadStoreCaster {
    @Override
    public String bytesToCharArray(byte[] b) throws IOException {
        return Bytes.toString((byte[])b);
    }

    @Override
    public Double bytesToDouble(byte[] b) throws IOException {
        if (8 > b.length) {
            return Bytes.toDouble((byte[])Bytes.padHead((byte[])b, (int)(8 - b.length)));
        }
        return Bytes.toDouble((byte[])Bytes.head((byte[])b, (int)8));
    }

    @Override
    public Float bytesToFloat(byte[] b) throws IOException {
        if (4 > b.length) {
            return Float.valueOf(Bytes.toFloat((byte[])Bytes.padHead((byte[])b, (int)(4 - b.length))));
        }
        return Float.valueOf(Bytes.toFloat((byte[])Bytes.head((byte[])b, (int)4)));
    }

    @Override
    public Integer bytesToInteger(byte[] b) throws IOException {
        if (4 > b.length) {
            return Bytes.toInt((byte[])Bytes.padHead((byte[])b, (int)(4 - b.length)));
        }
        return Bytes.toInt((byte[])Bytes.head((byte[])b, (int)4));
    }

    @Override
    public Long bytesToLong(byte[] b) throws IOException {
        if (8 > b.length) {
            return Bytes.toLong((byte[])Bytes.padHead((byte[])b, (int)(8 - b.length)));
        }
        return Bytes.toLong((byte[])Bytes.head((byte[])b, (int)8));
    }

    @Override
    public Map<String, Object> bytesToMap(byte[] b) throws IOException {
        throw new ExecException("Can't generate a Map from byte[]");
    }

    @Override
    public Tuple bytesToTuple(byte[] b, ResourceSchema.ResourceFieldSchema fieldSchema) throws IOException {
        throw new ExecException("Can't generate a Tuple from byte[]");
    }

    @Override
    public DataBag bytesToBag(byte[] b, ResourceSchema.ResourceFieldSchema fieldSchema) throws IOException {
        throw new ExecException("Can't generate DataBags from byte[]");
    }

    @Override
    public byte[] toBytes(DataBag bag) throws IOException {
        throw new ExecException("Cant' generate bytes from DataBag");
    }

    @Override
    public byte[] toBytes(String s) throws IOException {
        return Bytes.toBytes((String)s);
    }

    @Override
    public byte[] toBytes(Double d) throws IOException {
        return Bytes.toBytes((double)d);
    }

    @Override
    public byte[] toBytes(Float f) throws IOException {
        return Bytes.toBytes((float)f.floatValue());
    }

    @Override
    public byte[] toBytes(Integer i) throws IOException {
        return Bytes.toBytes((int)i);
    }

    @Override
    public byte[] toBytes(Long l) throws IOException {
        return Bytes.toBytes((long)l);
    }

    @Override
    public byte[] toBytes(Map<String, Object> m) throws IOException {
        throw new IOException("Can't generate bytes from Map");
    }

    @Override
    public byte[] toBytes(Tuple t) throws IOException {
        throw new IOException("Can't generate bytes from Tuple");
    }

    @Override
    public byte[] toBytes(DataByteArray a) throws IOException {
        return a.get();
    }
}

