/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.relational;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.pig.data.DataType;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.util.Pair;
import org.apache.pig.newplan.logical.expression.LogicalExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogicalSchema {
    private List<LogicalFieldSchema> fields = new ArrayList<LogicalFieldSchema>();
    private Map<String, Pair<Integer, Boolean>> aliases = new HashMap<String, Pair<Integer, Boolean>>();
    private boolean twoLevelAccessRequired = false;

    public void addField(LogicalFieldSchema field) {
        this.fields.add(field);
        if (field.alias != null && !field.alias.equals("")) {
            this.aliases.put(field.alias, new Pair<Integer, Boolean>(this.fields.size() - 1, true));
            int index = 0;
            while (index != -1) {
                if ((index = field.alias.indexOf("::", index)) == -1) continue;
                String a = field.alias.substring(index + 2);
                if (this.aliases.containsKey(a)) {
                    if (!((Boolean)this.aliases.get((Object)a).second).booleanValue()) {
                        this.aliases.remove(a);
                    }
                } else {
                    this.aliases.put(a, new Pair<Integer, Boolean>(this.fields.size() - 1, false));
                }
                index += 2;
            }
        }
    }

    public LogicalFieldSchema getField(String alias) {
        Pair<Integer, Boolean> p = this.aliases.get(alias);
        if (p == null) {
            return null;
        }
        return this.fields.get((Integer)p.first);
    }

    public LogicalFieldSchema getField(int fieldNum) {
        return this.fields.get(fieldNum);
    }

    public List<LogicalFieldSchema> getFields() {
        return this.fields;
    }

    public int size() {
        return this.fields.size();
    }

    public boolean isEqual(Object other) {
        if (other != null && other instanceof LogicalSchema) {
            LogicalSchema os = (LogicalSchema)other;
            if (this.size() != os.size()) {
                return false;
            }
            for (int i = 0; i < this.size(); ++i) {
                if (this.getField(i).isEqual(os.getField(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int findField(long uid) {
        for (int i = 0; i < this.size(); ++i) {
            LogicalFieldSchema f = this.getField(i);
            if (f.uid == uid) {
                return i;
            }
            if (f.schema == null || f.schema.findField(uid) == -1) continue;
            return i;
        }
        return -1;
    }

    public static LogicalSchema merge(LogicalSchema s1, LogicalSchema s2) throws FrontendException {
        if (s1 == null || s2 == null) {
            if (s1 != null) {
                return s1.deepCopy();
            }
            if (s2 != null) {
                return s2.deepCopy();
            }
            return null;
        }
        if (s1.size() != s2.size()) {
            return null;
        }
        LogicalSchema mergedSchema = new LogicalSchema();
        for (int i = 0; i < s1.size(); ++i) {
            LogicalSchema mergedSubSchema = null;
            LogicalFieldSchema fs1 = s1.getField(i);
            LogicalFieldSchema fs2 = s2.getField(i);
            String mergedAlias = fs1.alias == null ? fs2.alias : fs1.alias;
            byte mergedType = fs1.type == 1 ? fs2.type : fs1.type;
            if (DataType.isSchemaType(mergedType)) {
                mergedSubSchema = LogicalSchema.merge(fs1.schema, fs2.schema);
            }
            LogicalFieldSchema mergedFS = new LogicalFieldSchema(mergedAlias, mergedSubSchema, mergedType);
            mergedSchema.addField(mergedFS);
            if (!s1.isTwoLevelAccessRequired() || !s2.isTwoLevelAccessRequired()) continue;
            mergedSchema.setTwoLevelAccessRequired(true);
        }
        return mergedSchema;
    }

    public String toString(boolean verbose) {
        StringBuilder str = new StringBuilder();
        for (LogicalFieldSchema field : this.fields) {
            str.append(field.toString(verbose) + ",");
        }
        if (this.fields.size() != 0) {
            str.deleteCharAt(str.length() - 1);
        }
        return str.toString();
    }

    public String toString() {
        return this.toString(true);
    }

    public void setTwoLevelAccessRequired(boolean flag) {
        this.twoLevelAccessRequired = flag;
    }

    public boolean isTwoLevelAccessRequired() {
        return this.twoLevelAccessRequired;
    }

    public LogicalSchema mergeUid(LogicalSchema uidOnlySchema) throws FrontendException {
        if (uidOnlySchema != null) {
            if (this.size() != uidOnlySchema.size()) {
                throw new FrontendException("Structure of schema change. Original: " + uidOnlySchema + " Now: " + this, 2239);
            }
            for (int i = 0; i < this.size(); ++i) {
                this.getField(i).mergeUid(uidOnlySchema.getField(i));
            }
            return uidOnlySchema;
        }
        LogicalSchema clonedUidOnlyCopy = new LogicalSchema();
        for (int i = 0; i < this.size(); ++i) {
            this.getField(i).stampFieldSchema();
            clonedUidOnlyCopy.addField(this.getField(i).cloneUid());
        }
        return clonedUidOnlyCopy;
    }

    public LogicalSchema deepCopy() {
        LogicalSchema newSchema = new LogicalSchema();
        newSchema.setTwoLevelAccessRequired(this.isTwoLevelAccessRequired());
        for (int i = 0; i < this.size(); ++i) {
            newSchema.addField(this.getField(i).deepCopy());
        }
        return newSchema;
    }

    public static class LogicalFieldSchema {
        public String alias;
        public byte type;
        public long uid;
        public LogicalSchema schema;

        public LogicalFieldSchema(String alias, LogicalSchema schema, byte type) {
            this(alias, schema, type, -1L);
        }

        public LogicalFieldSchema(LogicalFieldSchema fs) {
            this(fs.alias, fs.schema, fs.type, fs.uid);
        }

        public LogicalFieldSchema(String alias, LogicalSchema schema, byte type, long uid) {
            this.alias = alias;
            this.type = type;
            this.schema = schema;
            this.uid = uid;
        }

        public boolean isEqual(Object other) {
            if (other instanceof LogicalFieldSchema) {
                LogicalFieldSchema ofs = (LogicalFieldSchema)other;
                if (this.type != ofs.type) {
                    return false;
                }
                if (this.schema == null && ofs.schema == null) {
                    return true;
                }
                if (this.schema == null) {
                    return false;
                }
                return this.schema.isEqual(ofs.schema);
            }
            return false;
        }

        public String toString(boolean verbose) {
            String uidString = "";
            if (verbose) {
                uidString = "#" + this.uid;
            }
            if (this.type == 120) {
                if (this.schema == null) {
                    return this.alias + uidString + ":bag{}";
                }
                return this.alias + uidString + ":bag{" + this.schema.toString() + "}";
            }
            if (this.type == 110) {
                if (this.schema == null) {
                    return this.alias + uidString + ":tuple{}";
                }
                return this.alias + uidString + ":tuple(" + this.schema.toString() + ")";
            }
            return this.alias + uidString + ":" + DataType.findTypeName(this.type);
        }

        public String toString() {
            return this.toString(true);
        }

        public void stampFieldSchema() {
            if (this.uid == -1L) {
                this.uid = LogicalExpression.getNextUid();
            }
            if (this.schema != null) {
                for (LogicalFieldSchema fs : this.schema.getFields()) {
                    fs.stampFieldSchema();
                }
            }
        }

        private boolean compatible(LogicalFieldSchema uidOnlyFieldSchema) {
            if (uidOnlyFieldSchema == null) {
                return false;
            }
            if (this.schema == null && uidOnlyFieldSchema.schema != null || this.schema != null && uidOnlyFieldSchema == null) {
                return false;
            }
            if (this.schema != null) {
                if (this.schema.size() != uidOnlyFieldSchema.schema.size()) {
                    return false;
                }
                for (int i = 0; i < this.schema.size(); ++i) {
                    boolean comp = this.schema.getField(i).compatible(uidOnlyFieldSchema.schema.getField(i));
                    if (comp) continue;
                    return false;
                }
            }
            return true;
        }

        public LogicalFieldSchema mergeUid(LogicalFieldSchema uidOnlyFieldSchema) throws FrontendException {
            if (uidOnlyFieldSchema != null && this.compatible(uidOnlyFieldSchema)) {
                this.uid = uidOnlyFieldSchema.uid;
                if (this.schema != null) {
                    for (int i = 0; i < this.schema.size(); ++i) {
                        this.schema.getField(i).mergeUid(uidOnlyFieldSchema.schema.getField(i));
                    }
                }
                return uidOnlyFieldSchema;
            }
            if (uidOnlyFieldSchema == null) {
                this.stampFieldSchema();
            } else {
                this.uid = uidOnlyFieldSchema.uid;
                if (this.schema != null) {
                    for (int i = 0; i < this.schema.size(); ++i) {
                        this.schema.getField(i).stampFieldSchema();
                    }
                }
            }
            LogicalFieldSchema clonedUidOnlyCopy = this.cloneUid();
            return clonedUidOnlyCopy;
        }

        public LogicalFieldSchema cloneUid() {
            LogicalFieldSchema resultFs = null;
            if (this.schema == null) {
                resultFs = new LogicalFieldSchema(null, null, this.type, this.uid);
            } else {
                LogicalSchema newSchema = new LogicalSchema();
                resultFs = new LogicalFieldSchema(null, newSchema, this.type, this.uid);
                for (int i = 0; i < this.schema.size(); ++i) {
                    LogicalFieldSchema fs = this.schema.getField(i).cloneUid();
                    newSchema.addField(fs);
                }
            }
            return resultFs;
        }

        public LogicalFieldSchema deepCopy() {
            LogicalFieldSchema newFs = new LogicalFieldSchema(this.alias != null ? this.alias : null, this.schema != null ? this.schema.deepCopy() : null, this.type, this.uid);
            return newFs;
        }
    }
}

