/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.scripting.jython;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.pig.FuncSpec;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.logicalLayer.parser.ParseException;
import org.apache.pig.impl.util.Utils;
import org.apache.pig.scripting.ScriptEngine;
import org.apache.pig.scripting.jython.JythonFunction;
import org.python.core.PyFunction;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyStringMap;
import org.python.core.PyTuple;
import org.python.util.PythonInterpreter;

public class JythonScriptEngine
extends ScriptEngine {
    public void registerFunctions(String path, String namespace, PigContext pigContext) throws IOException {
        Interpreter.init(path);
        pigContext.scriptJars.add(JythonScriptEngine.getJarPath(PythonInterpreter.class));
        PythonInterpreter pi = Interpreter.interpreter;
        PyList locals = ((PyStringMap)pi.getLocals()).items();
        namespace = namespace == null ? "" : namespace + ".";
        try {
            for (PyTuple item : locals) {
                String key = (String)item.get(0);
                Object value = item.get(1);
                FuncSpec funcspec = null;
                if (key.startsWith("__") || key.equals("schemaFunction") || key.equals("outputSchema") || key.equals("outputSchemaFunction") || !(value instanceof PyFunction) || ((PyFunction)value).__findattr__("schemaFunction".intern()) != null) continue;
                PyObject obj = ((PyFunction)value).__findattr__("outputSchema".intern());
                if (obj != null) {
                    Utils.getSchemaFromString(obj.toString());
                }
                funcspec = new FuncSpec(JythonFunction.class.getCanonicalName() + "('" + path + "','" + key + "')");
                pigContext.registerFunction(namespace + key, funcspec);
            }
        }
        catch (ParseException pe) {
            throw new IOException("Error parsing schema for script function from the decorator " + pe);
        }
    }

    public static PyFunction getFunction(String path, String functionName) throws IOException {
        Interpreter.init(path);
        return (PyFunction)Interpreter.interpreter.get(functionName);
    }

    private static class Interpreter {
        static final PythonInterpreter interpreter = new PythonInterpreter();
        static volatile ArrayList<String> filesLoaded = new ArrayList();

        private Interpreter() {
        }

        static synchronized void init(String path) throws IOException {
            if (!filesLoaded.contains(path)) {
                interpreter.exec("def outputSchema(schema_def):\n    def decorator(func):\n        func.outputSchema = schema_def\n        return func\n    return decorator\n\n");
                interpreter.exec("def outputSchemaFunction(schema_def):\n    def decorator(func):\n        func.outputSchemaFunction = schema_def\n        return func\n    return decorator\n");
                interpreter.exec("def schemaFunction(schema_def):\n     def decorator(func):\n         func.schemaFunction = schema_def\n         return func\n     return decorator\n\n");
                InputStream is = null;
                File file = new File(path);
                is = file.exists() ? new FileInputStream(file) : (file.isAbsolute() ? Interpreter.class.getResourceAsStream(path) : Interpreter.class.getResourceAsStream("/" + path));
                if (is != null) {
                    interpreter.execfile(is);
                    filesLoaded.add(path);
                    is.close();
                } else {
                    throw new IOException("Could not initialize interpreter with " + path);
                }
            }
        }
    }
}

