/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.tools.pigstats;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.jobcontrol.Job;
import org.apache.pig.ExecType;
import org.apache.pig.PigException;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.JobControlCompiler;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.MapReduceOper;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.NativeMapReduceOper;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.plans.MROpPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.plans.MROperPlan;
import org.apache.pig.classification.InterfaceAudience;
import org.apache.pig.classification.InterfaceStability;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.newplan.BaseOperatorPlan;
import org.apache.pig.newplan.DependencyOrderWalker;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.PlanVisitor;
import org.apache.pig.tools.pigstats.InputStats;
import org.apache.pig.tools.pigstats.JobStats;
import org.apache.pig.tools.pigstats.OutputStats;
import org.apache.pig.tools.pigstats.ScriptState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@InterfaceAudience.Public
@InterfaceStability.Evolving
public final class PigStats {
    private static final Log LOG = LogFactory.getLog(PigStats.class);
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static ThreadLocal<PigStats> tps = new ThreadLocal();
    private PigContext pigContext;
    private JobClient jobClient;
    private JobControlCompiler jcc;
    private JobGraph jobPlan;
    private Map<String, MapReduceOper> jobMroMap = new HashMap<String, MapReduceOper>();
    private Map<MapReduceOper, JobStats> mroJobMap;
    private long startTime = -1L;
    private long endTime = -1L;
    private String userId;
    private int returnCode = -1;
    private String errorMessage;
    private int errorCode = -1;

    public static PigStats get() {
        if (tps.get() == null) {
            tps.set(new PigStats());
        }
        return tps.get();
    }

    static PigStats start() {
        tps.set(new PigStats());
        return tps.get();
    }

    public boolean isSuccessful() {
        return this.returnCode == 0;
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public Properties getPigProperties() {
        if (this.pigContext == null) {
            return null;
        }
        return this.pigContext.getProperties();
    }

    public JobGraph getJobGraph() {
        return this.jobPlan;
    }

    public List<String> getOutputLocations() {
        ArrayList<String> locations = new ArrayList<String>();
        for (OutputStats output : this.getOutputStats()) {
            locations.add(output.getLocation());
        }
        return Collections.unmodifiableList(locations);
    }

    public List<String> getOutputNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (OutputStats output : this.getOutputStats()) {
            names.add(output.getName());
        }
        return Collections.unmodifiableList(names);
    }

    public long getNumberBytes(String location) {
        if (location == null) {
            return -1L;
        }
        String name = new Path(location).getName();
        long count = -1L;
        for (OutputStats output : this.getOutputStats()) {
            if (!name.equals(output.getName())) continue;
            count = output.getBytes();
            break;
        }
        return count;
    }

    public long getNumberRecords(String location) {
        if (location == null) {
            return -1L;
        }
        String name = new Path(location).getName();
        long count = -1L;
        for (OutputStats output : this.getOutputStats()) {
            if (!name.equals(output.getName())) continue;
            count = output.getNumberRecords();
            break;
        }
        return count;
    }

    public String getOutputAlias(String location) {
        if (location == null) {
            return null;
        }
        String name = new Path(location).getName();
        String alias = null;
        for (OutputStats output : this.getOutputStats()) {
            if (!name.equals(output.getName())) continue;
            alias = output.getAlias();
            break;
        }
        return alias;
    }

    public long getSMMSpillCount() {
        Iterator<JobStats> it = this.jobPlan.iterator();
        long ret = 0L;
        while (it.hasNext()) {
            ret += it.next().getSMMSpillCount();
        }
        return ret;
    }

    public long getProactiveSpillCountObjects() {
        Iterator<JobStats> it = this.jobPlan.iterator();
        long ret = 0L;
        while (it.hasNext()) {
            ret += it.next().getProactiveSpillCountObjects();
        }
        return ret;
    }

    public long getProactiveSpillCountRecords() {
        Iterator<JobStats> it = this.jobPlan.iterator();
        long ret = 0L;
        while (it.hasNext()) {
            ret += it.next().getProactiveSpillCountRecs();
        }
        return ret;
    }

    public long getBytesWritten() {
        Iterator<JobStats> it = this.jobPlan.iterator();
        long ret = 0L;
        while (it.hasNext()) {
            long n = it.next().getBytesWritten();
            if (n <= 0L) continue;
            ret += n;
        }
        return ret;
    }

    public long getRecordWritten() {
        Iterator<JobStats> it = this.jobPlan.iterator();
        long ret = 0L;
        while (it.hasNext()) {
            long n = it.next().getRecordWrittern();
            if (n <= 0L) continue;
            ret += n;
        }
        return ret;
    }

    public String getHadoopVersion() {
        return ScriptState.get().getHadoopVersion();
    }

    public String getPigVersion() {
        return ScriptState.get().getPigVersion();
    }

    public String getScriptId() {
        return ScriptState.get().getId();
    }

    public String getFeatures() {
        return ScriptState.get().getScriptFeatures();
    }

    public long getDuration() {
        return this.startTime > 0L && this.endTime > 0L ? this.endTime - this.startTime : -1L;
    }

    public int getNumberJobs() {
        return this.jobPlan.size();
    }

    public List<OutputStats> getOutputStats() {
        ArrayList<OutputStats> outputs = new ArrayList<OutputStats>();
        Iterator<JobStats> iter = this.jobPlan.iterator();
        while (iter.hasNext()) {
            for (OutputStats os : iter.next().getOutputs()) {
                outputs.add(os);
            }
        }
        return Collections.unmodifiableList(outputs);
    }

    public List<InputStats> getInputStats() {
        ArrayList<InputStats> inputs = new ArrayList<InputStats>();
        Iterator<JobStats> iter = this.jobPlan.iterator();
        while (iter.hasNext()) {
            for (InputStats is : iter.next().getInputs()) {
                inputs.add(is);
            }
        }
        return Collections.unmodifiableList(inputs);
    }

    private PigStats() {
        this.jobPlan = new JobGraph();
    }

    void start(PigContext pigContext, JobClient jobClient, JobControlCompiler jcc, MROperPlan mrPlan) {
        if (pigContext == null || jobClient == null || jcc == null) {
            LOG.warn((Object)("invalid params: " + pigContext + jobClient + jcc));
            return;
        }
        this.pigContext = pigContext;
        this.jobClient = jobClient;
        this.jcc = jcc;
        try {
            new JobGraphBuilder(mrPlan).visit();
        }
        catch (VisitorException e) {
            LOG.warn((Object)"unable to build job plan", (Throwable)e);
        }
        this.startTime = System.currentTimeMillis();
        this.userId = System.getProperty("user.name");
    }

    void stop() {
        this.endTime = System.currentTimeMillis();
        int m = this.getNumberSuccessfulJobs();
        int n = this.getNumberFailedJobs();
        this.returnCode = n == 0 && m > 0 && m == this.jobPlan.size() ? 0 : (m > 0 && m < this.jobPlan.size() ? 3 : 2);
    }

    boolean isInitialized() {
        return this.startTime > 0L;
    }

    JobClient getJobClient() {
        return this.jobClient;
    }

    JobControlCompiler getJobControlCompiler() {
        return this.jcc;
    }

    void setReturnCode(int returnCode) {
        this.returnCode = returnCode;
    }

    JobStats addJobStats(Job job) {
        MapReduceOper mro = null;
        JobID jobId = job.getAssignedJobID();
        mro = jobId != null ? this.jobMroMap.get(jobId.toString()) : this.jobMroMap.get(job.toString());
        if (mro == null) {
            LOG.warn((Object)("unable to get MR oper for job: " + (jobId == null ? job.toString() : jobId.toString())));
            return null;
        }
        JobStats js = this.mroJobMap.get(mro);
        js.setAlias(mro);
        js.setConf((Configuration)job.getJobConf());
        return js;
    }

    public JobStats addJobStatsForNative(NativeMapReduceOper mr) {
        JobStats js = this.mroJobMap.get(mr);
        js.setId(new JobID(mr.getJobId(), NativeMapReduceOper.getJobNumber()));
        js.setAlias(mr);
        return js;
    }

    void display() {
        List<JobStats> arr;
        if (this.returnCode == -1) {
            LOG.warn((Object)"unknown return code, can't display the results");
            return;
        }
        if (this.pigContext == null) {
            LOG.warn((Object)"unknown exec type, don't display the results");
            return;
        }
        ExecType execType = this.pigContext.getExecType();
        if (execType == ExecType.LOCAL) {
            LOG.info((Object)"Detected Local mode. Stats reported below may be incomplete");
        }
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        StringBuilder sb = new StringBuilder();
        sb.append("\nHadoopVersion\tPigVersion\tUserId\tStartedAt\tFinishedAt\tFeatures\n");
        sb.append(this.getHadoopVersion()).append("\t").append(this.getPigVersion()).append("\t").append(this.userId).append("\t").append(sdf.format(new Date(this.startTime))).append("\t").append(sdf.format(new Date(this.endTime))).append("\t").append(this.getFeatures()).append("\n");
        sb.append("\n");
        if (this.returnCode == 0) {
            sb.append("Success!\n");
        } else if (this.returnCode == 3) {
            sb.append("Some jobs have failed! Stop running all dependent jobs\n");
        } else {
            sb.append("Failed!\n");
        }
        sb.append("\n");
        if (this.returnCode == 0 || this.returnCode == 3) {
            sb.append("Job Stats (time in seconds):\n");
            if (execType == ExecType.LOCAL) {
                sb.append("JobId\tAlias\tFeature\tOutputs").append("\n");
            } else {
                sb.append("JobId\tMaps\tReduces\tMaxMapTime\tMinMapTIme\tAvgMapTime\tMaxReduceTime\tMinReduceTime\tAvgReduceTime\tAlias\tFeature\tOutputs").append("\n");
            }
            arr = this.jobPlan.getSuccessfulJobs();
            for (JobStats js : arr) {
                sb.append(js.getDisplayString(execType == ExecType.LOCAL));
            }
            sb.append("\n");
        }
        if (this.returnCode == 2 || this.returnCode == 3) {
            sb.append("Failed Jobs:\n");
            sb.append("JobId\tAlias\tFeature\tMessage\tOutputs").append("\n");
            arr = this.jobPlan.getFailedJobs();
            for (JobStats js : arr) {
                sb.append(js.getDisplayString(execType == ExecType.LOCAL));
            }
            sb.append("\n");
        }
        sb.append("Input(s):\n");
        for (InputStats is : this.getInputStats()) {
            sb.append(is.getDisplayString(execType == ExecType.LOCAL));
        }
        sb.append("\n");
        sb.append("Output(s):\n");
        for (OutputStats ds : this.getOutputStats()) {
            sb.append(ds.getDisplayString(execType == ExecType.LOCAL));
        }
        if (execType != ExecType.LOCAL) {
            sb.append("\nCounters:\n");
            sb.append("Total records written : " + this.getRecordWritten()).append("\n");
            sb.append("Total bytes written : " + this.getBytesWritten()).append("\n");
            sb.append("Spillable Memory Manager spill count : " + this.getSMMSpillCount()).append("\n");
            sb.append("Total bags proactively spilled: " + this.getProactiveSpillCountObjects()).append("\n");
            sb.append("Total records proactively spilled: " + this.getProactiveSpillCountRecords()).append("\n");
        }
        sb.append("\nJob DAG:\n").append(this.jobPlan.toString());
        LOG.info((Object)("Script Statistics: \n" + sb.toString()));
    }

    void mapMROperToJob(MapReduceOper mro, Job job) {
        if (mro == null) {
            LOG.warn((Object)"null MR operator");
        } else {
            JobStats js = this.mroJobMap.get(mro);
            if (js == null) {
                LOG.warn((Object)("null job stats for mro: " + mro.getOperatorKey()));
            } else {
                JobID id = job.getAssignedJobID();
                js.setId(id);
                if (id != null) {
                    this.jobMroMap.put(id.toString(), mro);
                } else {
                    this.jobMroMap.put(job.toString(), mro);
                }
            }
        }
    }

    void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    void setBackendException(Job job, Exception e) {
        if (e instanceof PigException) {
            LOG.error((Object)("ERROR " + ((PigException)e).getErrorCode() + ": " + e.getLocalizedMessage()));
        } else if (e != null) {
            LOG.error((Object)("ERROR: " + e.getLocalizedMessage()));
        }
        if (job.getAssignedJobID() == null || e == null) {
            LOG.debug((Object)"unable to set backend exception");
            return;
        }
        String id = job.getAssignedJobID().toString();
        for (JobStats js : this.jobPlan) {
            if (!id.equals(js.getJobId())) continue;
            js.setBackendException(e);
            break;
        }
    }

    PigContext getPigContext() {
        return this.pigContext;
    }

    int getNumberSuccessfulJobs() {
        Iterator<JobStats> iter = this.jobPlan.iterator();
        int count = 0;
        while (iter.hasNext()) {
            if (iter.next().getState() != JobStats.JobState.SUCCESS) continue;
            ++count;
        }
        return count;
    }

    int getNumberFailedJobs() {
        Iterator<JobStats> iter = this.jobPlan.iterator();
        int count = 0;
        while (iter.hasNext()) {
            if (iter.next().getState() != JobStats.JobState.FAILED) continue;
            ++count;
        }
        return count;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JobComparator
    implements Comparator<JobStats> {
        private JobComparator() {
        }

        @Override
        public int compare(JobStats o1, JobStats o2) {
            return o1.getJobId().compareTo(o2.getJobId());
        }
    }

    static class JobGraphPrinter
    extends PlanVisitor {
        StringBuffer buf = new StringBuffer();

        protected JobGraphPrinter(OperatorPlan plan) {
            super(plan, new DependencyOrderWalker(plan));
        }

        public void visit(JobStats op) throws FrontendException {
            this.buf.append(op.getJobId());
            List<Operator> succs = this.plan.getSuccessors(op);
            if (succs != null) {
                this.buf.append("\t->\t");
                for (Operator p : succs) {
                    this.buf.append(((JobStats)p).getJobId()).append(",");
                }
            }
            this.buf.append("\n");
        }

        public String toString() {
            this.buf.append("\n");
            return this.buf.toString();
        }
    }

    private class JobGraphBuilder
    extends MROpPlanVisitor {
        public JobGraphBuilder(MROperPlan plan) {
            super(plan, (PlanWalker<MapReduceOper, MROperPlan>)new org.apache.pig.impl.plan.DependencyOrderWalker<MapReduceOper, MROperPlan>(plan));
            PigStats.this.jobPlan = new JobGraph();
            PigStats.this.mroJobMap = new HashMap();
        }

        public void visitMROp(MapReduceOper mr) throws VisitorException {
            JobStats js = new JobStats(mr.getOperatorKey().toString(), PigStats.this.jobPlan);
            PigStats.this.jobPlan.add(js);
            List<MapReduceOper> preds = ((MROperPlan)this.getPlan()).getPredecessors(mr);
            if (preds != null) {
                for (MapReduceOper pred : preds) {
                    JobStats jpred = (JobStats)PigStats.this.mroJobMap.get(pred);
                    if (PigStats.this.jobPlan.isConnected(jpred, js)) continue;
                    PigStats.this.jobPlan.connect(jpred, js);
                }
            }
            PigStats.this.mroJobMap.put(mr, js);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class JobGraph
    extends BaseOperatorPlan
    implements Iterable<JobStats> {
        @Override
        public String toString() {
            JobGraphPrinter jp = new JobGraphPrinter(this);
            try {
                jp.visit();
            }
            catch (FrontendException e) {
                LOG.warn((Object)"unable to print job plan", (Throwable)e);
            }
            return jp.toString();
        }

        @Override
        public Iterator<JobStats> iterator() {
            return new Iterator<JobStats>(){
                private Iterator<Operator> iter;
                {
                    this.iter = JobGraph.this.getOperators();
                }

                @Override
                public boolean hasNext() {
                    return this.iter.hasNext();
                }

                @Override
                public JobStats next() {
                    return (JobStats)this.iter.next();
                }

                @Override
                public void remove() {
                }
            };
        }

        boolean isConnected(Operator from, Operator to) {
            List<Operator> succs = null;
            succs = this.getSuccessors(from);
            if (succs != null) {
                for (Operator succ : succs) {
                    if (!succ.getName().equals(to.getName()) && !this.isConnected(succ, to)) continue;
                    return true;
                }
            }
            return false;
        }

        List<JobStats> getSuccessfulJobs() {
            ArrayList<JobStats> lst = new ArrayList<JobStats>();
            for (JobStats js : this) {
                if (js.getState() != JobStats.JobState.SUCCESS) continue;
                lst.add(js);
            }
            Collections.sort(lst, new JobComparator());
            return lst;
        }

        List<JobStats> getFailedJobs() {
            ArrayList<JobStats> lst = new ArrayList<JobStats>();
            for (JobStats js : this) {
                if (js.getState() != JobStats.JobState.FAILED) continue;
                lst.add(js);
            }
            return lst;
        }
    }
}

