/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.toc;

import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.ResourceBundleFactory;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class DataPassingDataFactory
implements DataFactory,
Cloneable {
    private String queryName;
    private WrapperDataModel dataModel;

    public DataPassingDataFactory(String queryName) {
        if (queryName == null) {
            throw new NullPointerException();
        }
        this.queryName = queryName;
        this.dataModel = new WrapperDataModel();
    }

    public void open() throws ReportDataFactoryException {
    }

    public void cancelRunningQuery() {
    }

    public TableModel queryData(String query, DataRow parameters) throws ReportDataFactoryException {
        if (!this.queryName.equals(query)) {
            throw new ReportDataFactoryException("No such query");
        }
        Object o = parameters.get(query);
        if (o instanceof TableModel) {
            this.dataModel.setModel((TableModel)o);
        }
        return this.dataModel;
    }

    public DataFactory derive() {
        return (DataFactory)this.clone();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException();
        }
    }

    public void close() {
    }

    public boolean isQueryExecutable(String query, DataRow parameters) {
        return this.queryName.equals(query);
    }

    public String[] getQueryNames() {
        return new String[]{this.queryName};
    }

    public void initialize(Configuration configuration, ResourceManager resourceManager, ResourceKey contextKey, ResourceBundleFactory resourceBundleFactory) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WrapperDataModel
    implements TableModel {
        private TableModel model = new DefaultTableModel();

        private WrapperDataModel() {
        }

        public TableModel getModel() {
            return this.model;
        }

        public void setModel(TableModel model) {
            this.model = model;
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
            this.model.addTableModelListener(l);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return this.model.getColumnClass(columnIndex);
        }

        @Override
        public int getColumnCount() {
            return this.model.getColumnCount();
        }

        @Override
        public String getColumnName(int columnIndex) {
            return this.model.getColumnName(columnIndex);
        }

        @Override
        public int getRowCount() {
            return this.model.getRowCount();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.model.getValueAt(rowIndex, columnIndex);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return this.model.isCellEditable(rowIndex, columnIndex);
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
            this.model.removeTableModelListener(l);
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            this.model.setValueAt(aValue, rowIndex, columnIndex);
        }
    }
}

