/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.jute.BinaryInputArchive;
import org.apache.jute.Record;
import org.apache.zookeeper.server.ObserverBean;
import org.apache.zookeeper.server.Request;
import org.apache.zookeeper.server.quorum.Learner;
import org.apache.zookeeper.server.quorum.ObserverZooKeeperServer;
import org.apache.zookeeper.server.quorum.QuorumPacket;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.util.SerializeUtils;
import org.apache.zookeeper.txn.TxnHeader;

public class Observer
extends Learner {
    Observer(QuorumPeer self, ObserverZooKeeperServer observerZooKeeperServer) {
        this.self = self;
        this.zk = observerZooKeeperServer;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Observer ").append(this.sock);
        sb.append(" pendingRevalidationCount:").append(this.pendingRevalidations.size());
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void observeLeader() throws InterruptedException {
        this.zk.registerJMX(new ObserverBean(this, this.zk), this.self.jmxLocalPeerBean);
        try {
            InetSocketAddress addr = this.findLeader();
            LOG.info((Object)("Observing " + addr));
            try {
                this.connectToLeader(addr);
                long newLeaderZxid = this.registerWithLeader(16);
                this.syncWithLeader(newLeaderZxid);
                QuorumPacket qp = new QuorumPacket();
                while (this.self.isRunning()) {
                    this.readPacket(qp);
                    this.processPacket(qp);
                }
            }
            catch (IOException e) {
                LOG.warn((Object)"Exception when observing the leader", (Throwable)e);
                try {
                    this.sock.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                ConcurrentHashMap concurrentHashMap = this.pendingRevalidations;
                synchronized (concurrentHashMap) {
                    this.pendingRevalidations.clear();
                    this.pendingRevalidations.notifyAll();
                }
            }
        }
        finally {
            this.zk.unregisterJMX(this);
        }
    }

    protected void processPacket(QuorumPacket qp) throws IOException {
        switch (qp.getType()) {
            case 5: {
                this.ping(qp);
                break;
            }
            case 2: {
                LOG.warn((Object)"Ignoring proposal");
                break;
            }
            case 4: {
                LOG.warn((Object)"Ignoring commit");
                break;
            }
            case 12: {
                this.zk.takeSnapshot();
                this.self.cnxnFactory.setZooKeeperServer(this.zk);
                break;
            }
            case 6: {
                this.revalidate(qp);
                break;
            }
            case 7: {
                ((ObserverZooKeeperServer)this.zk).sync();
                break;
            }
            case 8: {
                TxnHeader hdr = new TxnHeader();
                BinaryInputArchive ia = BinaryInputArchive.getArchive(new ByteArrayInputStream(qp.getData()));
                Record txn = SerializeUtils.deserializeTxn(ia, hdr);
                Request request = new Request(null, hdr.getClientId(), hdr.getCxid(), hdr.getType(), null, null);
                request.txn = txn;
                request.hdr = hdr;
                ObserverZooKeeperServer obs = (ObserverZooKeeperServer)this.zk;
                obs.commitRequest(request);
            }
        }
    }

    public void shutdown() {
        LOG.info((Object)"shutdown called", (Throwable)new Exception("shutdown Observer"));
        super.shutdown();
    }
}

