/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.sco.simple;

import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.jdo.spi.PersistenceCapable;
import org.datanucleus.ObjectManagerFactoryImpl;
import org.datanucleus.StateManager;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.sco.SCOList;
import org.datanucleus.sco.SCOListIterator;
import org.datanucleus.sco.SCOUtils;
import org.datanucleus.state.FetchPlanState;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public class LinkedList
extends java.util.LinkedList
implements SCOList,
Cloneable {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ObjectManagerFactoryImpl.class.getClassLoader());
    protected transient Object owner;
    protected transient StateManager ownerSM;
    protected transient String fieldName;
    protected transient int fieldNumber;
    protected java.util.LinkedList delegate;

    public LinkedList(StateManager ownerSM, String fieldName) {
        this.ownerSM = ownerSM;
        this.owner = ownerSM.getObject();
        this.fieldName = fieldName;
        if (ownerSM != null) {
            this.fieldNumber = ownerSM.getClassMetaData().getMetaDataForMember(fieldName).getAbsoluteFieldNumber();
        }
    }

    public void initialise(Object o, boolean forInsert, boolean forUpdate) {
        Collection c = (Collection)o;
        this.delegate = c != null ? new java.util.LinkedList(c) : new java.util.LinkedList();
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("023003", (Object)StringUtils.toJVMIDString(this.ownerSM.getObject()), (Object)this.fieldName, (Object)("" + this.size()), (Object)SCOUtils.getSCOWrapperOptionsMessage(true, false, true, false)));
        }
    }

    public void initialise() {
        this.delegate = new java.util.LinkedList();
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(LOCALISER.msg("023003", (Object)StringUtils.toJVMIDString(this.ownerSM.getObject()), (Object)this.fieldName, (Object)("" + this.size()), (Object)SCOUtils.getSCOWrapperOptionsMessage(true, false, true, false)));
        }
    }

    public Object getValue() {
        return this.delegate;
    }

    public void load() {
    }

    public boolean isLoaded() {
        return true;
    }

    public void flush() {
    }

    public void updateEmbeddedElement(Object element, int fieldNumber, Object value) {
        this.makeDirty();
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public Object getOwner() {
        return this.ownerSM != null ? this.ownerSM.getObject() : null;
    }

    public synchronized void unsetOwner() {
        if (this.ownerSM != null) {
            this.ownerSM = null;
        }
    }

    public void makeDirty() {
        if (this.owner != null) {
            ((PersistenceCapable)this.owner).jdoMakeDirty(this.fieldName);
        }
    }

    public Object detachCopy(FetchPlanState state) {
        java.util.LinkedList detached = new java.util.LinkedList();
        SCOUtils.detachCopyForCollection(this.ownerSM, this.toArray(), state, detached);
        return detached;
    }

    public void attachCopy(Object value) {
        Collection c = (Collection)value;
        AbstractMemberMetaData fmd = this.ownerSM.getClassMetaData().getMetaDataForMember(this.fieldName);
        boolean elementsWithoutIdentity = SCOUtils.collectionHasElementsWithoutIdentity(fmd);
        ArrayList attachedElements = new ArrayList(c.size());
        SCOUtils.attachCopyForCollection(this.ownerSM, c.toArray(), attachedElements, elementsWithoutIdentity);
        SCOUtils.updateListWithListElements(this, attachedElements);
    }

    public Object clone() {
        return this.delegate.clone();
    }

    public boolean contains(Object element) {
        return this.delegate.contains(element);
    }

    public synchronized boolean containsAll(Collection c) {
        return this.delegate.containsAll(c);
    }

    public synchronized boolean equals(Object o) {
        return this.delegate.equals(o);
    }

    public Object get(int index) {
        return this.delegate.get(index);
    }

    public Object getFirst() {
        return this.delegate.getFirst();
    }

    public Object getLast() {
        return this.delegate.getLast();
    }

    public synchronized int hashCode() {
        return this.delegate.hashCode();
    }

    public int indexOf(Object element) {
        return this.delegate.indexOf(element);
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public Iterator iterator() {
        return new SCOListIterator(this, this.ownerSM, this.delegate, null, true, -1);
    }

    public ListIterator listIterator(int index) {
        return new SCOListIterator(this, this.ownerSM, this.delegate, null, true, index);
    }

    public int lastIndexOf(Object element) {
        return this.delegate.lastIndexOf(element);
    }

    public int size() {
        return this.delegate.size();
    }

    public synchronized List subList(int from, int to) {
        return this.delegate.subList(from, to);
    }

    public synchronized Object[] toArray() {
        return this.delegate.toArray();
    }

    public synchronized Object[] toArray(Object[] a) {
        return this.delegate.toArray(a);
    }

    public void add(int index, Object element) {
        this.delegate.add(index, element);
        this.makeDirty();
    }

    public boolean add(Object element) {
        boolean success = this.delegate.add(element);
        if (success) {
            this.makeDirty();
        }
        return success;
    }

    public boolean addAll(Collection elements) {
        boolean success = this.delegate.addAll(elements);
        if (success) {
            this.makeDirty();
        }
        return success;
    }

    public boolean addAll(int index, Collection elements) {
        boolean success = this.delegate.addAll(index, elements);
        if (success) {
            this.makeDirty();
        }
        return success;
    }

    public void addFirst(Object element) {
        this.delegate.addFirst(element);
        this.makeDirty();
    }

    public void addLast(Object element) {
        this.delegate.addLast(element);
        this.makeDirty();
    }

    public synchronized void clear() {
        this.delegate.clear();
        this.makeDirty();
    }

    public Object remove(int index) {
        Object obj = this.delegate.remove(index);
        this.makeDirty();
        return obj;
    }

    public synchronized boolean remove(Object element) {
        return this.remove(element, true);
    }

    public synchronized boolean remove(Object element, boolean allowCascadeDelete) {
        boolean success = this.delegate.remove(element);
        if (success) {
            this.makeDirty();
        }
        return success;
    }

    public boolean removeAll(Collection elements) {
        boolean success = this.delegate.removeAll(elements);
        if (success) {
            this.makeDirty();
        }
        return success;
    }

    public Object removeFirst() {
        Object obj = this.delegate.removeFirst();
        this.makeDirty();
        return obj;
    }

    public Object removeLast() {
        Object obj = this.delegate.removeLast();
        this.makeDirty();
        return obj;
    }

    public synchronized boolean retainAll(Collection c) {
        boolean success = this.delegate.retainAll(c);
        if (success) {
            this.makeDirty();
        }
        return success;
    }

    public Object set(int index, Object element, boolean allowDependentField) {
        Object obj = this.delegate.set(index, element);
        this.makeDirty();
        return obj;
    }

    public Object set(int index, Object element) {
        return this.set(index, element, true);
    }

    protected Object writeReplace() throws ObjectStreamException {
        return new java.util.LinkedList(this.delegate);
    }
}

