/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.agilebi.modeler;

import java.util.Collections;
import java.util.Map;
import org.pentaho.agilebi.modeler.ColumnBackedNode;
import org.pentaho.agilebi.modeler.IDropTarget;
import org.pentaho.agilebi.modeler.ModelerException;
import org.pentaho.agilebi.modeler.ModelerMessagesHolder;
import org.pentaho.agilebi.modeler.ModelerWorkspace;
import org.pentaho.agilebi.modeler.nodes.AbstractMetaDataModelNode;
import org.pentaho.agilebi.modeler.propforms.ModelerNodePropertiesForm;
import org.pentaho.metadata.model.LogicalColumn;
import org.pentaho.metadata.model.LogicalTable;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulEventSourceAdapter;
import org.pentaho.ui.xul.components.XulConfirmBox;
import org.pentaho.ui.xul.containers.XulDeck;
import org.pentaho.ui.xul.dnd.DropEvent;
import org.pentaho.ui.xul.dom.Document;
import org.pentaho.ui.xul.stereotype.Bindable;
import org.pentaho.ui.xul.util.AbstractModelNode;
import org.pentaho.ui.xul.util.XulDialogCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ModelerTreeHelper
extends XulEventSourceAdapter {
    private transient Object selectedTreeItem;
    private Map<Class<? extends ModelerNodePropertiesForm>, ModelerNodePropertiesForm> propertiesForms;
    private ModelerNodePropertiesForm selectedForm;
    private XulDeck propsDeck;
    protected ModelerWorkspace workspace;
    private Document document;

    public ModelerTreeHelper() {
    }

    public ModelerTreeHelper(Map<Class<? extends ModelerNodePropertiesForm>, ModelerNodePropertiesForm> propertiesForms, XulDeck propsDeck, ModelerWorkspace workspace, Document document) {
        this.propertiesForms = propertiesForms;
        this.propsDeck = propsDeck;
        this.workspace = workspace;
        this.document = document;
    }

    @Bindable
    public Object getSelectedTreeItem() {
        return this.selectedTreeItem;
    }

    @Bindable
    public void setSelectedTreeItem(Object selectedTreeItem) {
        this.selectedTreeItem = selectedTreeItem;
    }

    @Bindable
    public void setTreeSelectionChanged(Object selection) {
        AbstractMetaDataModelNode node;
        ModelerNodePropertiesForm form;
        this.setSelectedTreeItem(selection);
        if (selection != null && selection instanceof AbstractMetaDataModelNode && (form = this.propertiesForms.get((node = (AbstractMetaDataModelNode)selection).getPropertiesForm())) != null) {
            if (this.selectedForm != null && this.selectedForm != form) {
                this.selectedForm.setObject(null);
            }
            form.activate((AbstractMetaDataModelNode)selection);
            this.selectedForm = form;
            return;
        }
        if (this.propsDeck != null) {
            this.propsDeck.setSelectedIndex(0);
        }
    }

    @Bindable
    public void moveFieldUp() {
        if (this.selectedTreeItem == null) {
            return;
        }
        ((AbstractModelNode)this.selectedTreeItem).getParent().moveChildUp(this.selectedTreeItem);
    }

    @Bindable
    public void moveFieldDown() {
        if (this.selectedTreeItem == null) {
            return;
        }
        ((AbstractModelNode)this.selectedTreeItem).getParent().moveChildDown(this.selectedTreeItem);
    }

    @Bindable
    public void removeField() {
        ((AbstractModelNode)this.selectedTreeItem).getParent().remove(this.selectedTreeItem);
        this.setTreeSelectionChanged(null);
    }

    @Bindable
    public void clearFields() {
        try {
            XulConfirmBox confirm = (XulConfirmBox)this.document.createElement("confirmbox");
            confirm.setTitle(ModelerMessagesHolder.getMessages().getString("clear_model_title", new String[0]));
            confirm.setMessage(ModelerMessagesHolder.getMessages().getString("clear_model_msg", new String[0]));
            confirm.setAcceptLabel(ModelerMessagesHolder.getMessages().getString("yes", new String[0]));
            confirm.setCancelLabel(ModelerMessagesHolder.getMessages().getString("no", new String[0]));
            confirm.addDialogCallback(new XulDialogCallback(){

                public void onClose(XulComponent sender, XulDialogCallback.Status returnCode, Object retVal) {
                    if (returnCode == XulDialogCallback.Status.ACCEPT) {
                        ModelerTreeHelper.this.clearTreeModel();
                    }
                }

                public void onError(XulComponent sender, Throwable t) {
                }
            });
            confirm.open();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Bindable
    public abstract void clearTreeModel();

    public void addField(Object[] selectedFields) throws ModelerException {
        try {
            IDropTarget dropNode = (IDropTarget)this.getSelectedTreeItem();
            for (Object selectedField : selectedFields) {
                AbstractModelNode newNode = (AbstractModelNode)dropNode.onDrop(selectedField);
                ((AbstractModelNode)dropNode).add((Object)newNode);
            }
        }
        catch (IllegalStateException e) {
            throw new ModelerException(e);
        }
    }

    public Map<Class<? extends ModelerNodePropertiesForm>, ModelerNodePropertiesForm> getPropertiesForms() {
        return this.propertiesForms;
    }

    public void setPropertiesForms(Map<Class<? extends ModelerNodePropertiesForm>, ModelerNodePropertiesForm> propertiesForms) {
        this.propertiesForms = propertiesForms;
    }

    public ModelerNodePropertiesForm getSelectedForm() {
        return this.selectedForm;
    }

    public void setSelectedForm(ModelerNodePropertiesForm selectedForm) {
        this.selectedForm = selectedForm;
    }

    public XulDeck getPropsDeck() {
        return this.propsDeck;
    }

    public void setPropsDeck(XulDeck propsDeck) {
        this.propsDeck = propsDeck;
    }

    public ModelerWorkspace getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(ModelerWorkspace workspace) {
        this.workspace = workspace;
    }

    public Document getDocument() {
        return this.document;
    }

    public void setDocument(Document document) {
        this.document = document;
    }

    protected void removeLogicalColumnFromParentTable(ColumnBackedNode node) {
        LogicalColumn lCol = node.getLogicalColumn();
        if (lCol != null && lCol.getLogicalTable() != null) {
            LogicalTable lTab = lCol.getLogicalTable();
            lTab.getLogicalColumns().remove(lCol);
        }
    }

    public void onModelDrop(DropEvent event) throws ModelerException {
        boolean prevChangeState = this.isModelChanging();
        IDropTarget dropNode = (IDropTarget)event.getDropParent();
        Object newData = null;
        for (Object data : event.getDataTransfer().getData()) {
            newData = dropNode.onDrop(data);
        }
        if (newData == null) {
            event.setAccepted(false);
        } else {
            event.getDataTransfer().setData(Collections.singletonList(newData));
        }
    }

    protected abstract boolean isModelChanging();

    protected abstract void setModelIsChanging(boolean var1);
}

