/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.agilebi.modeler.nodes;

import java.io.Serializable;
import java.util.HashMap;
import org.pentaho.agilebi.modeler.ModelerException;
import org.pentaho.agilebi.modeler.ModelerMessagesHolder;
import org.pentaho.agilebi.modeler.nodes.AbstractMetaDataModelNode;
import org.pentaho.agilebi.modeler.nodes.AvailableField;
import org.pentaho.agilebi.modeler.nodes.FieldMetaData;
import org.pentaho.agilebi.modeler.propforms.CategoryPropertiesForm;
import org.pentaho.agilebi.modeler.propforms.ModelerNodePropertiesForm;
import org.pentaho.ui.xul.stereotype.Bindable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CategoryMetaData
extends AbstractMetaDataModelNode<FieldMetaData>
implements Serializable {
    private static final String IMAGE = "images/sm_folder_icon.png";
    private static final long serialVersionUID = 7879805619425103630L;
    String name;

    public CategoryMetaData() {
    }

    public CategoryMetaData(String name) {
        this.name = name;
    }

    @Bindable
    public String getName() {
        return this.name;
    }

    @Bindable
    public String getDisplayName() {
        return this.getName();
    }

    @Bindable
    public void setName(String name) {
        if (!name.equals(this.name)) {
            String oldName = this.name;
            this.name = name;
            this.firePropertyChange("name", oldName, name);
            this.firePropertyChange("displayName", oldName, name);
            this.validateNode();
        }
    }

    @Override
    public String getValidImage() {
        return IMAGE;
    }

    @Override
    public void validate() {
        boolean prevValid = this.valid;
        this.valid = true;
        this.validationMessages.clear();
        if (this.children.size() == 0) {
            this.valid = false;
            this.validationMessages.add(ModelerMessagesHolder.getMessages().getString("validation.category.REQUIRES_AT_LEAST_ONE_FIELD", new String[0]));
        }
        HashMap<String, FieldMetaData> usedNames = new HashMap<String, FieldMetaData>();
        for (FieldMetaData child : this.children) {
            this.valid &= child.isValid();
            this.validationMessages.addAll(child.getValidationMessages());
            if (usedNames.containsKey(child.getName())) {
                FieldMetaData dupe;
                this.valid = false;
                String dupeString = ModelerMessagesHolder.getMessages().getString("validation.category.DUPLICATE_FIELD_NAMES", child.getName());
                this.validationMessages.add(dupeString);
                child.invalidate();
                if (!child.getValidationMessages().contains(dupeString)) {
                    child.getValidationMessages().add(dupeString);
                }
                if (!(dupe = (FieldMetaData)usedNames.get(child.getName())).isValid()) continue;
                dupe.invalidate();
                if (dupe.getValidationMessages().contains(dupeString)) continue;
                dupe.getValidationMessages().add(dupeString);
                continue;
            }
            usedNames.put(child.getName(), child);
        }
        if (!this.suppressEvents) {
            this.firePropertyChange("valid", null, this.valid);
        }
    }

    @Override
    public Class<? extends ModelerNodePropertiesForm> getPropertiesForm() {
        return CategoryPropertiesForm.class;
    }

    @Bindable
    public boolean isUiExpanded() {
        return true;
    }

    @Bindable
    public boolean isEditingDisabled() {
        return false;
    }

    @Override
    public void onAdd(FieldMetaData child) {
        child.addPropertyChangeListener("name", this.nameListener);
        child.addPropertyChangeListener("valid", this.validListener);
        child.addPropertyChangeListener("children", this.childrenListener);
        this.validateNode();
    }

    @Override
    public void onRemove(FieldMetaData child) {
        child.removePropertyChangeListener(this.validListener);
        child.removePropertyChangeListener(this.nameListener);
        child.removePropertyChangeListener(this.childrenListener);
        this.validateNode();
    }

    @Override
    public boolean acceptsDrop(Object obj) {
        return obj instanceof AvailableField || obj instanceof FieldMetaData;
    }

    @Override
    public Object onDrop(Object data) throws ModelerException {
        try {
            if (data instanceof AvailableField) {
                AvailableField field = (AvailableField)data;
                return this.getWorkspace().createFieldForParentWithNode(this, field);
            }
            if (data instanceof FieldMetaData) {
                ((FieldMetaData)data).setParent(this);
                return data;
            }
            throw new IllegalArgumentException(ModelerMessagesHolder.getMessages().getString("invalid_drop", new String[0]));
        }
        catch (Exception e) {
            throw new ModelerException(e);
        }
    }
}

