/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.agilebi.modeler.propforms;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.pentaho.agilebi.modeler.ModelerMessagesHolder;
import org.pentaho.agilebi.modeler.ModelerWorkspace;
import org.pentaho.agilebi.modeler.geo.GeoRole;
import org.pentaho.agilebi.modeler.nodes.BaseColumnBackedMetaData;
import org.pentaho.agilebi.modeler.propforms.AbstractModelerNodeForm;
import org.pentaho.metadata.model.LogicalColumn;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.components.XulButton;
import org.pentaho.ui.xul.components.XulLabel;
import org.pentaho.ui.xul.components.XulMenuList;
import org.pentaho.ui.xul.components.XulTextbox;
import org.pentaho.ui.xul.containers.XulVbox;
import org.pentaho.ui.xul.stereotype.Bindable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LevelsPropertiesForm
extends AbstractModelerNodeForm<BaseColumnBackedMetaData> {
    protected XulTextbox name;
    protected XulLabel sourceLabel;
    protected XulLabel level_message_label;
    protected XulVbox messageBox;
    protected String colName;
    protected String locale;
    protected XulButton messageBtn;
    protected XulMenuList geoList;
    protected List<GeoRole> geoRoles = new ArrayList<GeoRole>();
    protected GeoRole selectedGeoRole;
    protected GeoRole dummyGeoRole = new GeoRole(ModelerMessagesHolder.getMessages().getString("none", new String[0]), Collections.<String>emptyList());
    protected PropertyChangeListener validListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            if (!evt.getPropertyName().equals("valid") && !evt.getPropertyName().equals("logicalColumn")) {
                return;
            }
            LevelsPropertiesForm.this.showValidations();
        }
    };

    public LevelsPropertiesForm(String panelId, String locale) {
        super(panelId);
        this.locale = locale;
    }

    public LevelsPropertiesForm(String locale) {
        this("levelprops", locale);
    }

    @Override
    public void setObject(BaseColumnBackedMetaData dim) {
        if (this.getNode() != null) {
            ((BaseColumnBackedMetaData)this.getNode()).removePropertyChangeListener(this.validListener);
        }
        this.setNode(dim);
        if (dim == null) {
            return;
        }
        ((BaseColumnBackedMetaData)this.getNode()).addPropertyChangeListener(this.validListener);
        this.name.setValue(dim.getName());
        this.setColumnName(dim.getLogicalColumn());
        this.setSelectedGeoRole((GeoRole)dim.getMemberAnnotations().get("Geo.Role"));
        if (this.selectedGeoRole == null) {
            this.setSelectedGeoRole(this.dummyGeoRole);
        }
        this.showValidations();
    }

    protected void showValidations() {
        if (this.getNode() == null) {
            return;
        }
        this.setNotValid(!((BaseColumnBackedMetaData)this.getNode()).isValid());
        this.setBackingColumnAvailable(((BaseColumnBackedMetaData)this.getNode()).getLogicalColumn() != null);
        this.setColumnName(((BaseColumnBackedMetaData)this.getNode()).getLogicalColumn());
        this.messageBox.setVisible(((BaseColumnBackedMetaData)this.getNode()).getValidationMessages().size() > 0);
        this.setValidMessages(((BaseColumnBackedMetaData)this.getNode()).getValidationMessagesString());
    }

    @Override
    public void init(ModelerWorkspace workspace) {
        super.init(workspace);
        this.bf.createBinding((Object)this, "notValid", "level_message", "visible", new BindingConvertor[0]);
        this.name = (XulTextbox)this.document.getElementById("level_name");
        this.sourceLabel = (XulLabel)this.document.getElementById("level_source_col");
        this.level_message_label = (XulLabel)this.document.getElementById("level_message_label");
        this.messageBox = (XulVbox)this.document.getElementById("level_message");
        this.bf.createBinding((Object)this, "backingColumnAvailable", "fixLevelColumnsBtn", "!visible", new BindingConvertor[0]);
        this.bf.createBinding((Object)this, "columnName", (Object)this.sourceLabel, "value", new BindingConvertor[0]);
        this.bf.createBinding((Object)this, "name", (Object)this.name, "value", new BindingConvertor[0]);
        this.bf.createBinding((Object)this, "validMessages", (Object)this.level_message_label, "value", new BindingConvertor[]{validMsgTruncatedBinding});
        this.messageBtn = (XulButton)this.document.getElementById("level_message_btn");
        this.bf.createBinding((Object)this, "validMessages", (Object)this.messageBtn, "visible", new BindingConvertor[]{showMsgBinding});
        this.geoList = (XulMenuList)this.document.getElementById("level_geo_role");
        this.geoRoles.clear();
        this.geoRoles.add(this.dummyGeoRole);
        this.geoRoles.addAll((Collection<GeoRole>)((Object)workspace.getGeoContext()));
        this.geoList.setElements(this.geoRoles);
        this.bf.createBinding((Object)this.geoList, "selectedItem", (Object)this, "selectedGeoRole", new BindingConvertor[0]);
    }

    @Bindable
    public void setColumnName(LogicalColumn col) {
        String prevName = this.colName;
        this.colName = col != null && col.getPhysicalColumn() != null ? col.getPhysicalColumn().getName(this.locale) : "";
        this.firePropertyChange("columnName", prevName, this.colName);
    }

    @Bindable
    public String getColumnName() {
        return this.colName;
    }

    @Bindable
    public void setName(String name) {
        if (this.getNode() != null) {
            ((BaseColumnBackedMetaData)this.getNode()).setName(name);
        }
        this.name.setValue(name);
    }

    @Bindable
    public String getName() {
        if (this.getNode() == null) {
            return null;
        }
        return ((BaseColumnBackedMetaData)this.getNode()).getName();
    }

    @Bindable
    public boolean isNotValid() {
        if (this.getNode() != null) {
            return !((BaseColumnBackedMetaData)this.getNode()).isValid();
        }
        return false;
    }

    @Bindable
    public void setNotValid(boolean notValid) {
        this.firePropertyChange("notValid", null, notValid);
    }

    @Bindable
    public boolean isBackingColumnAvailable() {
        if (this.getNode() != null) {
            return ((BaseColumnBackedMetaData)this.getNode()).getLogicalColumn() != null;
        }
        return false;
    }

    @Bindable
    public void setBackingColumnAvailable(boolean available) {
        this.firePropertyChange("backingColumnAvailable", null, available);
    }

    @Override
    public String getValidMessages() {
        if (this.getNode() != null) {
            return ((BaseColumnBackedMetaData)this.getNode()).getValidationMessagesString();
        }
        return null;
    }

    @Bindable
    public GeoRole getSelectedGeoRole() {
        return this.selectedGeoRole;
    }

    @Bindable
    public void setSelectedGeoRole(GeoRole selectedGeoRole) {
        GeoRole prevVal = this.selectedGeoRole;
        this.selectedGeoRole = selectedGeoRole;
        if (selectedGeoRole != null && selectedGeoRole != this.dummyGeoRole) {
            ((BaseColumnBackedMetaData)this.getNode()).getMemberAnnotations().put("Geo.Role", selectedGeoRole);
            ((BaseColumnBackedMetaData)this.getNode()).getMemberAnnotations().put("Data.Role", selectedGeoRole);
        } else {
            ((BaseColumnBackedMetaData)this.getNode()).getMemberAnnotations().remove("Data.Role");
            ((BaseColumnBackedMetaData)this.getNode()).getMemberAnnotations().remove("Geo.Role");
        }
        ((BaseColumnBackedMetaData)this.getNode()).validateNode();
        this.showValidations();
        this.firePropertyChange("selectedGeoRole", prevVal, selectedGeoRole);
    }
}

