/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.agilebi.modeler.util;

import java.util.HashMap;
import java.util.Map;
import org.pentaho.agilebi.modeler.IModelerSource;
import org.pentaho.agilebi.modeler.util.TableModelerSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelerSourceFactory {
    private static Map<String, Class<? extends IModelerSource>> outputSources = new HashMap<String, Class<? extends IModelerSource>>();
    private static Logger logger;

    public static void registerSourceType(String id, Class<? extends IModelerSource> clazz) {
        outputSources.put(id, clazz);
    }

    public static IModelerSource generateSource(String type) {
        Class<? extends IModelerSource> clz = outputSources.get(type);
        if (clz == null) {
            throw new IllegalArgumentException("Cannot find IModelerSoruce for type: " + type);
        }
        IModelerSource instance = null;
        try {
            instance = clz.newInstance();
        }
        catch (InstantiationException e) {
            logger.error("Error generating modeler source", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error("Error generating modeler source", (Throwable)e);
        }
        return instance;
    }

    static {
        outputSources.put(TableModelerSource.SOURCE_TYPE, TableModelerSource.class);
        logger = LoggerFactory.getLogger(ModelerSourceFactory.class);
    }
}

