/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.commons.util.repository.type;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.List;
import org.pentaho.commons.util.repository.type.AllowableActions;
import org.pentaho.commons.util.repository.type.CmisObject;
import org.pentaho.commons.util.repository.type.CmisProperties;
import org.pentaho.commons.util.repository.type.CmisProperty;
import org.pentaho.commons.util.repository.type.PropertyType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmisObjectImpl
implements CmisObject {
    private CmisProperties properties;
    private AllowableActions allowableActions;
    private List<CmisObject> relationship;
    private List<CmisObject> child;

    @Override
    public CmisProperties getProperties() {
        return this.properties;
    }

    @Override
    public void setProperties(CmisProperties properties) {
        this.properties = properties;
    }

    @Override
    public AllowableActions getAllowableActions() {
        return this.allowableActions;
    }

    @Override
    public void setAllowableActions(AllowableActions allowableActions) {
        this.allowableActions = allowableActions;
    }

    @Override
    public List<CmisObject> getRelationship() {
        return this.relationship;
    }

    @Override
    public void setRelationship(List<CmisObject> relationship) {
        this.relationship = relationship;
    }

    @Override
    public List<CmisObject> getChild() {
        return this.child;
    }

    @Override
    public void setChild(List<CmisObject> child) {
        this.child = child;
    }

    @Override
    public String findStringProperty(String name, String defaultValue) {
        CmisProperty property = this.findProperty(name, new PropertyType("string"));
        if (property == null) {
            return defaultValue;
        }
        return (String)property.getValue();
    }

    @Override
    public Boolean findBooleanProperty(String name, boolean defaultValue) {
        CmisProperty property = this.findProperty(name, new PropertyType("boolean"));
        if (property == null) {
            return defaultValue;
        }
        return (Boolean)property.getValue();
    }

    @Override
    public Calendar findDateTimeProperty(String name, Calendar defaultValue) {
        CmisProperty property = this.findProperty(name, new PropertyType("datetime"));
        if (property == null) {
            return defaultValue;
        }
        return (Calendar)property.getValue();
    }

    @Override
    public BigDecimal findDecimalProperty(String name, BigDecimal defaultValue) {
        CmisProperty property = this.findProperty(name, new PropertyType("decimal"));
        if (property == null) {
            return defaultValue;
        }
        return (BigDecimal)property.getValue();
    }

    @Override
    public String findHtmlProperty(String name, String defaultValue) {
        CmisProperty property = this.findProperty(name, new PropertyType("html"));
        if (property == null) {
            return defaultValue;
        }
        return (String)property.getValue();
    }

    @Override
    public String findIdProperty(String name, String defaultValue) {
        CmisProperty property = this.findProperty(name, new PropertyType("id"));
        if (property == null) {
            return defaultValue;
        }
        return (String)property.getValue();
    }

    @Override
    public Integer findIntegerProperty(String name, Integer defaultValue) {
        CmisProperty property = this.findProperty(name, new PropertyType("integer"));
        if (property == null) {
            return defaultValue;
        }
        return (Integer)property.getValue();
    }

    @Override
    public String findUriProperty(String name, String defaultValue) {
        CmisProperty property = this.findProperty(name, new PropertyType("uri"));
        if (property == null) {
            return defaultValue;
        }
        return (String)property.getValue();
    }

    @Override
    public String findXmlProperty(String name, String defaultValue) {
        CmisProperty property = this.findProperty(name, new PropertyType("xml"));
        if (property == null) {
            return defaultValue;
        }
        return (String)property.getValue();
    }

    private CmisProperty findProperty(String name, PropertyType type) {
        if (this.properties != null) {
            for (CmisProperty aProperty : this.properties.getProperties()) {
                if (!aProperty.getName().equals(name) || !aProperty.getPropertyType().getType().equals(type.getType())) continue;
                return aProperty;
            }
        }
        return null;
    }
}

