/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.util.logging;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.util.IVersionHelper;
import org.pentaho.platform.util.messages.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Logger {
    private static final ThreadLocal<List<Throwable>> threadExceptions = new ThreadLocal();
    private static IVersionHelper versionHelper = null;
    private static int logLevel = 5;
    private static final String MISC_LOG = "misc-";
    private static Log logger = LogFactory.getLog((String)"org.pentaho.platform.util.logging.Logger");
    private static final String logName = "org.pentaho.platform.util.logging.Logger";

    public static void addException(Throwable t) {
        List<Throwable> list = threadExceptions.get();
        if (list == null) {
            list = new ArrayList<Throwable>();
            threadExceptions.set(list);
        }
        list.add(t);
    }

    public static List<Throwable> getExceptions() {
        return threadExceptions.get();
    }

    public static synchronized void setVersionHelper(IVersionHelper helper) {
        versionHelper = helper;
    }

    public static String getLogLevelName(int localLogLevel) {
        switch (localLogLevel) {
            case 1: {
                return "TRACE";
            }
            case 2: {
                return "DEBUG";
            }
            case 3: {
                return "INFO";
            }
            case 4: {
                return "WARN";
            }
            case 5: {
                return "ERROR";
            }
            case 6: {
                return "FATAL";
            }
        }
        return Messages.getString("Logger.CODE_LOG_UNKNOWN");
    }

    public static int getLogLevel(String localLogLevel) {
        if ("TRACE".equalsIgnoreCase(localLogLevel)) {
            return 1;
        }
        if ("DEBUG".equalsIgnoreCase(localLogLevel)) {
            return 2;
        }
        if ("INFO".equalsIgnoreCase(localLogLevel)) {
            return 3;
        }
        if ("WARN".equalsIgnoreCase(localLogLevel)) {
            return 4;
        }
        if ("ERROR".equalsIgnoreCase(localLogLevel)) {
            return 5;
        }
        if ("FATAL".equalsIgnoreCase(localLogLevel)) {
            return 6;
        }
        return 5;
    }

    public static int getLogLevel() {
        return logLevel;
    }

    public static void setLogLevel(int newLogLevel) {
        logLevel = newLogLevel;
    }

    public static void trace(Object caller, String message) {
        String id;
        String string = id = caller == null ? Messages.getString("Logger.DEBUG_LOG_UNKNOWN") : caller.getClass().getName();
        if (logLevel <= 1) {
            logger.trace((Object)(MISC_LOG + id + ": " + message));
        }
    }

    public static void debug(Object caller, String message) {
        String id;
        String string = id = caller == null ? Messages.getString("Logger.DEBUG_LOG_UNKNOWN") : caller.getClass().getName();
        if (logLevel <= 2) {
            logger.debug((Object)(MISC_LOG + id + ": " + message));
        }
    }

    public static void info(Object caller, String message) {
        String id;
        String string = id = caller == null ? Messages.getString("Logger.DEBUG_LOG_UNKNOWN") : caller.getClass().getName();
        if (logLevel <= 3) {
            logger.info((Object)(MISC_LOG + id + ": " + message));
        }
    }

    public static void warn(Object caller, String message) {
        String id;
        String string = id = caller == null ? Messages.getString("Logger.DEBUG_LOG_UNKNOWN") : caller.getClass().getName();
        if (logLevel <= 4) {
            logger.warn((Object)(MISC_LOG + id + ": " + message));
        }
    }

    public static void error(Object caller, String message) {
        String id;
        String string = id = caller == null ? Messages.getString("Logger.DEBUG_LOG_UNKNOWN") : caller.getClass().getName();
        if (logLevel <= 5) {
            logger.error((Object)(MISC_LOG + id + ": " + message));
        }
    }

    public static void fatal(Object caller, String message) {
        String id;
        String string = id = caller == null ? Messages.getString("Logger.DEBUG_LOG_UNKNOWN") : caller.getClass().getName();
        if (logLevel <= 6) {
            logger.fatal((Object)(MISC_LOG + id + ": " + message));
        }
    }

    public static void trace(Object caller, String message, Throwable error) {
        String id;
        String string = id = caller == null ? Messages.getString("Logger.DEBUG_LOG_UNKNOWN") : caller.getClass().getName();
        if (logLevel <= 1) {
            logger.trace((Object)(MISC_LOG + id + ": " + message), error);
        }
        Logger.addException(error);
    }

    public static void debug(Object caller, String message, Throwable error) {
        String id;
        String string = id = caller == null ? Messages.getString("Logger.DEBUG_LOG_UNKNOWN") : caller.getClass().getName();
        if (logLevel <= 2) {
            logger.debug((Object)(MISC_LOG + id + ": " + message), error);
        }
        Logger.addException(error);
    }

    public static void info(Object caller, String message, Throwable error) {
        String id;
        String string = id = caller == null ? Messages.getString("Logger.DEBUG_LOG_UNKNOWN") : caller.getClass().getName();
        if (logLevel <= 3) {
            logger.info((Object)(MISC_LOG + id + ": " + message), error);
        }
        Logger.addException(error);
    }

    public static void warn(Object caller, String message, Throwable error) {
        String id;
        String string = id = caller == null ? Messages.getString("Logger.DEBUG_LOG_UNKNOWN") : caller.getClass().getName();
        if (logLevel <= 4) {
            logger.warn((Object)(MISC_LOG + id + ": " + message), error);
        }
        Logger.addException(error);
    }

    public static void error(Object caller, String message, Throwable error) {
        String id;
        String string = id = caller == null ? Messages.getString("Logger.DEBUG_LOG_UNKNOWN") : caller.getClass().getName();
        if (logLevel <= 5) {
            logger.error((Object)(MISC_LOG + id + ": " + message), error);
        }
        Logger.addException(error);
    }

    public static void fatal(Object caller, String message, Throwable error) {
        String id;
        String string = id = caller == null ? Messages.getString("Logger.DEBUG_LOG_UNKNOWN") : caller.getClass().getName();
        if (logLevel <= 6) {
            logger.fatal((Object)(MISC_LOG + id + ": " + message), error);
        }
        Logger.addException(error);
    }

    public static void debug(String caller, String message) {
        String id;
        String string = id = caller == null ? Messages.getString("Logger.DEBUG_LOG_UNKNOWN") : caller;
        if (logLevel <= 2) {
            logger.debug((Object)(MISC_LOG + id + ": " + message));
        }
    }

    public static void info(String caller, String message) {
        String id;
        String string = id = caller == null ? Messages.getString("Logger.DEBUG_LOG_UNKNOWN") : caller;
        if (logLevel <= 3) {
            logger.info((Object)(MISC_LOG + id + ": " + message));
        }
    }

    public static void warn(String caller, String message) {
        String id;
        String string = id = caller == null ? Messages.getString("Logger.DEBUG_LOG_UNKNOWN") : caller;
        if (logLevel <= 4) {
            logger.warn((Object)(MISC_LOG + id + ": " + message));
        }
    }

    public static void error(String caller, String message) {
        String id;
        String string = id = caller == null ? Messages.getString("Logger.DEBUG_LOG_UNKNOWN") : caller;
        if (logLevel <= 5) {
            logger.error((Object)(MISC_LOG + id + ": " + message));
        }
    }

    public static void fatal(String caller, String message) {
        String id;
        String string = id = caller == null ? Messages.getString("Logger.DEBUG_LOG_UNKNOWN") : caller;
        if (logLevel <= 6) {
            logger.fatal((Object)(MISC_LOG + id + ": " + message));
        }
    }

    public static void debug(String caller, String message, Throwable error) {
        String id;
        String string = id = caller == null ? Messages.getString("Logger.DEBUG_LOG_UNKNOWN") : caller;
        if (logLevel <= 2) {
            logger.debug((Object)(MISC_LOG + id + ": " + message), error);
            Logger.addException(error);
        }
    }

    public static void info(String caller, String message, Throwable error) {
        String id;
        String string = id = caller == null ? Messages.getString("Logger.DEBUG_LOG_UNKNOWN") : caller;
        if (logLevel <= 3) {
            logger.info((Object)(MISC_LOG + id + ": " + message), error);
            Logger.addException(error);
        }
    }

    public static void warn(String caller, String message, Throwable error) {
        String id;
        String string = id = caller == null ? Messages.getString("Logger.DEBUG_LOG_UNKNOWN") : caller;
        if (logLevel <= 4) {
            logger.warn((Object)(MISC_LOG + id + ": " + message), error);
            Logger.addException(error);
        }
    }

    public static void error(String caller, String message, Throwable error) {
        String id;
        String string = id = caller == null ? Messages.getString("Logger.DEBUG_LOG_UNKNOWN") : caller;
        if (logLevel <= 5) {
            if (versionHelper != null) {
                logger.error((Object)("Error: Pentaho " + versionHelper.getVersionInformation(Logger.class)));
            } else {
                logger.error((Object)"Error: Pentaho");
            }
            logger.error((Object)(MISC_LOG + id + ": " + message), error);
            logger.error((Object)"Error end:");
            Logger.addException(error);
        }
    }

    public static void fatal(String caller, String message, Throwable error) {
        String id;
        String string = id = caller == null ? Messages.getString("Logger.DEBUG_LOG_UNKNOWN") : caller;
        if (logLevel <= 6) {
            if (versionHelper != null) {
                logger.error((Object)("Error: Pentaho " + versionHelper.getVersionInformation(Logger.class)));
            } else {
                logger.error((Object)"Error: Pentaho");
            }
            logger.fatal((Object)(MISC_LOG + id + ": " + message), error);
            logger.error((Object)"Error end:");
            Logger.addException(error);
        }
    }
}

